/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.AddressFactory;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.InvalidStateException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import javax.transaction.TransactionManager;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.sip11.EventIDCache;
import org.mobicents.slee.resource.sip11.EventIDFilter;
import org.mobicents.slee.resource.sip11.SipActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.wrappers.ACKDummyTransaction;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.RequestEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TimeoutEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionTerminatedEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.WrapperSuperInterface;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class SipResourceAdaptor
implements SipListener,
ResourceAdaptor,
Serializable {
    private static transient Logger log = Logger.getLogger(SipResourceAdaptor.class);
    private static final String SIP_BIND_ADDRESS = "javax.sip.IP_ADDRESS";
    private static final String SIP_PORT_BIND = "javax.sip.PORT";
    private static final String TRANSPORTS_BIND = "javax.sip.TRANSPORT";
    private static final String STACK_NAME_BIND = "javax.sip.STACK_NAME";
    private int port = 5060;
    private Set<String> transports = new HashSet<String>();
    private Set<String> allowedTransports = new HashSet<String>();
    private String stackAddress = "0.0.0.0";
    private transient SipProvider provider;
    private transient SleeSipProviderImpl providerProxy = null;
    private static Set rfc3261Methods = new HashSet();
    private static Set<String> stxedRequests = new HashSet<String>();
    private transient Map activities = null;
    private transient SipActivityContextInterfaceFactory acif;
    private String entityName = "SipRA";
    private ResourceAdaptorState state;
    private String configurationMBeanName = "SipRA_1_2_Configuration";
    private Properties properties;
    private Properties provisionedProperties = new Properties();
    private transient Address address;
    private transient SleeEndpoint sleeEndpoint;
    private transient EventLookupFacility eventLookup;
    private static final transient EventIDCache eventIdCache;
    private static final transient EventIDFilter eventIDFilter;
    private transient BootstrapContext bootstrapContext;
    private transient SleeContainer serviceContainer;
    private transient SleeTransactionManager tm = null;
    private transient SipStack sipStack = null;
    private transient SipFactory sipFactory = null;

    public SipResourceAdaptor() {
        this.allowedTransports.add("udp");
        this.allowedTransports.add("tcp");
        this.transports.add("udp");
    }

    private Properties loadProperties(BootstrapContext bootstrapContext) {
        Properties props = new Properties();
        try {
            String bindAddress;
            props.load(this.getClass().getResourceAsStream("sipra.properties"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading default SIP RA properties: " + props));
            }
            if ((bindAddress = props.getProperty(SIP_BIND_ADDRESS)) == null && (bindAddress = System.getProperty("jboss.bind.address")) != null) {
                props.setProperty(SIP_BIND_ADDRESS, bindAddress);
            }
        }
        catch (IOException ex) {
            props.setProperty("javax.sip.RETRANSMISSION_FILTER", "on");
        }
        return props;
    }

    public void configure(Properties properties) throws InvalidStateException {
        String confValue;
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new InvalidStateException("Cannot configure RA wrong state: " + this.state);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring RA" + properties));
        }
        this.properties = this.loadProperties(this.bootstrapContext);
        if (properties != null) {
            if (log.isDebugEnabled()) {
                for (Map.Entry<Object, Object> en : properties.entrySet()) {
                    log.debug((Object)("---[SetHotProps][" + this.entityName + "] " + en.getKey() + " [*] " + en.getValue()));
                }
            }
            this.properties.putAll((Map<?, ?>)properties);
        }
        if ((confValue = this.properties.getProperty(SIP_PORT_BIND)) != null) {
            this.port = Integer.parseInt(confValue);
            confValue = null;
        }
        if ((confValue = this.properties.getProperty(TRANSPORTS_BIND, "udp")) != null) {
            String[] tmp = confValue.split(",");
            if (tmp.length > 0) {
                boolean valid = false;
                int i = 0;
                if (i < tmp.length && this.allowedTransports.contains(tmp[i])) {
                    valid = true;
                }
                if (valid) {
                    this.transports.clear();
                    for (i = 0; i < tmp.length; ++i) {
                        if (this.allowedTransports.contains(tmp[i])) {
                            this.transports.add(tmp[i]);
                            continue;
                        }
                        log.error((Object)(" TRANSPORT[" + tmp[i] + "] IS NOT A VALID TRANSPORT!!!"));
                    }
                }
            }
            confValue = null;
        }
        if ((confValue = this.properties.getProperty(SIP_BIND_ADDRESS)) != null) {
            this.stackAddress = confValue;
            this.properties.remove(SIP_BIND_ADDRESS);
            confValue = null;
        } else {
            this.stackAddress = System.getProperty("jboss.bind.address");
        }
        confValue = this.properties.getProperty(STACK_NAME_BIND);
        confValue = confValue == null ? "SipResourceAdaptorStack_" + this.stackAddress + "_" + this.port : confValue + "_" + this.stackAddress + "_" + this.port;
        this.properties.put(STACK_NAME_BIND, confValue);
        confValue = null;
        int i = 0;
        for (i = 0; i < 10; ++i) {
            InetSocketAddress sockAddress = new InetSocketAddress(this.stackAddress, this.port);
            try {
                log.info((Object)("Trying to bind to " + sockAddress));
                DatagramSocket socket = new DatagramSocket(sockAddress);
                this.properties.setProperty(SIP_PORT_BIND, Integer.valueOf(this.port).toString());
                socket.close();
                break;
            }
            catch (Exception ex) {
                this.port += 10;
                continue;
            }
        }
        if (i == 10) {
            throw new RuntimeException("Cannot create SIP Resource adaptor - no port available to bind to ");
        }
        log.info((Object)("RA bound to " + this.port));
        this.state = ResourceAdaptorState.CONFIGURED;
    }

    public void start() throws ResourceException {
        try {
            this.initializeNamingContext();
            this.initializeStack();
            this.activities = new ConcurrentHashMap();
            this.state = ResourceAdaptorState.ACTIVE;
            boolean created = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("---> START " + Arrays.toString(this.transports.toArray())));
            }
            for (String trans : this.transports) {
                ListeningPoint lp = this.sipStack.createListeningPoint(this.stackAddress, this.port, trans);
                if (!created) {
                    this.provider = this.sipStack.createSipProvider(lp);
                    created = true;
                } else {
                    this.provider.addListeningPoint(lp);
                }
                try {
                    this.provider.addSipListener((SipListener)this);
                }
                catch (Exception ex) {
                    String msg = "SIP RA failed to register as SipListener";
                    log.error((Object)msg, (Throwable)ex);
                    throw new ResourceException(msg);
                }
            }
            AddressFactory addressFactory = this.sipFactory.createAddressFactory();
            HeaderFactory headerFactory = this.sipFactory.createHeaderFactory();
            MessageFactory messageFactory = this.sipFactory.createMessageFactory();
            this.providerProxy = new SleeSipProviderImpl(addressFactory, headerFactory, messageFactory, this.sipStack, this, this.provider, (TransactionManager)this.tm);
        }
        catch (Exception ex) {
            String msg = "error in initializing resource adaptor";
            log.error((Object)msg, (Throwable)ex);
            throw new ResourceException(msg);
        }
    }

    protected void initializeStack() throws SipException {
        this.sipFactory = SipFactory.getInstance();
        this.sipFactory.setPathName("gov.nist");
        this.properties.remove(SIP_PORT_BIND);
        this.sipStack = this.sipFactory.createSipStack(this.properties);
        this.sipStack.start();
    }

    public void setProperties(Properties properties) throws ResourceException {
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new ResourceException("Cannot modify configuration properties wrong state: " + this.state);
        }
        this.properties = properties;
    }

    public Properties getProperties(Properties pproperties) {
        pproperties.putAll((Map<?, ?>)this.properties);
        return pproperties;
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container;
        this.serviceContainer = container = SleeContainer.lookupFromJndi();
        SipResourceAdaptor sipResourceAdaptor = this;
        this.tm = sipResourceAdaptor.serviceContainer.getTransactionManager();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(this.bootstrapContext.getEntityName());
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        SleeContainer sleeContainer = resourceAdaptorEntity.getServiceContainer();
        String string = this.bootstrapContext.getEntityName();
        resourceAdaptorEntity.getServiceContainer();
        this.acif = new SipActivityContextInterfaceFactoryImpl(sleeContainer, string, this, SleeContainer.getTransactionManager());
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        this.entityName = this.bootstrapContext.getEntityName();
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                }
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void stopping() {
        this.state = ResourceAdaptorState.STOPPING;
    }

    public void stop() {
        this.provider.removeSipListener((SipListener)this);
        ListeningPoint[] listeningPoints = this.provider.getListeningPoints();
        block6: for (int i = 0; i < listeningPoints.length; ++i) {
            ListeningPoint lp = listeningPoints[i];
            for (int k = 0; k < 10; ++k) {
                try {
                    this.sipStack.deleteListeningPoint(lp);
                    this.sipStack.deleteSipProvider(this.provider);
                    continue block6;
                }
                catch (ObjectInUseException ex) {
                    log.error((Object)"Object in use -- retrying to delete listening point", (Throwable)ex);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            log.error((Object)"Cannot unbind naming context", (Throwable)e);
        }
        this.state = ResourceAdaptorState.UNCONFIGURED;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sip Resource Adaptor stopped.");
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SipResourceAdaptor: init()");
        }
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    public void entityActivated() throws ResourceException {
        try {
            this.configure(this.provisionedProperties);
            this.start();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
        catch (InvalidStateException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivating() {
        this.stopping();
    }

    public void entityDeactivated() {
        this.stop();
    }

    public void entityRemoved() {
    }

    public void activityEnded(ActivityHandle handle) {
        WrapperSuperInterface activity;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing activity for handle[" + handle + "] activity[" + this.activities.get(handle) + "]."));
        }
        if ((activity = (WrapperSuperInterface)this.activities.remove(handle)) != null) {
            activity.cleanup();
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle ah, Object event, int arg2, Address arg3, int arg4, FailureReason arg5) {
        String id = ((SipActivityHandle)ah).getID();
        if (!id.endsWith("CANCEL") || !(event instanceof RequestEventWrapper)) {
            return;
        }
        try {
            Response txDoesNotExistsResponse = this.providerProxy.getMessageFactory().createResponse(481, ((RequestEventWrapper)((Object)event)).getRequest());
            this.provider.sendResponse(txDoesNotExistsResponse);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4) {
    }

    public Object getActivity(ActivityHandle arg0) {
        if (arg0 instanceof SipActivityHandle) {
            return this.activities.get(arg0);
        }
        return null;
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        return this.providerProxy;
    }

    public void queryLiveness(ActivityHandle arg0) {
    }

    public void serviceInstalled(String serviceID, int[] eventIDs, String[] resourceOptions) {
        eventIDFilter.serviceInstalled(serviceID, eventIDs);
    }

    public void serviceUninstalled(String serviceID) {
        eventIDFilter.serviceUninstalled(serviceID);
    }

    public void serviceActivated(String serviceID) {
        eventIDFilter.serviceActivated(serviceID);
    }

    public void serviceDeactivated(String serviceID) {
        eventIDFilter.serviceDeactivated(serviceID);
    }

    public void processIOException(IOExceptionEvent arg0) {
    }

    /*
     * Unable to fully structure code
     */
    public void processRequest(RequestEvent req) {
        if (SipResourceAdaptor.log.isInfoEnabled()) {
            SipResourceAdaptor.log.info((Object)("Received Request:\n" + req.getRequest()));
        }
        st = req.getServerTransaction();
        stw = null;
        if (st == null || st.getApplicationData() == null) {
            try {
                if (req.getDialog() == null && req.getRequest().getMethod().equals("ACK")) {
                    st = new ACKDummyTransaction(req.getRequest());
                }
                stw = (ServerTransactionWrapper)this.providerProxy.getNewServerTransaction(req.getRequest(), st, false);
                st = (ServerTransaction)stw.getWrappedTransaction();
                if (!SipResourceAdaptor.log.isDebugEnabled()) ** GOTO lbl23
                SipResourceAdaptor.log.debug((Object)("\n----------------- CREATED NEW STx ---------------------\nBRANCH: " + st.getBranchId() + "\n-------------------------------------------------------"));
            }
            catch (TransactionAlreadyExistsException e) {
                if (SipResourceAdaptor.log.isDebugEnabled()) {
                    SipResourceAdaptor.log.debug((Object)("Request where the server tx already exists, should be a retransmission and will be dropped. Request: \n" + req.getRequest() + "\n-------------------------"), (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                SipResourceAdaptor.log.error((Object)("\n-------------------------\nREQUEST:\n-------------------------\n" + req.getRequest() + "\n-------------------------"), (Throwable)e);
                this.sendErrorResponse(st, req.getRequest(), 500, e.getMessage());
                return;
            }
        } else {
            stw = (ServerTransactionWrapper)st.getApplicationData();
        }
lbl23:
        // 3 sources

        if (req.getRequest().getMethod().equals("CANCEL")) {
            this.processCancelRequest(st, stw, req);
        } else {
            this.processNotCancelRequest(st, stw, req);
        }
    }

    private void processCancelRequest(ServerTransaction st, ServerTransactionWrapper STW, RequestEvent req) {
        SipActivityHandle inviteHandle = STW.getInviteHandle();
        ServerTransactionWrapper inviteSTW = (ServerTransactionWrapper)this.getActivity(inviteHandle);
        boolean inDialog = false;
        SipActivityHandle SAH = null;
        if (inviteSTW != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found INVITE transaction CANCEL[" + STW + "] \nINVITE[" + inviteSTW + "]"));
            }
            if (inviteSTW.getState() == TransactionState.TERMINATED || inviteSTW.getState() == TransactionState.COMPLETED || inviteSTW.getState() == TransactionState.CONFIRMED) {
                log.error((Object)"Invite transaction has been found in state other than proceeding, final response sent, sending BAD_REQUEST");
                try {
                    Response response = this.providerProxy.getMessageFactory().createResponse(400, req.getRequest());
                    STW.sendResponse(response);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (inviteSTW.getDialog() != null) {
                Response response;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found DIALOG transaction CANCEL[" + STW + "]\nINVITE[" + inviteSTW + "]\nDialog[" + inviteSTW.getDialog() + "]\nSEQUENCE:Send200ToCANCEL,FireEventOnDialog,Send487ToInvite"));
                }
                SAH = ((DialogWrapper)inviteSTW.getDialog()).getActivityHandle();
                inDialog = true;
                RequestEventWrapper REW = new RequestEventWrapper(this.providerProxy, STW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
                int eventID = eventIdCache.getEventId(this.eventLookup, REW.getRequest(), inDialog);
                this.fireEvent((Object)REW, SAH, eventID, new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()));
                try {
                    response = this.providerProxy.getMessageFactory().createResponse(200, req.getRequest());
                    STW.sendResponse(response);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                try {
                    response = this.providerProxy.getMessageFactory().createResponse(487, inviteSTW.getRequest());
                    inviteSTW.sendResponse(response);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DIALOG not found transaction CANCEL[" + STW + "]\nINVITE[" + inviteSTW + "]\nDialog[" + inviteSTW.getDialog() + "]\nSEQUENCE:FireEventOnInvite"));
                }
                SAH = inviteSTW.getActivityHandle();
                inDialog = false;
                RequestEventWrapper REW = new RequestEventWrapper(this.providerProxy, STW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
                int eventID = eventIdCache.getEventId(this.eventLookup, REW.getRequest(), inDialog);
                this.fireEvent((Object)REW, SAH, eventID, new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("INVITE not found transaction CANCEL[" + STW + "]\nSEQUENCE:FireEventOnCancel"));
            }
            SAH = STW.getActivityHandle();
            inDialog = false;
            RequestEventWrapper REW = new RequestEventWrapper(this.providerProxy, STW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
            int eventID = eventIdCache.getEventId(this.eventLookup, REW.getRequest(), inDialog);
            this.fireEvent((Object)REW, SAH, eventID, new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()));
        }
    }

    private void processNotCancelRequest(ServerTransaction st, ServerTransactionWrapper STW, RequestEvent req) {
        SipActivityHandle SAH = null;
        DialogWrapper DW = null;
        boolean inDialog = false;
        if (st.getDialog() != null) {
            Dialog d = st.getDialog();
            if (d.getApplicationData() != null && d.getApplicationData() instanceof DialogActivity) {
                DW = (DialogWrapper)d.getApplicationData();
                inDialog = true;
                SAH = DW.getActivityHandle();
                DW.addOngoingTransaction(STW);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dialog [" + d + "] exists, but no wrapper is present. Delivering event on TX"));
                }
                inDialog = false;
                SAH = STW.getActivityHandle();
            }
        } else {
            SAH = STW.getActivityHandle();
        }
        RequestEventWrapper REW = new RequestEventWrapper(this.providerProxy, STW, (Dialog)DW, req.getRequest());
        if (!this.fireEvent((Object)REW, SAH, eventIdCache.getEventId(this.eventLookup, REW.getRequest(), inDialog), new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()))) {
            if (!inDialog) {
                this.activities.remove(STW.getActivityHandle());
                STW.cleanup();
            }
            this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to deliver request event to JAIN SLEE container");
        } else if (!inDialog && STW.getWrappedTransaction() instanceof ACKDummyTransaction) {
            this.processTransactionTerminated(new TransactionTerminatedEventWrapper((Object)this.providerProxy, (ServerTransaction)STW.getWrappedTransaction()));
        }
    }

    public void processResponse(ResponseEvent resp) {
        ClientTransaction ct;
        if (log.isInfoEnabled()) {
            log.info((Object)("Received Response:\n" + resp.getResponse()));
        }
        if ((ct = resp.getClientTransaction()) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("===> CT is NULL - RTR ? CALLID[" + ((CallID)resp.getResponse().getHeader("Call-ID")).getCallId() + "] BRANCH[" + ((Via)resp.getResponse().getHeaders("Via").next()).getBranch() + "] METHOD[" + ((CSeq)resp.getResponse().getHeader("CSeq")).getMethod() + "] CODE[" + resp.getResponse().getStatusCode() + "]"));
            }
            return;
        }
        int statusCode = resp.getResponse().getStatusCode();
        String method = ((CSeqHeader)resp.getResponse().getHeader("CSeq")).getMethod();
        if (ct.getApplicationData() == null || !(ct.getApplicationData() instanceof ClientTransactionWrapper)) {
            log.error((Object)("Received app data[" + ct.getApplicationData() + "] - should be instance of wrapper class!!"));
            return;
        }
        Object eventKey = null;
        SipActivityHandle SAH = null;
        ClientTransactionWrapper CTW = (ClientTransactionWrapper)ct.getApplicationData();
        DialogWrapper DW = null;
        boolean inDialog = false;
        if (ct.getDialog() != null) {
            Dialog d = ct.getDialog();
            if (d.getApplicationData() != null && d.getApplicationData() instanceof DialogActivity) {
                DW = (DialogWrapper)d.getApplicationData();
                SAH = DW.getActivityHandle();
                inDialog = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dialog [" + d + "] exists, but no wrapper is present. Delivering event on TX"));
                }
                inDialog = false;
                SAH = CTW.getActivityHandle();
            }
        } else {
            SAH = CTW.getActivityHandle();
        }
        ResponseEventWrapper REW = new ResponseEventWrapper(this.providerProxy, CTW, (Dialog)DW, resp.getResponse());
        int eventID = eventIdCache.getEventId(this.eventLookup, REW.getResponse(), inDialog);
        this.fireEvent((Object)REW, SAH, eventID, new Address(AddressPlan.SIP, ((FromHeader)resp.getResponse().getHeader("From")).getAddress().toString()));
        if (!(statusCode != 481 && statusCode != 408 || !inDialog || method.equals("INVITE") && method.equals("SUBSCRIBE"))) {
            try {
                Request bye = DW.createRequest("BYE");
                this.provider.sendRequest(bye);
            }
            catch (SipException e) {
                e.printStackTrace();
            }
        }
        if (statusCode > 299 && DW.getState() != DialogState.CONFIRMED) {
            try {
                DW.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeout(TimeoutEvent arg0) {
        block21: {
            ClientTransaction t = null;
            WrapperSuperInterface wsi = null;
            try {
                boolean inDialog = false;
                SipActivityHandle handle = null;
                int eventID = -1;
                if (log.isInfoEnabled()) {
                    if (!arg0.isServerTransaction()) {
                        log.info((Object)("Server transaction " + arg0.getServerTransaction().getBranchId() + " timer expired"));
                    } else {
                        log.info((Object)("Client transaction " + arg0.getClientTransaction().getBranchId() + " timer expired"));
                    }
                }
                TimeoutEventWrapper tew = null;
                if (!arg0.isServerTransaction()) {
                    t = arg0.getClientTransaction();
                    if (t.getApplicationData() == null || !(t.getApplicationData() instanceof ClientTransactionWrapper)) {
                        log.error((Object)("FAILURE on processTimeout - CTX. Wrong app data[" + t.getApplicationData() + "]"));
                        return;
                    }
                    tew = new TimeoutEventWrapper((Object)this.providerProxy, (ClientTransaction)t.getApplicationData(), arg0.getTimeout());
                    ClientTransactionWrapper ctw = (ClientTransactionWrapper)t.getApplicationData();
                    wsi = ctw;
                    if (ctw.getDialog() != null && ctw.getDialog() instanceof DialogWrapper) {
                        inDialog = true;
                        handle = ((DialogWrapper)ctw.getDialog()).getActivityHandle();
                    } else {
                        handle = ctw.getActivityHandle();
                    }
                    this.fireEvent((Object)tew, handle, eventIdCache.getTimeoutEventId(this.eventLookup, inDialog), new Address(AddressPlan.SIP, ((FromHeader)ctw.getRequest().getHeader("From")).getAddress().toString()));
                } else {
                    t = arg0.getServerTransaction();
                    wsi = (WrapperSuperInterface)t.getApplicationData();
                }
                boolean sendBYE = true;
                boolean sendClientResponse = true;
                String method = t.getRequest().getMethod();
                if (t.getDialog() == null || !(t.getDialog().getApplicationData() instanceof DialogWrapper)) break block21;
                DialogWrapper da = (DialogWrapper)t.getDialog().getApplicationData();
                if (this.isDialogTermMethod(da, method)) {
                    sendBYE = false;
                }
                if (t instanceof ServerTransaction) {
                    sendClientResponse = false;
                }
                if (sendClientResponse) {
                    try {
                        Response response = this.providerProxy.getMessageFactory().createResponse(408, t.getRequest());
                        ResponseEventWrapper REW = new ResponseEventWrapper(this.providerProxy, (ClientTransaction)t.getApplicationData(), (Dialog)da, response);
                        this.fireEvent((Object)REW, da.getActivityHandle(), eventIdCache.getEventId(this.eventLookup, response, inDialog), new Address(AddressPlan.SIP, ((FromHeader)response.getHeader("From")).getAddress().toString()));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (sendBYE) {
                    try {
                        Request bye = da.createRequest("BYE");
                        this.provider.sendRequest(bye);
                    }
                    catch (SipException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (wsi != null) {
                    this.sendActivityEndEvent(wsi.getActivityHandle());
                }
            }
        }
    }

    private boolean isDialogTermMethod(DialogActivity da, String method) {
        return false;
    }

    public void processTransactionTerminated(TransactionTerminatedEvent txTerminatedEvent) {
        Object t = null;
        t = !txTerminatedEvent.isServerTransaction() ? txTerminatedEvent.getClientTransaction() : txTerminatedEvent.getServerTransaction();
        if (log.isInfoEnabled()) {
            log.info((Object)("SIP Transaction " + t.getBranchId() + " terminated"));
        }
        if (t.getApplicationData() == null && t.getRequest().getMethod().equals("ACK")) {
            SipActivityHandle _sah = new SipActivityHandle(t.getBranchId() + "_" + "ACK");
            t.setApplicationData(this.activities.get(_sah));
        }
        if (t.getApplicationData() != null) {
            WrapperSuperInterface wsi = (WrapperSuperInterface)t.getApplicationData();
            DialogWrapper dw = null;
            if (t.getDialog() != null && t.getDialog().getApplicationData() instanceof DialogWrapper) {
                dw = (DialogWrapper)t.getDialog().getApplicationData();
                if (wsi instanceof ServerTransactionWrapper) {
                    dw.removeOngoingTransaction((ServerTransactionWrapper)wsi);
                } else if (wsi instanceof ClientTransactionWrapper) {
                    dw.removeOngoingTransaction((ClientTransactionWrapper)wsi);
                } else {
                    log.error((Object)("Unknown type " + wsi.getClass() + " of SIP Transaction, can't remove from dialog wrapper"));
                }
            }
            if (!this.sendActivityEndEvent(wsi.getActivityHandle())) {
                wsi.cleanup();
            }
        } else {
            log.error((Object)"TransactionTerminatedEvent dropped due to null app data");
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dte) {
        if (log.isInfoEnabled()) {
            log.info((Object)("SIP Dialog " + dte.getDialog().getDialogId() + " terminated"));
        }
        if (dte.getDialog().getApplicationData() != null) {
            this.sendActivityEndEvent(((DialogWrapper)dte.getDialog().getApplicationData()).getActivityHandle());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"DialogTerminatedEvent droping due to null app data.");
        }
    }

    public boolean sendActivityEndEvent(SipActivityHandle ah) {
        try {
            if (this.activities.containsKey(ah)) {
                this.sleeEndpoint.activityEnding((ActivityHandle)ah);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setIp(String ip) {
        this.stackAddress = ip.equals("null") ? System.getProperty("jboss.bind.address") : ip;
        this.provisionedProperties.put(SIP_BIND_ADDRESS, this.stackAddress);
    }

    public void setPort(Integer port) {
        this.port = port < 1024 ? 5060 : port;
        this.provisionedProperties.put(SIP_PORT_BIND, "" + this.port);
    }

    public void setTransports(String transportsToSet) {
        String[] tmp = transportsToSet.split(",");
        if (tmp.length > 0) {
            boolean valid = false;
            int i = 0;
            if (i < tmp.length && this.allowedTransports.contains(tmp[i].toLowerCase())) {
                valid = true;
            }
            if (valid) {
                this.transports.clear();
                for (i = 0; i < tmp.length; ++i) {
                    if (this.allowedTransports.contains(tmp[i].toLowerCase())) {
                        this.transports.add(tmp[i].toLowerCase());
                        continue;
                    }
                    log.error((Object)(" TRANSPORT[" + tmp[i] + "] IS NOT A VALID TRANSPORT!!!"));
                }
            }
        }
        this.provisionedProperties.put(TRANSPORTS_BIND, transportsToSet);
    }

    public void addActivity(SipActivityHandle sah, WrapperSuperInterface wrapperActivity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding sip activity handle " + sah));
        }
        this.activities.put(sah, wrapperActivity);
    }

    public void removeActivity(SipActivityHandle sah) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing sip activity handle " + sah));
        }
        this.activities.remove(sah);
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    private boolean fireEvent(Object event, ActivityHandle handle, int eventID, Address address, boolean useFiltering) {
        if (useFiltering && eventIDFilter.filterEvent(eventID)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event " + eventID + " filtered"));
            }
        } else if (eventID < 0) {
            log.error((Object)("Event id for " + eventID + " is less than zero, cant fire!!!"));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Firing event " + event + " on handle " + handle));
            }
            try {
                this.sleeEndpoint.fireEvent(handle, event, eventID, address);
                return true;
            }
            catch (Exception e) {
                log.error((Object)"Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    private boolean fireEvent(Object event, ActivityHandle handle, int eventId, Address address) {
        return this.fireEvent(event, handle, eventId, address, true);
    }

    private void sendErrorResponse(ServerTransaction serverTransaction, Request request, int code, String msg) {
        if (!request.getMethod().equals("ACK")) {
            try {
                ContentTypeHeader contentType = this.providerProxy.getHeaderFactory().createContentTypeHeader("text", "plain");
                Response response = this.providerProxy.getMessageFactory().createResponse(code, request, contentType, msg.getBytes());
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        String[] tmp = new String[]{"ACK", "BYE", "CANCEL", "INFO", "INVITE", "MESSAGE", "NOTIFY", "OPTIONS", "PRACK", "PUBLISH", "REFER", "REGISTER", "SUBSCRIBE", "UPDATE"};
        for (int i = 0; i < tmp.length; ++i) {
            rfc3261Methods.add(tmp[i]);
        }
        log.info((Object)("\n================SIP METHODS====================\n" + rfc3261Methods + "\n==============================================="));
        stxedRequests.add("ACK");
        stxedRequests.add("CANCEL");
        stxedRequests.add("BYE");
        eventIdCache = new EventIDCache();
        eventIDFilter = new EventIDFilter();
    }
}

