/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.mbean;

import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.sip11.mbean.SipRaConfigurationMBean;

public class SipRaConfiguration
implements SipRaConfigurationMBean {
    public static final String MBEAN_NAME_PREFIX = "slee:sippraconfiguration=";
    private boolean automaticDialogSupport = false;
    private String stackAddress = null;
    private String[] transports = null;
    private int port = -1;
    private static Logger logger = Logger.getLogger(SipRaConfiguration.class);

    public SipRaConfiguration(boolean automaticDialogSupport, String stackAddress, String[] transports, int port) {
        this.automaticDialogSupport = automaticDialogSupport;
        this.stackAddress = stackAddress;
        this.transports = transports;
        this.port = port;
    }

    public boolean getAutomaticDialogSupport() {
        return this.automaticDialogSupport;
    }

    public String getStackAddress() {
        return this.stackAddress;
    }

    public int getStackPort() {
        return this.port;
    }

    public String[] getTransport() {
        return this.transports;
    }

    public void startService(String name) {
        logger.info((Object)"Exposing RA configuration as MBean");
        MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
        ObjectName on = null;
        try {
            on = new ObjectName(MBEAN_NAME_PREFIX + name);
            mbs.registerMBean(this, on);
            logger.info((Object)"RA Configuration exposed");
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopService(String name) {
        logger.info((Object)"Removing RA configuration MBean");
        MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
        try {
            ObjectName on = new ObjectName(MBEAN_NAME_PREFIX + name);
            mbs.unregisterMBean(on);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

