/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.SuperTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.WrapperSuperInterface;

public class ServerTransactionWrapper
extends SuperTransactionWrapper
implements ServerTransaction,
WrapperSuperInterface {
    public ServerTransactionWrapper(ServerTransaction wrappedTransaction) {
        if (wrappedTransaction.getApplicationData() != null && wrappedTransaction.getApplicationData() instanceof ServerTransactionWrapper) {
            throw new IllegalArgumentException("ServerTransaction to wrap has alredy a wrapper!!!");
        }
        this.wrappedTransaction = wrappedTransaction;
        this.wrappedTransaction.setApplicationData((Object)this);
        this.sipActivityHandle = new SipActivityHandle(wrappedTransaction.getBranchId() + "_" + wrappedTransaction.getRequest().getMethod());
    }

    public ServerTransactionWrapper() {
    }

    public void enableRetransmissionAlerts() throws SipException {
        ((ServerTransaction)this.wrappedTransaction).enableRetransmissionAlerts();
    }

    public void sendResponse(Response arg0) throws SipException, InvalidArgumentException {
        Dialog dialog;
        ((ServerTransaction)this.wrappedTransaction).sendResponse(arg0);
        String method = this.getRequest().getMethod();
        int statusCode = arg0.getStatusCode();
        if (method.equals("CANCEL") && statusCode < 300 && statusCode > 199 && (dialog = this.getDialog()) != null && dialog.getState() == null) {
            dialog.delete();
        }
    }

    public Dialog getDialog() {
        if (this.wrappedTransaction.getDialog() != null && this.wrappedTransaction.getDialog().getApplicationData() != null) {
            return (DialogWrapper)this.wrappedTransaction.getDialog().getApplicationData();
        }
        return null;
    }

    public String getBranchId() {
        if (this.wrappedTransaction == null) {
            return null;
        }
        return this.wrappedTransaction.getBranchId();
    }

    public Request getRequest() {
        if (this.wrappedTransaction == null) {
            return null;
        }
        return this.wrappedTransaction.getRequest();
    }

    public int getRetransmitTimer() throws UnsupportedOperationException {
        if (this.wrappedTransaction == null) {
            return -1;
        }
        return this.wrappedTransaction.getRetransmitTimer();
    }

    public TransactionState getState() {
        if (this.wrappedTransaction == null) {
            return null;
        }
        return this.wrappedTransaction.getState();
    }

    public void setRetransmitTimer(int arg0) throws UnsupportedOperationException {
        if (this.wrappedTransaction == null) {
            return;
        }
        this.wrappedTransaction.setRetransmitTimer(arg0);
    }

    public void terminate() throws ObjectInUseException {
        if (this.wrappedTransaction == null) {
            return;
        }
        this.wrappedTransaction.terminate();
    }

    public String toString() {
        String ret = "";
        ret = ret + "ServerTransaction BR[" + this.getBranchId() + "] ";
        return ret;
    }

    public SipActivityHandle getInviteHandle() {
        String id = this.sipActivityHandle.getID();
        id = id.replace("_" + this.wrappedTransaction.getRequest().getMethod(), "_INVITE").intern();
        return new SipActivityHandle(id);
    }

    public void cleanup() {
        if (this.wrappedTransaction != null) {
            this.wrappedTransaction.setApplicationData(null);
            this.wrappedTransaction = null;
        }
    }
}

