/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.message.SIPRequest;
import java.rmi.server.UID;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.Parameters;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.AddressPlan;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.DialogForkedEvent;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.SuperTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.WrapperSuperInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogWrapper
implements DialogActivity,
WrapperSuperInterface {
    private static final long serialVersionUID = 1L;
    public static final Set<String> dialogCreatingMethods;
    protected Dialog wrappedDialog = null;
    protected SipActivityHandle sipActivityHandle;
    protected String initiatingTransctionId = null;
    protected SipResourceAdaptor ra;
    protected ConcurrentHashMap<String, ClientTransaction> ongoingClientTransactions = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, ServerTransaction> ongoingServerTransactions = new ConcurrentHashMap();
    protected String lastCancelableTransactionId = null;
    protected SleeSipProviderImpl provider = null;
    protected static final Logger logger;
    SipActivityHandle forkInitialActivityHandle = null;
    protected DialogForkState forkState = DialogForkState.AWAIT_FIRST_TAG;
    protected ArrayList<RouteHeader> localRouteSet = new ArrayList();
    protected boolean routeSetOnRequest = false;
    protected String localToTag = null;
    protected SipURI reqeustURI = null;
    protected AtomicLong localSequenceNumber = new AtomicLong(0L);
    protected ConcurrentHashMap<String, SipActivityHandle> toTag2DialogHandle = new ConcurrentHashMap();
    protected Address fromAddress;
    protected Address toAddress;
    protected CallIdHeader callIdToReUse = null;
    protected String autoGeneratedFromTag = null;

    public DialogWrapper(SleeSipProviderImpl provider, SipResourceAdaptor ra) {
        this.provider = provider;
        this.ra = ra;
        this.sipActivityHandle = new SipActivityHandle(new UID().toString());
        this.autoGeneratedFromTag = Utils.getInstance().generateTag();
    }

    public DialogWrapper(Dialog wrappedDialog, SipActivityHandle forkInitialActivityHandle, SleeSipProviderImpl provider, SipResourceAdaptor ra) {
        this(provider, ra);
        this.wrappedDialog = wrappedDialog;
        this.forkInitialActivityHandle = forkInitialActivityHandle;
        if (forkInitialActivityHandle == null) {
            if (wrappedDialog.getApplicationData() != null) {
                if (wrappedDialog.getApplicationData() instanceof DialogWrapper) {
                    throw new IllegalArgumentException("Dialog to wrap has alredy a wrapper!!!");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Overwriting application data present - " + wrappedDialog.getApplicationData()));
                }
            }
            this.wrappedDialog.setApplicationData((Object)this);
        }
    }

    @Override
    public void cleanup() {
        if (this.wrappedDialog != null && this.forkInitialActivityHandle == null) {
            this.wrappedDialog.setApplicationData(null);
            if (!this.wrappedDialog.isServer()) {
                String key = this.wrappedDialog.getLocalTag() + "_" + this.wrappedDialog.getCallId().getCallId();
                this.ra.removeClientDialogMapping(key);
            }
        }
        this.wrappedDialog = null;
        this.sipActivityHandle = null;
        this.ra = null;
        this.ongoingClientTransactions = null;
        this.ongoingServerTransactions = null;
    }

    private void setLocalSequenceNumber(long lCseq) {
        if (lCseq <= this.localSequenceNumber.get()) {
            throw new RuntimeException("Sequence number should not decrease !");
        }
        this.localSequenceNumber.set(lCseq);
    }

    public ClientTransaction getClientTransaction(String id) {
        return this.ongoingClientTransactions.get(id);
    }

    public String getInitiatingTransactionId() {
        return this.initiatingTransctionId;
    }

    public ServerTransaction getServerTransaction(String id) {
        return this.ongoingServerTransactions.get(id);
    }

    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.createAck(arg0);
        }
        throw new SipException("Cant create ACK before initial request has not been sent!!!");
    }

    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.createPrack(arg0);
        }
        throw new SipException("Cant create PRACK before initial request has not been sent!!!");
    }

    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.createReliableProvisionalResponse(arg0);
        }
        throw new SipException("Cant create response before initial request has not been sent!!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        if (this.wrappedDialog == null) {
            this.ra.processDialogTerminated(new DialogTerminatedEvent((Object)this.provider, (Dialog)this));
        } else if (this.forkInitialActivityHandle == null) {
            try {
                this.terminateFork(this.getActivityHandle());
            }
            finally {
                if (this.wrappedDialog.getState() == null) {
                    this.ra.processDialogTerminated(new DialogTerminatedEvent((Object)this.provider, this.wrappedDialog));
                }
            }
            this.wrappedDialog.delete();
        } else {
            this.ra.processDialogTerminated(new DialogTerminatedEvent((Object)this.provider, (Dialog)this));
        }
    }

    public Object getApplicationData() {
        throw new SecurityException();
    }

    public CallIdHeader getCallId() {
        if (this.wrappedDialog == null) {
            return this.callIdToReUse;
        }
        return this.wrappedDialog.getCallId();
    }

    public String getDialogId() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return this.wrappedDialog.getDialogId();
    }

    public Transaction getFirstTransaction() {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.getFirstTransaction();
        }
        return null;
    }

    public Address getLocalParty() {
        if (this.wrappedDialog != null && !this.isInForkedActions()) {
            return this.wrappedDialog.getLocalParty();
        }
        if (this.wrappedDialog != null && this.isInForkedActions()) {
            return this.fromAddress;
        }
        return null;
    }

    public Address getRemoteParty() {
        if (this.wrappedDialog != null && !this.isInForkedActions()) {
            return this.wrappedDialog.getRemoteParty();
        }
        if (this.wrappedDialog != null && this.isInForkedActions()) {
            return this.toAddress;
        }
        return null;
    }

    public Address getRemoteTarget() {
        if (this.wrappedDialog != null && !this.isInForkedActions()) {
            return this.wrappedDialog.getRemoteTarget();
        }
        if (this.wrappedDialog != null && this.isInForkedActions()) {
            return this.toAddress != null ? this.toAddress : null;
        }
        return null;
    }

    public long getLocalSeqNumber() {
        if (this.isInForkedActions() || this.wrappedDialog == null) {
            return this.localSequenceNumber.get();
        }
        return this.wrappedDialog.getLocalSeqNumber();
    }

    public int getLocalSequenceNumber() {
        if (this.isInForkedActions() || this.wrappedDialog == null) {
            return (int)this.localSequenceNumber.get();
        }
        return this.wrappedDialog.getLocalSequenceNumber();
    }

    public String getLocalTag() {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.getLocalTag();
        }
        return this.autoGeneratedFromTag;
    }

    public long getRemoteSeqNumber() {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.getRemoteSeqNumber();
        }
        return -1L;
    }

    public int getRemoteSequenceNumber() {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.getRemoteSequenceNumber();
        }
        return -1;
    }

    public String getRemoteTag() {
        if (this.wrappedDialog != null && !this.isInForkedActions()) {
            return this.wrappedDialog.getRemoteTag();
        }
        if (this.wrappedDialog != null && this.isInForkedActions()) {
            return this.localToTag;
        }
        return null;
    }

    public Iterator getRouteSet() {
        if (this.wrappedDialog != null) {
            return this.wrappedDialog.getRouteSet();
        }
        return new ArrayList<RouteHeader>(this.localRouteSet).iterator();
    }

    public DialogState getState() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return this.wrappedDialog.getState();
    }

    public void incrementLocalSequenceNumber() {
        if (this.isInForkedActions() || this.wrappedDialog == null) {
            this.localSequenceNumber.incrementAndGet();
        } else {
            this.wrappedDialog.incrementLocalSequenceNumber();
        }
    }

    public boolean isSecure() {
        if (this.wrappedDialog == null) {
            return false;
        }
        return this.wrappedDialog.isSecure();
    }

    public boolean isServer() {
        if (this.wrappedDialog == null) {
            return false;
        }
        return this.wrappedDialog.isServer();
    }

    public void sendAck(Request arg0) throws SipException {
        if (this.wrappedDialog == null) {
            throw new SipException("Wrong state, cant send ack before dialog createing request!!!");
        }
        this.wrappedDialog.sendAck(arg0);
    }

    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        if (this.wrappedDialog == null) {
            throw new SipException("Wrong state, cant send provisional response before dialog createing request!!!");
        }
        this.wrappedDialog.sendReliableProvisionalResponse(arg0);
    }

    public void setApplicationData(Object arg0) {
        throw new SecurityException();
    }

    public void terminateOnBye(boolean arg0) throws SipException {
        this.wrappedDialog.terminateOnBye(arg0);
    }

    @Override
    public SipActivityHandle getActivityHandle() {
        return this.sipActivityHandle;
    }

    public Object getWrappedObject() {
        return this.wrappedDialog;
    }

    public boolean hasOngoingServerTransaction(String branchID) {
        return this.ongoingServerTransactions.containsKey(branchID);
    }

    public boolean hasOngoingClientTransaction(String branchID) {
        return this.ongoingClientTransactions.containsKey(branchID);
    }

    public void addOngoingTransaction(ServerTransactionWrapper stw) {
        this.ongoingServerTransactions.putIfAbsent(stw.getBranchId(), stw);
        if (this.isInForkedActions()) {
            this.setLocalSequenceNumber(((CSeq)stw.getRequest().getHeader("CSeq")).getSeqNumber());
        }
    }

    public void addOngoingTransaction(ClientTransactionWrapper ctw) {
        this.ongoingClientTransactions.putIfAbsent(ctw.getBranchId(), ctw);
    }

    public void removeOngoingTransaction(ClientTransactionWrapper ctw) {
        this.ongoingClientTransactions.remove(ctw.getBranchId());
    }

    public void removeOngoingTransaction(ServerTransactionWrapper stw) {
        this.ongoingServerTransactions.remove(stw.getBranchId());
    }

    public void removeOngoingTransaction(SuperTransactionWrapper stw) {
    }

    public void clearOngoingTransaction() {
        this.ongoingClientTransactions.clear();
        this.ongoingServerTransactions.clear();
    }

    public void clearAssociations() {
    }

    public String getLastCancelableTransactionId() {
        return this.lastCancelableTransactionId;
    }

    private void forgeMessage(Message originalMessage, Message forgedMessage, Set<String> headerstoOmmit) throws SipException {
        ListIterator lit = originalMessage.getHeaderNames();
        while (lit.hasNext()) {
            String headerName = (String)lit.next();
            if (headerName.equals("To") || headerName.equals("From")) {
                Parameters origHeader = (Parameters)originalMessage.getHeader(headerName);
                Parameters forgedHeader = (Parameters)forgedMessage.getHeader(headerName);
                Iterator it = origHeader.getParameterNames();
                HashSet<String> toOmmit = new HashSet<String>();
                toOmmit.add("tag");
                this.copyParameters(headerName, origHeader, forgedHeader, toOmmit);
                continue;
            }
            if (headerstoOmmit.contains(headerName)) continue;
            if (forgedMessage.getHeaders(headerName).hasNext()) {
                forgedMessage.removeHeader(headerName);
            }
            ListIterator headersIterator = originalMessage.getHeaders(headerName);
            while (headersIterator.hasNext()) {
                Header origHeader = (Header)headersIterator.next();
                Header forgedHeader = null;
                try {
                    forgedHeader = this.provider.getHeaderFactory().createHeader(headerName, origHeader.toString().substring(origHeader.toString().indexOf(":") + 1));
                    forgedMessage.addLast(forgedHeader);
                }
                catch (ParseException e) {
                    logger.error((Object)("Failed to generate header on [" + headerName + "]. To copy value [" + origHeader + "]\n"), (Throwable)e);
                    throw new SipException("Major failure", (Throwable)e);
                }
            }
        }
        byte[] rawOriginal = originalMessage.getRawContent();
        if (rawOriginal != null && rawOriginal.length != 0) {
            byte[] copy = new byte[rawOriginal.length];
            System.arraycopy(rawOriginal, 0, copy, 0, copy.length);
            try {
                forgedMessage.setContent((Object)new String(copy), (ContentTypeHeader)forgedMessage.getHeader("Content-Type"));
            }
            catch (ParseException e) {
                logger.error((Object)("Failed to set content on forged message. To copy value [" + new String(copy) + "] Type [" + forgedMessage.getHeader("Content-Type") + "]\n"), (Throwable)e);
            }
        }
    }

    private void copyParameters(String name, Parameters origHeader, Parameters forgedHeader, Set<String> toOmmit) {
        Iterator it = origHeader.getParameterNames();
        while (it.hasNext()) {
            String p_name = (String)it.next();
            if (toOmmit.contains(p_name) || forgedHeader.getParameter(p_name) != null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ommiting parameter on [" + name + "]. To copy value [" + origHeader.getParameter(p_name) + "]\nValue in forged [" + forgedHeader.getParameter(p_name) + "]"));
                continue;
            }
            try {
                forgedHeader.setParameter(p_name, origHeader.getParameter(p_name));
            }
            catch (ParseException e) {
                logger.error((Object)("Failed to pass parameter on [" + name + "]. To copy value [" + origHeader.getParameter(p_name) + "]\nValue in forged [" + forgedHeader.getParameter(p_name) + "]"), (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Dialog Id[" + this.getDialogId() + "] State[" + this.getState() + "] OngoingCTX[" + this.ongoingClientTransactions.size() + "] OngoingSTX[" + this.ongoingServerTransactions.size() + "]";
    }

    public ClientTransaction sendCancel() throws SipException {
        this.verifyDialogExistency();
        try {
            ClientTransaction inviteCTX = this.getClientTransaction(this.lastCancelableTransactionId);
            Request cancelRequest = inviteCTX.createCancel();
            ClientTransaction cancelTransaction = this.provider.getNewClientTransaction(cancelRequest, false);
            cancelTransaction.sendRequest();
            return cancelTransaction;
        }
        catch (NullPointerException npe) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)npe);
            }
            throw new SipException("Possibly fialed to obtain client transaction or no INVITE transaction present");
        }
        catch (Exception e) {
            throw new SipException("Failed to send CANCEL due to:", (Throwable)e);
        }
    }

    public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
        this.verifyDialogExistency();
        if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
            throw new IllegalArgumentException("Client transaction is not in ongoing transaction list!!!");
        }
        if (st != null) {
            if (!((DialogWrapper)st.getDialog()).hasOngoingServerTransaction(st.getBranchId())) {
                throw new IllegalArgumentException("Server transaction is not in ongoing transaction list!!!");
            }
            ((ClientTransactionWrapper)ct).associateServerTransaction(st.getBranchId(), ((DialogWrapper)st.getDialog()).getActivityHandle());
        } else {
            ((ClientTransactionWrapper)ct).associateServerTransaction(null, null);
        }
    }

    public Request createRequest(String arg0) throws SipException {
        HeaderFactory headerFactory = this.provider.getHeaderFactory();
        if (this.wrappedDialog == null) {
            try {
                FromHeader fromHeader = headerFactory.createFromHeader(this.fromAddress, this.autoGeneratedFromTag);
                ToHeader toHeader = headerFactory.createToHeader(this.toAddress, null);
                URI requestURI = this.toAddress.getURI();
                ListeningPoint listeningPoint = this.provider.getListeningPoints()[0];
                ViaHeader viaHeader = headerFactory.createViaHeader(listeningPoint.getIPAddress(), listeningPoint.getPort(), listeningPoint.getTransport(), null);
                ArrayList<ViaHeader> viaHeadersList = new ArrayList<ViaHeader>();
                viaHeadersList.add(viaHeader);
                MaxForwardsHeader maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
                CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(this.localSequenceNumber.get() + 1L, arg0);
                Request request = this.provider.getMessageFactory().createRequest((URI)requestURI.clone(), arg0, this.callIdToReUse, cSeqHeader, fromHeader, toHeader, viaHeadersList, maxForwardsHeader);
                this.fillRequestHeaders(request);
                return request;
            }
            catch (Exception e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.isInForkedActions() && !this.wrappedDialog.isServer()) {
            try {
                Request req = this.wrappedDialog.createRequest(arg0);
                req.removeHeader("Route");
                ListeningPoint listeningPoint = this.provider.getListeningPoints()[0];
                ViaHeader viaHeader = headerFactory.createViaHeader(listeningPoint.getIPAddress(), listeningPoint.getPort(), listeningPoint.getTransport(), null);
                req.addFirst((Header)viaHeader);
                CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(this.localSequenceNumber.get() + 1L, null);
                cSeqHeader.setMethod(arg0);
                this.fillRequestHeaders(req);
                return req;
            }
            catch (Exception e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            Request req = this.wrappedDialog.createRequest(arg0);
            ListeningPoint listeningPoint = this.provider.getListeningPoints()[0];
            ViaHeader viaHeader = headerFactory.createViaHeader(listeningPoint.getIPAddress(), listeningPoint.getPort(), listeningPoint.getTransport(), null);
            req.addFirst((Header)viaHeader);
            return req;
        }
        catch (Exception e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
    }

    public Request createRequest(Request origRequest) throws SipException {
        this.generateRouteList(origRequest);
        HashSet<String> headersToOmmit = new HashSet<String>();
        Request forgedRequest = null;
        if (this.wrappedDialog != null) {
            if (!origRequest.getMethod().equals("ACK")) {
                forgedRequest = this.wrappedDialog.createRequest(origRequest.getMethod());
            } else {
                try {
                    forgedRequest = this.wrappedDialog.createAck(this.wrappedDialog.getLocalSeqNumber());
                }
                catch (InvalidArgumentException e) {
                    throw new SipException("", (Throwable)e);
                }
            }
        } else {
            try {
                MaxForwardsHeader mf = this.provider.getHeaderFactory().createMaxForwardsHeader(70);
                forgedRequest = this.provider.getMessageFactory().createRequest(null);
                forgedRequest.setRequestURI(origRequest.getRequestURI());
                forgedRequest.addHeader((Header)mf);
                forgedRequest.addHeader((Header)this.callIdToReUse);
                CSeqHeader cseqHeader = (CSeqHeader)origRequest.getHeader("CSeq");
                cseqHeader = (CSeqHeader)cseqHeader.clone();
                forgedRequest.addHeader((Header)cseqHeader);
                if (forgedRequest.getMethod() == null) {
                    ((SIPRequest)forgedRequest).setMethod(cseqHeader.getMethod());
                }
            }
            catch (Exception e) {
                throw new SipException("", (Throwable)e);
            }
        }
        this.fillRequestHeaders(forgedRequest);
        headersToOmmit.add("Route");
        headersToOmmit.add("Record-Route");
        headersToOmmit.add("Call-ID");
        headersToOmmit.add("CSeq");
        this.forgeMessage((Message)origRequest, (Message)forgedRequest, headersToOmmit);
        forgedRequest.addFirst((Header)this.provider.getLocalVia(this.provider.getListeningPoints()[0].getTransport(), null));
        return forgedRequest;
    }

    public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {
        if (this.wrappedDialog == null && !dialogCreatingMethods.contains(request.getMethod())) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
        }
        ClientTransactionWrapper CTW = (ClientTransactionWrapper)this.provider.getNewClientTransaction(request, false);
        boolean created = false;
        if (request.getMethod().compareTo("INVITE") == 0) {
            this.lastCancelableTransactionId = CTW.getBranchId();
        }
        if (this.wrappedDialog == null) {
            this.wrappedDialog = this.provider.getNewDialog((Transaction)CTW, null, false);
            this.wrappedDialog.setApplicationData((Object)this);
            created = true;
        }
        this.addOngoingTransaction(CTW);
        String method = request.getMethod();
        if (this.isInForkedActions()) {
            CTW.sendRequest();
            if (method.compareTo("ACK") != 0 && method.compareTo("CANCEL") != 0) {
                this.localSequenceNumber.incrementAndGet();
            }
        } else if (!created) {
            this.wrappedDialog.sendRequest((ClientTransaction)CTW.getWrappedTransaction());
        } else {
            CTW.sendRequest();
        }
        return CTW;
    }

    public void sendRequest(ClientTransaction ctw) throws TransactionDoesNotExistException, SipException {
        if (this.wrappedDialog == null) {
            Request request = ctw.getRequest();
            if (this.wrappedDialog == null && !dialogCreatingMethods.contains(request.getMethod())) {
                throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
            }
            ClientTransactionWrapper CTW = (ClientTransactionWrapper)ctw;
            boolean created = false;
            if (request.getMethod().equals("INVITE")) {
                this.lastCancelableTransactionId = CTW.getBranchId();
            }
            if (this.wrappedDialog == null) {
                this.wrappedDialog = this.provider.getNewDialog((Transaction)CTW, null, false);
                this.wrappedDialog.setApplicationData((Object)this);
            }
            this.addOngoingTransaction(CTW);
            if (!created) {
                this.wrappedDialog.sendRequest((ClientTransaction)CTW.getWrappedTransaction());
            } else {
                CTW.sendRequest();
            }
        } else if (this.isInForkedActions()) {
            Request r = ctw.getRequest();
            if (this.isInForkedActions() && r.getMethod().compareTo("ACK") != 0 && r.getMethod().compareTo("CANCEL") != 0) {
                this.localSequenceNumber.incrementAndGet();
            }
            ctw.sendRequest();
        } else {
            this.wrappedDialog.sendRequest((ClientTransaction)((ClientTransactionWrapper)ctw).getWrappedTransaction());
        }
    }

    public Response createResponse(ServerTransaction origServerTransaction, Response receivedResponse) throws SipException {
        Response forgedResponse;
        if (!this.hasOngoingServerTransaction(origServerTransaction.getBranchId())) {
            throw new IllegalArgumentException("Passed server transaction is not in ongoing STX list for this dialog!!!!");
        }
        try {
            forgedResponse = this.provider.getMessageFactory().createResponse(receivedResponse.getStatusCode(), origServerTransaction.getRequest());
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new SipException("Failed to forge message", (Throwable)e);
        }
        HashSet<String> headersToOmmit = new HashSet<String>();
        headersToOmmit.add("Route");
        headersToOmmit.add("Record-Route");
        headersToOmmit.add("Via");
        headersToOmmit.add("Call-ID");
        headersToOmmit.add("CSeq");
        headersToOmmit.add("Contact");
        this.forgeMessage((Message)receivedResponse, (Message)forgedResponse, headersToOmmit);
        Request origRequest = origServerTransaction.getRequest();
        ViaHeader topVia = (ViaHeader)origRequest.getHeader("Via");
        if (topVia != null) {
            Address address = this.getLocalAddressForTransport(topVia.getTransport());
            if (address != null) {
                ContactHeader contactHeader = this.provider.getHeaderFactory().createContactHeader(address);
                forgedResponse.addLast((Header)contactHeader);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to obtain contact address for AS, can not compute AS contact.");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"There is no via header, can not compute AS contact.");
        }
        ToHeader localToHeader = (ToHeader)forgedResponse.getHeader("To");
        if (localToHeader.getTag() == null && this.isServer()) {
            ToHeader otherToHeader = (ToHeader)receivedResponse.getHeader("To");
            try {
                localToHeader.setTag(otherToHeader.getTag());
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new SipException("Failed to set ToTag", (Throwable)e);
            }
        }
        return forgedResponse;
    }

    public ServerTransaction getAssociatedServerTransaction(ClientTransaction ct) {
        if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
            throw new IllegalArgumentException("Passed client transaction is not running for this dialog");
        }
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        if (ctw.getAssociatedTransactionBranchId() == null || this.ra.getActivity(ctw.getAssociationHandle()) == null) {
            return null;
        }
        DialogWrapper da = (DialogWrapper)this.ra.getActivity(ctw.getAssociationHandle());
        return da.getServerTransaction(ctw.getAssociatedTransactionBranchId());
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public void setCallIdToReUse(CallIdHeader callIdToReUse) {
        this.callIdToReUse = callIdToReUse;
    }

    private void verifyDialogExistency() {
        if (this.wrappedDialog == null) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet!");
        }
    }

    private void fillRequestHeaders(Request request) throws SipException {
        String method = request.getMethod();
        try {
            if (this.isInForkedActions() && this.wrappedDialog != null && !this.wrappedDialog.isServer()) {
                request.removeHeader("Call-ID");
                request.addLast((Header)this.wrappedDialog.getCallId());
                ToHeader toHeader = (ToHeader)request.getHeader("To");
                FromHeader fromHeader = (FromHeader)request.getHeader("From");
                if (toHeader == null || !toHeader.getAddress().equals(this.wrappedDialog.getRemoteParty())) {
                    toHeader = this.provider.getHeaderFactory().createToHeader(this.toAddress, null);
                }
                if (this.localToTag != null && this.localToTag.compareTo(toHeader.getTag()) != 0) {
                    toHeader.setTag(this.localToTag);
                }
                request.removeHeader("To");
                request.addHeader((Header)toHeader);
                if (fromHeader == null || !fromHeader.getAddress().equals(this.wrappedDialog.getLocalParty())) {
                    fromHeader = this.provider.getHeaderFactory().createFromHeader(this.wrappedDialog.getLocalParty(), this.wrappedDialog.getLocalTag());
                }
                request.removeHeader("From");
                request.addHeader((Header)fromHeader);
                if (this.localRouteSet.size() > 0) {
                    if (request.getHeaders("Route") != null && !request.getHeaders("Route").hasNext()) {
                        request.removeHeader("Route");
                    }
                    for (int i = 0; i < this.localRouteSet.size(); ++i) {
                        request.addLast((Header)this.localRouteSet.get(i));
                    }
                }
                SipURI cloned = (SipURI)this.reqeustURI.clone();
                request.setRequestURI((URI)cloned);
                CSeqHeader cseq = (CSeqHeader)request.getHeader("CSeq");
                if (cseq == null) {
                    throw new SipException("CSeq cant be null at this point!!");
                }
                if (!method.equals("CANCEL") && !method.equals("ACK")) {
                    cseq.setSeqNumber(this.localSequenceNumber.get() + 1L);
                }
                cloned.setMethodParam(cseq.getMethod());
            } else if (this.isInForkedActions() || this.wrappedDialog == null || !this.wrappedDialog.isServer()) {
                if (this.wrappedDialog == null) {
                    request.removeHeader("Call-ID");
                    request.addLast((Header)this.callIdToReUse);
                    ToHeader toHeader = (ToHeader)request.getHeader("To");
                    FromHeader fromHeader = (FromHeader)request.getHeader("From");
                    if (toHeader == null) {
                        toHeader = this.provider.getHeaderFactory().createToHeader(this.toAddress, null);
                    } else {
                        toHeader.setAddress(this.toAddress);
                        if (this.wrappedDialog != null) {
                            toHeader.setTag(this.wrappedDialog.getRemoteTag());
                        }
                    }
                    request.removeHeader("To");
                    request.addLast((Header)toHeader);
                    if (fromHeader == null || !fromHeader.getAddress().equals(this.fromAddress)) {
                        fromHeader = this.provider.getHeaderFactory().createFromHeader(this.fromAddress, this.autoGeneratedFromTag);
                    } else {
                        fromHeader.setAddress(this.fromAddress);
                        fromHeader.setTag(this.autoGeneratedFromTag);
                    }
                    request.removeHeader("From");
                    request.addLast((Header)fromHeader);
                    if (this.localRouteSet.size() > 0) {
                        if (request.getHeaders("Route") != null && !request.getHeaders("Route").hasNext()) {
                            request.removeHeader("Route");
                        }
                        for (int i = 0; i < this.localRouteSet.size(); ++i) {
                            request.addLast((Header)this.localRouteSet.get(i));
                        }
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No need to fill request headers, route set and other state should be maintaned by stack: " + this));
                }
            }
        }
        catch (Exception e) {
            throw new SipException("Couldnt add specs headers due to:", (Throwable)e);
        }
    }

    public boolean processIncomingResponse(ResponseEvent respEvent) {
        Response response = respEvent.getResponse();
        boolean firedByDialogWrapper = false;
        int statusCode = response.getStatusCode();
        String toTag = ((ToHeader)response.getHeader("To")).getTag();
        DialogForkState oldForkState = this.forkState;
        SipActivityHandle masterActivityHandle = this.getActivityHandle();
        if (this.wrappedDialog.isServer()) {
            return false;
        }
        switch (this.forkState) {
            case AWAIT_FIRST_TAG: {
                if (100 <= statusCode && statusCode < 200) {
                    if (toTag != null) {
                        this.localToTag = toTag;
                        this.forkState = DialogForkState.AWAIT_FINAL;
                        this.toTag2DialogHandle.put(this.localToTag, this.sipActivityHandle);
                        this.fetchData(response);
                        this.ra.addClientDialogMaping(this.wrappedDialog.getLocalTag() + "_" + this.wrappedDialog.getCallId().getCallId(), this.getActivityHandle());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received 1xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                    }
                    firedByDialogWrapper = false;
                    break;
                }
                if (statusCode < 300) {
                    this.forkState = DialogForkState.END;
                    if (toTag != null) {
                        this.localToTag = toTag;
                        this.toTag2DialogHandle.put(toTag, this.sipActivityHandle);
                    }
                    this.fetchData(response);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received 2xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                    }
                    firedByDialogWrapper = false;
                    this.terminateFork(masterActivityHandle);
                    break;
                }
                if (statusCode < 700) {
                    this.forkState = DialogForkState.END;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received failure message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                    }
                    int eventID = SipResourceAdaptor.eventIdCache.getEventId(this.ra.getEventLookup(), response);
                    ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                    this.ra.fireEvent((Object)REW, this.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader)response.getHeader("From")).getAddress().toString()));
                    firedByDialogWrapper = true;
                    this.terminateFork(null);
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Received strange message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                break;
            }
            case AWAIT_FINAL: {
                if (100 <= statusCode && statusCode < 200) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received 1xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                    }
                    if (toTag == null) {
                        firedByDialogWrapper = false;
                        break;
                    }
                    if (toTag.compareTo(this.localToTag) == 0) {
                        this.fetchData(response);
                        firedByDialogWrapper = false;
                        break;
                    }
                    if (this.toTag2DialogHandle.containsKey(toTag)) {
                        DialogWrapper child = (DialogWrapper)this.ra.getActivity(this.toTag2DialogHandle.get(toTag));
                        if (child == null) {
                            this.toTag2DialogHandle.remove(toTag);
                            return true;
                        }
                        child.fetchData(response);
                        int eventID = SipResourceAdaptor.eventIdCache.getEventId(this.ra.getEventLookup(), response);
                        logger.info((Object)("Received 1xx message: " + statusCode + ". ToTag:" + toTag + "EventId:" + eventID));
                        ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                        this.ra.fireEvent((Object)REW, child.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader)response.getHeader("From")).getAddress().toString()));
                        firedByDialogWrapper = true;
                        break;
                    }
                    DialogWrapper child = this.provider.getNewDialogActivity(this.wrappedDialog, this.getActivityHandle(), null);
                    child.forkState = this.forkState;
                    child.localToTag = toTag;
                    child.fetchData(response);
                    this.toTag2DialogHandle.put(toTag, child.getActivityHandle());
                    int eventID = SipResourceAdaptor.eventIdCache.getDialogForkEventId(this.ra.getEventLookup());
                    DialogForkedEvent REW = new DialogForkedEvent((Object)this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, (Dialog)child, response);
                    this.ra.fireEvent(REW, this.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader)response.getHeader("From")).getAddress().toString()));
                    firedByDialogWrapper = true;
                    break;
                }
                if (statusCode < 300) {
                    this.forkState = DialogForkState.END;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received 2xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                    }
                    if (this.localToTag != null && toTag != null && this.localToTag.compareTo(toTag) == 0) {
                        this.fetchData(response);
                        firedByDialogWrapper = false;
                    } else if (toTag != null && this.toTag2DialogHandle.containsKey(toTag)) {
                        DialogWrapper child = (DialogWrapper)this.ra.getActivity(this.toTag2DialogHandle.get(toTag));
                        child.fetchData(response);
                        masterActivityHandle = child.getActivityHandle();
                        child.makeMaster();
                        if (child != this) {
                            this.forkInitialActivityHandle = child.getActivityHandle();
                        } else {
                            logger.error((Object)("Local: " + this.localToTag + " : " + toTag + " MSG:\n" + response));
                        }
                        int eventID = SipResourceAdaptor.eventIdCache.getEventId(this.ra.getEventLookup(), response);
                        ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                        this.ra.fireEvent((Object)REW, child.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader)response.getHeader("From")).getAddress().toString()));
                        firedByDialogWrapper = true;
                    } else if (toTag != null) {
                        DialogWrapper child = this.provider.getNewDialogActivity(this.wrappedDialog, this.getActivityHandle(), null);
                        child.forkState = this.forkState;
                        child.localToTag = toTag;
                        this.toTag2DialogHandle.put(toTag, child.getActivityHandle());
                        masterActivityHandle = child.getActivityHandle();
                        child.makeMaster();
                        this.forkInitialActivityHandle = child.getActivityHandle();
                        child.fetchData(response);
                        int eventID = SipResourceAdaptor.eventIdCache.getDialogForkEventId(this.ra.getEventLookup());
                        DialogForkedEvent REW = new DialogForkedEvent((Object)this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, (Dialog)child, response);
                        this.ra.fireEvent(REW, this.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader)response.getHeader("From")).getAddress().toString()));
                        firedByDialogWrapper = true;
                    } else {
                        logger.error((Object)"Received 2xx reponse without toTag, this is error.");
                    }
                    this.terminateFork(masterActivityHandle);
                    break;
                }
                if (statusCode < 700) {
                    this.forkState = DialogForkState.END;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received failure message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                    }
                    int eventID = SipResourceAdaptor.eventIdCache.getEventId(this.ra.getEventLookup(), response);
                    ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                    this.ra.fireEvent((Object)REW, this.getActivityHandle(), eventID, new javax.slee.Address(AddressPlan.SIP, ((FromHeader)response.getHeader("From")).getAddress().toString()));
                    firedByDialogWrapper = true;
                    this.terminateFork(null);
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("Received strange message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                break;
            }
            case END: {
                if (toTag == null || toTag.equals(this.wrappedDialog.getRemoteTag())) break;
                if (statusCode < 200 || statusCode > 300) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received late message, action IGNORE: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.forkState) + ". On dialog: " + this.toString()));
                    }
                } else if (dialogCreatingMethods.contains(((CSeqHeader)response.getHeader("CSeq")).getMethod())) {
                    this.doTerminateOnLate2xx(respEvent);
                }
                firedByDialogWrapper = true;
            }
        }
        return firedByDialogWrapper;
    }

    public void doTerminateOnLate2xx(ResponseEvent respEvent) {
        try {
            Response response = respEvent.getResponse();
            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
            List routeSet = this.getRouteList(response);
            SipURI requestURI = this.getReqeustUri(response);
            long cseqNumber = cseq.getSeqNumber();
            long statusCode = response.getStatusCode();
            if (cseq.getMethod().equals("INVITE") && statusCode < 300L && statusCode >= 200L) {
                if (requestURI == null) {
                    logger.error((Object)"Cannot ack on reqeust that has empty contact!!!!");
                    return;
                }
                MaxForwardsHeader mf = this.provider.getHeaderFactory().createMaxForwardsHeader(70);
                Request forgedRequest = this.provider.getMessageFactory().createRequest(null);
                forgedRequest.setRequestURI((URI)requestURI);
                forgedRequest.addHeader((Header)mf);
                forgedRequest.addHeader(response.getHeader("Call-ID"));
                forgedRequest.addHeader((Header)this.provider.getHeaderFactory().createCSeqHeader(cseqNumber, "ACK"));
                forgedRequest.addHeader(response.getHeader("From"));
                forgedRequest.addHeader(response.getHeader("To"));
                for (Header h : routeSet) {
                    forgedRequest.addLast(h);
                }
                forgedRequest.addHeader((Header)this.provider.getLocalVia(this.provider.getListeningPoints()[0].getTransport(), null));
                ((SIPRequest)forgedRequest).setMethod("ACK");
                this.provider.sendRequest(forgedRequest);
                forgedRequest = this.provider.getMessageFactory().createRequest(null);
                forgedRequest.setRequestURI((URI)requestURI);
                forgedRequest.addHeader((Header)mf);
                forgedRequest.addHeader(response.getHeader("Call-ID"));
                forgedRequest.addHeader((Header)this.provider.getHeaderFactory().createCSeqHeader(cseqNumber + 1L, "BYE"));
                forgedRequest.addHeader(response.getHeader("From"));
                forgedRequest.addHeader(response.getHeader("To"));
                for (Header h : routeSet) {
                    forgedRequest.addLast(h);
                }
                forgedRequest.addHeader((Header)this.provider.getLocalVia(this.provider.getListeningPoints()[0].getTransport(), null));
                ((SIPRequest)forgedRequest).setMethod("BYE");
                this.provider.sendRequest(forgedRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SipURI getReqeustUri(Response response) {
        ContactHeader contact = (ContactHeader)response.getHeader("Contact");
        if (contact != null) {
            SipURI contactURI = (SipURI)contact.getAddress().getURI();
            try {
                SipURI requestURI = this.provider.getAddressFactory().createSipURI(contactURI.getUser(), contactURI.getHost());
                requestURI.setPort(contactURI.getPort());
                return requestURI;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private List getRouteList(Response response) {
        ArrayList<RouteHeader> routeList = new ArrayList<RouteHeader>();
        ListIterator rrLit = response.getHeaders("Record-Route");
        while (rrLit.hasNext()) {
            RecordRouteHeader rrh = (RecordRouteHeader)rrLit.next();
            RouteHeader rh = this.provider.getHeaderFactory().createRouteHeader(rrh.getAddress());
            Iterator pIt = rrh.getParameterNames();
            while (pIt.hasNext()) {
                String pName = (String)pIt.next();
                try {
                    rh.setParameter(pName, rrh.getParameter(pName));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            routeList.add(0, rh);
        }
        return routeList;
    }

    private void fetchData(Response response) {
        ContactHeader contact;
        if (this.localToTag == null) {
            this.localToTag = ((ToHeader)response.getHeader("To")).getTag();
            this.reqeustURI = null;
            this.localRouteSet.clear();
        }
        if ((contact = (ContactHeader)response.getHeader("Contact")) != null && (this.reqeustURI == null || contact != null && !this.reqeustURI.equals(contact.getAddress().getURI()))) {
            this.reqeustURI = (SipURI)contact.getAddress().getURI();
        }
        if (this.localRouteSet.size() == 0 || this.routeSetOnRequest) {
            this.routeSetOnRequest = false;
            this.localRouteSet.clear();
            this.localRouteSet.addAll(this.getRouteList(response));
        }
        this.setCallIdToReUse((CallIdHeader)response.getHeader("Call-ID"));
    }

    public void generateRouteList(Request origRequest) {
        if (this.wrappedDialog == null) {
            ViaHeader topVia = (ViaHeader)origRequest.getHeader("Via");
            Address address = null;
            if (topVia == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"There is no via header, can not compute AS contact. Skipping computation of request route.");
                }
                return;
            }
            address = this.getLocalAddressForTransport(topVia.getTransport());
            ListIterator lit = origRequest.getHeaders("Route");
            if (lit != null) {
                GenericURI addressURI = (GenericURI)(address == null ? null : address.getURI());
                while (lit.hasNext()) {
                    RouteHeader rh = (RouteHeader)lit.next();
                    GenericURI rhURI = (GenericURI)rh.getAddress().getURI();
                    if (addressURI != null && rhURI.equals((Object)addressURI)) continue;
                    this.localRouteSet.add(rh);
                }
            }
        }
    }

    private Address getLocalAddressForTransport(String transport) {
        ListeningPoint lp = this.provider.getListeningPoint(transport);
        Address address = null;
        if (lp != null) {
            try {
                address = this.provider.getAddressFactory().createAddress("Mobicents SIP AS <sip:" + lp.getIPAddress() + ">");
                ((SipURI)address.getURI()).setPort(lp.getPort());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("There is no listening point, for transport: " + transport + ", can not compute AS contact."));
        }
        return address;
    }

    private void terminateFork(SipActivityHandle masterToRetain) {
        HashSet tagSet = new HashSet(this.toTag2DialogHandle.keySet());
        Iterator tagIterator = tagSet.iterator();
        while (tagIterator.hasNext()) {
            String tag = (String)tagIterator.next();
            if (masterToRetain != null && this.toTag2DialogHandle.get(tag) == masterToRetain) {
                tagIterator.remove();
                continue;
            }
            DialogWrapper dw = (DialogWrapper)this.ra.getActivity(this.toTag2DialogHandle.get(tag));
            if (dw == null) {
                this.toTag2DialogHandle.remove(tag);
                tagIterator.remove();
                continue;
            }
            dw.delete();
        }
    }

    private void makeMaster() {
        this.forkState = DialogForkState.END;
        this.forkInitialActivityHandle = null;
        this.wrappedDialog.setApplicationData((Object)this);
        this.ra.addClientDialogMaping(this.wrappedDialog.getLocalTag() + "_" + this.wrappedDialog.getCallId().getCallId(), this.getActivityHandle());
    }

    protected boolean isInForkedActions() {
        return this.forkInitialActivityHandle != null || this.forkState == DialogForkState.AWAIT_FINAL;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("INVITE");
        set.add("REFER");
        set.add("SUBSCRIBE");
        dialogCreatingMethods = Collections.unmodifiableSet(set);
        logger = Logger.getLogger(DialogWrapper.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DialogForkState {
        AWAIT_FIRST_TAG,
        AWAIT_FINAL,
        END;

    }
}

