package org.mobicents.slee.resource.sip11.wrappers;

import javax.sip.Transaction;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;

import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip11.SipActivityHandle;

public abstract class SuperTransactionWrapper implements WrapperSuperInterface{

	protected SipActivityHandle sipActivityHandle;
	protected Transaction wrappedTransaction;
	
	private int eventDelivery = 0;
	private boolean activity  = true;
	public Object getApplicationData() {
		throw new SecurityException();
	}

	public void setApplicationData(Object arg0) {
		throw new SecurityException();
	}
	
	public SipActivityHandle getActivityHandle() {
		return this.sipActivityHandle;
	}

	public Transaction getWrappedTransaction() {
		return wrappedTransaction;
	}

	public boolean isDelivering() {
		return this.eventDelivery>0;
	}

	public void setEventDelivery(boolean flag) {
		if(flag)
		{
			this.eventDelivery++;
		}else if(this.eventDelivery>0)
		{
			this.eventDelivery--;
		}
	}
	
	
	public static SipActivityHandle generateHandle(Transaction t)
	{
		SipActivityHandle sah=new SipActivityHandle(t.getBranchId() + "_"
				+ t.getRequest().getMethod());
		return sah;
	}
	public static SipActivityHandle generateHandle(Message m)
	{
	
		return generateHandle(m,false);
	}
	public static SipActivityHandle generateHandle(Message m, boolean retransmission)
	{
		
		String branch = ((ViaHeader)m.getHeader(ViaHeader.NAME)).getBranch();
		String method = ((CSeqHeader)m.getHeader(CSeqHeader.NAME)).getMethod();
		SipActivityHandle sah=new SipActivityHandle(branch+ "_"	+ method+(retransmission?("_"+Math.random()):""));
		return sah;
	}
	public boolean isActivity() {
		return this.activity;
	}

	public void markActivity(boolean f) {

		this.activity = f;
	}

}

