/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.AddressFactory;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.InvalidStateException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import javax.transaction.TransactionManager;
import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.sip11.EventIDCache;
import org.mobicents.slee.resource.sip11.EventIDFilter;
import org.mobicents.slee.resource.sip11.SipActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.mbean.SipRaConfiguration;
import org.mobicents.slee.resource.sip11.wrappers.ACKDummyTransaction;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.RequestEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.SuperTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TimeoutEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionTerminatedEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.WrapperSuperInterface;
import org.mobicents.slee.runtime.transaction.SleeTransactionManager;

public class SipResourceAdaptor
implements SipListener,
ResourceAdaptor,
Serializable {
    private static final transient Logger log = Logger.getLogger(SipResourceAdaptor.class);
    private static final String SIP_BIND_ADDRESS = "javax.sip.IP_ADDRESS";
    private static final String SIP_PORT_BIND = "javax.sip.PORT";
    private static final String TRANSPORTS_BIND = "javax.sip.TRANSPORT";
    private static final String STACK_NAME_BIND = "javax.sip.STACK_NAME";
    private int port = 5060;
    private Set<String> transports = new HashSet<String>();
    private Set<String> allowedTransports = new HashSet<String>();
    private String stackAddress = "0.0.0.0";
    private transient SipProvider provider;
    private transient SleeSipProviderImpl providerProxy = null;
    private static Set rfc3261Methods = new HashSet();
    private static Set<String> stxedRequests = new HashSet<String>();
    private transient Map<String, SipActivityHandle> fromTagCallId2Handle = null;
    private transient Map<SipActivityHandle, Object> activities = null;
    private transient SipActivityContextInterfaceFactory acif;
    private String entityName = "SipRA";
    private ResourceAdaptorState state;
    private String configurationMBeanName = "SipRA_1_1_Configuration";
    private Properties properties;
    private Properties provisionedProperties = new Properties();
    private transient Address address;
    private transient SleeEndpoint sleeEndpoint;
    private transient EventLookupFacility eventLookup;
    public static final transient EventIDCache eventIdCache;
    private static final transient EventIDFilter eventIDFilter;
    private transient BootstrapContext bootstrapContext;
    private transient SleeContainer serviceContainer;
    private transient SleeTransactionManager tm = null;
    private transient SipStack sipStack = null;
    private transient SipFactory sipFactory = null;

    public SipResourceAdaptor() {
        this.allowedTransports.add("udp");
        this.allowedTransports.add("tcp");
        this.transports.add("udp");
    }

    private Properties loadProperties(BootstrapContext bootstrapContext) {
        Properties props = new Properties();
        try {
            String bindAddress;
            props.load(this.getClass().getResourceAsStream("sipra.properties"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading default SIP RA properties: " + props));
            }
            if ((bindAddress = props.getProperty(SIP_BIND_ADDRESS)) == null && (bindAddress = System.getProperty("jboss.bind.address")) != null) {
                props.setProperty(SIP_BIND_ADDRESS, bindAddress);
            }
        }
        catch (IOException ex) {
            props.setProperty("javax.sip.RETRANSMISSION_FILTER", "on");
        }
        return props;
    }

    public void configure(Properties properties) throws InvalidStateException {
        String confValue;
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new InvalidStateException("Cannot configure RA wrong state: " + this.state);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuring RA" + properties));
        }
        this.properties = this.loadProperties(this.bootstrapContext);
        if (properties != null) {
            if (log.isDebugEnabled()) {
                for (Map.Entry<Object, Object> en : properties.entrySet()) {
                    log.debug((Object)("---[SetHotProps][" + this.entityName + "] " + en.getKey() + " [*] " + en.getValue()));
                }
            }
            this.properties.putAll((Map<?, ?>)properties);
        }
        if ((confValue = this.properties.getProperty(SIP_PORT_BIND)) != null) {
            this.port = Integer.parseInt(confValue);
            confValue = null;
        }
        if ((confValue = this.properties.getProperty(TRANSPORTS_BIND, "udp")) != null) {
            String[] tmp = confValue.split(",");
            if (tmp.length > 0) {
                boolean valid = false;
                int i = 0;
                if (i < tmp.length && this.allowedTransports.contains(tmp[i])) {
                    valid = true;
                }
                if (valid) {
                    this.transports.clear();
                    for (i = 0; i < tmp.length; ++i) {
                        if (this.allowedTransports.contains(tmp[i])) {
                            this.transports.add(tmp[i]);
                            continue;
                        }
                        log.error((Object)(" TRANSPORT[" + tmp[i] + "] IS NOT A VALID TRANSPORT!!!"));
                    }
                }
            }
            confValue = null;
        }
        if ((confValue = this.properties.getProperty(SIP_BIND_ADDRESS)) != null) {
            this.stackAddress = confValue;
            this.properties.remove(SIP_BIND_ADDRESS);
            confValue = null;
        } else {
            this.stackAddress = System.getProperty("jboss.bind.address");
        }
        confValue = this.properties.getProperty(STACK_NAME_BIND);
        confValue = confValue == null ? "SipResourceAdaptorStack_" + this.stackAddress + "_" + this.port : confValue + "_" + this.stackAddress + "_" + this.port;
        this.properties.put(STACK_NAME_BIND, confValue);
        confValue = null;
        int i = 0;
        for (i = 0; i < 10; ++i) {
            InetSocketAddress sockAddress = new InetSocketAddress(this.stackAddress, this.port);
            try {
                log.info((Object)("Trying to bind to " + sockAddress));
                DatagramSocket socket = new DatagramSocket(sockAddress);
                this.properties.setProperty(SIP_PORT_BIND, Integer.valueOf(this.port).toString());
                socket.close();
                break;
            }
            catch (Exception ex) {
                this.port += 10;
                continue;
            }
        }
        if (i == 10) {
            throw new RuntimeException("Cannot create SIP Resource adaptor - no port available to bind to ");
        }
        log.info((Object)("RA bound to " + this.port));
        this.state = ResourceAdaptorState.CONFIGURED;
    }

    public void start() throws ResourceException {
        try {
            this.initializeNamingContext();
            this.initializeStack();
            this.activities = new ConcurrentHashMap<SipActivityHandle, Object>();
            this.fromTagCallId2Handle = new ConcurrentHashMap<String, SipActivityHandle>();
            this.state = ResourceAdaptorState.ACTIVE;
            boolean created = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("---> START " + Arrays.toString(this.transports.toArray())));
            }
            for (String trans : this.transports) {
                ListeningPoint lp = this.sipStack.createListeningPoint(this.stackAddress, this.port, trans);
                if (!created) {
                    this.provider = this.sipStack.createSipProvider(lp);
                    created = true;
                } else {
                    this.provider.addListeningPoint(lp);
                }
                try {
                    this.provider.addSipListener((SipListener)this);
                }
                catch (Exception ex) {
                    String msg = "SIP RA failed to register as SipListener";
                    log.error((Object)msg, (Throwable)ex);
                    throw new ResourceException(msg);
                }
            }
            AddressFactory addressFactory = this.sipFactory.createAddressFactory();
            HeaderFactory headerFactory = this.sipFactory.createHeaderFactory();
            MessageFactory messageFactory = this.sipFactory.createMessageFactory();
            this.providerProxy = new SleeSipProviderImpl(addressFactory, headerFactory, messageFactory, this.sipStack, this, this.provider, (TransactionManager)this.tm);
            String[] tmpTransports = this.transports.toArray(new String[this.transports.size()]);
            SipRaConfiguration sipc = new SipRaConfiguration(false, this.stackAddress, tmpTransports, this.port);
            sipc.startService(this.configurationMBeanName + "_" + this.entityName);
        }
        catch (Exception ex) {
            String msg = "error in initializing resource adaptor";
            log.error((Object)msg, (Throwable)ex);
            throw new ResourceException(msg);
        }
    }

    protected void initializeStack() throws SipException {
        this.sipFactory = SipFactory.getInstance();
        this.sipFactory.setPathName("gov.nist");
        this.properties.remove(SIP_PORT_BIND);
        this.sipStack = this.sipFactory.createSipStack(this.properties);
        this.sipStack.start();
    }

    public void setProperties(Properties properties) throws ResourceException {
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new ResourceException("Cannot modify configuration properties wrong state: " + this.state);
        }
        this.properties = properties;
    }

    public Properties getProperties(Properties pproperties) {
        pproperties.putAll((Map<?, ?>)this.properties);
        return pproperties;
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container;
        this.serviceContainer = container = SleeContainer.lookupFromJndi();
        SipResourceAdaptor sipResourceAdaptor = this;
        this.tm = sipResourceAdaptor.serviceContainer.getTransactionManager();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(this.bootstrapContext.getEntityName());
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        SleeContainer sleeContainer = resourceAdaptorEntity.getServiceContainer();
        String string = this.bootstrapContext.getEntityName();
        resourceAdaptorEntity.getServiceContainer();
        this.acif = new SipActivityContextInterfaceFactoryImpl(sleeContainer, string, this, SleeContainer.getTransactionManager());
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        this.entityName = this.bootstrapContext.getEntityName();
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("jndiName prefix =" + prefix + "; jndiName = " + name));
                }
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    public void stopping() {
        this.state = ResourceAdaptorState.STOPPING;
    }

    public void stop() {
        SipRaConfiguration.stopService(this.configurationMBeanName + "_" + this.entityName);
        this.provider.removeSipListener((SipListener)this);
        ListeningPoint[] listeningPoints = this.provider.getListeningPoints();
        block6: for (int i = 0; i < listeningPoints.length; ++i) {
            ListeningPoint lp = listeningPoints[i];
            for (int k = 0; k < 10; ++k) {
                try {
                    this.sipStack.deleteListeningPoint(lp);
                    this.sipStack.deleteSipProvider(this.provider);
                    continue block6;
                }
                catch (ObjectInUseException ex) {
                    log.error((Object)"Object in use -- retrying to delete listening point", (Throwable)ex);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            log.error((Object)"Cannot unbind naming context", (Throwable)e);
        }
        this.state = ResourceAdaptorState.UNCONFIGURED;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sip Resource Adaptor stopped.");
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SipResourceAdaptor: init()");
        }
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    public void entityActivated() throws ResourceException {
        try {
            this.configure(this.provisionedProperties);
            this.start();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
        catch (InvalidStateException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivating() {
        this.stopping();
    }

    public void entityDeactivated() {
        this.stop();
    }

    public void entityRemoved() {
    }

    public void activityEnded(ActivityHandle handle) {
        WrapperSuperInterface wsi;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing activity for handle[" + handle + "] activity[" + this.activities.get(handle) + "]."));
        }
        if ((wsi = (WrapperSuperInterface)this.activities.remove(handle)) == null) {
            if (log.isEnabledFor((Priority)Level.WARN)) {
                log.warn((Object)("No wrapper for handle[" + handle + "] activity[" + this.activities.get(handle) + "] on activity ended."));
            }
            return;
        }
        this.performActivityEndActions(wsi);
    }

    private void performActivityEndActions(WrapperSuperInterface wsi) {
        SuperTransactionWrapper stw;
        DialogWrapper dw = null;
        if (wsi instanceof SuperTransactionWrapper && (stw = (SuperTransactionWrapper)wsi).getWrappedTransaction().getDialog() != null && stw.getWrappedTransaction().getDialog().getApplicationData() instanceof DialogWrapper) {
            dw = (DialogWrapper)stw.getWrappedTransaction().getDialog().getApplicationData();
            if (wsi instanceof ServerTransactionWrapper) {
                dw.removeOngoingTransaction((ServerTransactionWrapper)wsi);
            } else if (wsi instanceof ClientTransactionWrapper) {
                dw.removeOngoingTransaction((ClientTransactionWrapper)wsi);
            } else {
                throw new RuntimeException("Unknown type " + wsi.getClass() + " of SIP Transaction, can't remove from dialog wrapper");
            }
        }
        if (wsi != null) {
            wsi.cleanup();
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle handle, Object event, int arg2, Address arg3, int arg4, FailureReason arg5) {
        String id = ((SipActivityHandle)handle).getID();
        this.testForDummyActivityTermination(event);
        if (!id.endsWith("CANCEL") || !(event instanceof CancelRequestEvent)) {
            return;
        }
        try {
            Response txDoesNotExistsResponse = this.providerProxy.getMessageFactory().createResponse(481, ((CancelRequestEvent)event).getRequest());
            ServerTransactionWrapper stw = (ServerTransactionWrapper)this.getActivity(handle);
            if (stw != null) {
                stw.sendResponse(txDoesNotExistsResponse);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, Object event, int arg2, Address arg3, int arg4) {
        if (this.testForDummyActivityTermination(event)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testForDummyActivityTermination(Object event) {
        ClientTransactionWrapper ctw = null;
        if (event instanceof TimeoutEvent) {
            TimeoutEventWrapper te = (TimeoutEventWrapper)((Object)event);
            ctw = (ClientTransactionWrapper)te.getClientTransaction();
            if (ctw == null) {
                return false;
            }
            if (ctw != null && !ctw.isActivity()) {
                ClientTransactionWrapper clientTransactionWrapper = ctw;
                synchronized (clientTransactionWrapper) {
                    ctw.setEventDelivery(false);
                    if (!ctw.isDelivering() && ctw.getState() == TransactionState.TERMINATED) {
                        this.performActivityEndActions(ctw);
                        return true;
                    }
                }
            }
        } else if (event instanceof ResponseEventWrapper) {
            ResponseEventWrapper rew = (ResponseEventWrapper)((Object)event);
            ctw = (ClientTransactionWrapper)rew.getClientTransaction();
            if (ctw == null) {
                return false;
            }
            int statusCode = rew.getResponse().getStatusCode();
            ClientTransactionWrapper clientTransactionWrapper = ctw;
            synchronized (clientTransactionWrapper) {
                if (!ctw.isActivity()) {
                    ctw.setEventDelivery(false);
                    if (statusCode >= 200 && !ctw.isDelivering() && ctw.getState() == TransactionState.TERMINATED) {
                        this.performActivityEndActions(ctw);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Object getActivity(ActivityHandle arg0) {
        if (arg0 instanceof SipActivityHandle) {
            return this.activities.get(arg0);
        }
        return null;
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public EventLookupFacility getEventLookup() {
        return this.eventLookup;
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        return this.providerProxy;
    }

    public void queryLiveness(ActivityHandle arg0) {
    }

    public void serviceInstalled(String serviceID, int[] eventIDs, String[] resourceOptions) {
        eventIDFilter.serviceInstalled(serviceID, eventIDs);
    }

    public void serviceUninstalled(String serviceID) {
        eventIDFilter.serviceUninstalled(serviceID);
    }

    public void serviceActivated(String serviceID) {
        eventIDFilter.serviceActivated(serviceID);
    }

    public void serviceDeactivated(String serviceID) {
        eventIDFilter.serviceDeactivated(serviceID);
    }

    public void processIOException(IOExceptionEvent arg0) {
    }

    /*
     * Unable to fully structure code
     */
    public void processRequest(RequestEvent req) {
        if (SipResourceAdaptor.log.isInfoEnabled()) {
            SipResourceAdaptor.log.info((Object)("Received Request:\n" + req.getRequest()));
        }
        st = req.getServerTransaction();
        stw = null;
        if (st == null || st.getApplicationData() == null) {
            try {
                if (req.getDialog() == null && req.getRequest().getMethod().equals("ACK")) {
                    st = new ACKDummyTransaction(req.getRequest());
                }
                stw = (ServerTransactionWrapper)this.providerProxy.getNewServerTransaction(req.getRequest(), st);
                st = (ServerTransaction)stw.getWrappedTransaction();
                if (!SipResourceAdaptor.log.isDebugEnabled()) ** GOTO lbl23
                SipResourceAdaptor.log.debug((Object)("\n----------------- CREATED NEW STx ---------------------\nBRANCH: " + st.getBranchId() + "\n-------------------------------------------------------"));
            }
            catch (TransactionAlreadyExistsException e) {
                if (SipResourceAdaptor.log.isDebugEnabled()) {
                    SipResourceAdaptor.log.debug((Object)("Request where the server tx already exists, should be a retransmission and will be dropped. Request: \n" + req.getRequest() + "\n-------------------------"), (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                SipResourceAdaptor.log.error((Object)("\n-------------------------\nREQUEST:\n-------------------------\n" + req.getRequest() + "\n-------------------------"), (Throwable)e);
                this.sendErrorResponse(st, req.getRequest(), 500, e.getMessage());
                return;
            }
        } else {
            stw = (ServerTransactionWrapper)st.getApplicationData();
        }
lbl23:
        // 3 sources

        if (req.getRequest().getMethod().equals("CANCEL")) {
            this.processCancelRequest(st, stw, req);
        } else {
            this.processNotCancelRequest(st, stw, req);
        }
    }

    private void processCancelRequest(ServerTransaction st, ServerTransactionWrapper STW, RequestEvent req) {
        SipActivityHandle inviteHandle = STW.getInviteHandle();
        ServerTransactionWrapper inviteSTW = (ServerTransactionWrapper)this.getActivity(inviteHandle);
        CancelRequestEvent REW = null;
        boolean inDialog = false;
        SipActivityHandle SAH = null;
        if (inviteSTW != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found INVITE transaction CANCEL[" + STW + "] \nINVITE[" + inviteSTW + "]"));
            }
            if (inviteSTW.getState() == TransactionState.TERMINATED || inviteSTW.getState() == TransactionState.COMPLETED || inviteSTW.getState() == TransactionState.CONFIRMED) {
                log.error((Object)("Invite transaction has been found in state other than proceeding(" + inviteSTW.getState() + "), final response sent, sending BAD_REQUEST"));
                try {
                    Response response = this.providerProxy.getMessageFactory().createResponse(400, req.getRequest());
                    STW.sendResponse(response);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (inviteSTW.getDialog() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found DIALOG transaction CANCEL[" + STW + "]\nINVITE[" + inviteSTW + "]\nDialog[" + inviteSTW.getDialog() + "]\nSEQUENCE:Send200ToCANCEL,FireEventOnDialog,Send487ToInvite"));
                }
                SAH = ((DialogWrapper)inviteSTW.getDialog()).getActivityHandle();
                inDialog = true;
                REW = new CancelRequestEvent((Object)this.providerProxy, (ServerTransaction)STW, (ServerTransaction)inviteSTW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DIALOG not found transaction CANCEL[" + STW + "]\nINVITE[" + inviteSTW + "]\nDialog[" + inviteSTW.getDialog() + "]\nSEQUENCE:FireEventOnInvite"));
                }
                SAH = inviteSTW.getActivityHandle();
                inDialog = false;
                REW = new CancelRequestEvent((Object)this.providerProxy, (ServerTransaction)STW, (ServerTransaction)inviteSTW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("INVITE not found transaction CANCEL[" + STW + "]\nSEQUENCE:FireEventOnCancel"));
            }
            SAH = STW.getActivityHandle();
            inDialog = false;
            REW = new CancelRequestEvent((Object)this.providerProxy, (ServerTransaction)STW, (ServerTransaction)inviteSTW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
        }
        int eventID = eventIdCache.getEventId(this.eventLookup, REW.getRequest(), inDialog);
        this.fireEvent(REW, SAH, eventID, new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()), null);
    }

    private void processNotCancelRequest(ServerTransaction st, ServerTransactionWrapper STW, RequestEvent req) {
        SipActivityHandle SAH = null;
        DialogWrapper DW = null;
        boolean inDialog = false;
        if (st.getDialog() != null) {
            Dialog d = st.getDialog();
            if (d.getApplicationData() != null && d.getApplicationData() instanceof DialogActivity) {
                DW = (DialogWrapper)d.getApplicationData();
                inDialog = true;
                SAH = DW.getActivityHandle();
                DW.addOngoingTransaction(STW);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dialog [" + d + "] exists, but no wrapper is present. Delivering event on TX"));
                }
                inDialog = false;
                SAH = STW.getActivityHandle();
            }
        } else {
            SAH = STW.getActivityHandle();
        }
        RequestEventWrapper REW = new RequestEventWrapper(this.providerProxy, STW, (Dialog)DW, req.getRequest());
        if (!this.fireEvent((Object)REW, SAH, eventIdCache.getEventId(this.eventLookup, REW.getRequest(), inDialog), new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()), null)) {
            this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to deliver request event to JAIN SLEE container");
        } else if (!inDialog && STW.getWrappedTransaction() instanceof ACKDummyTransaction) {
            this.processTransactionTerminated(new TransactionTerminatedEventWrapper((Object)this.providerProxy, (ServerTransaction)STW.getWrappedTransaction()));
        }
    }

    public void processResponse(ResponseEvent resp) {
        try {
            boolean inDialog;
            DialogWrapper DW;
            String method;
            int statusCode;
            block18: {
                ClientTransactionWrapper CTW;
                SipActivityHandle SAH;
                block17: {
                    ClientTransaction ct;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Received Response:\n" + resp.getResponse()));
                    }
                    if ((ct = resp.getClientTransaction()) == null) {
                        this.processLateResponse(resp);
                        return;
                    }
                    statusCode = resp.getResponse().getStatusCode();
                    method = ((CSeqHeader)resp.getResponse().getHeader("CSeq")).getMethod();
                    if (ct.getApplicationData() == null || !(ct.getApplicationData() instanceof ClientTransactionWrapper)) {
                        log.error((Object)("Received app data[" + ct.getApplicationData() + "] - should be instance of wrapper class!!"));
                        return;
                    }
                    SAH = null;
                    CTW = (ClientTransactionWrapper)ct.getApplicationData();
                    DW = null;
                    inDialog = false;
                    if (ct.getDialog() != null) {
                        Dialog d = ct.getDialog();
                        if (d.getApplicationData() != null && d.getApplicationData() instanceof DialogActivity) {
                            DW = (DialogWrapper)d.getApplicationData();
                            SAH = DW.getActivityHandle();
                            inDialog = true;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Dialog [" + d + "] exists, but no wrapper is present. Delivering event on TX"));
                            }
                            inDialog = false;
                            SAH = CTW.getActivityHandle();
                        }
                    } else {
                        SAH = CTW.getActivityHandle();
                    }
                    if (!inDialog) break block17;
                    if (DialogWrapper.dialogCreatingMethods.contains(method) && DW.processIncomingResponse(resp)) break block18;
                }
                ResponseEventWrapper REW = new ResponseEventWrapper(this.providerProxy, CTW, (Dialog)DW, resp.getResponse());
                int eventID = eventIdCache.getEventId(this.eventLookup, REW.getResponse());
                this.fireEvent((Object)REW, SAH, eventID, new Address(AddressPlan.SIP, ((FromHeader)resp.getResponse().getHeader("From")).getAddress().toString()), CTW);
            }
            if (!(statusCode != 481 && statusCode != 408 || !inDialog || method.equals("INVITE") && method.equals("SUBSCRIBE"))) {
                try {
                    Request bye = DW.createRequest("BYE");
                    this.provider.sendRequest(bye);
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processLateResponse(ResponseEvent resp) throws SipException {
        int _statusCode = resp.getResponse().getStatusCode();
        if (_statusCode < 200 || _statusCode >= 300) {
            return;
        }
        String callId = ((CallID)resp.getResponse().getHeader("Call-ID")).getCallId();
        String _method = ((CSeq)resp.getResponse().getHeader("CSeq")).getMethod();
        String branchId = ((Via)resp.getResponse().getHeaders("Via").next()).getBranch();
        String toTag = ((ToHeader)resp.getResponse().getHeader("To")).getTag();
        if (log.isInfoEnabled()) {
            log.info((Object)("ClientTransaction is null posible late 2xx. ToTag[" + toTag + "] Dialog[" + resp.getDialog() + "] CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
        }
        if (DialogWrapper.dialogCreatingMethods.contains(_method)) {
            String masterDialogKey = DialogWrapper.generateMasterKey(((FromHeader)resp.getResponse().getHeader("From")).getTag(), (CallIdHeader)resp.getResponse().getHeader("Call-ID"));
            DialogWrapper dw = this.getDialogActivityFromMasterKey(masterDialogKey);
            if (dw != null) {
                dw.processIncomingResponse(resp);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message was late 2xx, dialog wrapper processed it. CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No master dialog wrapper, using default. CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
                }
                this.processIncomingLateResponseOnTx(resp);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("===> ClientTransaction is NULL, along with dialog - RTR ? CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
            }
            this.processIncomingLateResponseOnTx(resp);
        }
    }

    private void processIncomingLateResponseOnTx(ResponseEvent resp) {
        SipActivityHandle sah = SuperTransactionWrapper.generateHandle((Message)resp.getResponse(), true);
        int eventID = eventIdCache.getEventId(this.getEventLookup(), resp.getResponse());
        ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, null, null, resp.getResponse());
        if (this.fireEvent((Object)REW, sah, eventID, new Address(AddressPlan.SIP, ((FromHeader)resp.getResponse().getHeader("From")).getAddress().toString()), null)) {
            try {
                this.sleeEndpoint.activityEnding((ActivityHandle)sah);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DialogWrapper getDialogActivityFromMasterKey(String key) {
        SipActivityHandle masterHandle = this.fromTagCallId2Handle.get(key);
        if (masterHandle == null) {
            return null;
        }
        Object activity = this.getActivity(masterHandle);
        if (activity instanceof DialogWrapper) {
            return (DialogWrapper)activity;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void processTimeout(TimeoutEvent arg0) {
        block29: {
            block27: {
                block28: {
                    block25: {
                        block26: {
                            t = null;
                            wsi = null;
                            dialogPresent = false;
                            handleToFire = null;
                            txHandle = null;
                            tew = null;
                            address = null;
                            isServerTransaction = false;
                            dw = null;
                            method = null;
                            ctw = null;
                            if (SipResourceAdaptor.log.isInfoEnabled()) {
                                if (arg0.isServerTransaction()) {
                                    SipResourceAdaptor.log.info((Object)("Server transaction " + arg0.getServerTransaction().getBranchId() + " timer expired"));
                                } else {
                                    SipResourceAdaptor.log.info((Object)("Client transaction " + arg0.getClientTransaction().getBranchId() + " timer expired"));
                                }
                            }
                            if (arg0.isServerTransaction()) ** GOTO lbl44
                            t = arg0.getClientTransaction();
                            if (t.getApplicationData() != null && t.getApplicationData() instanceof ClientTransactionWrapper) break block25;
                            if (SipResourceAdaptor.log.isEnabledFor((Priority)Level.ERROR)) {
                                SipResourceAdaptor.log.error((Object)("FAILURE on processTimeout - CTX. Wrong app data[" + t.getApplicationData() + "] branch[" + t.getBranchId() + "]"));
                            }
                            if (handleToFire == null) break block26;
                            if (ctw == null || ctw.isActivity()) {
                                ctw = null;
                            }
                            this.fireEvent((Object)tew, handleToFire, SipResourceAdaptor.eventIdCache.getTransactionTimeoutEventId(this.eventLookup, dialogPresent), new Address(AddressPlan.SIP, address), ctw);
                        }
                        if (method != null && method.equals("BYE") && dialogPresent) {
                            dw.delete();
                        }
                        return;
                    }
                    tew = new TimeoutEventWrapper((Object)this.providerProxy, (ClientTransaction)t.getApplicationData(), arg0.getTimeout());
                    ctw = (ClientTransactionWrapper)t.getApplicationData();
                    txHandle = ctw.getActivityHandle();
                    wsi = ctw;
                    if (ctw.getDialog() != null && ctw.getDialog() instanceof DialogWrapper) {
                        dialogPresent = true;
                        dw = (DialogWrapper)ctw.getDialog();
                    } else {
                        handleToFire = txHandle;
                    }
                    ** GOTO lbl68
lbl44:
                    // 1 sources

                    t = arg0.getServerTransaction();
                    if (t.getApplicationData() != null && t.getApplicationData() instanceof ServerTransactionWrapper) break block27;
                    if (SipResourceAdaptor.log.isEnabledFor((Priority)Level.ERROR)) {
                        SipResourceAdaptor.log.error((Object)("FAILURE on processTimeout - STX. Wrong app data[" + t.getApplicationData() + "] branch[" + t.getBranchId() + "]"));
                    }
                    if (handleToFire == null) break block28;
                    if (ctw == null || ctw.isActivity()) {
                        ctw = null;
                    }
                    this.fireEvent((Object)tew, handleToFire, SipResourceAdaptor.eventIdCache.getTransactionTimeoutEventId(this.eventLookup, dialogPresent), new Address(AddressPlan.SIP, address), ctw);
                }
                if (method != null && method.equals("BYE") && dialogPresent) {
                    dw.delete();
                }
                return;
            }
            try {
                isServerTransaction = true;
                stw = (ServerTransactionWrapper)t.getApplicationData();
                wsi = (WrapperSuperInterface)t.getApplicationData();
                txHandle = stw.getActivityHandle();
                if (stw.getDialog() != null && stw.getDialog() instanceof DialogWrapper) {
                    dialogPresent = true;
                    dw = (DialogWrapper)stw.getDialog();
                } else {
                    handleToFire = txHandle;
                }
lbl68:
                // 4 sources

                if (dialogPresent && !isServerTransaction) {
                    handleToFire = dw.getActivityHandle();
                }
                method = t.getRequest().getMethod();
                address = ((FromHeader)t.getRequest().getHeader("From")).getAddress().toString();
                if (handleToFire == null) break block29;
            }
            catch (RuntimeException re) {
                try {
                    re.printStackTrace();
                    throw re;
                }
                catch (Throwable var14_15) {
                    if (handleToFire != null) {
                        if (ctw == null || ctw.isActivity()) {
                            ctw = null;
                        }
                        this.fireEvent((Object)tew, handleToFire, SipResourceAdaptor.eventIdCache.getTransactionTimeoutEventId(this.eventLookup, dialogPresent), new Address(AddressPlan.SIP, address), ctw);
                    }
                    if (method != null && method.equals("BYE") && dialogPresent) {
                        dw.delete();
                    }
                    throw var14_15;
                }
            }
            if (ctw == null || ctw.isActivity()) {
                ctw = null;
            }
            this.fireEvent((Object)tew, handleToFire, SipResourceAdaptor.eventIdCache.getTransactionTimeoutEventId(this.eventLookup, dialogPresent), new Address(AddressPlan.SIP, address), ctw);
        }
        if (method != null && method.equals("BYE") && dialogPresent) {
            dw.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTransactionTerminated(TransactionTerminatedEvent txTerminatedEvent) {
        ClientTransaction t = null;
        boolean isClientTransaction = false;
        if (!txTerminatedEvent.isServerTransaction()) {
            t = txTerminatedEvent.getClientTransaction();
            isClientTransaction = true;
        } else {
            t = txTerminatedEvent.getServerTransaction();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("SIP Transaction " + t.getBranchId() + "_" + t.getRequest().getMethod() + " terminated : "));
        }
        if (t.getApplicationData() == null && t.getRequest().getMethod().equals("ACK")) {
            SipActivityHandle _sah = new SipActivityHandle(t.getBranchId() + "_" + "ACK");
            t.setApplicationData(this.activities.get(_sah));
        }
        if (t.getApplicationData() != null) {
            WrapperSuperInterface wsi = (WrapperSuperInterface)t.getApplicationData();
            DialogWrapper dw = null;
            if (t.getDialog() != null && t.getDialog().getApplicationData() instanceof DialogWrapper) {
                dw = (DialogWrapper)t.getDialog().getApplicationData();
            }
            if (dw == null) {
                if (wsi.isActivity()) {
                    this.sendActivityEndEvent(wsi.getActivityHandle(), wsi);
                } else {
                    if (log.isEnabledFor((Priority)Level.WARN)) {
                        log.warn((Object)("SIP Transaction " + t.getBranchId() + "_" + t.getRequest().getMethod() + " terminated : dw.null, but TX is not an activity."));
                    }
                    this.performActivityEndActions(wsi);
                }
            } else {
                if (t.getRequest().getMethod().equals("INVITE") && dw.getState() == null) {
                    dw.delete();
                }
                if (wsi.isActivity()) {
                    this.sendActivityEndEvent(wsi.getActivityHandle(), wsi);
                } else {
                    WrapperSuperInterface wrapperSuperInterface = wsi;
                    synchronized (wrapperSuperInterface) {
                        if (!wsi.isDelivering()) {
                            this.performActivityEndActions(wsi);
                        } else if (log.isInfoEnabled()) {
                            log.info((Object)("SIP Transaction " + t.getBranchId() + "_" + t.getRequest().getMethod() + " terminated : count on eventProcessing??"));
                        }
                    }
                }
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("TransactionTerminatedEvent dropped. There is no activity for transaction = " + t.getBranchId() + "_" + t.getRequest().getMethod() + " , request method = " + t.getRequest().getMethod()));
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dte) {
        DialogWrapper dw = null;
        if (dte.getDialog() instanceof DialogWrapper) {
            dw = (DialogWrapper)dte.getDialog();
        } else if (dte.getDialog().getApplicationData() != null) {
            dw = (DialogWrapper)dte.getDialog().getApplicationData();
        }
        if (log.isInfoEnabled() && dw != null) {
            log.info((Object)("SIP Dialog " + dw.getActivityHandle() + " terminated"));
        }
        if (dw != null) {
            if (dw.getActivityHandle() == null) {
                log.error((Object)(" FAILED: CLEANED DIALOG:" + dw));
            }
            this.sendActivityEndEvent(dw.getActivityHandle(), null);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"DialogTerminatedEvent droping due to null app data.");
        }
    }

    public boolean sendActivityEndEvent(SipActivityHandle ah, Object activity) {
        try {
            if (this.activities.containsKey(ah)) {
                this.sleeEndpoint.activityEnding((ActivityHandle)ah);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setIp(String ip) {
        this.stackAddress = ip.equals("null") ? System.getProperty("jboss.bind.address") : ip;
        this.provisionedProperties.put(SIP_BIND_ADDRESS, this.stackAddress);
    }

    public String getIp() {
        return this.provisionedProperties.getProperty(SIP_BIND_ADDRESS);
    }

    public void setPort(Integer port) {
        this.port = port < 1024 ? 5060 : port;
        this.provisionedProperties.put(SIP_PORT_BIND, "" + this.port);
    }

    public Integer getPort() {
        String s = this.provisionedProperties.getProperty(SIP_PORT_BIND);
        return s == null ? new Integer(-1) : Integer.valueOf(s);
    }

    public void setTransports(String transportsToSet) {
        String[] tmp = transportsToSet.split(",");
        if (tmp.length > 0) {
            boolean valid = false;
            int i = 0;
            if (i < tmp.length && this.allowedTransports.contains(tmp[i].toLowerCase())) {
                valid = true;
            }
            if (valid) {
                this.transports.clear();
                for (i = 0; i < tmp.length; ++i) {
                    if (this.allowedTransports.contains(tmp[i].toLowerCase())) {
                        this.transports.add(tmp[i].toLowerCase());
                        continue;
                    }
                    log.error((Object)(" TRANSPORT[" + tmp[i] + "] IS NOT A VALID TRANSPORT!!!"));
                }
            }
        }
        this.provisionedProperties.put(TRANSPORTS_BIND, transportsToSet);
    }

    public String getTransports() {
        String s = "";
        Iterator<String> tIterator = this.transports.iterator();
        while (tIterator.hasNext()) {
            s = s + tIterator.next();
            if (!tIterator.hasNext()) continue;
            s = s + ",";
        }
        return s;
    }

    public boolean addActivity(SipActivityHandle sah, WrapperSuperInterface wrapperActivity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding sip activity handle " + sah));
        }
        try {
            this.getSleeEndpoint().activityStarted((ActivityHandle)sah);
        }
        catch (Exception e) {
            log.error((Object)("Failed to start sip activity (" + sah + ")"), (Throwable)e);
            return false;
        }
        this.activities.put(sah, wrapperActivity);
        return true;
    }

    public void removeActivity(SipActivityHandle sah) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing sip activity handle " + sah));
        }
        this.activities.remove(sah);
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public boolean fireEvent(Object event, ActivityHandle handle, int eventID, Address address, WrapperSuperInterface wsi, boolean useFiltering) {
        block9: {
            if (useFiltering && eventIDFilter.filterEvent(eventID)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event " + eventID + " filtered"));
                }
            } else if (eventID < 0) {
                log.error((Object)("Event id for " + eventID + " is less than zero, cant fire!!!"));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Firing event " + event + " on handle " + handle));
                }
                try {
                    if (wsi != null && !wsi.isActivity()) {
                        wsi.setEventDelivery(true);
                    }
                    this.sleeEndpoint.fireEvent(handle, event, eventID, address);
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)"Error firing event.", (Throwable)e);
                    if (wsi == null) break block9;
                    wsi.setEventDelivery(false);
                }
            }
        }
        return false;
    }

    public boolean fireEvent(Object event, ActivityHandle handle, int eventId, Address address, WrapperSuperInterface wsi) {
        return this.fireEvent(event, handle, eventId, address, wsi, true);
    }

    private void sendErrorResponse(ServerTransaction serverTransaction, Request request, int code, String msg) {
        if (!request.getMethod().equals("ACK")) {
            try {
                ContentTypeHeader contentType = this.providerProxy.getHeaderFactory().createContentTypeHeader("text", "plain");
                Response response = this.providerProxy.getMessageFactory().createResponse(code, request, contentType, msg.getBytes());
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addClientDialogMaping(String key, SipActivityHandle handle) {
        this.fromTagCallId2Handle.put(key, handle);
    }

    public void removeClientDialogMapping(String key) {
        this.fromTagCallId2Handle.remove(key);
    }

    public SipActivityHandle getMasterHandleForCall(Response msg) {
        String key = ((FromHeader)msg.getHeader("From")).getTag() + "_" + ((CallIdHeader)msg.getHeader("Call-ID")).getCallId();
        SipActivityHandle forkMasterDialogHandle = this.fromTagCallId2Handle.get(key);
        return forkMasterDialogHandle;
    }

    static {
        String[] tmp = new String[]{"ACK", "BYE", "CANCEL", "INFO", "INVITE", "MESSAGE", "NOTIFY", "OPTIONS", "PRACK", "PUBLISH", "REFER", "REGISTER", "SUBSCRIBE", "UPDATE"};
        for (int i = 0; i < tmp.length; ++i) {
            rfc3261Methods.add(tmp[i]);
        }
        log.info((Object)("\n================SIP METHODS====================\n" + rfc3261Methods + "\n==============================================="));
        stxedRequests.add("ACK");
        stxedRequests.add("CANCEL");
        stxedRequests.add("BYE");
        eventIdCache = new EventIDCache();
        eventIDFilter = new EventIDFilter();
    }
}

