/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.AddressFactory;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.transaction.SleeTransactionManager;
import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.DialogActivity;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip11.EventIDCache;
import org.mobicents.slee.resource.sip11.EventIDFilter;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.wrappers.ACKDummyTransaction;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.RequestEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TimeoutEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionTerminatedEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.WrapperSuperInterface;

public class SipResourceAdaptor
implements SipListener,
ResourceAdaptor {
    private static Logger log = Logger.getLogger(SipResourceAdaptor.class);
    private static final String SIP_BIND_ADDRESS = "javax.sip.IP_ADDRESS";
    private static final String SIP_PORT_BIND = "javax.sip.PORT";
    private static final String TRANSPORTS_BIND = "javax.sip.TRANSPORT";
    private static final String STACK_NAME_BIND = "javax.sip.STACK_NAME";
    private int port = 5060;
    private Set<String> transports = new HashSet<String>();
    private String transportsProperty;
    private String stackName;
    private String stackAddress;
    private Set<String> allowedTransports = new HashSet<String>();
    private SipProvider provider;
    private SleeSipProviderImpl providerProxy;
    private static Set rfc3261Methods = new HashSet();
    private static Set<String> stxedRequests = new HashSet<String>();
    private Map<String, SipActivityHandle> fromTagCallId2Handle = null;
    private Map<SipActivityHandle, WrapperSuperInterface> activities = null;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private SipStack sipStack = null;
    private SipFactory sipFactory = null;
    private static final int EVENT_FLAGS;
    private static final int ACTIVITY_FLAGS = 2;

    private static int getEventFlags() {
        int eventFlags = 128;
        EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        return eventFlags;
    }

    public SipResourceAdaptor() {
        this.allowedTransports.add("udp");
        this.allowedTransports.add("tcp");
        this.transports.add("udp");
    }

    public void processIOException(IOExceptionEvent arg0) {
    }

    /*
     * Unable to fully structure code
     */
    public void processRequest(RequestEvent req) {
        if (SipResourceAdaptor.log.isInfoEnabled()) {
            SipResourceAdaptor.log.info((Object)("Received Request:\n" + req.getRequest()));
        }
        st = req.getServerTransaction();
        stw = null;
        if (st == null || st.getApplicationData() == null) {
            try {
                if (req.getDialog() == null && req.getRequest().getMethod().equals("ACK")) {
                    st = new ACKDummyTransaction(req.getRequest());
                }
                stw = (ServerTransactionWrapper)this.providerProxy.getNewServerTransaction(req.getRequest(), st, false);
                st = (ServerTransaction)stw.getWrappedTransaction();
                if (!SipResourceAdaptor.log.isDebugEnabled()) ** GOTO lbl23
                SipResourceAdaptor.log.debug((Object)("\n----------------- CREATED NEW STx ---------------------\nBRANCH: " + st.getBranchId() + "\n-------------------------------------------------------"));
            }
            catch (TransactionAlreadyExistsException e) {
                if (SipResourceAdaptor.log.isDebugEnabled()) {
                    SipResourceAdaptor.log.debug((Object)("Request where the server tx already exists, should be a retransmission and will be dropped. Request: \n" + req.getRequest() + "\n-------------------------"), (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                SipResourceAdaptor.log.error((Object)("\n-------------------------\nREQUEST:\n-------------------------\n" + req.getRequest() + "\n-------------------------"), (Throwable)e);
                this.sendErrorResponse(st, req.getRequest(), 500, e.getMessage());
                return;
            }
        } else {
            stw = (ServerTransactionWrapper)st.getApplicationData();
        }
lbl23:
        // 3 sources

        if (req.getRequest().getMethod().equals("CANCEL")) {
            this.processCancelRequest(st, stw, req);
        } else {
            this.processNotCancelRequest(st, stw, req);
        }
    }

    private void processCancelRequest(ServerTransaction st, ServerTransactionWrapper STW, RequestEvent req) {
        SipActivityHandle inviteHandle = STW.getInviteHandle();
        ServerTransactionWrapper inviteSTW = (ServerTransactionWrapper)this.getActivity(inviteHandle);
        CancelRequestEvent REW = null;
        boolean inDialog = false;
        SipActivityHandle SAH = null;
        if (inviteSTW != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found INVITE transaction CANCEL[" + STW + "] \nINVITE[" + inviteSTW + "]"));
            }
            if (inviteSTW.getState() == TransactionState.TERMINATED || inviteSTW.getState() == TransactionState.COMPLETED || inviteSTW.getState() == TransactionState.CONFIRMED) {
                log.error((Object)("Invite transaction has been found in state other than proceeding(" + inviteSTW.getState() + "), final response sent, sending BAD_REQUEST"));
                try {
                    Response response = this.providerProxy.getMessageFactory().createResponse(400, req.getRequest());
                    STW.sendResponse(response);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
                catch (InvalidArgumentException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (inviteSTW.getDialog() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found DIALOG transaction CANCEL[" + STW + "]\nINVITE[" + inviteSTW + "]\nDialog[" + inviteSTW.getDialog() + "]\nSEQUENCE:Send200ToCANCEL,FireEventOnDialog,Send487ToInvite"));
                }
                SAH = ((DialogWrapper)inviteSTW.getDialog()).getActivityHandle();
                inDialog = true;
                REW = new CancelRequestEvent((Object)this.providerProxy, (ServerTransaction)STW, (ServerTransaction)inviteSTW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DIALOG not found transaction CANCEL[" + STW + "]\nINVITE[" + inviteSTW + "]\nDialog[" + inviteSTW.getDialog() + "]\nSEQUENCE:FireEventOnInvite"));
                }
                SAH = inviteSTW.getActivityHandle();
                inDialog = false;
                REW = new CancelRequestEvent((Object)this.providerProxy, (ServerTransaction)STW, (ServerTransaction)inviteSTW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("INVITE not found transaction CANCEL[" + STW + "]\nSEQUENCE:FireEventOnCancel"));
            }
            SAH = STW.getActivityHandle();
            inDialog = false;
            REW = new CancelRequestEvent((Object)this.providerProxy, (ServerTransaction)STW, (ServerTransaction)inviteSTW, inviteSTW != null ? inviteSTW.getDialog() : null, req.getRequest());
        }
        FireableEventType eventID = this.eventIdCache.getEventId(this.raContext.getEventLookupFacility(), REW.getRequest(), inDialog);
        this.fireEvent(REW, SAH, eventID, new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()), false);
    }

    private void processNotCancelRequest(ServerTransaction st, ServerTransactionWrapper STW, RequestEvent req) {
        block13: {
            SipActivityHandle SAH = null;
            DialogWrapper DW = null;
            boolean inDialog = false;
            SleeTransactionManager txManager = this.raContext.getSleeTransactionManager();
            boolean terminateTx = false;
            try {
                txManager.begin();
                terminateTx = true;
                if (st.getDialog() != null) {
                    Dialog d = st.getDialog();
                    if (d.getApplicationData() != null && d.getApplicationData() instanceof DialogActivity) {
                        DW = (DialogWrapper)d.getApplicationData();
                        inDialog = true;
                        SAH = DW.getActivityHandle();
                        DW.addOngoingTransaction(STW);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Dialog [" + d + "] exists, but no wrapper is present. Delivering event on TX"));
                        }
                        inDialog = false;
                        SAH = STW.getActivityHandle();
                    }
                } else {
                    SAH = STW.getActivityHandle();
                    if (this.activities.get(SAH) == null && !this.addActivity(SAH, STW)) {
                        this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to deliver request event to JAIN SLEE container");
                        terminateTx = false;
                        txManager.rollback();
                        return;
                    }
                }
                RequestEventWrapper REW = new RequestEventWrapper(this.providerProxy, STW, (Dialog)DW, req.getRequest());
                if (!this.fireEvent((Object)REW, SAH, this.eventIdCache.getEventId(this.raContext.getEventLookupFacility(), REW.getRequest(), inDialog), new Address(AddressPlan.SIP, ((ToHeader)req.getRequest().getHeader("To")).getAddress().toString()), true)) {
                    if (!inDialog) {
                        this.activities.remove(STW.getActivityHandle());
                        STW.cleanup();
                    }
                    this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to deliver request event to JAIN SLEE container");
                    terminateTx = false;
                    txManager.rollback();
                    return;
                }
                if (!inDialog && STW.getWrappedTransaction() instanceof ACKDummyTransaction) {
                    this.processTransactionTerminated(new TransactionTerminatedEventWrapper((Object)this.providerProxy, (ServerTransaction)STW.getWrappedTransaction()));
                }
                terminateTx = false;
                txManager.commit();
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
                if (!terminateTx) break block13;
                try {
                    txManager.rollback();
                }
                catch (Throwable f) {
                    log.error((Object)f.getMessage(), f);
                }
            }
        }
    }

    public void processResponse(ResponseEvent resp) {
        try {
            ClientTransaction ct;
            if (log.isInfoEnabled()) {
                log.info((Object)("Received Response:\n" + resp.getResponse()));
            }
            if ((ct = resp.getClientTransaction()) == null) {
                this.processLateResponse(resp);
                return;
            }
            int statusCode = resp.getResponse().getStatusCode();
            String method = ((CSeqHeader)resp.getResponse().getHeader("CSeq")).getMethod();
            if (ct.getApplicationData() == null || !(ct.getApplicationData() instanceof ClientTransactionWrapper)) {
                log.error((Object)("Received app data[" + ct.getApplicationData() + "] - should be instance of wrapper class!!"));
                return;
            }
            SipActivityHandle SAH = null;
            ClientTransactionWrapper CTW = (ClientTransactionWrapper)ct.getApplicationData();
            DialogWrapper DW = null;
            boolean inDialog = false;
            if (ct.getDialog() != null) {
                Dialog d = ct.getDialog();
                if (d.getApplicationData() != null && d.getApplicationData() instanceof DialogActivity) {
                    DW = (DialogWrapper)d.getApplicationData();
                    SAH = DW.getActivityHandle();
                    inDialog = true;
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Dialog [" + d + "] exists, but no wrapper is present. Delivering event on TX"));
                    }
                    inDialog = false;
                    SAH = CTW.getActivityHandle();
                }
            } else {
                SAH = CTW.getActivityHandle();
            }
            if (!inDialog || !DW.processIncomingResponse(resp)) {
                ResponseEventWrapper REW = new ResponseEventWrapper(this.providerProxy, CTW, (Dialog)DW, resp.getResponse());
                FireableEventType eventID = this.eventIdCache.getEventId(this.raContext.getEventLookupFacility(), REW.getResponse());
                this.fireEvent((Object)REW, SAH, eventID, new Address(AddressPlan.SIP, ((FromHeader)resp.getResponse().getHeader("From")).getAddress().toString()), false);
            }
            if (!(statusCode != 481 && statusCode != 408 || !inDialog || method.equals("INVITE") && method.equals("SUBSCRIBE"))) {
                try {
                    Request bye = DW.createRequest("BYE");
                    this.provider.sendRequest(bye);
                }
                catch (SipException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processLateResponse(ResponseEvent resp) {
        int _statusCode = resp.getResponse().getStatusCode();
        String callId = ((CallID)resp.getResponse().getHeader("Call-ID")).getCallId();
        String _method = ((CSeq)resp.getResponse().getHeader("CSeq")).getMethod();
        String branchId = ((Via)resp.getResponse().getHeaders("Via").next()).getBranch();
        String toTag = ((ToHeader)resp.getResponse().getHeader("To")).getTag();
        ClientTransaction ct = resp.getClientTransaction();
        if (log.isInfoEnabled()) {
            log.info((Object)("ClientTransaction is null posible late 2xx. ToTag[" + toTag + "] Dialog[" + resp.getDialog() + "] CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
        }
        if (DialogWrapper.dialogCreatingMethods.contains(_method)) {
            SipActivityHandle forkMasterDialogHandle = this.getMasterHandleForCall(resp.getResponse());
            if (forkMasterDialogHandle != null) {
                DialogWrapper dw = (DialogWrapper)this.getActivity(forkMasterDialogHandle);
                if (dw != null) {
                    dw.processIncomingResponse(resp);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message was late 2xx, dialog wrapper processed it. CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No master dialog wrapper, using default. CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
                    }
                    new DialogWrapper(this.providerProxy, this).doTerminateOnLate2xx(resp);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No Handle for dialog with such from and callId, using default. CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
                }
                new DialogWrapper(this.providerProxy, this).doTerminateOnLate2xx(resp);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("===> ClientTransaction is NULL, along with dialog - RTR ? CALLID[" + callId + "] BRANCH[" + branchId + "] METHOD[" + _method + "] CODE[" + _statusCode + "]"));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processTimeout(TimeoutEvent arg0) {
        block22: {
            block20: {
                block21: {
                    block18: {
                        block19: {
                            t = null;
                            dialogPresent = false;
                            handleToFire = null;
                            tew = null;
                            address = null;
                            isServerTransaction = false;
                            dw = null;
                            method = null;
                            if (SipResourceAdaptor.log.isInfoEnabled()) {
                                if (arg0.isServerTransaction()) {
                                    SipResourceAdaptor.log.info((Object)("Server transaction " + arg0.getServerTransaction().getBranchId() + " timer expired"));
                                } else {
                                    SipResourceAdaptor.log.info((Object)("Client transaction " + arg0.getClientTransaction().getBranchId() + " timer expired"));
                                }
                            }
                            if (arg0.isServerTransaction()) ** GOTO lbl36
                            t = arg0.getClientTransaction();
                            if (t.getApplicationData() != null && t.getApplicationData() instanceof ClientTransactionWrapper) break block18;
                            SipResourceAdaptor.log.error((Object)("FAILURE on processTimeout - CTX. Wrong app data[" + t.getApplicationData() + "]"));
                            if (handleToFire == null) break block19;
                            this.fireEvent((Object)tew, handleToFire, this.eventIdCache.getTransactionTimeoutEventId(this.raContext.getEventLookupFacility(), dialogPresent), new Address(AddressPlan.SIP, address), false);
                        }
                        if (method != null && method.equals("BYE") && dw != null) {
                            dw.delete();
                        }
                        return;
                    }
                    tew = new TimeoutEventWrapper((Object)this.providerProxy, (ClientTransaction)t.getApplicationData(), arg0.getTimeout());
                    ctw = (ClientTransactionWrapper)t.getApplicationData();
                    if (ctw.getDialog() != null && ctw.getDialog() instanceof DialogWrapper) {
                        dialogPresent = true;
                        dw = (DialogWrapper)ctw.getDialog();
                    } else {
                        handleToFire = ctw.getActivityHandle();
                    }
                    ** GOTO lbl53
lbl36:
                    // 1 sources

                    isServerTransaction = true;
                    t = arg0.getServerTransaction();
                    stw = (ServerTransactionWrapper)t.getApplicationData();
                    if (stw != null) break block20;
                    SipResourceAdaptor.log.error((Object)("FAILURE on processTimeout - STX. Wrong app data[" + t.getApplicationData() + "]"));
                    if (handleToFire == null) break block21;
                    this.fireEvent((Object)tew, handleToFire, this.eventIdCache.getTransactionTimeoutEventId(this.raContext.getEventLookupFacility(), dialogPresent), new Address(AddressPlan.SIP, address), false);
                }
                if (method != null && method.equals("BYE") && dw != null) {
                    dw.delete();
                }
                return;
            }
            try {
                if (stw.getDialog() != null && stw.getDialog() instanceof DialogWrapper) {
                    dialogPresent = true;
                    dw = (DialogWrapper)stw.getDialog();
                }
lbl53:
                // 5 sources

                if (dialogPresent && !isServerTransaction) {
                    handleToFire = dw.getActivityHandle();
                }
                method = t.getRequest().getMethod();
                address = ((FromHeader)t.getRequest().getHeader("From")).getAddress().toString();
                if (handleToFire == null) break block22;
            }
            catch (RuntimeException re) {
                try {
                    re.printStackTrace();
                    throw re;
                }
                catch (Throwable var11_13) {
                    if (handleToFire != null) {
                        this.fireEvent((Object)tew, handleToFire, this.eventIdCache.getTransactionTimeoutEventId(this.raContext.getEventLookupFacility(), dialogPresent), new Address(AddressPlan.SIP, address), false);
                    }
                    if (method != null && method.equals("BYE") && dw != null) {
                        dw.delete();
                    }
                    throw var11_13;
                }
            }
            this.fireEvent((Object)tew, handleToFire, this.eventIdCache.getTransactionTimeoutEventId(this.raContext.getEventLookupFacility(), dialogPresent), new Address(AddressPlan.SIP, address), false);
        }
        if (method != null && method.equals("BYE") && dw != null) {
            dw.delete();
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent txTerminatedEvent) {
        Object t = null;
        t = !txTerminatedEvent.isServerTransaction() ? txTerminatedEvent.getClientTransaction() : txTerminatedEvent.getServerTransaction();
        if (log.isInfoEnabled()) {
            log.info((Object)("SIP Transaction " + t.getBranchId() + " terminated"));
        }
        if (t.getApplicationData() == null && t.getRequest().getMethod().equals("ACK")) {
            SipActivityHandle _sah = new SipActivityHandle(t.getBranchId() + "_" + "ACK");
            t.setApplicationData((Object)this.activities.get(_sah));
        }
        if (t.getApplicationData() != null) {
            WrapperSuperInterface wsi = (WrapperSuperInterface)t.getApplicationData();
            DialogWrapper dw = null;
            if (t.getDialog() != null && t.getDialog().getApplicationData() instanceof DialogWrapper) {
                dw = (DialogWrapper)t.getDialog().getApplicationData();
                if (wsi instanceof ServerTransactionWrapper) {
                    dw.removeOngoingTransaction((ServerTransactionWrapper)wsi);
                } else if (wsi instanceof ClientTransactionWrapper) {
                    dw.removeOngoingTransaction((ClientTransactionWrapper)wsi);
                } else {
                    log.error((Object)("Unknown type " + wsi.getClass() + " of SIP Transaction, can't remove from dialog wrapper"));
                }
            }
            if (!this.sendActivityEndEvent(wsi.getActivityHandle())) {
                wsi.cleanup();
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("TransactionTerminatedEvent dropped. There is no activity for transaction = " + t.getBranchId() + " , request method = " + t.getRequest().getMethod()));
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dte) {
        DialogWrapper dw = null;
        if (dte.getDialog() instanceof DialogWrapper) {
            dw = (DialogWrapper)dte.getDialog();
        } else if (dte.getDialog().getApplicationData() != null) {
            dw = (DialogWrapper)dte.getDialog().getApplicationData();
        }
        if (log.isInfoEnabled() && dw != null) {
            log.info((Object)("SIP Dialog " + dw.getActivityHandle() + " terminated"));
        }
        if (dw != null) {
            if (dw.getActivityHandle() == null) {
                log.error((Object)(" FAILED: CLEANED DIALOG:" + dw));
            }
            this.sendActivityEndEvent(dw.getActivityHandle());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"DialogTerminatedEvent droping due to null app data.");
        }
    }

    public boolean sendActivityEndEvent(SipActivityHandle ah) {
        try {
            if (this.activities.containsKey(ah)) {
                this.raContext.getSleeEndpoint().endActivity((ActivityHandle)ah);
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean addActivity(SipActivityHandle sah, WrapperSuperInterface wrapperActivity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding sip activity handle " + sah));
        }
        try {
            this.raContext.getSleeEndpoint().startActivityTransacted((ActivityHandle)sah, (Object)wrapperActivity, 2);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            return false;
        }
        this.activities.put(sah, wrapperActivity);
        return true;
    }

    public void removeActivity(SipActivityHandle sah) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing sip activity handle " + sah));
        }
        this.activities.remove(sah);
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event " + eventID + " filtered"));
            }
        } else if (eventID == null) {
            log.error((Object)("Event id for " + eventID + " is unknown, cant fire!!!"));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Firing event " + event + " on handle " + handle));
            }
            try {
                if (transacted) {
                    this.raContext.getSleeEndpoint().fireEventTransacted(handle, eventID, event, address, null, EVENT_FLAGS);
                } else {
                    this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                }
                return true;
            }
            catch (Exception e) {
                log.error((Object)"Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventId, Address address, boolean transacted) {
        return this.fireEvent(event, handle, eventId, address, true, transacted);
    }

    private void sendErrorResponse(ServerTransaction serverTransaction, Request request, int code, String msg) {
        if (!request.getMethod().equals("ACK")) {
            try {
                ContentTypeHeader contentType = this.providerProxy.getHeaderFactory().createContentTypeHeader("text", "plain");
                Response response = this.providerProxy.getMessageFactory().createResponse(code, request, contentType, msg.getBytes());
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addClientDialogMaping(String key, SipActivityHandle handle) {
        this.fromTagCallId2Handle.put(key, handle);
    }

    public void removeClientDialogMapping(String key) {
        this.fromTagCallId2Handle.remove(key);
    }

    public SipActivityHandle getMasterHandleForCall(Response msg) {
        String key = ((FromHeader)msg.getHeader("From")).getTag() + "_" + ((CallIdHeader)msg.getHeader("Call-ID")).getCallId();
        SipActivityHandle forkMasterDialogHandle = this.fromTagCallId2Handle.get(key);
        return forkMasterDialogHandle;
    }

    public void raActive() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("sipra.properties"));
            properties.setProperty(SIP_BIND_ADDRESS, this.stackAddress);
            properties.setProperty(STACK_NAME_BIND, this.stackName);
            properties.setProperty(TRANSPORTS_BIND, this.transportsProperty);
            properties.setProperty(SIP_PORT_BIND, Integer.toString(this.port));
            this.sipFactory = SipFactory.getInstance();
            this.sipFactory.setPathName("gov.nist");
            this.sipStack = this.sipFactory.createSipStack(properties);
            this.sipStack.start();
            this.activities = new ConcurrentHashMap<SipActivityHandle, WrapperSuperInterface>();
            this.fromTagCallId2Handle = new ConcurrentHashMap<String, SipActivityHandle>();
            boolean created = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("---> START " + Arrays.toString(this.transports.toArray())));
            }
            for (String trans : this.transports) {
                ListeningPoint lp = this.sipStack.createListeningPoint(this.stackAddress, this.port, trans);
                if (!created) {
                    this.provider = this.sipStack.createSipProvider(lp);
                    created = true;
                } else {
                    this.provider.addListeningPoint(lp);
                }
                this.provider.addSipListener((SipListener)this);
            }
            AddressFactory addressFactory = this.sipFactory.createAddressFactory();
            HeaderFactory headerFactory = this.sipFactory.createHeaderFactory();
            MessageFactory messageFactory = this.sipFactory.createMessageFactory();
            this.providerProxy = new SleeSipProviderImpl(addressFactory, headerFactory, messageFactory, this.sipStack, this, this.provider);
        }
        catch (Throwable ex) {
            String msg = "error in initializing resource adaptor";
            log.error((Object)msg, ex);
            throw new RuntimeException(msg, ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sip Resource Adaptor entity active.");
        }
    }

    public void raInactive() {
        this.provider.removeSipListener((SipListener)this);
        ListeningPoint[] listeningPoints = this.provider.getListeningPoints();
        block4: for (int i = 0; i < listeningPoints.length; ++i) {
            ListeningPoint lp = listeningPoints[i];
            for (int k = 0; k < 10; ++k) {
                try {
                    this.sipStack.deleteListeningPoint(lp);
                    this.sipStack.deleteSipProvider(this.provider);
                    continue block4;
                }
                catch (ObjectInUseException ex) {
                    log.error((Object)"Object in use -- retrying to delete listening point", (Throwable)ex);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sip Resource Adaptor entity inactive.");
        }
    }

    public void raStopping() {
    }

    public void eventProcessingFailed(ActivityHandle ah, FireableEventType arg1, Object event, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
        String id = ((SipActivityHandle)ah).getID();
        if (!id.endsWith("CANCEL") || !(event instanceof CancelRequestEvent)) {
            return;
        }
        try {
            Response txDoesNotExistsResponse = this.providerProxy.getMessageFactory().createResponse(481, ((CancelRequestEvent)event).getRequest());
            ServerTransactionWrapper stw = (ServerTransactionWrapper)this.getActivity(ah);
            stw.sendResponse(txDoesNotExistsResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public void raConfigure(ConfigProperties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring RA.");
        }
        this.stackName = "SipResourceAdaptorStack_" + (String)properties.getProperty(STACK_NAME_BIND).getValue();
        this.port = (Integer)properties.getProperty(SIP_PORT_BIND).getValue();
        this.stackAddress = (String)properties.getProperty(SIP_BIND_ADDRESS).getValue();
        if (this.stackAddress.equals("null")) {
            this.stackAddress = System.getProperty("jboss.bind.address");
        }
        this.transportsProperty = (String)properties.getProperty(TRANSPORTS_BIND).getValue();
        for (String transport : this.transportsProperty.split(",")) {
            this.transports.add(transport);
        }
        log.info((Object)("RA bound to " + this.stackName + ":" + this.port));
    }

    public void raUnconfigure() {
        this.port = -1;
        this.stackName = null;
        this.stackAddress = null;
        this.transports.clear();
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        try {
            Integer port = (Integer)properties.getProperty(SIP_PORT_BIND).getValue();
            String stackAddress = (String)properties.getProperty(SIP_BIND_ADDRESS).getValue();
            if (stackAddress.equals("null")) {
                stackAddress = System.getProperty("jboss.bind.address");
            }
            InetSocketAddress sockAddress = new InetSocketAddress(stackAddress, (int)port);
            new DatagramSocket(sockAddress).close();
            String transports = (String)properties.getProperty(TRANSPORTS_BIND).getValue();
            String[] transportsArray = transports.split(",");
            boolean validTransports = true;
            if (transportsArray.length > 0) {
                String transport;
                int i$ = 0;
                String[] arr$ = transportsArray;
                int len$ = arr$.length;
                if (i$ < len$ && !this.allowedTransports.contains((transport = arr$[i$]).toLowerCase())) {
                    validTransports = false;
                }
            } else {
                validTransports = false;
            }
            if (!validTransports) {
                throw new IllegalArgumentException("javax.sip.TRANSPORT config property with invalid value: " + transports);
            }
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public void serviceActive(ReceivableService receivableService) {
        this.eventIDFilter.serviceActive(receivableService);
    }

    public void serviceInactive(ReceivableService receivableService) {
        this.eventIDFilter.serviceInactive(receivableService);
    }

    public void serviceStopping(ReceivableService receivableService) {
        this.eventIDFilter.serviceStopping(receivableService);
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.raContext = raContext;
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
    }

    public ResourceAdaptorContext getRaContext() {
        return this.raContext;
    }

    public void activityEnded(ActivityHandle handle) {
        WrapperSuperInterface activity;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing activity for handle[" + handle + "] activity[" + this.activities.get(handle) + "]."));
        }
        if ((activity = this.activities.remove(handle)) != null) {
            activity.cleanup();
        }
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle arg0) {
        if (arg0 instanceof SipActivityHandle) {
            return this.activities.get(arg0);
        }
        return null;
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (activity instanceof WrapperSuperInterface) {
            WrapperSuperInterface wrapperSuperInterface = (WrapperSuperInterface)activity;
            if (this.activities.containsKey(wrapperSuperInterface.getActivityHandle())) {
                return wrapperSuperInterface.getActivityHandle();
            }
            return null;
        }
        return null;
    }

    public void queryLiveness(ActivityHandle arg0) {
    }

    public Object getResourceAdaptorInterface(String raTypeSbbInterfaceclassName) {
        return this.providerProxy;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    static {
        String[] tmp = new String[]{"ACK", "BYE", "CANCEL", "INFO", "INVITE", "MESSAGE", "NOTIFY", "OPTIONS", "PRACK", "PUBLISH", "REFER", "REGISTER", "SUBSCRIBE", "UPDATE"};
        for (int i = 0; i < tmp.length; ++i) {
            rfc3261Methods.add(tmp[i]);
        }
        log.info((Object)("\n================SIP METHODS====================\n" + rfc3261Methods + "\n==============================================="));
        stxedRequests.add("ACK");
        stxedRequests.add("CANCEL");
        stxedRequests.add("BYE");
        EVENT_FLAGS = SipResourceAdaptor.getEventFlags();
    }
}

