/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.address.SipUri;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportAlreadySupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SleeSipProvider;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.SuperTransactionWrapper;

public class SleeSipProviderImpl
implements SleeSipProvider {
    protected AddressFactory addressFactory = null;
    protected HeaderFactory headerFactory = null;
    protected MessageFactory messageFactory = null;
    protected SipStack stack = null;
    protected SipResourceAdaptor ra = null;
    protected SipProvider provider = null;
    protected static final Logger logger = Logger.getLogger(SleeSipProviderImpl.class);

    public SleeSipProviderImpl(AddressFactory addressFactory, HeaderFactory headerFactory, MessageFactory messageFactory, SipStack stack, SipResourceAdaptor ra, SipProvider provider) {
        this.addressFactory = addressFactory;
        this.headerFactory = headerFactory;
        this.messageFactory = messageFactory;
        this.stack = stack;
        this.ra = ra;
        this.provider = provider;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public SipURI getLocalSipURI(String transport) {
        ListeningPoint lp = this.provider.getListeningPoint(transport);
        SipUri uri = null;
        if (lp != null) {
            try {
                uri = new SipUri();
                uri.setHost(lp.getIPAddress());
                uri.setPort(lp.getPort());
                uri.setTransportParam(transport);
            }
            catch (ParseException e) {
                logger.error((Object)("Failed parsing LP info. Failed to parse listening point for transport [" + transport + "] [" + lp + "]"), (Throwable)e);
            }
            return uri;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Failed parsing LP info. No listening point for transport [" + transport + "] [" + lp + "]"));
        }
        return null;
    }

    public ViaHeader getLocalVia(String transport, String branch) {
        try {
            SipURI uri = this.getLocalSipURI(transport);
            if (uri == null) {
                return null;
            }
            return this.headerFactory.createViaHeader(uri.getHost(), uri.getPort(), transport, branch);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public boolean isLocalHostname(String host) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            HashSet<InetAddress> stackAddresses = new HashSet<InetAddress>();
            for (ListeningPoint listeningPoint : this.provider.getListeningPoints()) {
                InetAddress tmp = InetAddress.getByName(listeningPoint.getIPAddress());
                if (tmp == null) continue;
                stackAddresses.add(tmp);
            }
            for (InetAddress inetAddress : addresses) {
                if (!stackAddresses.contains(inetAddress)) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isLocalSipURI(SipURI uri) {
        ListeningPoint lp = this.provider.getListeningPoint(uri.getTransportParam());
        if (lp != null && lp.getIPAddress().equals(uri.getHost()) && lp.getPort() == uri.getPort()) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Passed uri not local? Passed URI[" + uri + "] doesnt match lp[" + lp + "]"));
        }
        return false;
    }

    public void addListeningPoint(ListeningPoint arg0) throws ObjectInUseException, TransportAlreadySupportedException {
        throw new UnsupportedOperationException("No dynamic change to LP");
    }

    public void addSipListener(SipListener arg0) throws TooManyListenersException {
        throw new TooManyListenersException("RA can be the only Listener for this stack!!");
    }

    public ListeningPoint getListeningPoint() {
        return this.provider.getListeningPoint();
    }

    public ListeningPoint getListeningPoint(String arg0) {
        return this.provider.getListeningPoint(arg0);
    }

    public ListeningPoint[] getListeningPoints() {
        return this.provider.getListeningPoints();
    }

    public CallIdHeader getNewCallId() {
        return this.provider.getNewCallId();
    }

    public ServerTransaction getNewServerTransaction(Request arg0) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        return this.getNewServerTransaction(arg0, null, true);
    }

    public SipStack getSipStack() {
        throw new UnsupportedOperationException("This operation is not supported yet");
    }

    public void removeListeningPoint(ListeningPoint arg0) throws ObjectInUseException {
        throw new UnsupportedOperationException("This operation is not supported yet");
    }

    public void removeSipListener(SipListener arg0) {
        throw new UnsupportedOperationException("This operation is not supported yet");
    }

    public void sendRequest(Request arg0) throws SipException {
        this.provider.sendRequest(arg0);
    }

    public void sendResponse(Response arg0) throws SipException {
        this.provider.sendResponse(arg0);
    }

    public void setAutomaticDialogSupportEnabled(boolean arg0) {
        this.provider.setAutomaticDialogSupportEnabled(arg0);
    }

    public void setListeningPoint(ListeningPoint arg0) throws ObjectInUseException {
        throw new UnsupportedOperationException("This operation is not supported yet");
    }

    public ClientTransaction getNewClientTransaction(Request request, boolean createActivity) throws TransactionUnavailableException {
        ClientTransaction ct = this.provider.getNewClientTransaction(request);
        ClientTransactionWrapper ctw = new ClientTransactionWrapper(ct);
        DialogWrapper dw = null;
        if (ct.getDialog() != null && ct.getDialog().getApplicationData() instanceof DialogWrapper) {
            dw = (DialogWrapper)ct.getDialog().getApplicationData();
            dw.addOngoingTransaction(ctw);
        }
        if (dw == null && createActivity) {
            this.ra.addActivity(ctw.getActivityHandle(), ctw);
        }
        return ctw;
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        return this.getNewClientTransaction(request, true);
    }

    public ServerTransaction getNewServerTransaction(Request request, ServerTransaction serverTransaction, boolean createActivityInSlee) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        if (serverTransaction == null) {
            serverTransaction = this.provider.getNewServerTransaction(request);
        }
        ServerTransactionWrapper stw = new ServerTransactionWrapper(serverTransaction);
        DialogWrapper dw = null;
        if (serverTransaction.getDialog() != null && serverTransaction.getDialog().getApplicationData() instanceof DialogWrapper) {
            dw = (DialogWrapper)serverTransaction.getDialog().getApplicationData();
            dw.addOngoingTransaction(stw);
        }
        if (dw == null && createActivityInSlee) {
            this.ra.addActivity(stw.getActivityHandle(), stw);
        }
        return stw;
    }

    public Dialog getNewDialog(Transaction transaction) throws SipException {
        return this.getNewDialog(transaction, null, true);
    }

    public Dialog getNewDialog(Transaction transaction, SipActivityHandle forkMaster, boolean makeWrapper) throws SipException {
        SuperTransactionWrapper stw = (SuperTransactionWrapper)transaction;
        Transaction t = stw.getWrappedTransaction();
        Dialog d = this.provider.getNewDialog(t);
        if (makeWrapper) {
            DialogWrapper dw = this.getNewDialogActivity(d, forkMaster, stw);
            return dw;
        }
        return d;
    }

    public DialogWrapper getNewDialogActivity(Dialog d, SipActivityHandle forkMaster, SuperTransactionWrapper stw) {
        DialogWrapper dw = new DialogWrapper(d, forkMaster, this, this.ra);
        if (stw != null) {
            if (stw instanceof ServerTransactionWrapper) {
                dw.addOngoingTransaction((ServerTransactionWrapper)stw);
            } else if (stw instanceof ClientTransactionWrapper) {
                dw.addOngoingTransaction((ClientTransactionWrapper)stw);
            } else {
                logger.error((Object)("Unknown type " + stw.getClass() + " of SIP Transaction, can't add to dialog wrapper"));
            }
        }
        this.ra.addActivity(dw.getActivityHandle(), dw);
        return dw;
    }

    public DialogActivity getNewDialog(Address from, Address to) throws SipException {
        if (from == null) {
            throw new IllegalArgumentException("From address cant be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("To address cant be null");
        }
        return this.getNewDialog(from, to, null);
    }

    public DialogActivity getNewDialog(DialogActivity incomingDialog, boolean useSameCallId) throws SipException {
        if (incomingDialog == null || !incomingDialog.isServer()) {
            throw new IllegalArgumentException("Incoming dialog is either null or is UAC dialog!!");
        }
        CallIdHeader callIdHeader = null;
        if (useSameCallId) {
            callIdHeader = incomingDialog.getCallId();
        }
        DialogWrapper dw = (DialogWrapper)this.getNewDialog(incomingDialog.getRemoteParty(), incomingDialog.getLocalParty(), callIdHeader);
        return dw;
    }

    private DialogActivity getNewDialog(Address from, Address to, CallIdHeader callIdHeader) throws SipException {
        DialogWrapper dw = new DialogWrapper(this, this.ra);
        dw.setFromAddress(from);
        dw.setToAddress(to);
        this.ra.addActivity(dw.getActivityHandle(), dw);
        if (callIdHeader == null) {
            callIdHeader = this.provider.getNewCallId();
        }
        dw.setCallIdToReUse(callIdHeader);
        return dw;
    }

    public boolean acceptCancel(CancelRequestEvent cancelEvent, boolean isProxy) {
        if (cancelEvent.getMatchingTransaction() != null) {
            Response response;
            try {
                response = this.getMessageFactory().createResponse(200, cancelEvent.getRequest());
                cancelEvent.getServerTransaction().sendResponse(response);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (!isProxy) {
                try {
                    response = this.getMessageFactory().createResponse(487, cancelEvent.getMatchingTransaction().getRequest());
                    cancelEvent.getMatchingTransaction().sendResponse(response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return true;
        }
        if (!isProxy) {
            try {
                Response txDoesNotExistsResponse = this.getMessageFactory().createResponse(481, cancelEvent.getRequest());
                cancelEvent.getServerTransaction().sendResponse(txDoesNotExistsResponse);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    public DialogActivity forwardForkedResponse(ServerTransaction origServerTransaction, Response response) throws SipException {
        return null;
    }
}

