/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.message.SIPRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportAlreadySupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;

public class SleeSipProviderImpl
implements SleeSipProvider {
    protected AddressFactory addressFactory = null;
    protected HeaderFactory headerFactory = null;
    protected MessageFactory messageFactory = null;
    protected SipStack stack = null;
    protected SipResourceAdaptor ra = null;
    protected SipProvider provider = null;
    protected final Tracer tracer;

    public SleeSipProviderImpl(AddressFactory addressFactory, HeaderFactory headerFactory, MessageFactory messageFactory, SipStack stack, SipResourceAdaptor ra, SipProvider provider) {
        this.addressFactory = addressFactory;
        this.headerFactory = headerFactory;
        this.messageFactory = messageFactory;
        this.stack = stack;
        this.ra = ra;
        this.provider = provider;
        this.tracer = ra.getTracer(SleeSipProviderImpl.class.getSimpleName());
    }

    public SipProvider getRealProvider() {
        return this.provider;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public SipURI getLocalSipURI(String transport) {
        ListeningPoint lp = this.provider.getListeningPoint(transport);
        if (lp != null) {
            try {
                SipUri uri = new SipUri();
                uri.setHost(lp.getIPAddress());
                uri.setPort(lp.getPort());
                uri.setTransportParam(transport);
                return uri;
            }
            catch (ParseException e) {
                this.tracer.severe("Failed parsing LP info. Failed to parse listening point for transport [" + transport + "] [" + lp + "]", (Throwable)e);
                return null;
            }
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Failed parsing LP info. No listening point for transport [" + transport + "] [" + lp + "]");
        }
        return null;
    }

    public ViaHeader getLocalVia(String transport, String branch) {
        ListeningPoint lp = this.provider.getListeningPoint(transport);
        if (lp != null) {
            try {
                return this.headerFactory.createViaHeader(lp.getIPAddress(), lp.getPort(), lp.getTransport(), branch);
            }
            catch (ParseException e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public ViaHeader getLocalVia() throws ParseException, InvalidArgumentException {
        ListeningPoint lp = this.provider.getListeningPoints()[0];
        return this.headerFactory.createViaHeader(lp.getIPAddress(), lp.getPort(), lp.getTransport(), null);
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public boolean isLocalHostname(String host) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host);
            HashSet<InetAddress> stackAddresses = new HashSet<InetAddress>();
            for (ListeningPoint listeningPoint : this.provider.getListeningPoints()) {
                InetAddress tmp = InetAddress.getByName(listeningPoint.getIPAddress());
                if (tmp == null) continue;
                stackAddresses.add(tmp);
            }
            for (InetAddress inetAddress : addresses) {
                if (!stackAddresses.contains(inetAddress)) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isLocalSipURI(SipURI uri) {
        ListeningPoint lp = this.provider.getListeningPoint(uri.getTransportParam());
        if (lp != null && lp.getIPAddress().equals(uri.getHost()) && lp.getPort() == uri.getPort()) {
            return true;
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Passed uri not local? Passed URI[" + uri + "] doesnt match lp[" + lp + "]");
        }
        return false;
    }

    public void addListeningPoint(ListeningPoint arg0) throws ObjectInUseException, TransportAlreadySupportedException {
        throw new UnsupportedOperationException("No dynamic change to LP");
    }

    public void addSipListener(SipListener arg0) throws TooManyListenersException {
        throw new TooManyListenersException("RA can be the only Listener for this stack!!");
    }

    public ListeningPoint getListeningPoint() {
        return this.provider.getListeningPoint();
    }

    public ListeningPoint getListeningPoint(String arg0) {
        return this.provider.getListeningPoint(arg0);
    }

    public ListeningPoint[] getListeningPoints() {
        return this.provider.getListeningPoints();
    }

    public CallIdHeader getNewCallId() {
        return this.provider.getNewCallId();
    }

    public SipStack getSipStack() {
        throw new UnsupportedOperationException();
    }

    public void removeListeningPoint(ListeningPoint arg0) throws ObjectInUseException {
        throw new UnsupportedOperationException();
    }

    public void removeSipListener(SipListener arg0) {
        throw new UnsupportedOperationException();
    }

    public void sendRequest(Request arg0) throws SipException {
        this.provider.sendRequest(arg0);
    }

    public void sendResponse(Response arg0) throws SipException {
        this.provider.sendResponse(arg0);
    }

    public void setAutomaticDialogSupportEnabled(boolean arg0) {
        this.provider.setAutomaticDialogSupportEnabled(arg0);
    }

    public void setListeningPoint(ListeningPoint arg0) throws ObjectInUseException {
        throw new UnsupportedOperationException();
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        ClientTransaction ct = this.provider.getNewClientTransaction(request);
        ClientTransactionWrapper ctw = new ClientTransactionWrapper(ct, this.ra);
        ctw.setActivity(true);
        DialogWrapper dw = ctw.getDialogWrapper();
        if (dw != null) {
            dw.addOngoingTransaction(ctw);
        }
        if (!this.ra.addSuspendedActivity(ctw, this.tracer.isFineEnabled())) {
            throw new TransactionUnavailableException("Failed to create activity");
        }
        return ctw;
    }

    public ClientTransactionWrapper getNewDialogActivityClientTransaction(DialogWrapper dialogWrapper, Request request) throws TransactionUnavailableException {
        ClientTransaction ct = this.provider.getNewClientTransaction(request);
        ClientTransactionWrapper ctw = new ClientTransactionWrapper(ct, this.ra);
        dialogWrapper.addOngoingTransaction(ctw);
        return ctw;
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        ServerTransaction st = this.provider.getNewServerTransaction(request);
        ServerTransactionWrapper stw = new ServerTransactionWrapper(st, this.ra);
        DialogWrapper dw = stw.getDialogWrapper();
        if (dw != null) {
            dw.addOngoingTransaction(stw);
        } else {
            stw.setActivity(true);
            if (!this.ra.addSuspendedActivity(stw, this.tracer.isFineEnabled())) {
                throw new TransactionUnavailableException("Failed to create activity.");
            }
        }
        return stw;
    }

    public Dialog getNewDialog(Transaction transaction) throws SipException {
        if (transaction.getClass() == ServerTransactionWrapper.class) {
            ServerTransactionWrapper stw = (ServerTransactionWrapper)transaction;
            ServerTransaction st = stw.getWrappedServerTransaction();
            Dialog d = this.provider.getNewDialog((Transaction)st);
            String localTag = Utils.getInstance().generateTag();
            String dialogId = ((SIPRequest)st.getRequest()).getDialogId(true, localTag);
            DialogWrapper dw = new DialogWrapper(d, dialogId, localTag, this.ra);
            dw.addOngoingTransaction(stw);
            this.ra.addSuspendedActivity(dw, this.tracer.isFineEnabled());
            return dw;
        }
        if (transaction.getClass() == ClientTransactionWrapper.class) {
            Request r = transaction.getRequest();
            DialogWrapper dw = this._getNewDialog(((FromHeader)r.getHeader("From")).getAddress(), Utils.getInstance().generateTag(), ((ToHeader)r.getHeader("To")).getAddress(), null);
            dw.addOngoingTransaction((ClientTransactionWrapper)transaction);
            return dw;
        }
        throw new IllegalArgumentException("unknown transaction class");
    }

    public DialogActivity getNewDialog(Address from, Address to) throws SipException {
        if (from == null) {
            throw new IllegalArgumentException("From address cant be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("To address cant be null");
        }
        return this._getNewDialog(from, Utils.getInstance().generateTag(), to, null);
    }

    public DialogActivity getNewDialog(DialogActivity incomingDialog, boolean useSameCallId) throws SipException {
        if (incomingDialog == null || !incomingDialog.isServer()) {
            throw new IllegalArgumentException("Incoming dialog is either null or is UAC dialog!!");
        }
        CallIdHeader callIdHeader = null;
        if (useSameCallId) {
            callIdHeader = incomingDialog.getCallId();
        }
        return this._getNewDialog(incomingDialog.getRemoteParty(), Utils.getInstance().generateTag(), incomingDialog.getLocalParty(), callIdHeader);
    }

    private DialogWrapper _getNewDialog(Address from, String localTag, Address to, CallIdHeader callIdHeader) throws SipException {
        ClientDialogWrapper dw = new ClientDialogWrapper(from, localTag, to, callIdHeader == null ? this.provider.getNewCallId() : callIdHeader, this.ra);
        if (!this.ra.addSuspendedActivity(dw, this.tracer.isFineEnabled())) {
            throw new SipException("Failed to create activity.");
        }
        return dw;
    }

    public boolean acceptCancel(CancelRequestEvent cancelEvent, boolean isProxy) {
        if (cancelEvent.getMatchingTransaction() != null) {
            Response response;
            try {
                response = this.getMessageFactory().createResponse(200, cancelEvent.getRequest());
                cancelEvent.getServerTransaction().sendResponse(response);
                Thread.sleep(50L);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (!isProxy) {
                try {
                    response = this.getMessageFactory().createResponse(487, cancelEvent.getMatchingTransaction().getRequest());
                    cancelEvent.getMatchingTransaction().sendResponse(response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return true;
        }
        if (!isProxy) {
            try {
                Response txDoesNotExistsResponse = this.getMessageFactory().createResponse(481, cancelEvent.getRequest());
                Thread.sleep(50L);
                cancelEvent.getServerTransaction().sendResponse(txDoesNotExistsResponse);
                Thread.sleep(50L);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    public DialogActivity forwardForkedResponse(ServerTransaction origServerTransaction, Response response) throws SipException {
        throw new UnsupportedOperationException();
    }
}

