/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.ContactHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.message.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Set<String> DIALOG_CREATING_METHODS;
    private static Set<String> HEADERS_TO_OMMIT_ON_REQUEST_COPY;
    private static Set<String> HEADERS_TO_OMMIT_ON_RESPONSE_COPY;

    public static Set<String> getDialogCreatingMethods() {
        if (DIALOG_CREATING_METHODS == null) {
            HashSet<String> set = new HashSet<String>();
            set.add("INVITE");
            set.add("REFER");
            set.add("SUBSCRIBE");
            DIALOG_CREATING_METHODS = Collections.unmodifiableSet(set);
        }
        return DIALOG_CREATING_METHODS;
    }

    public static Set<String> getHeadersToOmmitOnRequestCopy() {
        if (HEADERS_TO_OMMIT_ON_REQUEST_COPY == null) {
            HashSet<String> set = new HashSet<String>();
            set.add("Route");
            set.add("Record-Route");
            set.add("Via");
            set.add("Call-ID");
            set.add("CSeq");
            HEADERS_TO_OMMIT_ON_REQUEST_COPY = Collections.unmodifiableSet(set);
        }
        return HEADERS_TO_OMMIT_ON_REQUEST_COPY;
    }

    public static Set<String> getHeadersToOmmitOnResponseCopy() {
        if (HEADERS_TO_OMMIT_ON_RESPONSE_COPY == null) {
            HashSet<String> set = new HashSet<String>();
            set.add("Route");
            set.add("Record-Route");
            set.add("Via");
            set.add("Call-ID");
            set.add("CSeq");
            set.add("Contact");
            HEADERS_TO_OMMIT_ON_RESPONSE_COPY = Collections.unmodifiableSet(set);
        }
        return HEADERS_TO_OMMIT_ON_RESPONSE_COPY;
    }

    public static List<RouteHeader> getRouteList(Response response, HeaderFactory headerFactory) throws ParseException {
        ArrayList<RouteHeader> routeList = new ArrayList<RouteHeader>();
        ListIterator rrLit = response.getHeaders("Record-Route");
        while (rrLit.hasNext()) {
            RecordRouteHeader rrh = (RecordRouteHeader)rrLit.next();
            RouteHeader rh = headerFactory.createRouteHeader(rrh.getAddress());
            Iterator pIt = rrh.getParameterNames();
            while (pIt.hasNext()) {
                String pName = (String)pIt.next();
                rh.setParameter(pName, rrh.getParameter(pName));
            }
            routeList.add(0, rh);
        }
        return routeList;
    }

    public static SipURI getRequestUri(Response response, AddressFactory addressFactory) throws ParseException {
        ContactHeader contact = (ContactHeader)response.getHeader("Contact");
        if (contact != null) {
            SipURI contactURI = (SipURI)contact.getAddress().getURI();
            SipURI requestURI = addressFactory.createSipURI(contactURI.getUser(), contactURI.getHost());
            requestURI.setPort(contactURI.getPort());
            return requestURI;
        }
        return null;
    }
}

