/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.CSeq;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.FireableEventType;
import net.java.slee.resource.sip.DialogForkedEvent;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.LateResponseHandler;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.Utils;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogWrapperData;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogForkState;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientDialogWrapper
extends DialogWrapper {
    private static final long serialVersionUID = 1L;
    private static Tracer tracer;
    private transient ClientDialogWrapperData data = new ClientDialogWrapperData(this);

    private ClientDialogWrapper(SipActivityHandle activityHandle, String localTag, SipResourceAdaptor ra) {
        super(activityHandle, localTag, ra);
        this.setResourceAdaptor(ra);
    }

    @Override
    public void setResourceAdaptor(SipResourceAdaptor ra) {
        super.setResourceAdaptor(ra);
        if (tracer == null) {
            tracer = ra.getTracer(ClientDialogWrapper.class.getSimpleName());
        }
    }

    public ClientDialogWrapper(Address from, String localTag, Address to, CallIdHeader callIdHeader, SipResourceAdaptor ra) {
        this(new DialogWithoutIdActivityHandle(callIdHeader.getCallId(), localTag, null), localTag, ra);
        this.data.setToAddress(to);
        this.data.setFromAddress(from);
        this.data.setCustomCallId(callIdHeader);
    }

    private ClientDialogWrapper(Dialog wrappedDialog, DialogWithoutIdActivityHandle forkInitialActivityHandle, SipResourceAdaptor ra) {
        this(new DialogWithoutIdActivityHandle(wrappedDialog.getCallId().getCallId(), wrappedDialog.getLocalTag(), wrappedDialog.getRemoteTag()), wrappedDialog.getLocalTag(), ra);
        this.data.setForkInitialActivityHandle(forkInitialActivityHandle);
        this.wrappedDialog = wrappedDialog;
    }

    @Override
    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = this.wrappedDialog != null ? super.getEventFiringAddress() : ClientTransactionWrapper.getEventFiringAddress(this.data.getFromAddress());
        }
        return this.eventFiringAddress;
    }

    @Override
    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        this.verifyDialogExistency();
        return super.createAck(arg0);
    }

    @Override
    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        this.verifyDialogExistency();
        return super.createPrack(arg0);
    }

    @Override
    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        this.verifyDialogExistency();
        return super.createReliableProvisionalResponse(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        if (this.wrappedDialog == null || this.data.getForkInitialActivityHandle() != null) {
            this.ra.processDialogTerminated(this);
        } else {
            try {
                this.terminateFork(this.getActivityHandle());
            }
            finally {
                super.delete();
            }
        }
    }

    @Override
    public CallIdHeader getCallId() {
        if (this.wrappedDialog == null) {
            return this.data.getCustomCallId();
        }
        return super.getCallId();
    }

    @Override
    public String getDialogId() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return super.getDialogId();
    }

    @Override
    public Transaction getFirstTransaction() {
        this.verifyDialogExistency();
        return super.getFirstTransaction();
    }

    @Override
    public Address getLocalParty() {
        if (this.wrappedDialog != null && !this.data.isInForkedActions()) {
            return super.getLocalParty();
        }
        return this.data.getFromAddress();
    }

    @Override
    public Address getRemoteParty() {
        if (this.wrappedDialog != null && !this.data.isInForkedActions()) {
            return super.getRemoteParty();
        }
        return this.data.getToAddress();
    }

    @Override
    public Address getRemoteTarget() {
        if (this.wrappedDialog != null && !this.data.isInForkedActions()) {
            return super.getRemoteTarget();
        }
        return this.data.getToAddress();
    }

    @Override
    public long getLocalSeqNumber() {
        if (this.data.isInForkedActions() || this.wrappedDialog == null) {
            return this.data.getLocalSequenceNumber().get();
        }
        return super.getLocalSeqNumber();
    }

    @Override
    public int getLocalSequenceNumber() {
        return (int)this.getLocalSeqNumber();
    }

    @Override
    public long getRemoteSeqNumber() {
        if (this.wrappedDialog != null) {
            return super.getRemoteSeqNumber();
        }
        return 1L;
    }

    @Override
    public int getRemoteSequenceNumber() {
        return (int)this.getRemoteSeqNumber();
    }

    @Override
    public String getRemoteTag() {
        if (this.wrappedDialog != null && !this.data.isInForkedActions()) {
            return super.getRemoteTag();
        }
        return this.data.getLocalRemoteTag();
    }

    @Override
    public Iterator<RouteHeader> getRouteSet() {
        if (this.wrappedDialog != null) {
            return super.getRouteSet();
        }
        return this.data.getRouteSet().iterator();
    }

    @Override
    public DialogState getState() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return super.getState();
    }

    @Override
    public void incrementLocalSequenceNumber() {
        if (this.data.isInForkedActions() || this.wrappedDialog == null) {
            this.data.getLocalSequenceNumber().incrementAndGet();
        } else {
            super.incrementLocalSequenceNumber();
        }
    }

    @Override
    public boolean isSecure() {
        if (this.wrappedDialog == null) {
            return false;
        }
        return super.isSecure();
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void sendAck(Request arg0) throws SipException {
        this.verifyDialogExistency();
        super.sendAck(arg0);
    }

    @Override
    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        this.verifyDialogExistency();
        super.sendReliableProvisionalResponse(arg0);
    }

    @Override
    public void terminateOnBye(boolean arg0) throws SipException {
        this.verifyDialogExistency();
        super.terminateOnBye(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addOngoingTransaction(ServerTransactionWrapper stw) {
        if (this.data.isInForkedActions()) {
            AtomicLong cSeq;
            long cSeqNewValue = ((CSeq)stw.getRequest().getHeader("CSeq")).getSeqNumber();
            AtomicLong atomicLong = cSeq = this.data.getLocalSequenceNumber();
            synchronized (atomicLong) {
                if (cSeqNewValue <= cSeq.get()) {
                    throw new IllegalArgumentException("Sequence number should not decrease !");
                }
                cSeq.set(cSeqNewValue);
            }
        }
        return super.addOngoingTransaction(stw);
    }

    @Override
    public String toString() {
        return "ClientDialogWrapper Id[" + this.getDialogId() + "] Handle[" + this.getActivityHandle() + "] State[" + this.getState() + "] OngoingCTX[" + this.ongoingClientTransactions.keySet() + "] OngoingSTX[" + this.ongoingServerTransactions.keySet() + "]";
    }

    @Override
    public ClientTransaction sendCancel() throws SipException {
        this.verifyDialogExistency();
        return super.sendCancel();
    }

    @Override
    public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
        this.verifyDialogExistency();
        super.associateServerTransaction(ct, st);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Request createRequest(String methodName) throws SipException {
        HeaderFactory headerFactory = this.provider.getHeaderFactory();
        Request request = null;
        if (this.wrappedDialog == null) {
            try {
                FromHeader fromHeader = headerFactory.createFromHeader(this.data.getFromAddress(), super.getLocalTag());
                ToHeader toHeader = headerFactory.createToHeader(this.data.getToAddress(), null);
                URI requestURI = (URI)this.data.getToAddress().getURI().clone();
                ArrayList<ViaHeader> viaHeadersList = new ArrayList<ViaHeader>(1);
                viaHeadersList.add(this.provider.getLocalVia());
                MaxForwardsHeader maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
                CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(this.data.getLocalSequenceNumber().get() + 1L, methodName);
                request = this.provider.getMessageFactory().createRequest(requestURI, methodName, this.data.getCustomCallId(), cSeqHeader, fromHeader, toHeader, viaHeadersList, maxForwardsHeader);
                Iterator<RouteHeader> i$ = this.data.getRouteSet().iterator();
                while (i$.hasNext()) {
                    RouteHeader routeHeader = i$.next();
                    request.addLast((Header)routeHeader);
                }
                return request;
            }
            catch (Exception e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
        if (!this.data.isInForkedActions()) return super.createRequest(methodName);
        try {
            request = this.wrappedDialog.createRequest(methodName);
            request.removeHeader("Route");
            for (RouteHeader routeHeader : this.data.getRouteSet()) {
                request.addLast((Header)routeHeader);
            }
            request.addFirst((Header)this.provider.getLocalVia());
            SipURI requestURI = (SipURI)this.data.getRequestURI().clone();
            request.setRequestURI((URI)requestURI);
            CSeqHeader cseq = (CSeqHeader)request.getHeader("CSeq");
            try {
                if (!methodName.equals("CANCEL") && !methodName.equals("ACK")) {
                    cseq.setSeqNumber(this.data.getLocalSequenceNumber().get() + 1L);
                }
                requestURI.setMethodParam(cseq.getMethod());
                if (this.data.getLocalRemoteTag() == null) return request;
                ((ToHeader)request.getHeader("To")).setTag(this.data.getLocalRemoteTag());
                return request;
            }
            catch (ParseException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Request createRequest(Request origRequest) throws SipException {
        this.generateRouteList(origRequest);
        Request forgedRequest = null;
        if (this.wrappedDialog != null) {
            forgedRequest = super.createRequest(origRequest);
            if (!this.data.isInForkedActions() || this.wrappedDialog.isServer()) return forgedRequest;
            forgedRequest.removeHeader("Route");
            SipURI requestURI = (SipURI)this.data.getRequestURI().clone();
            forgedRequest.setRequestURI((URI)requestURI);
            CSeqHeader cseq = (CSeqHeader)forgedRequest.getHeader("CSeq");
            String method = forgedRequest.getMethod();
            try {
                if (!method.equals("CANCEL") && !method.equals("ACK")) {
                    cseq.setSeqNumber(this.data.getLocalSequenceNumber().get() + 1L);
                }
                requestURI.setMethodParam(cseq.getMethod());
                if (this.data.getLocalRemoteTag() == null) return forgedRequest;
                ((ToHeader)forgedRequest.getHeader("To")).setTag(this.data.getLocalRemoteTag());
                return forgedRequest;
            }
            catch (ParseException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            HeaderFactory headerFactory = this.provider.getHeaderFactory();
            MaxForwardsHeader maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
            ToHeader toHeader = this.provider.getHeaderFactory().createToHeader(this.data.getToAddress(), null);
            FromHeader fromHeader = headerFactory.createFromHeader(this.data.getFromAddress(), super.getLocalTag());
            ArrayList<ViaHeader> viaHeadersList = new ArrayList<ViaHeader>(1);
            viaHeadersList.add(this.provider.getLocalVia());
            forgedRequest = this.provider.getMessageFactory().createRequest(origRequest.getRequestURI(), origRequest.getMethod(), this.data.getCustomCallId(), (CSeqHeader)((CSeqHeader)origRequest.getHeader("CSeq")).clone(), fromHeader, toHeader, viaHeadersList, maxForwardsHeader);
        }
        catch (InvalidArgumentException e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
        for (RouteHeader routeHeader : this.data.getRouteSet()) {
            forgedRequest.addLast((Header)routeHeader);
        }
        this.forgeMessage((Message)origRequest, (Message)forgedRequest, Utils.getHeadersToOmmitOnRequestCopy());
        return forgedRequest;
    }

    @Override
    public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {
        boolean createDialog;
        if (this.wrappedDialog == null && !Utils.getDialogCreatingMethods().contains(request.getMethod())) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
        }
        this.ensureCorrectDialogLocalTag(request);
        ClientTransactionWrapper ctw = this.provider.getNewDialogActivityClientTransaction(this, request);
        String method = request.getMethod();
        if (method.equals("INVITE")) {
            this.lastCancelableTransactionId = ctw.getBranchId();
        }
        boolean bl = createDialog = this.wrappedDialog == null;
        if (createDialog) {
            this.wrappedDialog = this.provider.getRealProvider().getNewDialog(ctw.getWrappedTransaction());
        } else {
            this.ensureCorrectDialogRemoteTag(request);
        }
        if (this.data.isInForkedActions()) {
            ctw.sendRequest();
            if (!method.equals("ACK") && !method.equals("CANCEL")) {
                this.data.getLocalSequenceNumber().incrementAndGet();
            }
        } else if (createDialog) {
            ctw.sendRequest();
        } else {
            if (tracer.isInfoEnabled()) {
                tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
            }
            this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
        }
        if (createDialog) {
            this.wrappedDialog.setApplicationData((Object)this);
        }
        return ctw;
    }

    private void ensureCorrectDialogRemoteTag(Request request) throws SipException {
        String remoteTag;
        String string = remoteTag = this.data.isInForkedActions() && this.data.getLocalRemoteTag() != null ? this.data.getLocalRemoteTag() : this.wrappedDialog.getRemoteTag();
        if (remoteTag != null) {
            try {
                ((ToHeader)request.getHeader("To")).setTag(remoteTag);
            }
            catch (ParseException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void sendRequest(ClientTransaction ct) throws TransactionDoesNotExistException, SipException {
        boolean createDialog;
        Request request = ct.getRequest();
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        this.ensureCorrectDialogLocalTag(request);
        boolean bl = createDialog = this.wrappedDialog == null;
        if (createDialog) {
            if (!Utils.getDialogCreatingMethods().contains(request.getMethod())) {
                throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
            }
            if (request.getMethod().equals("INVITE")) {
                this.lastCancelableTransactionId = ctw.getBranchId();
            }
            this.wrappedDialog = this.provider.getRealProvider().getNewDialog(ctw.getWrappedTransaction());
            this.wrappedDialog.setApplicationData((Object)this);
            this.addOngoingTransaction(ctw);
            if (createDialog) {
                ctw.sendRequest();
            } else {
                if (tracer.isInfoEnabled()) {
                    tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
                }
                this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
            }
        } else {
            this.ensureCorrectDialogRemoteTag(request);
            if (this.data.isInForkedActions()) {
                if (!request.getMethod().equals("ACK") && !request.getMethod().equals("CANCEL")) {
                    this.data.getLocalSequenceNumber().incrementAndGet();
                }
                ctw.sendRequest();
            } else {
                if (tracer.isInfoEnabled()) {
                    tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
                }
                this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
            }
        }
    }

    private void verifyDialogExistency() {
        if (this.wrappedDialog == null) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet!");
        }
    }

    @Override
    public boolean processIncomingResponse(ResponseEvent respEvent) {
        Response response = respEvent.getResponse();
        boolean firedByDialogWrapper = false;
        int statusCode = response.getStatusCode();
        String toTag = ((ToHeader)response.getHeader("To")).getTag();
        DialogForkState oldForkState = this.data.getForkState();
        DialogWithoutIdActivityHandle masterActivityHandle = (DialogWithoutIdActivityHandle)this.getActivityHandle();
        boolean fineTrace = tracer.isFineEnabled();
        switch (oldForkState) {
            case AWAIT_FIRST_TAG: {
                if (100 <= statusCode && statusCode < 200) {
                    if (toTag != null) {
                        this.data.setLocalRemoteTag(toTag);
                        this.data.setForkState(DialogForkState.AWAIT_FINAL);
                        this.data.mapTagToDialog(toTag, masterActivityHandle);
                        this.fetchData(response);
                    }
                    if (fineTrace) {
                        tracer.fine("Received 1xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                    }
                    firedByDialogWrapper = false;
                    break;
                }
                if (statusCode < 300) {
                    this.data.setForkState(DialogForkState.END);
                    if (toTag != null) {
                        this.data.setLocalRemoteTag(toTag);
                        this.data.mapTagToDialog(toTag, masterActivityHandle);
                    }
                    this.fetchData(response);
                    if (fineTrace) {
                        tracer.fine("Received 2xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                    }
                    firedByDialogWrapper = false;
                    this.terminateFork(masterActivityHandle);
                    break;
                }
                if (statusCode < 700) {
                    this.data.setForkState(DialogForkState.END);
                    if (fineTrace) {
                        tracer.fine("Received failure message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                    }
                    FireableEventType eventID = this.ra.getEventIdCache().getEventId(this.ra.getEventLookupFacility(), response);
                    ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                    this.fireEvent(fineTrace, (Object)REW, this.activityHandle, this.getEventFiringAddress(), eventID);
                    firedByDialogWrapper = true;
                    this.terminateFork(null);
                    break;
                }
                if (!fineTrace) break;
                tracer.fine("Received strange message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                break;
            }
            case AWAIT_FINAL: {
                if (100 <= statusCode && statusCode < 200) {
                    if (fineTrace) {
                        tracer.fine("Received 1xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                    }
                    if (toTag == null) {
                        firedByDialogWrapper = false;
                        break;
                    }
                    if (toTag.equals(this.data.getLocalRemoteTag())) {
                        this.fetchData(response);
                        firedByDialogWrapper = false;
                        break;
                    }
                    if (this.data.tagIsMapped(toTag)) {
                        ClientDialogWrapper child = (ClientDialogWrapper)this.ra.getActivity(this.data.getDialogMappedToTag(toTag));
                        if (child == null) {
                            this.data.unmapDialogMappedToTag(toTag);
                            return true;
                        }
                        child.fetchData(response);
                        FireableEventType eventID = this.ra.getEventIdCache().getEventId(this.ra.getEventLookupFacility(), response);
                        if (fineTrace) {
                            tracer.fine("Received 1xx message: " + statusCode + ". ToTag:" + toTag + "EventId:" + eventID);
                        }
                        ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                        this.fireEvent(fineTrace, (Object)REW, child.activityHandle, child.getEventFiringAddress(), eventID);
                        firedByDialogWrapper = true;
                        break;
                    }
                    ClientDialogWrapper child = this.getNewChildDialogActivity(this.wrappedDialog, (DialogWithoutIdActivityHandle)this.getActivityHandle());
                    child.data.setForkState(oldForkState);
                    child.data.setLocalRemoteTag(toTag);
                    child.fetchData(response);
                    this.data.mapTagToDialog(toTag, (DialogWithoutIdActivityHandle)child.getActivityHandle());
                    FireableEventType eventID = this.ra.getEventIdCache().getDialogForkEventId(this.ra.getEventLookupFacility());
                    DialogForkedEvent REW = new DialogForkedEvent((Object)this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, (Dialog)child, response);
                    this.fireEvent(fineTrace, REW, this.activityHandle, this.getEventFiringAddress(), eventID);
                    firedByDialogWrapper = true;
                    break;
                }
                if (statusCode < 300) {
                    this.data.setForkState(DialogForkState.END);
                    if (tracer.isFineEnabled()) {
                        tracer.fine("Received 2xx message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                    }
                    if (this.data.getLocalRemoteTag() != null && toTag != null && this.data.getLocalRemoteTag().equals(toTag)) {
                        this.fetchData(response);
                        firedByDialogWrapper = false;
                    } else if (toTag != null && this.data.tagIsMapped(toTag)) {
                        ClientDialogWrapper child = (ClientDialogWrapper)this.ra.getActivity(this.data.getDialogMappedToTag(toTag));
                        child.fetchData(response);
                        masterActivityHandle = (DialogWithoutIdActivityHandle)child.getActivityHandle();
                        child.makeMaster();
                        if (child != this) {
                            this.data.setForkInitialActivityHandle((DialogWithoutIdActivityHandle)child.getActivityHandle());
                        } else {
                            tracer.severe("Local: " + this.data.getLocalRemoteTag() + " : " + toTag + " MSG:\n" + response);
                        }
                        FireableEventType eventID = this.ra.getEventIdCache().getEventId(this.ra.getEventLookupFacility(), response);
                        ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                        this.fireEvent(fineTrace, (Object)REW, child.activityHandle, child.getEventFiringAddress(), eventID);
                        firedByDialogWrapper = true;
                    } else if (toTag != null) {
                        ClientDialogWrapper child = this.getNewChildDialogActivity(this.wrappedDialog, null);
                        child.data.setForkState(DialogForkState.END);
                        child.data.setLocalRemoteTag(toTag);
                        masterActivityHandle = (DialogWithoutIdActivityHandle)child.getActivityHandle();
                        this.data.mapTagToDialog(toTag, masterActivityHandle);
                        child.makeMaster();
                        this.data.setForkInitialActivityHandle((DialogWithoutIdActivityHandle)child.getActivityHandle());
                        child.fetchData(response);
                        FireableEventType eventID = this.ra.getEventIdCache().getDialogForkEventId(this.ra.getEventLookupFacility());
                        DialogForkedEvent REW = new DialogForkedEvent((Object)this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, (Dialog)child, response);
                        this.fireEvent(fineTrace, REW, this.activityHandle, this.getEventFiringAddress(), eventID);
                        firedByDialogWrapper = true;
                    } else {
                        tracer.severe("Received 2xx reponse without toTag, this is error.");
                    }
                    this.terminateFork(masterActivityHandle);
                    break;
                }
                if (statusCode < 700) {
                    this.data.setForkState(DialogForkState.END);
                    if (fineTrace) {
                        tracer.fine("Received failure message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                    }
                    FireableEventType eventID = this.ra.getEventIdCache().getEventId(this.ra.getEventLookupFacility(), response);
                    ResponseEventWrapper REW = new ResponseEventWrapper(this.provider, (ClientTransaction)respEvent.getClientTransaction().getApplicationData(), (Dialog)this, response);
                    this.fireEvent(fineTrace, (Object)REW, this.activityHandle, this.getEventFiringAddress(), eventID);
                    firedByDialogWrapper = true;
                    this.terminateFork(null);
                    break;
                }
                if (!fineTrace) break;
                tracer.fine("Received strange message: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                break;
            }
            case END: {
                if (toTag == null || toTag.equals(this.wrappedDialog.getRemoteTag())) break;
                if (statusCode < 200 || statusCode > 300) {
                    if (fineTrace) {
                        tracer.fine("Received late message, action IGNORE: " + statusCode + ". ToTag:" + toTag + ". Fork state old:" + (Object)((Object)oldForkState) + " - new" + (Object)((Object)this.data.getForkState()) + ". On dialog: " + this.toString());
                    }
                } else if (Utils.getDialogCreatingMethods().contains(((CSeqHeader)response.getHeader("CSeq")).getMethod())) {
                    LateResponseHandler.doTerminateOnLate2xx(respEvent, this.ra);
                }
                firedByDialogWrapper = true;
            }
        }
        return firedByDialogWrapper;
    }

    private void fireEvent(boolean fineTrace, Object event, SipActivityHandle activityHandle, javax.slee.Address eventFiringAddress, FireableEventType eventType) {
        if (this.ra.getEventIDFilter().filterEvent(eventType)) {
            tracer.fine("Event " + eventType + " filtered.");
            return;
        }
        try {
            this.ra.getSleeEndpoint().fireEvent((ActivityHandle)activityHandle, eventType, event, eventFiringAddress, null, 64);
        }
        catch (Throwable e) {
            tracer.severe("Failed to fire event", e);
        }
    }

    private ClientDialogWrapper getNewChildDialogActivity(Dialog child, DialogWithoutIdActivityHandle master) {
        ClientDialogWrapper dw = new ClientDialogWrapper(child, master, this.ra);
        this.ra.addActivity(dw, false, tracer.isFineEnabled());
        return dw;
    }

    private void fetchData(Response response) {
        ContactHeader contact;
        if (this.data.getLocalRemoteTag() == null) {
            this.data.setLocalRemoteTag(((ToHeader)response.getHeader("To")).getTag());
            this.data.setRequestURI(null);
            this.data.clearRouteSet();
        }
        if ((contact = (ContactHeader)response.getHeader("Contact")) != null && (this.data.getRequestURI() == null || contact != null && !this.data.getRequestURI().equals(contact.getAddress().getURI()))) {
            this.data.setRequestURI((SipURI)contact.getAddress().getURI());
        }
        if (this.data.getRouteSet().size() == 0 || this.data.isRouteSetOnRequest()) {
            this.data.setRouteSetOnRequest(false);
            this.data.clearRouteSet();
            try {
                this.data.addAlltoRouteSet(Utils.getRouteList(response, this.provider.getHeaderFactory()));
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        this.data.setCustomCallId((CallIdHeader)response.getHeader("Call-ID"));
    }

    public void generateRouteList(Request origRequest) {
        if (this.wrappedDialog == null) {
            ViaHeader topVia = (ViaHeader)origRequest.getHeader("Via");
            Address address = null;
            if (topVia == null) {
                if (tracer.isFineEnabled()) {
                    tracer.fine("There is no via header, can not compute AS contact. Skipping computation of request route.");
                }
                return;
            }
            address = this.getLocalAddressForTransport(topVia.getTransport());
            ListIterator lit = origRequest.getHeaders("Route");
            if (lit != null) {
                GenericURI addressURI = (GenericURI)(address == null ? null : address.getURI());
                while (lit.hasNext()) {
                    RouteHeader rh = (RouteHeader)lit.next();
                    GenericURI rhURI = (GenericURI)rh.getAddress().getURI();
                    if (addressURI != null && rhURI.equals((Object)addressURI)) continue;
                    this.data.addToRouteSet(rh);
                }
            }
        }
    }

    private Address getLocalAddressForTransport(String transport) {
        ListeningPoint lp = this.provider.getListeningPoint(transport);
        Address address = null;
        if (lp != null) {
            try {
                address = this.provider.getAddressFactory().createAddress("Mobicents SIP AS <sip:" + lp.getIPAddress() + ">");
                ((SipURI)address.getURI()).setPort(lp.getPort());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (tracer.isFineEnabled()) {
            tracer.fine("There is no listening point, for transport: " + transport + ", can not compute AS contact.");
        }
        return address;
    }

    private void terminateFork(SipActivityHandle dialogToRetain) {
        ClientDialogWrapper master = null;
        for (String tag : new HashSet<String>(this.data.getTagsMappedToDialogs())) {
            DialogWithoutIdActivityHandle child = this.data.unmapDialogMappedToTag(tag);
            if (dialogToRetain != null && dialogToRetain.equals(child)) continue;
            ClientDialogWrapper dw = (ClientDialogWrapper)this.ra.getActivity(child);
            if (dw != null && dw.data.getForkInitialActivityHandle() == null) {
                master = dw;
                continue;
            }
            dw.delete();
        }
        if (master != null) {
            master.delete();
        }
    }

    private void makeMaster() {
        this.data.setForkState(DialogForkState.END);
        this.data.setForkInitialActivityHandle(null);
        this.wrappedDialog.setApplicationData((Object)this);
    }

    @Override
    public void clear() {
        super.clear();
        this.data = null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.data = new ClientDialogWrapperData(this);
        this.activityHandle.setActivity(this);
    }
}

