/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.sip.ClientTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.slee.AddressPlan;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.TransactionActivityHandle;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionAssociation;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionWrapper;

public class ClientTransactionWrapper
extends TransactionWrapper
implements ClientTransaction {
    private static final long serialVersionUID = 1L;
    private static Tracer tracer;
    private ClientTransactionAssociation association;
    private transient javax.slee.Address eventFiringAddress;
    private transient ClientTransaction wrappedTransaction;

    public ClientTransactionWrapper(ClientTransaction wrappedTransaction, SipResourceAdaptor ra) {
        super(new TransactionActivityHandle(wrappedTransaction.getBranchId()));
        this.wrappedTransaction = wrappedTransaction;
        this.wrappedTransaction.setApplicationData((Object)this);
        this.setResourceAdaptor(ra);
    }

    public void setResourceAdaptor(SipResourceAdaptor ra) {
        if (tracer == null) {
            tracer = ra.getTracer(ClientTransactionWrapper.class.getSimpleName());
        }
    }

    public Transaction getWrappedTransaction() {
        return this.wrappedTransaction;
    }

    public ClientTransaction getWrappedClientTransaction() {
        return this.wrappedTransaction;
    }

    public void setWrappedClientTransaction(ClientTransaction wrappedTransaction) {
        this.wrappedTransaction = wrappedTransaction;
    }

    public boolean isAckTransaction() {
        return false;
    }

    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = ClientTransactionWrapper.getEventFiringAddress(((FromHeader)this.wrappedTransaction.getRequest().getHeader("From")).getAddress());
        }
        return this.eventFiringAddress;
    }

    public static javax.slee.Address getEventFiringAddress(Address fromAddress) {
        return new javax.slee.Address(AddressPlan.SIP, fromAddress.toString());
    }

    private void validateWrappedTransaction() throws IllegalStateException {
        if (this.wrappedTransaction == null) {
            throw new IllegalStateException();
        }
    }

    public Request createAck() throws SipException {
        this.validateWrappedTransaction();
        return this.wrappedTransaction.createAck();
    }

    public Request createCancel() throws SipException {
        this.validateWrappedTransaction();
        return this.wrappedTransaction.createCancel();
    }

    public void sendRequest() throws SipException {
        this.validateWrappedTransaction();
        String method = this.wrappedTransaction.getRequest().getMethod();
        DialogWrapper dw = this.getDialogWrapper();
        if ((method.equals("INVITE") || method.equals("SUBSCRIBE")) && dw != null) {
            dw.lastCancelableTransactionId = this.getBranchId();
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(this.toString() + " sending request:\n" + this.getRequest());
        }
        this.wrappedTransaction.sendRequest();
    }

    public void associateServerTransaction(String branch, SipActivityHandle dialogHandle) {
        if (this.association != null) {
            throw new IllegalStateException("Transaction already associated to [" + this.association.getAssociatedServerTransactionBranchId() + "] [" + this.association.getDialogActivityHandle() + "]");
        }
        this.association = new ClientTransactionAssociation(dialogHandle, branch);
    }

    public ClientTransactionAssociation getClientTransactionAssociation() {
        return this.association;
    }

    public String toString() {
        String id = this.wrappedTransaction == null ? String.valueOf(null) : this.wrappedTransaction.getBranchId();
        return "ClientTransaction[" + id + ']';
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.activityHandle.setActivity(this);
    }

    public void terminated() {
        DialogWrapper dw;
        if (this.isActivity() && (dw = this.getDialogWrapper()) != null) {
            dw.removeOngoingTransaction(this);
        }
    }

    public void clear() {
        super.clear();
        if (this.wrappedTransaction != null) {
            this.wrappedTransaction.setApplicationData(null);
            this.wrappedTransaction = null;
        }
        this.eventFiringAddress = null;
        this.association = null;
    }
}

