/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.Parameters;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.AddressPlan;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.slee.resource.sip11.DialogWithIdActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.Utils;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionAssociation;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogWrapper
extends Wrapper
implements DialogActivity {
    private static final long serialVersionUID = 1L;
    protected transient SipResourceAdaptor ra;
    protected transient SleeSipProviderImpl provider;
    protected transient ConcurrentHashMap<String, ClientTransaction> ongoingClientTransactions = new ConcurrentHashMap(1);
    protected transient ConcurrentHashMap<String, ServerTransaction> ongoingServerTransactions = new ConcurrentHashMap(1);
    protected transient Dialog wrappedDialog;
    private String localTag;
    protected transient javax.slee.Address eventFiringAddress;
    private static Tracer tracer;
    protected String lastCancelableTransactionId;
    static final String[] EMPTY_STRING_ARRAY;

    public DialogWrapper(Dialog wrappedDialog, String dialogId, String localTag, SipResourceAdaptor ra) throws IllegalArgumentException {
        this(new DialogWithIdActivityHandle(dialogId), localTag, ra);
        this.wrappedDialog = wrappedDialog;
        this.wrappedDialog.setApplicationData((Object)this);
    }

    protected DialogWrapper(SipActivityHandle sipActivityHandle, String localTag, SipResourceAdaptor ra) {
        super(sipActivityHandle);
        this.setResourceAdaptor(ra);
        this.localTag = localTag;
    }

    @Override
    public void setResourceAdaptor(SipResourceAdaptor ra) {
        this.ra = ra;
        this.provider = ra.getProviderWrapper();
        if (tracer == null) {
            tracer = ra.getTracer(DialogWrapper.class.getSimpleName());
        }
    }

    @Override
    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = new javax.slee.Address(AddressPlan.SIP, this.wrappedDialog.getLocalParty().toString());
        }
        return this.eventFiringAddress;
    }

    @Override
    public boolean isAckTransaction() {
        return false;
    }

    @Override
    public boolean isActivity() {
        return true;
    }

    @Override
    public boolean isDialog() {
        return true;
    }

    public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
        if (ct == null) {
            throw new NullPointerException("null client transaction");
        }
        if (st == null) {
            throw new NullPointerException("null server transaction");
        }
        if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
            throw new IllegalArgumentException("client transaction is not in ongoing transaction list.");
        }
        DialogWrapper stDialog = (DialogWrapper)st.getDialog();
        if (stDialog == null) {
            throw new IllegalArgumentException("the specified server transaction has no dialog.");
        }
        ((ClientTransactionWrapper)ct).associateServerTransaction(st.getBranchId(), stDialog.getActivityHandle());
    }

    public ServerTransaction getAssociatedServerTransaction(ClientTransaction ct) {
        if (!this.hasOngoingClientTransaction(ct.getBranchId())) {
            return null;
        }
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        ClientTransactionAssociation cta = ctw.getClientTransactionAssociation();
        if (cta != null) {
            DialogWrapper associatedDialog = (DialogWrapper)this.ra.getActivity(cta.getDialogActivityHandle());
            if (associatedDialog != null) {
                return associatedDialog.getServerTransaction(cta.getAssociatedServerTransactionBranchId());
            }
            return null;
        }
        return null;
    }

    public Request createRequest(String methodName) throws SipException {
        try {
            Request request = this.wrappedDialog.createRequest(methodName);
            return request;
        }
        catch (Exception e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
    }

    public Request createRequest(Request origRequest) throws SipException {
        Request forgedRequest = null;
        try {
            forgedRequest = !origRequest.getMethod().equals("ACK") ? this.wrappedDialog.createRequest(origRequest.getMethod()) : this.wrappedDialog.createAck(this.wrappedDialog.getLocalSeqNumber());
            forgedRequest.addFirst((Header)this.provider.getLocalVia());
        }
        catch (ParseException e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
        catch (InvalidArgumentException e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
        this.forgeMessage((Message)origRequest, (Message)forgedRequest, Utils.getHeadersToOmmitOnRequestCopy());
        return forgedRequest;
    }

    protected void forgeMessage(Message originalMessage, Message forgedMessage, Set<String> headerstoOmmit) throws SipException {
        ListIterator lit = originalMessage.getHeaderNames();
        while (lit.hasNext()) {
            String headerName = (String)lit.next();
            if (headerName.equals("To") || headerName.equals("From")) {
                Parameters origHeader = (Parameters)originalMessage.getHeader(headerName);
                Parameters forgedHeader = (Parameters)forgedMessage.getHeader(headerName);
                HashSet<String> toOmmit = new HashSet<String>(1);
                toOmmit.add("tag");
                this.copyParameters(headerName, origHeader, forgedHeader, toOmmit);
                continue;
            }
            if (headerstoOmmit.contains(headerName)) continue;
            if (forgedMessage.getHeaders(headerName).hasNext()) {
                forgedMessage.removeHeader(headerName);
            }
            ListIterator headersIterator = originalMessage.getHeaders(headerName);
            while (headersIterator.hasNext()) {
                Header origHeader = (Header)headersIterator.next();
                try {
                    Header forgedHeader = this.provider.getHeaderFactory().createHeader(headerName, origHeader.toString().substring(origHeader.toString().indexOf(":") + 1));
                    forgedMessage.addLast(forgedHeader);
                }
                catch (ParseException e) {
                    tracer.severe("Failed to generate header on [" + headerName + "]. To copy value [" + origHeader + "]\n", (Throwable)e);
                    throw new SipException("Major failure", (Throwable)e);
                }
            }
        }
        byte[] rawOriginal = originalMessage.getRawContent();
        if (rawOriginal != null && rawOriginal.length != 0) {
            byte[] copy = new byte[rawOriginal.length];
            System.arraycopy(rawOriginal, 0, copy, 0, copy.length);
            try {
                forgedMessage.setContent((Object)new String(copy), (ContentTypeHeader)forgedMessage.getHeader("Content-Type"));
            }
            catch (ParseException e) {
                tracer.severe("Failed to set content on forged message. To copy value [" + new String(copy) + "] Type [" + forgedMessage.getHeader("Content-Type") + "]\n", (Throwable)e);
            }
        }
    }

    private void copyParameters(String name, Parameters origHeader, Parameters forgedHeader, Set<String> toOmmit) {
        Iterator it = origHeader.getParameterNames();
        while (it.hasNext()) {
            String p_name = (String)it.next();
            if (toOmmit.contains(p_name) || forgedHeader.getParameter(p_name) != null) {
                if (!tracer.isFineEnabled()) continue;
                tracer.fine("Ommiting parameter on [" + name + "]. To copy value [" + origHeader.getParameter(p_name) + "]\nValue in forged [" + forgedHeader.getParameter(p_name) + "]");
                continue;
            }
            try {
                forgedHeader.setParameter(p_name, origHeader.getParameter(p_name));
            }
            catch (ParseException e) {
                tracer.severe("Failed to pass parameter on [" + name + "]. To copy value [" + origHeader.getParameter(p_name) + "]\nValue in forged [" + forgedHeader.getParameter(p_name) + "]", (Throwable)e);
            }
        }
    }

    public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {
        this.ensureCorrectDialogLocalTag(request);
        ClientTransactionWrapper ctw = this.provider.getNewDialogActivityClientTransaction(this, request);
        if (request.getMethod().equals("INVITE")) {
            this.lastCancelableTransactionId = ctw.getBranchId();
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
        }
        this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
        return ctw;
    }

    protected void ensureCorrectDialogLocalTag(Request request) throws SipException {
        if (this.localTag != null) {
            try {
                ((FromHeader)request.getHeader("From")).setTag(this.localTag);
            }
            catch (ParseException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sendRequest(ClientTransaction ct) throws TransactionDoesNotExistException, SipException {
        Request request = ct.getRequest();
        this.ensureCorrectDialogLocalTag(request);
        if (tracer.isInfoEnabled()) {
            tracer.info(String.valueOf(ct) + " sending request:\n" + request);
        }
        this.wrappedDialog.sendRequest(((ClientTransactionWrapper)ct).getWrappedClientTransaction());
    }

    public Response createResponse(ServerTransaction origServerTransaction, Response receivedResponse) throws SipException {
        Response forgedResponse;
        if (!this.hasOngoingServerTransaction(origServerTransaction.getBranchId())) {
            throw new IllegalArgumentException("Passed server transaction is not in ongoing server transaction list for the dialog.");
        }
        try {
            forgedResponse = this.provider.getMessageFactory().createResponse(receivedResponse.getStatusCode(), origServerTransaction.getRequest());
        }
        catch (ParseException e) {
            throw new SipException("Failed to forge message", (Throwable)e);
        }
        this.forgeMessage((Message)receivedResponse, (Message)forgedResponse, Utils.getHeadersToOmmitOnResponseCopy());
        Request origRequest = origServerTransaction.getRequest();
        ViaHeader topVia = (ViaHeader)origRequest.getHeader("Via");
        if (topVia != null) {
            Address address = this.provider.getAddressFactory().createAddress((URI)this.provider.getLocalSipURI(topVia.getTransport()));
            if (address != null) {
                ContactHeader contactHeader = this.provider.getHeaderFactory().createContactHeader(address);
                forgedResponse.addLast((Header)contactHeader);
            } else if (tracer.isFineEnabled()) {
                tracer.fine("Failed to obtain contact address for AS, can not compute AS contact.");
            }
        } else if (tracer.isFineEnabled()) {
            tracer.fine("There is no via header, can not compute AS contact.");
        }
        return forgedResponse;
    }

    public ClientTransaction sendCancel() throws SipException {
        try {
            ClientTransaction inviteCTX = this.getClientTransaction(this.lastCancelableTransactionId);
            ClientTransactionWrapper cancelTransaction = this.provider.getNewDialogActivityClientTransaction(this, inviteCTX.createCancel());
            cancelTransaction.sendRequest();
            return cancelTransaction;
        }
        catch (NullPointerException npe) {
            if (tracer.isFineEnabled()) {
                tracer.fine(npe.getMessage(), (Throwable)npe);
            }
            throw new SipException("Possibly fialed to obtain client transaction or no INVITE transaction present");
        }
        catch (Exception e) {
            throw new SipException("Failed to send CANCEL due to:", (Throwable)e);
        }
    }

    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        return this.wrappedDialog.createAck(arg0);
    }

    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        return this.wrappedDialog.createPrack(arg0);
    }

    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        return this.wrappedDialog.createReliableProvisionalResponse(arg0);
    }

    public void delete() {
        DialogState currentState = this.wrappedDialog.getState();
        boolean needToFireDTE = !this.isEnding() && !this.wrappedDialog.isServer() && (currentState == null || currentState == DialogState.TERMINATED);
        this.wrappedDialog.delete();
        if (needToFireDTE) {
            this.ra.processDialogTerminated(this);
        }
    }

    public CallIdHeader getCallId() {
        return this.wrappedDialog.getCallId();
    }

    public String getDialogId() {
        return this.wrappedDialog.getDialogId();
    }

    @Deprecated
    public Transaction getFirstTransaction() {
        return this.wrappedDialog.getFirstTransaction();
    }

    public Address getLocalParty() {
        return this.wrappedDialog.getLocalParty();
    }

    public Address getRemoteParty() {
        return this.wrappedDialog.getRemoteParty();
    }

    public Address getRemoteTarget() {
        return this.wrappedDialog.getRemoteTarget();
    }

    public long getLocalSeqNumber() {
        return this.wrappedDialog.getLocalSeqNumber();
    }

    @Deprecated
    public int getLocalSequenceNumber() {
        return this.wrappedDialog.getLocalSequenceNumber();
    }

    public String getLocalTag() {
        if (this.localTag == null && this.wrappedDialog != null) {
            this.localTag = this.wrappedDialog.getLocalTag();
        }
        return this.localTag;
    }

    public long getRemoteSeqNumber() {
        return this.wrappedDialog.getRemoteSeqNumber();
    }

    @Deprecated
    public int getRemoteSequenceNumber() {
        return this.wrappedDialog.getRemoteSequenceNumber();
    }

    public String getRemoteTag() {
        return this.wrappedDialog.getRemoteTag();
    }

    public Iterator<RouteHeader> getRouteSet() {
        return this.wrappedDialog.getRouteSet();
    }

    public DialogState getState() {
        return this.wrappedDialog.getState();
    }

    public void incrementLocalSequenceNumber() {
        this.wrappedDialog.incrementLocalSequenceNumber();
    }

    public boolean isSecure() {
        return this.wrappedDialog.isSecure();
    }

    public boolean isServer() {
        return this.wrappedDialog.isServer();
    }

    public void sendAck(Request arg0) throws SipException {
        this.wrappedDialog.sendAck(arg0);
    }

    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        this.wrappedDialog.sendReliableProvisionalResponse(arg0);
    }

    public void terminateOnBye(boolean arg0) throws SipException {
        this.wrappedDialog.terminateOnBye(arg0);
    }

    public String toString() {
        return "DialogWrapper Id[" + this.getDialogId() + "] Handle[" + this.getActivityHandle() + "] State[" + this.getState() + "] OngoingCTX[" + this.ongoingClientTransactions.keySet() + "] OngoingSTX[" + this.ongoingServerTransactions.keySet() + "]";
    }

    public boolean processIncomingResponse(ResponseEvent respEvent) {
        return false;
    }

    public ClientTransaction getClientTransaction(String id) {
        return this.ongoingClientTransactions.get(id);
    }

    public ServerTransaction getServerTransaction(String id) {
        return this.ongoingServerTransactions.get(id);
    }

    public boolean hasOngoingServerTransaction(String branchID) {
        return this.ongoingServerTransactions.containsKey(branchID);
    }

    public boolean hasOngoingClientTransaction(String branchID) {
        return this.ongoingClientTransactions.containsKey(branchID);
    }

    public boolean addOngoingTransaction(ServerTransactionWrapper stw) {
        boolean alreadyMapped = this.ongoingServerTransactions.put(stw.getBranchId(), stw) == null;
        return alreadyMapped;
    }

    protected void updateReplicatedState() {
        if (!this.ra.inLocalMode()) {
            this.wrappedDialog.setApplicationData((Object)this);
        }
    }

    public boolean addOngoingTransaction(ClientTransactionWrapper ctw) {
        boolean alreadyMapped = this.ongoingClientTransactions.put(ctw.getBranchId(), ctw) == null;
        return alreadyMapped;
    }

    public void removeOngoingTransaction(ClientTransactionWrapper ctw) {
        if (this.ongoingClientTransactions == null || this.ongoingClientTransactions.remove(ctw.getBranchId()) != null) {
            // empty if block
        }
    }

    public void removeOngoingTransaction(ServerTransactionWrapper stw) {
        if (this.ongoingServerTransactions == null || this.ongoingServerTransactions.remove(stw.getBranchId()) != null) {
            // empty if block
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.wrappedDialog != null) {
            this.wrappedDialog.setApplicationData(null);
            this.wrappedDialog = null;
        }
        this.ra = null;
        this.provider = null;
        this.ongoingClientTransactions = null;
        this.ongoingServerTransactions = null;
        this.localTag = null;
        this.lastCancelableTransactionId = null;
        this.eventFiringAddress = null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.ongoingClientTransactions = new ConcurrentHashMap(1);
        this.ongoingServerTransactions = new ConcurrentHashMap(1);
        this.activityHandle.setActivity(this);
    }

    public Dialog getWrappedDialog() {
        return this.wrappedDialog;
    }

    public void setWrappedDialog(Dialog wrappedDialog) {
        this.wrappedDialog = wrappedDialog;
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
    }
}

