/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.sip.CancelRequestEvent;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.LoadBalancerElector;
import org.mobicents.ha.javax.sip.cache.SipResourceAdaptorMobicentsSipCache;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.sip11.ClusteredSipActivityManagement;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.EventIDCache;
import org.mobicents.slee.resource.sip11.EventIDFilter;
import org.mobicents.slee.resource.sip11.LocalSipActivityManagement;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityManagement;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.TransactionActivityHandle;
import org.mobicents.slee.resource.sip11.Utils;
import org.mobicents.slee.resource.sip11.wrappers.ACKDummyTransaction;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.NullClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.RequestEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ResponseEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TimeoutEventWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipResourceAdaptor
implements SipListener,
FaultTolerantResourceAdaptor<SipActivityHandle, String> {
    private static final String SIP_BIND_ADDRESS = "javax.sip.IP_ADDRESS";
    private static final String SIP_PORT_BIND = "javax.sip.PORT";
    private static final String TRANSPORTS_BIND = "javax.sip.TRANSPORT";
    private static final String STACK_NAME_BIND = "javax.sip.STACK_NAME";
    private static final String LOAD_BALANCER_HEART_BEAT_SERVICE_CLASS = "org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName";
    private static final String BALANCERS = "org.mobicents.ha.javax.sip.BALANCERS";
    private int port = 5060;
    private Set<String> transports = new HashSet<String>();
    private String transportsProperty;
    private String stackAddress;
    private String sipBalancerHeartBeatServiceClassName;
    private String balancers;
    private String loadBalancerElector;
    private Set<String> allowedTransports = new HashSet<String>();
    private SipProvider provider;
    private SleeSipProviderImpl providerWrapper;
    private SipActivityManagement activityManagement;
    private final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private SleeEndpoint sleeEndpoint;
    private EventLookupFacility eventLookupFacility;
    private Tracer tracer;
    private ClusteredSipStack sipStack = null;
    private SipFactory sipFactory = null;
    public static final int DEFAULT_EVENT_FLAGS = 64;
    private static final int ACTIVITY_FLAGS = 2;
    private FaultTolerantResourceAdaptorContext<SipActivityHandle, String> ftRaContext;

    public SipResourceAdaptor() {
        this.allowedTransports.add("udp");
        this.allowedTransports.add("tcp");
        this.transports.add("udp");
    }

    public void processIOException(IOExceptionEvent arg0) {
        this.tracer.severe("processIOException event = " + arg0.toString());
    }

    public void processRequest(RequestEvent req) {
        boolean infoTrace = this.tracer.isInfoEnabled();
        if (infoTrace) {
            this.tracer.info("Received Request:\n" + req.getRequest());
        }
        if (req.getRequest().getMethod().equals("CANCEL")) {
            this.processCancelRequest(req);
        } else {
            this.processNotCancelRequest(req, infoTrace);
        }
    }

    private void processCancelRequest(RequestEvent req) {
        boolean fineTrace = this.tracer.isFineEnabled();
        ServerTransactionWrapper cancelSTW = this.getServerTransactionWrapper(req, fineTrace);
        if (cancelSTW == null) {
            return;
        }
        SIPServerTransaction inviteST = ((SIPServerTransaction)cancelSTW.getWrappedServerTransaction()).getCanceledInviteTransaction();
        ServerTransactionWrapper inviteSTW = inviteST != null ? (ServerTransactionWrapper)inviteST.getApplicationData() : null;
        Dialog d = cancelSTW.getWrappedServerTransaction().getDialog();
        DialogWrapper dw = d == null ? null : (DialogWrapper)d.getApplicationData();
        Wrapper activity = dw;
        if (activity != null) {
            if (!this.inLocalMode()) {
                dw.setResourceAdaptor(this);
                dw.setWrappedDialog(d);
            }
            dw.addOngoingTransaction(cancelSTW);
        } else if (inviteSTW != null) {
            activity = inviteSTW;
            inviteSTW.setResourceAdaptor(this);
        } else {
            activity = cancelSTW;
            cancelSTW.setActivity(true);
            if (!this.addActivity(activity, false, fineTrace)) {
                String errorMsg = "Failed to add cancel transaction activity, can't proceed.";
                this.tracer.severe("Failed to add cancel transaction activity, can't proceed.");
                this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to add cancel transaction activity, can't proceed.");
                return;
            }
        }
        if (fineTrace) {
            this.tracer.fine("Activity selected to fire CANCEL event: " + activity);
        }
        CancelRequestEvent REW = new CancelRequestEvent((Object)this.providerWrapper, (ServerTransaction)cancelSTW, (ServerTransaction)inviteSTW, (Dialog)dw, req.getRequest());
        int eventsFlags = EventFlags.setRequestEventReferenceReleasedCallback((int)64);
        FireableEventType eventType = this.eventIdCache.getEventId(this.eventLookupFacility, REW.getRequest(), activity.isDialog());
        if (this.eventIDFilter.filterEvent(eventType)) {
            if (fineTrace) {
                this.tracer.fine("Event " + (eventType == null ? "null" : eventType.getEventType()) + " filtered");
            }
            this.processCancelNotHandled(cancelSTW, req.getRequest());
        } else {
            try {
                this.sleeEndpoint.fireEvent((ActivityHandle)activity.getActivityHandle(), eventType, (Object)REW, activity.getEventFiringAddress(), null, eventsFlags);
            }
            catch (Throwable e) {
                this.tracer.severe("Failed to fire event", e);
                this.processCancelNotHandled(cancelSTW, req.getRequest());
            }
        }
    }

    private void processCancelNotHandled(ServerTransactionWrapper cancelSTW, Request r) {
        try {
            cancelSTW.getWrappedServerTransaction().sendResponse(this.providerWrapper.getMessageFactory().createResponse(481, r));
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
        Dialog d = cancelSTW.getDialog();
        if (d != null) {
            d.delete();
        }
    }

    private ServerTransactionWrapper getServerTransactionWrapper(RequestEvent requestEvent, boolean fineTrace) {
        ServerTransactionWrapper stw = null;
        ServerTransaction st = requestEvent.getServerTransaction();
        if (st != null) {
            stw = (ServerTransactionWrapper)st.getApplicationData();
            if (stw == null) {
                stw = new ServerTransactionWrapper(st, this);
                if (fineTrace) {
                    this.tracer.fine("New server transaction " + stw);
                }
            } else {
                stw.setResourceAdaptor(this);
            }
        } else {
            if (requestEvent.getDialog() != null && this.inLocalMode()) {
                if (fineTrace) {
                    this.tracer.fine("Got in-dialog request with null server transaction, in local mode must be a retransmission, thus dropping. Request: " + requestEvent.getRequest());
                }
                return null;
            }
            if (!requestEvent.getRequest().getMethod().equals("ACK")) {
                try {
                    stw = new ServerTransactionWrapper(this.provider.getNewServerTransaction(requestEvent.getRequest()), this);
                }
                catch (Throwable e) {
                    if (fineTrace) {
                        this.tracer.fine(e.getMessage(), e);
                    }
                }
            } else {
                stw = new ServerTransactionWrapper(new ACKDummyTransaction(requestEvent.getRequest()), this);
                if (fineTrace) {
                    this.tracer.fine("New ACK server transaction " + stw);
                }
            }
        }
        return stw;
    }

    private void processNotCancelRequest(RequestEvent req, boolean infoTrace) {
        boolean fineTrace = this.tracer.isFineEnabled();
        Dialog d = req.getDialog();
        DialogWrapper dw = d == null ? null : (DialogWrapper)d.getApplicationData();
        ServerTransactionWrapper stw = this.getServerTransactionWrapper(req, fineTrace);
        if (stw == null) {
            return;
        }
        Wrapper activity = dw;
        if (activity == null) {
            activity = stw;
            stw.setActivity(true);
            if (!this.addActivity(activity, false, fineTrace)) {
                this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to deliver request event to JAIN SLEE container");
                return;
            }
        } else {
            if (!this.inLocalMode()) {
                dw.setResourceAdaptor(this);
                dw.setWrappedDialog(d);
            }
            dw.addOngoingTransaction(stw);
        }
        int eventFlags = 64;
        if (stw.isAckTransaction()) {
            eventFlags = EventFlags.setRequestEventReferenceReleasedCallback((int)eventFlags);
        }
        FireableEventType eventType = this.eventIdCache.getEventId(this.eventLookupFacility, req.getRequest(), dw != null);
        RequestEventWrapper rew = new RequestEventWrapper(this.providerWrapper, stw, (Dialog)dw, req.getRequest());
        if (this.eventIDFilter.filterEvent(eventType)) {
            if (fineTrace) {
                this.tracer.fine("Event " + (eventType == null ? "null" : eventType.getEventType()) + " filtered");
            }
            if (!stw.isAckTransaction()) {
                this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to deliver request event to JAIN SLEE container");
            } else {
                this.processTransactionTerminated(stw);
            }
        } else {
            try {
                this.sleeEndpoint.fireEvent((ActivityHandle)activity.getActivityHandle(), eventType, (Object)rew, activity.getEventFiringAddress(), null, eventFlags);
            }
            catch (Throwable e) {
                this.tracer.severe("Failed to fire event", e);
                if (!stw.isAckTransaction()) {
                    this.sendErrorResponse(req.getServerTransaction(), req.getRequest(), 500, "Failed to deliver request event to JAIN SLEE container");
                }
                this.processTransactionTerminated(stw);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processResponse(ResponseEvent responseEvent) {
        DialogWrapper dw;
        Response response;
        block26: {
            boolean infoTrace = this.tracer.isInfoEnabled();
            boolean fineTrace = this.tracer.isFineEnabled();
            if (infoTrace) {
                this.tracer.info("Received Response:\n" + responseEvent.getResponse());
            }
            response = responseEvent.getResponse();
            SipActivityHandle handle = null;
            Address address = null;
            ClientTransactionWrapper ctw = null;
            Dialog d = responseEvent.getDialog();
            DialogWrapper dialogWrapper = dw = d == null ? null : (DialogWrapper)d.getApplicationData();
            if (dw != null && !this.inLocalMode()) {
                dw.setResourceAdaptor(this);
                dw.setWrappedDialog(d);
            }
            boolean requestEventUnreferenced = false;
            ClientTransaction ct = responseEvent.getClientTransaction();
            if (ct == null) {
                DialogWithoutIdActivityHandle masterHandle;
                FromHeader fromHeader = (FromHeader)response.getHeader("From");
                address = ClientTransactionWrapper.getEventFiringAddress(fromHeader.getAddress());
                if (dw != null) {
                    if (!fineTrace) return;
                    this.tracer.fine("Received " + response.getStatusCode() + " in-dialog response without a client transaction, dropping, should be a retransmission.");
                    return;
                }
                String localTag = fromHeader.getTag();
                if (localTag != null && this.isDialogConfirmation(response) && this.activityManagement.get(masterHandle = new DialogWithoutIdActivityHandle(((CallIdHeader)response.getHeader("Call-ID")).getCallId(), localTag, null)) != null) {
                    if (fineTrace) {
                        this.tracer.fine("Received a 2xx response without a client transaction, but found a master dialog so it's a late fork response, sending ack and bye.");
                    }
                    this.processLateDialogFork2xxResponse(response);
                    return;
                }
                if (fineTrace) {
                    this.tracer.fine("Received " + response.getStatusCode() + " response without a client transaction, and didn't found a master dialog, firing event in a dummy client transaction.");
                }
                String branchId = ((ViaHeader)response.getHeaders("Via").next()).getBranch();
                String method = ((CSeqHeader)response.getHeader("CSeq")).getMethod();
                handle = new TransactionActivityHandle(branchId, method);
                ctw = new NullClientTransactionWrapper(handle, this);
                try {
                    this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)ctw, 2);
                    this.activityManagement.put(handle, ctw);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                requestEventUnreferenced = response.getStatusCode() > 199;
            } else {
                ctw = (ClientTransactionWrapper)ct.getApplicationData();
                if (ctw == null) {
                    this.tracer.severe("Dropping response without app data in client tx, can't proceed");
                    return;
                }
                if (fineTrace) {
                    this.tracer.fine("Received " + response.getStatusCode() + " response on existent client transaction " + ctw.getActivityHandle());
                }
                ctw.setResourceAdaptor(this);
                address = ctw.getEventFiringAddress();
                if (dw != null) {
                    handle = dw.getActivityHandle();
                    requestEventUnreferenced = response.getStatusCode() > 199;
                } else {
                    handle = ctw.getActivityHandle();
                }
            }
            int eventFlags = 64;
            if (requestEventUnreferenced) {
                eventFlags = EventFlags.setRequestEventReferenceReleasedCallback((int)eventFlags);
            }
            if (dw == null || !dw.processIncomingResponse(responseEvent)) {
                ResponseEventWrapper rew = new ResponseEventWrapper(this.providerWrapper, ctw, (Dialog)dw, response);
                FireableEventType eventType = this.eventIdCache.getEventId(this.eventLookupFacility, response);
                if (this.eventIDFilter.filterEvent(eventType)) {
                    if (fineTrace) {
                        this.tracer.fine("Event " + (eventType == null ? "null" : eventType.getEventType()) + " filtered");
                    }
                    if (requestEventUnreferenced) {
                        this.processResponseEventUnreferenced(rew);
                    }
                } else {
                    try {
                        this.sleeEndpoint.fireEvent((ActivityHandle)handle, eventType, (Object)rew, address, null, eventFlags);
                    }
                    catch (Throwable e) {
                        this.tracer.severe("Failed to fire event", e);
                        if (!requestEventUnreferenced) break block26;
                        this.processResponseEventUnreferenced(rew);
                    }
                }
            }
        }
        if (response.getStatusCode() != 481) {
            if (response.getStatusCode() != 408) return;
        }
        if (dw == null) return;
        String method = ((CSeqHeader)response.getHeader("CSeq")).getMethod();
        if (method.equals("INVITE")) {
            if (method.equals("SUBSCRIBE")) return;
        }
        try {
            this.provider.sendRequest(dw.createRequest("BYE"));
            return;
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
    }

    private boolean isDialogConfirmation(Response response) {
        CSeqHeader cSeqHeader = (CSeqHeader)response.getHeader("CSeq");
        if (!cSeqHeader.getMethod().equals("INVITE") && !cSeqHeader.getMethod().equals("SUBSCRIBE")) {
            return false;
        }
        if (cSeqHeader.getSeqNumber() != 1L) {
            return false;
        }
        return response.getStatusCode() < 300 && response.getStatusCode() > 199;
    }

    private void processLateDialogFork2xxResponse(Response response) {
        SleeSipProviderImpl provider = this.getProviderWrapper();
        try {
            CSeqHeader cseq = (CSeqHeader)response.getHeader("CSeq");
            List<RouteHeader> routeSet = Utils.getRouteList(response, provider.getHeaderFactory());
            SipURI requestURI = Utils.getRequestUri(response, provider.getAddressFactory());
            String branch = ((ViaHeader)response.getHeaders("Via").next()).getBranch();
            long cseqNumber = cseq.getSeqNumber();
            if (requestURI == null) {
                this.tracer.severe("Cannot ack on request that has empty contact!!!!");
                return;
            }
            MaxForwardsHeader mf = provider.getHeaderFactory().createMaxForwardsHeader(70);
            ArrayList<ViaHeader> lst = new ArrayList<ViaHeader>(1);
            ViaHeader localViaHeader = provider.getLocalVia();
            localViaHeader.setBranch(branch);
            lst.add(localViaHeader);
            Request forgedRequest = provider.getMessageFactory().createRequest((URI)requestURI, "ACK", (CallIdHeader)response.getHeader("Call-ID"), provider.getHeaderFactory().createCSeqHeader(cseqNumber, "ACK"), (FromHeader)response.getHeader("From"), (ToHeader)response.getHeader("To"), lst, mf);
            for (RouteHeader h : routeSet) {
                forgedRequest.addLast((Header)h);
            }
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Sending request:\n" + forgedRequest);
            }
            provider.sendRequest(forgedRequest);
            lst = new ArrayList();
            lst.add(provider.getLocalVia());
            requestURI = Utils.getRequestUri(response, provider.getAddressFactory());
            forgedRequest = provider.getMessageFactory().createRequest((URI)requestURI, "BYE", (CallIdHeader)response.getHeader("Call-ID"), provider.getHeaderFactory().createCSeqHeader(cseqNumber + 1L, "BYE"), (FromHeader)response.getHeader("From"), (ToHeader)response.getHeader("To"), lst, mf);
            for (RouteHeader h : routeSet) {
                forgedRequest.addLast((Header)h);
            }
            ((SIPRequest)forgedRequest).setMethod("BYE");
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Sending request:\n" + forgedRequest);
            }
            provider.sendRequest(forgedRequest);
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
        }
    }

    public void processTimeout(TimeoutEvent arg0) {
        ServerTransaction t;
        TransactionWrapper tw;
        if (this.tracer.isInfoEnabled()) {
            if (arg0.isServerTransaction()) {
                this.tracer.info("Server transaction " + arg0.getServerTransaction().getBranchId() + " timer expired");
            } else {
                this.tracer.info("Client transaction " + arg0.getClientTransaction().getBranchId() + " timer expired");
            }
        }
        if ((tw = (TransactionWrapper)(t = arg0.isServerTransaction() ? arg0.getServerTransaction() : arg0.getClientTransaction()).getApplicationData()) == null) {
            this.tracer.severe("FAILURE on processTimeout. Unexpected app data[" + t.getApplicationData() + "] branch[" + t.getBranchId() + "]");
            return;
        }
        tw.setResourceAdaptor(this);
        TimeoutEventWrapper tew = null;
        tew = arg0.isServerTransaction() ? new TimeoutEventWrapper((Object)this.providerWrapper, (ServerTransaction)tw, arg0.getTimeout()) : new TimeoutEventWrapper((Object)this.providerWrapper, (ClientTransaction)tw, arg0.getTimeout());
        Dialog d = tw.getWrappedTransaction().getDialog();
        DialogWrapper dw = d != null ? (DialogWrapper)d.getApplicationData() : null;
        FireableEventType eventType = this.eventIdCache.getTransactionTimeoutEventId(this.eventLookupFacility, dw != null);
        if (!this.eventIDFilter.filterEvent(eventType)) {
            Wrapper activity;
            Wrapper wrapper = activity = tw.isActivity() ? tw : dw;
            if (dw != null && !this.inLocalMode()) {
                dw.setResourceAdaptor(this);
                dw.setWrappedDialog(d);
            }
            try {
                this.sleeEndpoint.fireEvent((ActivityHandle)activity.getActivityHandle(), eventType, (Object)tew, activity.getEventFiringAddress(), null, 64);
            }
            catch (Throwable e) {
                this.tracer.severe("Failed to fire event", e);
            }
        } else if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event " + eventType + " filtered.");
        }
    }

    public void processTransactionTerminated(TransactionTerminatedEvent txTerminatedEvent) {
        Object t = null;
        t = txTerminatedEvent.isServerTransaction() ? txTerminatedEvent.getServerTransaction() : txTerminatedEvent.getClientTransaction();
        TransactionWrapper tw = (TransactionWrapper)t.getApplicationData();
        if (tw != null) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("SIP Transaction " + tw.getActivityHandle() + " terminated");
            }
            this.processTransactionTerminated(tw);
        } else if (this.tracer.isInfoEnabled()) {
            this.tracer.info("SIP Transaction " + t.getBranchId() + ':' + t.getRequest().getMethod() + " terminated");
        }
    }

    private void processTransactionTerminated(TransactionWrapper tw) {
        tw.terminated();
        if (tw.isActivity()) {
            tw.setResourceAdaptor(this);
            this.sendActivityEndEvent(tw);
        } else if (!tw.isClientTransaction()) {
            tw.clear();
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dte) {
        Dialog d = dte.getDialog();
        if (d != null) {
            DialogWrapper dw = (DialogWrapper)d.getApplicationData();
            if (dw != null) {
                if (!this.inLocalMode()) {
                    dw.setResourceAdaptor(this);
                    dw.setWrappedDialog(d);
                }
                this.processDialogTerminated(dw);
            } else if (this.tracer.isFineEnabled()) {
                this.tracer.fine("DialogTerminatedEvent dropped due to null app data.");
            }
        }
    }

    public void processDialogTerminated(DialogWrapper dw) {
        if (!dw.isEnding()) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("SIP Dialog " + dw.getActivityHandle() + " terminated");
            }
            if (!this.sendActivityEndEvent(dw)) {
                this.tracer.warning("Dialog activity that ended not found.");
            }
            dw.ending();
        }
    }

    public boolean sendActivityEndEvent(Wrapper activity) {
        try {
            activity.ending();
            this.sleeEndpoint.endActivity((ActivityHandle)activity.getActivityHandle());
            return true;
        }
        catch (Exception e) {
            this.tracer.severe(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean addActivity(Wrapper wrapperActivity, boolean transacted, boolean fineTrace) {
        if (fineTrace) {
            this.tracer.fine("Adding sip activity handle " + wrapperActivity.getActivityHandle());
        }
        try {
            if (transacted) {
                this.sleeEndpoint.startActivityTransacted((ActivityHandle)wrapperActivity.getActivityHandle(), (Object)wrapperActivity, 2);
            } else {
                this.sleeEndpoint.startActivity((ActivityHandle)wrapperActivity.getActivityHandle(), (Object)wrapperActivity, 2);
            }
        }
        catch (ActivityAlreadyExistsException e) {
            if (!(this.inLocalMode() || wrapperActivity.isDialog() && wrapperActivity.getActivityHandle().getClass() != DialogWithoutIdActivityHandle.class)) {
                if (fineTrace) {
                    this.tracer.fine("Failed to add activity, but RA is running in cluster and the activity type is not replicated, which means it may result from fail over", (Throwable)e);
                }
            }
            this.tracer.severe(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
            return false;
        }
        this.activityManagement.put(wrapperActivity.getActivityHandle(), wrapperActivity);
        return true;
    }

    public boolean addSuspendedActivity(Wrapper wrapperActivity, boolean fineTrace) {
        if (fineTrace) {
            this.tracer.fine("Adding suspended sip activity handle " + wrapperActivity.getActivityHandle());
        }
        try {
            this.sleeEndpoint.startActivitySuspended((ActivityHandle)wrapperActivity.getActivityHandle(), (Object)wrapperActivity, 2);
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
            return false;
        }
        this.activityManagement.put(wrapperActivity.getActivityHandle(), wrapperActivity);
        return true;
    }

    private void sendErrorResponse(ServerTransaction serverTransaction, Request request, int code, String msg) {
        if (!request.getMethod().equals("ACK")) {
            try {
                ContentTypeHeader contentType = this.providerWrapper.getHeaderFactory().createContentTypeHeader("text", "plain");
                Response response = this.providerWrapper.getMessageFactory().createResponse(code, request, contentType, msg.getBytes());
                if (serverTransaction != null) {
                    serverTransaction.sendResponse(response);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void raActive() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("sipra.properties"));
            properties.setProperty(SIP_BIND_ADDRESS, this.stackAddress);
            properties.setProperty(STACK_NAME_BIND, this.raContext.getEntityName());
            properties.setProperty(TRANSPORTS_BIND, this.transportsProperty);
            properties.setProperty(SIP_PORT_BIND, Integer.toString(this.port));
            if (this.sipBalancerHeartBeatServiceClassName != null) {
                properties.setProperty(LOAD_BALANCER_HEART_BEAT_SERVICE_CLASS, this.sipBalancerHeartBeatServiceClassName);
            }
            if (this.balancers != null) {
                properties.setProperty(BALANCERS, this.balancers);
            }
            if (this.loadBalancerElector != null) {
                properties.setProperty(LoadBalancerElector.IMPLEMENTATION_CLASS_NAME_PROPERTY, this.loadBalancerElector);
            }
            properties.setProperty("org.mobicents.ha.javax.sip.CACHE_CLASS_NAME", SipResourceAdaptorMobicentsSipCache.class.getName());
            this.sipFactory = SipFactory.getInstance();
            this.sipFactory.setPathName("org.mobicents.ha");
            this.sipStack = (ClusteredSipStack)this.sipFactory.createSipStack(properties);
            this.sipStack.start();
            this.activityManagement = this.inLocalMode() ? new LocalSipActivityManagement() : new ClusteredSipActivityManagement(this.sipStack, (ReplicatedData<SipActivityHandle, String>)this.ftRaContext.getReplicateData(), this.raContext.getSleeTransactionManager());
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("---> START " + Arrays.toString(this.transports.toArray()));
            }
            boolean created = false;
            for (String trans : this.transports) {
                ListeningPoint lp = this.sipStack.createListeningPoint(this.stackAddress, this.port, trans);
                if (!created) {
                    this.provider = this.sipStack.createSipProvider(lp);
                    this.provider.addSipListener((SipListener)this);
                    created = true;
                    continue;
                }
                this.provider.addListeningPoint(lp);
            }
            AddressFactory addressFactory = this.sipFactory.createAddressFactory();
            HeaderFactory headerFactory = this.sipFactory.createHeaderFactory();
            MessageFactory messageFactory = this.sipFactory.createMessageFactory();
            this.providerWrapper = new SleeSipProviderImpl(addressFactory, headerFactory, messageFactory, this.sipStack, this, this.provider);
        }
        catch (Throwable ex) {
            String msg = "error in initializing resource adaptor";
            this.tracer.severe(msg, ex);
            throw new RuntimeException(msg, ex);
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Sip Resource Adaptor entity active.");
        }
    }

    public void raInactive() {
        this.provider.removeSipListener((SipListener)this);
        ListeningPoint[] listeningPoints = this.provider.getListeningPoints();
        block4: for (int i = 0; i < listeningPoints.length; ++i) {
            ListeningPoint lp = listeningPoints[i];
            for (int k = 0; k < 10; ++k) {
                try {
                    this.sipStack.deleteListeningPoint(lp);
                    this.sipStack.deleteSipProvider(this.provider);
                    continue block4;
                }
                catch (ObjectInUseException ex) {
                    this.tracer.severe("Object in use -- retrying to delete listening point", (Throwable)ex);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Sip Resource Adaptor entity inactive.");
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Object for entity named " + this.raContext.getEntityName() + " is stopping. " + this.activityManagement);
        }
    }

    public void eventProcessingFailed(ActivityHandle ah, FireableEventType arg1, Object event, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
        if (event.getClass() == CancelRequestEvent.class) {
            try {
                Response txDoesNotExistsResponse = this.providerWrapper.getMessageFactory().createResponse(481, ((CancelRequestEvent)event).getRequest());
                ServerTransactionWrapper stw = (ServerTransactionWrapper)this.getActivity(ah);
                stw.sendResponse(txDoesNotExistsResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address arg3, ReceivableService arg4, int arg5) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event Unreferenced. Handle = " + handle + ", type = " + eventType.getEventType() + ", event = " + event);
        }
        if (event instanceof ResponseEventWrapper) {
            ResponseEventWrapper rew = (ResponseEventWrapper)((Object)event);
            this.processResponseEventUnreferenced(rew);
        } else if (event instanceof RequestEventWrapper) {
            RequestEventWrapper rew = (RequestEventWrapper)((Object)event);
            ServerTransactionWrapper stw = (ServerTransactionWrapper)rew.getServerTransaction();
            if (stw.isAckTransaction()) {
                this.processTransactionTerminated(stw);
            } else {
                Request r = rew.getRequest();
                if (r.getMethod().equals("CANCEL") && stw.getState() != TransactionState.TERMINATED) {
                    this.processCancelNotHandled(stw, r);
                }
            }
        }
    }

    private void processResponseEventUnreferenced(ResponseEventWrapper rew) {
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)rew.getClientTransaction();
        if (!ctw.isActivity()) {
            ctw.getDialogWrapper().removeOngoingTransaction(ctw);
            ctw.clear();
        } else {
            this.sendActivityEndEvent(this.activityManagement.get(ctw.getActivityHandle()));
        }
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
        this.raConfigure(properties);
    }

    public void raConfigure(ConfigProperties properties) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Configuring RA.");
        }
        this.port = (Integer)properties.getProperty(SIP_PORT_BIND).getValue();
        this.stackAddress = (String)properties.getProperty(SIP_BIND_ADDRESS).getValue();
        if (this.stackAddress.equals("")) {
            this.stackAddress = System.getProperty("jboss.bind.address");
        }
        this.balancers = (String)properties.getProperty(BALANCERS).getValue();
        if (this.balancers.equals("")) {
            this.balancers = null;
        } else {
            this.sipBalancerHeartBeatServiceClassName = (String)properties.getProperty(LOAD_BALANCER_HEART_BEAT_SERVICE_CLASS).getValue();
            if (this.sipBalancerHeartBeatServiceClassName.equals("")) {
                throw new IllegalArgumentException("invalid org.mobicents.ha.javax.sip.LoadBalancerHeartBeatingServiceClassName property value");
            }
        }
        this.loadBalancerElector = (String)properties.getProperty(LoadBalancerElector.IMPLEMENTATION_CLASS_NAME_PROPERTY).getValue();
        if (this.loadBalancerElector.equals("")) {
            this.loadBalancerElector = null;
        }
        this.transportsProperty = (String)properties.getProperty(TRANSPORTS_BIND).getValue();
        for (String transport : this.transportsProperty.split(",")) {
            this.transports.add(transport);
        }
        this.tracer.info("RA entity named " + this.raContext.getEntityName() + " bound to port " + this.port);
    }

    public void raUnconfigure() {
        this.port = -1;
        this.stackAddress = null;
        this.transports.clear();
        this.balancers = null;
        this.loadBalancerElector = null;
        this.sipBalancerHeartBeatServiceClassName = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        try {
            String sipBalancerElectorClassName;
            Integer port = (Integer)properties.getProperty(SIP_PORT_BIND).getValue();
            String stackAddress = (String)properties.getProperty(SIP_BIND_ADDRESS).getValue();
            if (stackAddress.equals("")) {
                stackAddress = System.getProperty("jboss.bind.address");
            }
            InetSocketAddress sockAddress = new InetSocketAddress(stackAddress, (int)port);
            new DatagramSocket(sockAddress).close();
            String transports = (String)properties.getProperty(TRANSPORTS_BIND).getValue();
            String[] transportsArray = transports.split(",");
            boolean validTransports = true;
            if (transportsArray.length > 0) {
                String transport;
                int i$ = 0;
                String[] arr$ = transportsArray;
                int len$ = arr$.length;
                if (i$ < len$ && !this.allowedTransports.contains((transport = arr$[i$]).toLowerCase())) {
                    validTransports = false;
                }
            } else {
                validTransports = false;
            }
            if (!validTransports) {
                throw new IllegalArgumentException("javax.sip.TRANSPORT config property with invalid value: " + transports);
            }
            String sipBalancerHeartBeatServiceClassName = (String)properties.getProperty(LOAD_BALANCER_HEART_BEAT_SERVICE_CLASS).getValue();
            if (!sipBalancerHeartBeatServiceClassName.equals("")) {
                Class.forName(sipBalancerHeartBeatServiceClassName);
            }
            if (!(sipBalancerElectorClassName = (String)properties.getProperty(LoadBalancerElector.IMPLEMENTATION_CLASS_NAME_PROPERTY).getValue()).equals("")) {
                Class.forName(sipBalancerElectorClassName);
            }
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public void serviceActive(ReceivableService receivableService) {
        this.eventIDFilter.serviceActive(receivableService);
    }

    public void serviceInactive(ReceivableService receivableService) {
        this.eventIDFilter.serviceInactive(receivableService);
    }

    public void serviceStopping(ReceivableService receivableService) {
        this.eventIDFilter.serviceStopping(receivableService);
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.raContext = raContext;
        this.tracer = raContext.getTracer("SipResourceAdaptor");
        this.sleeEndpoint = raContext.getSleeEndpoint();
        this.eventLookupFacility = raContext.getEventLookupFacility();
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.sleeEndpoint = null;
        this.eventLookupFacility = null;
    }

    public EventLookupFacility getEventLookupFacility() {
        return this.eventLookupFacility;
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public Tracer getTracer(String tracerName) {
        return this.raContext.getTracer(tracerName);
    }

    public SipActivityManagement getActivityManagement() {
        return this.activityManagement;
    }

    public void activityEnded(ActivityHandle activityHandle) {
        Wrapper activity = this.activityManagement.remove((SipActivityHandle)activityHandle);
        if (activity != null) {
            activity.clear();
        }
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle arg0) {
        Wrapper w = this.activityManagement.get((SipActivityHandle)arg0);
        if (w != null) {
            w.setResourceAdaptor(this);
        }
        return w;
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (activity instanceof Wrapper) {
            Wrapper w = (Wrapper)activity;
            return w != null ? w.getActivityHandle() : null;
        }
        return null;
    }

    public void queryLiveness(ActivityHandle arg0) {
        SipActivityHandle handle = (SipActivityHandle)arg0;
        Wrapper activity = this.activityManagement.get(handle);
        if (activity == null || activity.isEnding()) {
            this.sleeEndpoint.endActivity(arg0);
        }
    }

    public Object getResourceAdaptorInterface(String raTypeSbbInterfaceclassName) {
        return this.providerWrapper;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public SleeSipProviderImpl getProviderWrapper() {
        return this.providerWrapper;
    }

    public EventIDCache getEventIdCache() {
        return this.eventIdCache;
    }

    public EventIDFilter getEventIDFilter() {
        return this.eventIDFilter;
    }

    public boolean inLocalMode() {
        return this.sipStack.getSipCache().inLocalMode();
    }

    public void failOver(SipActivityHandle activityHandle) {
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext<SipActivityHandle, String> context) {
        this.ftRaContext = context;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.ftRaContext = null;
    }
}

