/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.header.ToHeader;
import javax.sip.message.Response;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.TransactionActivityHandle;
import org.mobicents.slee.resource.sip11.wrappers.ACKDummyTransaction;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionWrapper;

public class ServerTransactionWrapper
extends TransactionWrapper
implements ServerTransaction {
    private static final long serialVersionUID = 1L;
    private final boolean ackTransaction;
    private transient Address eventFiringAddress;
    private static Tracer tracer;
    private transient ServerTransaction wrappedTransaction;

    public ServerTransactionWrapper(ACKDummyTransaction wrappedTransaction, SipResourceAdaptor ra) {
        this(wrappedTransaction, ra, true);
    }

    public ServerTransactionWrapper(ServerTransaction wrappedTransaction, SipResourceAdaptor ra) {
        this(wrappedTransaction, ra, wrappedTransaction.getRequest().getMethod().equals("ACK"));
    }

    private ServerTransactionWrapper(ServerTransaction wrappedTransaction, SipResourceAdaptor ra, boolean ackTransaction) {
        super(new TransactionActivityHandle(wrappedTransaction.getBranchId(), wrappedTransaction.getRequest().getMethod()));
        this.ackTransaction = ackTransaction;
        this.wrappedTransaction = wrappedTransaction;
        this.wrappedTransaction.setApplicationData((Object)this);
        if (tracer == null) {
            tracer = ra.getTracer(ServerTransactionWrapper.class.getSimpleName());
        }
    }

    public void setResourceAdaptor(SipResourceAdaptor ra) {
        super.setResourceAdaptor(ra);
        if (tracer == null) {
            tracer = ra.getTracer(ClientTransactionWrapper.class.getSimpleName());
        }
    }

    public Transaction getWrappedTransaction() {
        return this.wrappedTransaction;
    }

    public ServerTransaction getWrappedServerTransaction() {
        return this.wrappedTransaction;
    }

    public void setWrappedServerTransaction(ServerTransaction wrappedTransaction) {
        this.wrappedTransaction = wrappedTransaction;
    }

    public boolean isAckTransaction() {
        return this.ackTransaction;
    }

    public boolean isClientTransaction() {
        return false;
    }

    private void validateWrappedTransaction() throws IllegalStateException {
        if (this.wrappedTransaction == null) {
            throw new IllegalStateException();
        }
    }

    public Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = new Address(AddressPlan.SIP, ((ToHeader)this.wrappedTransaction.getRequest().getHeader("To")).getAddress().toString());
        }
        return this.eventFiringAddress;
    }

    public void enableRetransmissionAlerts() throws SipException {
        this.validateWrappedTransaction();
        this.wrappedTransaction.enableRetransmissionAlerts();
    }

    public void sendResponse(Response arg0) throws SipException, InvalidArgumentException {
        DialogWrapper dw;
        this.validateWrappedTransaction();
        Dialog d = this.wrappedTransaction.getDialog();
        if (d != null && (dw = (DialogWrapper)d.getApplicationData()) != null) {
            int statusCode = arg0.getStatusCode();
            if (this.getRequest().getMethod().equals("CANCEL") && statusCode < 300 && statusCode > 199 && dw.getState() == null) {
                dw.delete();
            } else if (d.getLocalTag() == null) {
                try {
                    ((ToHeader)arg0.getHeader("To")).setTag(dw.getLocalTag());
                }
                catch (ParseException e) {
                    throw new SipException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(this.toString() + " sending response:\n" + arg0);
        }
        this.wrappedTransaction.sendResponse(arg0);
    }

    public String toString() {
        String id = this.wrappedTransaction == null ? String.valueOf(null) : this.wrappedTransaction.getBranchId();
        return "ServerTransaction[" + id + ']';
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.activityHandle.setActivity(this);
    }

    public void terminated() {
        DialogWrapper dw = this.getDialogWrapper();
        if (dw != null) {
            dw.removeOngoingTransaction(this);
        }
    }

    public void clear() {
        super.clear();
        if (this.wrappedTransaction != null) {
            this.wrappedTransaction.setApplicationData(null);
            this.wrappedTransaction = null;
        }
        this.eventFiringAddress = null;
    }
}

