/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.RouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.AddressPlan;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.slee.resource.sip11.DialogWithIdActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.Utils;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionAssociation;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogWrapper
extends Wrapper
implements DialogActivity {
    private static final long serialVersionUID = 1L;
    protected transient ConcurrentHashMap<SipActivityHandle, ClientTransactionWrapper> ongoingClientTransactions = new ConcurrentHashMap(1);
    protected transient ConcurrentHashMap<SipActivityHandle, ServerTransactionWrapper> ongoingServerTransactions = new ConcurrentHashMap(1);
    protected transient Dialog wrappedDialog;
    private String localTag;
    protected transient javax.slee.Address eventFiringAddress;
    private static Tracer tracer;
    protected SipActivityHandle lastCancelableTransactionId;
    static final String[] EMPTY_STRING_ARRAY;

    public DialogWrapper(Dialog wrappedDialog, String dialogId, String localTag, SipResourceAdaptor ra) throws IllegalArgumentException {
        this(new DialogWithIdActivityHandle(dialogId), localTag, ra);
        this.wrappedDialog = wrappedDialog;
        this.wrappedDialog.setApplicationData((Object)this);
    }

    protected DialogWrapper(SipActivityHandle sipActivityHandle, String localTag, SipResourceAdaptor ra) {
        super(sipActivityHandle);
        this.setResourceAdaptor(ra);
        this.localTag = localTag;
    }

    @Override
    public void setResourceAdaptor(SipResourceAdaptor ra) {
        super.setResourceAdaptor(ra);
        if (tracer == null) {
            tracer = ra.getTracer(DialogWrapper.class.getSimpleName());
        }
    }

    @Override
    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = new javax.slee.Address(AddressPlan.SIP, this.wrappedDialog.getLocalParty().toString());
        }
        return this.eventFiringAddress;
    }

    @Override
    public boolean isAckTransaction() {
        return false;
    }

    @Override
    public boolean isActivity() {
        return true;
    }

    @Override
    public boolean isDialog() {
        return true;
    }

    public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
        if (ct == null) {
            throw new NullPointerException("null client transaction");
        }
        if (st == null) {
            throw new NullPointerException("null server transaction");
        }
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        ServerTransactionWrapper stw = (ServerTransactionWrapper)st;
        DialogWrapper stDialog = (DialogWrapper)st.getDialog();
        if (stDialog == null) {
            throw new IllegalArgumentException("the specified server transaction has no dialog.");
        }
        ctw.associateServerTransaction(stw, stDialog.getActivityHandle());
    }

    public ServerTransaction getAssociatedServerTransaction(ClientTransaction ct) {
        if (ct == null) {
            throw new NullPointerException("Passed Client Transaction is null!");
        }
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        ClientTransactionAssociation cta = ctw.getClientTransactionAssociation();
        if (cta != null) {
            DialogWrapper associatedDialog = (DialogWrapper)this.ra.getActivity(cta.getDialogActivityHandle());
            if (associatedDialog != null) {
                return associatedDialog.getServerTransaction(cta.getAssociatedServerTransaction());
            }
            return null;
        }
        return null;
    }

    public Request createRequest(String methodName) throws SipException {
        try {
            Request request = this.wrappedDialog.createRequest(methodName);
            if (this.getState() == null) {
                this.ra.getProviderWrapper().addLoadBalancerToRoute(request);
            }
            return request;
        }
        catch (Exception e) {
            throw new SipException(e.getMessage(), (Throwable)e);
        }
    }

    public Request createRequest(Request origRequest) throws SipException {
        SleeSipProviderImpl provider = this.ra.getProviderWrapper();
        SIPRequest request = (SIPRequest)origRequest.clone();
        String transport = request.getTopmostViaHeader().getTransport();
        ListeningPointImpl listeningPointImpl = (ListeningPointImpl)provider.getListeningPoint(transport);
        ViaList viaList = new ViaList();
        viaList.add((SIPHeader)((Via)listeningPointImpl.createViaHeader()));
        request.setVia((List)viaList);
        try {
            request.setHeader((Header)provider.getHeaderFactory().createMaxForwardsHeader(70));
        }
        catch (InvalidArgumentException e) {
            throw new SipException("Failed to create max forwards header", (Throwable)e);
        }
        request.setHeader((Header)this.getCallId().clone());
        if (origRequest.getHeader("Contact") != null) {
            request.setHeader((Header)listeningPointImpl.createContactHeader());
        }
        if (this.getState() == null) {
            SipURI topRouteSipURI;
            RouteHeader topRoute;
            URI topRouteURI;
            RouteList routeList = request.getRouteHeaders();
            if (routeList != null && (topRouteURI = (topRoute = (RouteHeader)routeList.get(0)).getAddress().getURI()).isSipURI() && (topRouteSipURI = (SipURI)topRouteURI).getHost().equals(listeningPointImpl.getIPAddress()) && topRouteSipURI.getPort() == listeningPointImpl.getPort()) {
                if (routeList.size() > 1) {
                    routeList.remove(0);
                } else {
                    request.removeHeader("Route");
                }
            }
            this.ra.getProviderWrapper().addLoadBalancerToRoute((Request)request);
        } else {
            request.removeHeader("Route");
            RouteList routeList = new RouteList();
            Iterator it = this.wrappedDialog.getRouteSet();
            while (it.hasNext()) {
                Route route = (Route)it.next();
                routeList.add((SIPHeader)route);
            }
            if (!routeList.isEmpty()) {
                request.addHeader((Header)routeList);
            }
        }
        request.removeHeader("Record-Route");
        return request;
    }

    public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {
        this.ensureCorrectDialogLocalTag(request);
        ClientTransactionWrapper ctw = this.ra.getProviderWrapper().getNewDialogActivityClientTransaction(this, request);
        if (request.getMethod().equals("INVITE")) {
            this.lastCancelableTransactionId = ctw.getActivityHandle();
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
        }
        this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
        return ctw;
    }

    protected void ensureCorrectDialogLocalTag(Request request) throws SipException {
        if (this.localTag != null) {
            try {
                ((FromHeader)request.getHeader("From")).setTag(this.localTag);
            }
            catch (ParseException e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sendRequest(ClientTransaction ct) throws TransactionDoesNotExistException, SipException {
        Request request = ct.getRequest();
        this.ensureCorrectDialogLocalTag(request);
        if (tracer.isInfoEnabled()) {
            tracer.info(String.valueOf(ct) + " sending request:\n" + request);
        }
        this.wrappedDialog.sendRequest(((ClientTransactionWrapper)ct).getWrappedClientTransaction());
    }

    public Response createResponse(ServerTransaction origServerTransaction, Response receivedResponse) throws SipException {
        SleeSipProviderImpl provider = this.ra.getProviderWrapper();
        Response forgedResponse = null;
        try {
            forgedResponse = provider.getMessageFactory().createResponse(receivedResponse.getStatusCode(), origServerTransaction.getRequest());
        }
        catch (ParseException e) {
            throw new SipException("Failed to forge message", (Throwable)e);
        }
        DialogState dialogState = this.getState();
        String localTag = this.getLocalTag();
        if ((dialogState == null || dialogState == DialogState.EARLY) && localTag != null && this.isServer()) {
            try {
                ((ToHeader)forgedResponse.getHeader("To")).setTag(localTag);
            }
            catch (ParseException e) {
                throw new SipException("Failed to set local tag", (Throwable)e);
            }
        }
        ListIterator lit = receivedResponse.getHeaderNames();
        String headerName = null;
        ListIterator headersIterator = null;
        while (lit.hasNext()) {
            headerName = (String)lit.next();
            if (Utils.getHeadersToOmmitOnResponseCopy().contains(headerName)) continue;
            forgedResponse.removeHeader(headerName);
            headersIterator = receivedResponse.getHeaders(headerName);
            while (headersIterator.hasNext()) {
                forgedResponse.addLast((Header)((Header)headersIterator.next()).clone());
            }
        }
        byte[] rawOriginal = receivedResponse.getRawContent();
        if (rawOriginal != null && rawOriginal.length != 0) {
            byte[] copy = new byte[rawOriginal.length];
            System.arraycopy(rawOriginal, 0, copy, 0, copy.length);
            try {
                forgedResponse.setContent((Object)copy, (ContentTypeHeader)forgedResponse.getHeader("Content-Type"));
            }
            catch (ParseException e) {
                tracer.severe("Failed to set content on forged response. To copy value [" + new String(copy) + "] Type [" + receivedResponse.getHeader("Content-Type") + "]\n", (Throwable)e);
            }
        }
        if (receivedResponse.getHeader("Contact") != null) {
            String transport = ((ViaHeader)forgedResponse.getHeader("Via")).getTransport();
            forgedResponse.setHeader((Header)((ListeningPointImpl)provider.getListeningPoint(transport)).createContactHeader());
        }
        return forgedResponse;
    }

    public ClientTransaction sendCancel() throws SipException {
        try {
            ClientTransaction inviteCTX = this.getClientTransaction(this.lastCancelableTransactionId);
            ClientTransactionWrapper cancelTransaction = this.ra.getProviderWrapper().getNewDialogActivityClientTransaction(this, inviteCTX.createCancel());
            if (tracer.isInfoEnabled()) {
                tracer.info(String.valueOf(cancelTransaction) + " sending request:\n" + cancelTransaction.getRequest());
            }
            cancelTransaction.getWrappedClientTransaction().sendRequest();
            return cancelTransaction;
        }
        catch (NullPointerException npe) {
            throw new SipException("Failed to find client transaction or no INVITE transaction present", (Throwable)npe);
        }
        catch (Exception e) {
            throw new SipException("Failed to send CANCEL due to:", (Throwable)e);
        }
    }

    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        return this.wrappedDialog.createAck(arg0);
    }

    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        return this.wrappedDialog.createPrack(arg0);
    }

    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        return this.wrappedDialog.createReliableProvisionalResponse(arg0);
    }

    public void delete() {
        DialogState currentState = this.wrappedDialog.getState();
        boolean needToFireDTE = !this.isEnding() && !this.wrappedDialog.isServer() && (currentState == null || currentState == DialogState.TERMINATED);
        this.wrappedDialog.delete();
        if (needToFireDTE) {
            this.ra.processDialogTerminated(this);
        }
    }

    public CallIdHeader getCallId() {
        return this.wrappedDialog.getCallId();
    }

    public String getDialogId() {
        return this.wrappedDialog.getDialogId();
    }

    @Deprecated
    public Transaction getFirstTransaction() {
        return this.wrappedDialog.getFirstTransaction();
    }

    public Address getLocalParty() {
        return this.wrappedDialog.getLocalParty();
    }

    public Address getRemoteParty() {
        return this.wrappedDialog.getRemoteParty();
    }

    public Address getRemoteTarget() {
        return this.wrappedDialog.getRemoteTarget();
    }

    public long getLocalSeqNumber() {
        return this.wrappedDialog.getLocalSeqNumber();
    }

    @Deprecated
    public int getLocalSequenceNumber() {
        return this.wrappedDialog.getLocalSequenceNumber();
    }

    public String getLocalTag() {
        if (this.localTag == null && this.wrappedDialog != null) {
            this.localTag = this.wrappedDialog.getLocalTag();
        }
        return this.localTag;
    }

    public long getRemoteSeqNumber() {
        return this.wrappedDialog.getRemoteSeqNumber();
    }

    @Deprecated
    public int getRemoteSequenceNumber() {
        return this.wrappedDialog.getRemoteSequenceNumber();
    }

    public String getRemoteTag() {
        return this.wrappedDialog.getRemoteTag();
    }

    public Iterator<RouteHeader> getRouteSet() {
        return this.wrappedDialog.getRouteSet();
    }

    public DialogState getState() {
        return this.wrappedDialog.getState();
    }

    public void incrementLocalSequenceNumber() {
        this.wrappedDialog.incrementLocalSequenceNumber();
    }

    public boolean isSecure() {
        return this.wrappedDialog.isSecure();
    }

    public boolean isServer() {
        return this.wrappedDialog.isServer();
    }

    public void sendAck(Request arg0) throws SipException {
        if (tracer.isInfoEnabled()) {
            tracer.info(this + " sending ACK:\n" + arg0);
        }
        this.wrappedDialog.sendAck(arg0);
    }

    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        this.wrappedDialog.sendReliableProvisionalResponse(arg0);
    }

    public void terminateOnBye(boolean arg0) throws SipException {
        this.wrappedDialog.terminateOnBye(arg0);
    }

    public String toString() {
        return "DialogWrapper Id[" + this.getDialogId() + "] Handle[" + this.getActivityHandle() + "] State[" + this.getState() + "] OngoingCTX[" + this.ongoingClientTransactions.keySet() + "] OngoingSTX[" + this.ongoingServerTransactions.keySet() + "]";
    }

    public boolean processIncomingResponse(ResponseEvent respEvent) {
        return false;
    }

    public ClientTransaction getClientTransaction(SipActivityHandle transaction) {
        return this.ongoingClientTransactions.get(transaction);
    }

    public ServerTransaction getServerTransaction(SipActivityHandle transaction) {
        return this.ongoingServerTransactions.get(transaction);
    }

    public boolean addOngoingTransaction(ServerTransactionWrapper stw) {
        boolean alreadyMapped = this.ongoingServerTransactions.put(stw.getActivityHandle(), stw) == null;
        return alreadyMapped;
    }

    protected void updateReplicatedState() {
        if (!this.ra.inLocalMode()) {
            this.wrappedDialog.setApplicationData((Object)this);
        }
    }

    public boolean addOngoingTransaction(ClientTransactionWrapper ctw) {
        boolean alreadyMapped = this.ongoingClientTransactions.put(ctw.getActivityHandle(), ctw) == null;
        return alreadyMapped;
    }

    public void removeOngoingTransaction(ClientTransactionWrapper ctw) {
        if (this.ongoingClientTransactions == null || this.ongoingClientTransactions.remove(ctw.getActivityHandle()) != null) {
            // empty if block
        }
    }

    public void removeOngoingTransaction(ServerTransactionWrapper stw) {
        if (this.ongoingServerTransactions == null || this.ongoingServerTransactions.remove(stw.getActivityHandle()) != null) {
            // empty if block
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.wrappedDialog != null) {
            this.wrappedDialog.setApplicationData(null);
            this.wrappedDialog = null;
        }
        this.ongoingClientTransactions = null;
        this.ongoingServerTransactions = null;
        this.localTag = null;
        this.lastCancelableTransactionId = null;
        this.eventFiringAddress = null;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.ongoingClientTransactions = new ConcurrentHashMap(1);
        this.ongoingServerTransactions = new ConcurrentHashMap(1);
        this.activityHandle.setActivity(this);
    }

    public Dialog getWrappedDialog() {
        return this.wrappedDialog;
    }

    public void setWrappedDialog(Dialog wrappedDialog) {
        this.wrappedDialog = wrappedDialog;
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
    }
}

