/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.stack.SIPDialog;
import java.io.Serializable;
import javax.sip.Dialog;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.sip11.ClientTransactionActivityHandle;
import org.mobicents.slee.resource.sip11.DialogWithIdActivityHandle;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.LocalSipActivityManagement;
import org.mobicents.slee.resource.sip11.ServerTransactionActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityManagement;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredSipActivityManagement
implements SipActivityManagement {
    private final ClusteredSipStack sipStack;
    private final LocalSipActivityManagement nonReplicatedActivityManagement;
    private final ReplicatedData<SipActivityHandle, String> replicatedData;
    private final SleeTransactionManager sleeTransactionManager;

    public ClusteredSipActivityManagement(ClusteredSipStack sipStack, ReplicatedData<SipActivityHandle, String> replicatedData, SleeTransactionManager sleeTransactionManager) {
        this.sipStack = sipStack;
        this.nonReplicatedActivityManagement = new LocalSipActivityManagement();
        this.replicatedData = replicatedData;
        this.sleeTransactionManager = sleeTransactionManager;
    }

    @Override
    public Wrapper get(SipActivityHandle handle) {
        Class<?> handleType = handle.getClass();
        if (handleType == ServerTransactionActivityHandle.TYPE || handleType == ClientTransactionActivityHandle.TYPE) {
            return this.nonReplicatedActivityManagement.get(handle);
        }
        if (handleType == DialogWithoutIdActivityHandle.TYPE) {
            String dialogId;
            SIPDialog d;
            String remoteTag;
            DialogWithoutIdActivityHandle dialogWithoutIdActivityHandle;
            Wrapper activity = this.nonReplicatedActivityManagement.get(handle);
            if (activity == null && (dialogWithoutIdActivityHandle = (DialogWithoutIdActivityHandle)handle).getRemoteTag() == null && (remoteTag = (String)((Object)this.replicatedData.get((Serializable)handle))) != null && (d = this.sipStack.getDialog(dialogId = (dialogWithoutIdActivityHandle.getCallId() + ':' + dialogWithoutIdActivityHandle.getLocalTag() + ':' + remoteTag).toLowerCase())) != null) {
                DialogWrapper dw = (DialogWrapper)d.getApplicationData();
                dw.setWrappedDialog((Dialog)d);
                activity = dw;
                this.nonReplicatedActivityManagement.put(handle, activity);
            }
            return activity;
        }
        if (handleType == DialogWithIdActivityHandle.TYPE) {
            SIPDialog d = this.sipStack.getDialog(((DialogWithIdActivityHandle)handle).getDialogId());
            if (d != null) {
                DialogWrapper dw = (DialogWrapper)d.getApplicationData();
                if (dw.getWrappedDialog() == null) {
                    dw.setWrappedDialog((Dialog)d);
                }
                return dw;
            }
            return handle.getActivity();
        }
        throw new IllegalArgumentException("unknown type of sip activity handle -> " + handle.getClass());
    }

    @Override
    public void put(SipActivityHandle handle, Wrapper activity) {
        if (handle.getClass() != DialogWithIdActivityHandle.TYPE) {
            this.nonReplicatedActivityManagement.put(handle, activity);
        }
    }

    @Override
    public Wrapper remove(SipActivityHandle handle) {
        Class<?> handleType = handle.getClass();
        if (handleType == ServerTransactionActivityHandle.TYPE || handleType == ClientTransactionActivityHandle.TYPE) {
            return this.nonReplicatedActivityManagement.remove(handle);
        }
        if (handleType == DialogWithoutIdActivityHandle.TYPE) {
            Wrapper activity = this.nonReplicatedActivityManagement.remove(handle);
            DialogWithoutIdActivityHandle dialogWithoutIdActivityHandle = (DialogWithoutIdActivityHandle)handle;
            if (dialogWithoutIdActivityHandle.getRemoteTag() == null) {
                Transaction tx = null;
                try {
                    tx = this.sleeTransactionManager.suspend();
                }
                catch (SystemException e) {
                    // empty catch block
                }
                this.replicatedData.remove((Serializable)handle);
                if (tx != null) {
                    try {
                        this.sleeTransactionManager.resume(tx);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            return activity;
        }
        if (handleType == DialogWithIdActivityHandle.TYPE) {
            return handle.getActivity();
        }
        throw new IllegalArgumentException("unknown type of sip activity handle -> " + handle.getClass());
    }

    public void replicateRemoteTag(DialogWithoutIdActivityHandle handle, String tag) {
        this.replicatedData.put((Serializable)handle, (Serializable)((Object)tag));
    }

    public String toString() {
        return "ClusteredSipActivityManagement[ non replicated activities = " + this.nonReplicatedActivityManagement.handleSet() + " ]";
    }
}

