/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import java.util.concurrent.ConcurrentHashMap;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.FireableEventType;

public class EventIDCache {
    private static final String OUT_OF_DIALOG_REQUEST_EVENT_PREFIX = "javax.sip.message.Request.";
    private static final String RESPONSE_EVENT_PREFIX = "javax.sip.message.Response.";
    private static final String INDIALOG_REQUEST_EVENT_PREFIX = "javax.sip.Dialog.";
    private static final String SIP_EXTENSION_REQUEST_EVENT_NAME_SUFIX = "SIP_EXTENSION";
    private static final String VENDOR = "net.java.slee";
    private static final String VERSION = "1.2";
    private static final String TRANSACTION_TIMEOUT_EVENTNAME = "javax.sip.Timeout.TRANSACTION";
    private static final String DIALOG_TIMEOUT_EVENTNAME = "javax.sip.Timeout.Dialog";
    private static final String DIALOG_FORKED_EVENTNAME = "javax.sip.Dialog.FORKED";
    private ConcurrentHashMap<String, FireableEventType> eventIds = new ConcurrentHashMap();

    public FireableEventType getEventId(EventLookupFacility eventLookupFacility, Request request, boolean inDialogActivity) {
        String requestMethod = request.getMethod();
        if (requestMethod.equals("CANCEL")) {
            inDialogActivity = false;
        }
        FireableEventType eventID = null;
        if (inDialogActivity) {
            eventID = this.getEventId(eventLookupFacility, INDIALOG_REQUEST_EVENT_PREFIX + requestMethod);
            if (eventID == null) {
                eventID = this.getEventId(eventLookupFacility, INDIALOG_REQUEST_EVENT_PREFIX + SIP_EXTENSION_REQUEST_EVENT_NAME_SUFIX);
            }
        } else {
            eventID = this.getEventId(eventLookupFacility, OUT_OF_DIALOG_REQUEST_EVENT_PREFIX + requestMethod);
            if (eventID == null) {
                eventID = this.getEventId(eventLookupFacility, OUT_OF_DIALOG_REQUEST_EVENT_PREFIX + SIP_EXTENSION_REQUEST_EVENT_NAME_SUFIX);
            }
        }
        return eventID;
    }

    public FireableEventType getEventId(EventLookupFacility eventLookupFacility, Response response) {
        String statusCodeName = null;
        int responseStatus = response.getStatusCode();
        statusCodeName = responseStatus == 100 ? "TRYING" : (100 < responseStatus && responseStatus < 200 ? "PROVISIONAL" : (responseStatus < 300 ? "SUCCESS" : (responseStatus < 400 ? "REDIRECT" : (responseStatus < 500 ? "CLIENT_ERROR" : (responseStatus < 600 ? "SERVER_ERROR" : "GLOBAL_FAILURE")))));
        return this.getEventId(eventLookupFacility, RESPONSE_EVENT_PREFIX + statusCodeName);
    }

    public FireableEventType getTransactionTimeoutEventId(EventLookupFacility eventLookupFacility, boolean inDialog) {
        return this.getEventId(eventLookupFacility, TRANSACTION_TIMEOUT_EVENTNAME);
    }

    public FireableEventType getDialogTimeoutEventId(EventLookupFacility eventLookupFacility) {
        return this.getEventId(eventLookupFacility, DIALOG_TIMEOUT_EVENTNAME);
    }

    public FireableEventType getDialogForkEventId(EventLookupFacility eventLookupFacility) {
        return this.getEventId(eventLookupFacility, DIALOG_FORKED_EVENTNAME);
    }

    private FireableEventType getEventId(EventLookupFacility eventLookupFacility, String eventName) {
        FireableEventType eventType = this.eventIds.get(eventName);
        if (eventType == null) {
            try {
                eventType = eventLookupFacility.getFireableEventType(new EventTypeID(eventName, VENDOR, VERSION));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (eventType != null) {
                this.eventIds.put(eventName, eventType);
            }
        }
        return eventType;
    }
}

