/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogWrapper;

public class ClientDialogForkHandler
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DialogWithoutIdActivityHandle master;
    private DialogWithoutIdActivityHandle forkWinner;
    private volatile transient ConcurrentHashMap<String, DialogWithoutIdActivityHandle> forks;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private DialogWithoutIdActivityHandle[] EMPTY_HANDLE_ARRAY = new DialogWithoutIdActivityHandle[0];

    public ClientDialogForkHandler() {
        this.master = null;
    }

    public ClientDialogForkHandler(DialogWithoutIdActivityHandle master) {
        this.master = master;
    }

    public DialogWithoutIdActivityHandle getMaster() {
        return this.master;
    }

    public DialogWithoutIdActivityHandle getForkWinner() {
        return this.forkWinner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFork(SipResourceAdaptor ra, DialogWithoutIdActivityHandle fork) {
        if (this.master != null) {
            throw new IllegalStateException("non initial dialogs can't add forks");
        }
        if (!this.closed.get()) {
            if (this.forks == null) {
                ClientDialogForkHandler clientDialogForkHandler = this;
                synchronized (clientDialogForkHandler) {
                    if (this.forks == null) {
                        this.forks = new ConcurrentHashMap(3);
                    }
                }
            }
            this.forks.put(fork.getRemoteTag(), fork);
        } else {
            this.terminateFork(ra, fork);
        }
    }

    public DialogWithoutIdActivityHandle getFork(String remoteTag) {
        return this.forks != null ? this.forks.get(remoteTag) : null;
    }

    public void forkConfirmed(SipResourceAdaptor ra, ClientDialogWrapper original, ClientDialogWrapper fork) {
        if (this.master != null) {
            throw new IllegalStateException("non initial dialogs can't be used to confirme a fork");
        }
        if (this.closed.compareAndSet(false, true)) {
            if (this.forks != null) {
                this.forkWinner = this.forks.remove(fork.data.getLocalRemoteTag());
                for (DialogWithoutIdActivityHandle loser : this.forks.values()) {
                    this.terminateFork(ra, loser);
                }
                this.forks = null;
            }
            original.wrappedDialog = null;
            original.delete();
            fork.data.getForkHandler().closed.set(true);
            fork.wrappedDialog.setApplicationData((Object)fork);
        }
    }

    public void terminate(SipResourceAdaptor ra) {
        if (this.master != null) {
            throw new IllegalStateException("non initial dialogs can't terminate forking");
        }
        if (this.closed.compareAndSet(false, true) && this.forks != null) {
            for (DialogWithoutIdActivityHandle fork : this.forks.values()) {
                this.terminateFork(ra, fork);
            }
            this.forks = null;
        }
    }

    public boolean isForking() {
        return this.forks != null || !this.closed.get();
    }

    private void terminateFork(SipResourceAdaptor ra, DialogWithoutIdActivityHandle fork) {
        ClientDialogWrapper dw = (ClientDialogWrapper)ra.getActivity(fork);
        if (dw != null) {
            dw.setWrappedDialog(null);
            dw.delete();
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        DialogWithoutIdActivityHandle[] forksArray = this.forks == null ? null : this.forks.values().toArray(this.EMPTY_HANDLE_ARRAY);
        stream.writeObject(forksArray);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        DialogWithoutIdActivityHandle[] forksArray = (DialogWithoutIdActivityHandle[])stream.readObject();
        if (forksArray != null && forksArray.length > 0) {
            this.forks = new ConcurrentHashMap(forksArray.length);
            for (DialogWithoutIdActivityHandle fork : forksArray) {
                this.forks.put(fork.getRemoteTag(), fork);
            }
        }
    }
}

