/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.message.SIPRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.TooManyListenersException;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportAlreadySupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.sip.CancelRequestEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.ha.javax.sip.LoadBalancerElector;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogForkHandler;
import org.mobicents.slee.resource.sip11.wrappers.ClientDialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;

public class SleeSipProviderImpl
implements SleeSipProvider {
    protected AddressFactory addressFactory = null;
    protected HeaderFactory headerFactory = null;
    protected MessageFactory messageFactory = null;
    protected ClusteredSipStack stack = null;
    protected SipResourceAdaptor ra = null;
    protected SipProvider provider = null;
    protected final Tracer tracer;
    private ConcurrentHashMap<String, SipUri> localSipURIs = new ConcurrentHashMap();

    public SleeSipProviderImpl(AddressFactory addressFactory, HeaderFactory headerFactory, MessageFactory messageFactory, ClusteredSipStack stack, SipResourceAdaptor ra, SipProvider provider) {
        this.addressFactory = addressFactory;
        this.headerFactory = headerFactory;
        this.messageFactory = messageFactory;
        this.stack = stack;
        this.ra = ra;
        this.tracer = ra.getTracer(SleeSipProviderImpl.class.getSimpleName());
        this.provider = provider;
    }

    public SipProvider getRealProvider() {
        return this.provider;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public SipURI getLocalSipURI(String transport) {
        ListeningPoint lp;
        SipUri sipURI = this.localSipURIs.get(this.localSipURIs);
        if (sipURI == null && (lp = this.getListeningPoint(transport)) != null) {
            sipURI = new SipUri();
            try {
                sipURI.setHost(lp.getIPAddress());
                sipURI.setTransportParam(transport);
            }
            catch (ParseException e) {
                this.tracer.severe("Failed to create local sip uri for transport " + transport, (Throwable)e);
            }
            sipURI.setPort(lp.getPort());
            this.localSipURIs.put(transport, sipURI);
        }
        return sipURI;
    }

    public ViaHeader getLocalVia(String transport, String branch) {
        ListeningPoint lp = this.provider.getListeningPoint(transport);
        if (lp != null) {
            try {
                return this.headerFactory.createViaHeader(lp.getIPAddress(), lp.getPort(), lp.getTransport(), branch);
            }
            catch (ParseException e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
            catch (InvalidArgumentException e) {
                this.tracer.severe(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public ViaHeader getLocalVia() throws ParseException, InvalidArgumentException {
        ListeningPointImpl lp = (ListeningPointImpl)this.provider.getListeningPoints()[0];
        return lp != null ? lp.createViaHeader() : null;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public boolean isLocalHostname(String host) {
        block4: {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(host);
                HashSet<InetAddress> stackAddresses = new HashSet<InetAddress>();
                for (ListeningPoint listeningPoint : this.provider.getListeningPoints()) {
                    InetAddress tmp = InetAddress.getByName(listeningPoint.getIPAddress());
                    if (tmp == null) continue;
                    stackAddresses.add(tmp);
                }
                for (InetAddress inetAddress : addresses) {
                    if (!stackAddresses.contains(inetAddress)) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                if (!this.tracer.isFineEnabled()) break block4;
                this.tracer.fine("Unknown host", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isLocalSipURI(SipURI uri) {
        ListeningPoint lp = this.provider.getListeningPoint(uri.getTransportParam());
        if (lp != null && lp.getIPAddress().equals(uri.getHost()) && lp.getPort() == uri.getPort()) {
            return true;
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Passed uri not local? Passed URI[" + uri + "] doesnt match lp[" + lp + "]");
        }
        return false;
    }

    public void addListeningPoint(ListeningPoint arg0) throws ObjectInUseException, TransportAlreadySupportedException {
        throw new UnsupportedOperationException("No dynamic change to LP");
    }

    public void addSipListener(SipListener arg0) throws TooManyListenersException {
        throw new TooManyListenersException("RA can be the only Listener for this stack!!");
    }

    public ListeningPoint getListeningPoint() {
        return this.provider.getListeningPoint();
    }

    public ListeningPoint getListeningPoint(String arg0) {
        return this.provider.getListeningPoint(arg0);
    }

    public ListeningPoint[] getListeningPoints() {
        return this.provider.getListeningPoints();
    }

    public CallIdHeader getNewCallId() {
        return this.provider.getNewCallId();
    }

    public SipStack getSipStack() {
        throw new UnsupportedOperationException();
    }

    public void removeListeningPoint(ListeningPoint arg0) throws ObjectInUseException {
        throw new UnsupportedOperationException();
    }

    public void removeSipListener(SipListener arg0) {
        throw new UnsupportedOperationException();
    }

    public void sendRequest(Request arg0) throws SipException {
        this.provider.sendRequest(arg0);
    }

    public void sendResponse(Response arg0) throws SipException {
        this.provider.sendResponse(arg0);
    }

    public void setAutomaticDialogSupportEnabled(boolean arg0) {
        this.provider.setAutomaticDialogSupportEnabled(arg0);
    }

    public void setListeningPoint(ListeningPoint arg0) throws ObjectInUseException {
        throw new UnsupportedOperationException();
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        try {
            this.addLoadBalancerToRoute(request);
        }
        catch (SipException e) {
            throw new TransactionUnavailableException("Failed to add load balancer to route", (Throwable)e);
        }
        ClientTransaction ct = this.provider.getNewClientTransaction(request);
        ClientTransactionWrapper ctw = new ClientTransactionWrapper(ct, this.ra);
        ctw.setActivity(true);
        DialogWrapper dw = ctw.getDialogWrapper();
        if (dw != null) {
            dw.addOngoingTransaction(ctw);
        }
        if (!this.ra.addSuspendedActivity(ctw, this.tracer.isFineEnabled())) {
            throw new TransactionUnavailableException("Failed to create activity");
        }
        return ctw;
    }

    public ClientTransactionWrapper getNewDialogActivityClientTransaction(DialogWrapper dialogWrapper, Request request) throws TransactionUnavailableException {
        ClientTransaction ct = this.provider.getNewClientTransaction(request);
        ClientTransactionWrapper ctw = new ClientTransactionWrapper(ct, this.ra);
        dialogWrapper.addOngoingTransaction(ctw);
        return ctw;
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        ServerTransaction st = this.provider.getNewServerTransaction(request);
        ServerTransactionWrapper stw = new ServerTransactionWrapper(st, this.ra);
        DialogWrapper dw = stw.getDialogWrapper();
        if (dw != null) {
            dw.addOngoingTransaction(stw);
        } else {
            stw.setActivity(true);
            if (!this.ra.addSuspendedActivity(stw, this.tracer.isFineEnabled())) {
                throw new TransactionUnavailableException("Failed to create activity.");
            }
        }
        return stw;
    }

    public Dialog getNewDialog(Transaction transaction) throws SipException {
        if (transaction.getClass() == ServerTransactionWrapper.class) {
            return this.getNewDialog((ServerTransactionWrapper)transaction);
        }
        if (transaction.getClass() == ClientTransactionWrapper.class) {
            return this.getNewDialog((ClientTransactionWrapper)transaction);
        }
        throw new IllegalArgumentException("unknown transaction class");
    }

    private Dialog getNewDialog(ServerTransactionWrapper stw) throws SipException {
        ServerTransaction st = stw.getWrappedServerTransaction();
        Dialog d = this.provider.getNewDialog((Transaction)st);
        if (this.ra.isValidateDialogCSeq()) {
            ((DialogExt)d).disableSequenceNumberValidation();
        }
        String localTag = d.getLocalTag();
        String dialogId = d.getDialogId();
        if (localTag == null) {
            localTag = Utils.getInstance().generateTag();
            dialogId = ((SIPRequest)st.getRequest()).getDialogId(true, localTag);
        }
        DialogWrapper dw = new DialogWrapper(d, dialogId, localTag, this.ra);
        dw.addOngoingTransaction(stw);
        this.ra.addSuspendedActivity(dw, this.tracer.isFineEnabled());
        return dw;
    }

    private Dialog getNewDialog(ClientTransactionWrapper ctw) throws SipException {
        Request r = ctw.getWrappedTransaction().getRequest();
        FromHeader fh = (FromHeader)r.getHeader("From");
        String localTag = fh.getTag();
        if (localTag == null) {
            localTag = Utils.getInstance().generateTag();
            try {
                fh.setTag(localTag);
            }
            catch (ParseException e) {
                throw new SipException("Failed to set local tag.", (Throwable)e);
            }
        }
        Dialog d = this.provider.getNewDialog(ctw.getWrappedTransaction());
        if (this.ra.isValidateDialogCSeq()) {
            ((DialogExt)d).disableSequenceNumberValidation();
        }
        DialogWrapper dw = this._getNewDialog(fh.getAddress(), localTag, ((ToHeader)r.getHeader("To")).getAddress(), d.getCallId());
        dw.setWrappedDialog(d);
        d.setApplicationData((Object)dw);
        dw.addOngoingTransaction(ctw);
        return dw;
    }

    public DialogActivity getNewDialog(Address from, Address to) throws SipException {
        if (from == null) {
            throw new IllegalArgumentException("From address cant be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("To address cant be null");
        }
        return this._getNewDialog(from, Utils.getInstance().generateTag(), to, null);
    }

    public DialogActivity getNewDialog(DialogActivity incomingDialog, boolean useSameCallId) throws SipException {
        if (incomingDialog == null || !incomingDialog.isServer()) {
            throw new IllegalArgumentException("Incoming dialog is either null or is UAC dialog!!");
        }
        CallIdHeader callIdHeader = null;
        if (useSameCallId) {
            callIdHeader = incomingDialog.getCallId();
        }
        return this._getNewDialog(incomingDialog.getRemoteParty(), Utils.getInstance().generateTag(), incomingDialog.getLocalParty(), callIdHeader);
    }

    private DialogWrapper _getNewDialog(Address from, String localTag, Address to, CallIdHeader callIdHeader) throws SipException {
        ClientDialogWrapper dw = new ClientDialogWrapper(from, localTag, to, callIdHeader == null ? this.provider.getNewCallId() : callIdHeader, this.ra, new ClientDialogForkHandler());
        if (!this.ra.addSuspendedActivity(dw, this.tracer.isFineEnabled())) {
            throw new SipException("Failed to create activity.");
        }
        return dw;
    }

    public boolean acceptCancel(CancelRequestEvent cancelEvent, boolean isProxy) {
        if (cancelEvent.getMatchingTransaction() != null) {
            Response response;
            try {
                response = this.getMessageFactory().createResponse(200, cancelEvent.getRequest());
                cancelEvent.getServerTransaction().sendResponse(response);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (!isProxy) {
                try {
                    response = this.getMessageFactory().createResponse(487, cancelEvent.getMatchingTransaction().getRequest());
                    cancelEvent.getMatchingTransaction().sendResponse(response);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return true;
        }
        if (!isProxy) {
            try {
                Response txDoesNotExistsResponse = this.getMessageFactory().createResponse(481, cancelEvent.getRequest());
                cancelEvent.getServerTransaction().sendResponse(txDoesNotExistsResponse);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return false;
    }

    public DialogActivity forwardForkedResponse(ServerTransaction origServerTransaction, Response response) throws SipException {
        throw new UnsupportedOperationException();
    }

    public ClusteredSipStack getClusteredSipStack() {
        return this.stack;
    }

    public void addLoadBalancerToRoute(Request r) throws SipException {
        LoadBalancerElector loadBalancerElector = this.stack.getLoadBalancerElector();
        if (loadBalancerElector != null) {
            Address lbAddress = loadBalancerElector.getLoadBalancer();
            if (lbAddress == null) {
                return;
            }
            lbAddress = (Address)loadBalancerElector.getLoadBalancer().clone();
            ((SipURI)lbAddress.getURI()).setLrParam();
            r.addFirst((Header)this.headerFactory.createRouteHeader(lbAddress));
        }
    }
}

