/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.message.SIPRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.sip.ClientTransaction;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.SleeSipProviderImpl;
import org.mobicents.slee.resource.sip11.Utils;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;

public class ClientDialogWrapper
extends DialogWrapper {
    private static final long serialVersionUID = 1L;
    private static Tracer tracer;
    private Address fromAddress;
    private Address toAddress;
    private CallIdHeader customCallId;
    private AtomicLong localSequenceNumber = new AtomicLong(0L);
    private AtomicBoolean forkingPossible = new AtomicBoolean(true);
    private boolean confirmed = false;

    public ClientDialogWrapper(Address from, String localTag, Address to, CallIdHeader callIdHeader, SipResourceAdaptor ra) {
        this(new DialogWithoutIdActivityHandle(callIdHeader.getCallId(), localTag), localTag, ra);
        this.toAddress = to;
        this.fromAddress = from;
        this.customCallId = callIdHeader;
    }

    public ClientDialogWrapper(SipActivityHandle handle, String localTag, SipResourceAdaptor ra) {
        super(handle, localTag, ra);
        if (tracer == null) {
            tracer = ra.getTracer(ClientDialogWrapper.class.getSimpleName());
        }
    }

    public boolean isForkingPossible() {
        return this.forkingPossible.get();
    }

    public boolean stopForking() {
        return this.forkingPossible.compareAndSet(true, false);
    }

    public void confirmed() {
        this.confirmed = true;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = this.wrappedDialog != null ? super.getEventFiringAddress() : ClientTransactionWrapper.getEventFiringAddress(this.fromAddress);
        }
        return this.eventFiringAddress;
    }

    public Request createAck(long arg0) throws InvalidArgumentException, SipException {
        this.verifyDialogExistency();
        return super.createAck(arg0);
    }

    public Request createPrack(Response arg0) throws DialogDoesNotExistException, SipException {
        this.verifyDialogExistency();
        return super.createPrack(arg0);
    }

    public Response createReliableProvisionalResponse(int arg0) throws InvalidArgumentException, SipException {
        this.verifyDialogExistency();
        return super.createReliableProvisionalResponse(arg0);
    }

    public void delete() {
        if (this.wrappedDialog == null) {
            if (tracer.isFineEnabled()) {
                tracer.fine("Deleting " + this.getActivityHandle() + " dialog activity, there is no wrapped dialog.");
            }
            this.ra.processDialogTerminated(this);
        } else {
            super.delete();
        }
    }

    public CallIdHeader getCallId() {
        if (this.wrappedDialog == null) {
            return this.customCallId;
        }
        return super.getCallId();
    }

    public String getDialogId() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return super.getDialogId();
    }

    public Transaction getFirstTransaction() {
        this.verifyDialogExistency();
        return super.getFirstTransaction();
    }

    public Address getLocalParty() {
        if (this.wrappedDialog == null) {
            return this.fromAddress;
        }
        return super.getLocalParty();
    }

    public Address getRemoteParty() {
        if (this.wrappedDialog == null) {
            return this.toAddress;
        }
        return super.getRemoteParty();
    }

    public Address getRemoteTarget() {
        if (this.wrappedDialog == null) {
            return this.toAddress;
        }
        return super.getRemoteTarget();
    }

    public long getLocalSeqNumber() {
        if (this.wrappedDialog == null) {
            return this.localSequenceNumber.get();
        }
        return super.getLocalSeqNumber();
    }

    public int getLocalSequenceNumber() {
        return (int)this.getLocalSeqNumber();
    }

    public long getRemoteSeqNumber() {
        if (this.wrappedDialog != null) {
            return super.getRemoteSeqNumber();
        }
        return 1L;
    }

    public int getRemoteSequenceNumber() {
        return (int)this.getRemoteSeqNumber();
    }

    public String getRemoteTag() {
        if (this.wrappedDialog != null) {
            return super.getRemoteTag();
        }
        return null;
    }

    public DialogState getState() {
        if (this.wrappedDialog == null) {
            return null;
        }
        return super.getState();
    }

    public void incrementLocalSequenceNumber() {
        if (this.wrappedDialog != null) {
            super.incrementLocalSequenceNumber();
        } else {
            this.localSequenceNumber.incrementAndGet();
        }
    }

    public boolean isSecure() {
        if (this.wrappedDialog == null) {
            return false;
        }
        return super.isSecure();
    }

    public boolean isServer() {
        if (this.wrappedDialog == null) {
            return false;
        }
        return super.isServer();
    }

    public void sendAck(Request arg0) throws SipException {
        this.verifyDialogExistency();
        super.sendAck(arg0);
    }

    public void sendReliableProvisionalResponse(Response arg0) throws SipException {
        this.verifyDialogExistency();
        super.sendReliableProvisionalResponse(arg0);
    }

    public void terminateOnBye(boolean arg0) throws SipException {
        this.verifyDialogExistency();
        super.terminateOnBye(arg0);
    }

    public String toString() {
        return "ClientDialogWrapper[ handle = " + this.getActivityHandle() + ", state = " + this.getState() + ", clientTXs = " + (this.ongoingClientTransactions == null ? "" : this.ongoingClientTransactions.keySet()) + ", serverTXs = " + (this.ongoingServerTransactions == null ? "" : this.ongoingServerTransactions.keySet()) + " ]";
    }

    public ClientTransaction sendCancel() throws SipException {
        this.verifyDialogExistency();
        return super.sendCancel();
    }

    public void associateServerTransaction(ClientTransaction ct, ServerTransaction st) {
        this.verifyDialogExistency();
        super.associateServerTransaction(ct, st);
    }

    public Request createRequest(Request origRequest) throws SipException {
        Request request = super.createRequest(origRequest);
        if (this.wrappedDialog == null) {
            SIPRequest sipRequest = (SIPRequest)request;
            SleeSipProviderImpl provider = this.ra.getProviderWrapper();
            HeaderFactory headerFactory = provider.getHeaderFactory();
            try {
                URI requestURI = (URI)this.toAddress.getURI().clone();
                if (requestURI.isSipURI()) {
                    ((SipUri)requestURI).clearUriParms();
                }
                sipRequest.setRequestURI(requestURI);
                FromHeader fromHeader = headerFactory.createFromHeader(this.fromAddress, this.getLocalTag());
                sipRequest.setFrom(fromHeader);
                ToHeader toHeader = headerFactory.createToHeader(this.toAddress, null);
                sipRequest.setTo(toHeader);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        }
        return request;
    }

    public Request createRequest(String methodName) throws SipException {
        if (methodName.equals("ACK") || methodName.equals("PRACK")) {
            throw new SipException("Invalid method specified for createRequest:" + methodName);
        }
        SleeSipProviderImpl provider = this.ra.getProviderWrapper();
        HeaderFactory headerFactory = provider.getHeaderFactory();
        Request request = null;
        if (this.wrappedDialog == null) {
            try {
                URI requestURI = (URI)this.toAddress.getURI().clone();
                if (requestURI.isSipURI()) {
                    ((SipUri)requestURI).clearUriParms();
                }
                FromHeader fromHeader = headerFactory.createFromHeader(this.fromAddress, this.getLocalTag());
                ToHeader toHeader = headerFactory.createToHeader(this.toAddress, null);
                ArrayList<ViaHeader> viaHeadersList = new ArrayList<ViaHeader>(1);
                viaHeadersList.add(provider.getLocalVia());
                MaxForwardsHeader maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
                CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(this.localSequenceNumber.get() + 1L, methodName);
                request = provider.getMessageFactory().createRequest(requestURI, methodName, this.customCallId, cSeqHeader, fromHeader, toHeader, viaHeadersList, maxForwardsHeader);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage(), (Throwable)e);
            }
        } else {
            request = super.createRequest(methodName);
        }
        if (this.getState() == null) {
            this.ra.getProviderWrapper().addLoadBalancerToRoute(request);
        }
        return request;
    }

    public ClientTransaction sendRequest(Request request) throws SipException, TransactionUnavailableException {
        boolean createDialog;
        if (this.wrappedDialog == null && !Utils.getDialogCreatingMethods().contains(request.getMethod())) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
        }
        this.ensureCorrectDialogLocalTag(request);
        SleeSipProviderImpl provider = this.ra.getProviderWrapper();
        ClientTransactionWrapper ctw = provider.getNewDialogActivityClientTransaction(this, request);
        String method = request.getMethod();
        if (method.equals("INVITE")) {
            this.lastCancelableTransactionId = ctw.activityHandle;
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
        }
        boolean bl = createDialog = this.wrappedDialog == null;
        if (createDialog) {
            this.wrappedDialog = provider.getRealProvider().getNewDialog(ctw.getWrappedTransaction());
            if (this.ra.disableSequenceNumberValidation()) {
                ((DialogExt)this.wrappedDialog).disableSequenceNumberValidation();
            }
            this.wrappedDialog.setApplicationData((Object)this);
            ctw.getWrappedClientTransaction().sendRequest();
        } else {
            this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
        }
        return ctw;
    }

    public void sendRequest(ClientTransaction ct) throws TransactionDoesNotExistException, SipException {
        boolean createDialog;
        SleeSipProviderImpl provider = this.ra.getProviderWrapper();
        Request request = ct.getRequest();
        ClientTransactionWrapper ctw = (ClientTransactionWrapper)ct;
        this.ensureCorrectDialogLocalTag(request);
        if (tracer.isInfoEnabled()) {
            tracer.info(String.valueOf(ctw) + " sending request:\n" + request);
        }
        boolean bl = createDialog = this.wrappedDialog == null;
        if (createDialog) {
            if (!Utils.getDialogCreatingMethods().contains(request.getMethod())) {
                throw new IllegalStateException("Dialog activity present, but no dialog creating reqeust has been sent yet! This method: " + request.getMethod() + " is not dialog creating one");
            }
            if (request.getMethod().equals("INVITE")) {
                this.lastCancelableTransactionId = ctw.getActivityHandle();
            }
            this.wrappedDialog = provider.getRealProvider().getNewDialog(ctw.getWrappedTransaction());
            this.wrappedDialog.setApplicationData((Object)this);
            this.addOngoingTransaction(ctw);
            ctw.getWrappedClientTransaction().sendRequest();
        } else if (this.wrappedDialog.getState() == null) {
            ctw.getWrappedClientTransaction().sendRequest();
        } else {
            this.wrappedDialog.sendRequest(ctw.getWrappedClientTransaction());
        }
    }

    private void verifyDialogExistency() {
        if (this.wrappedDialog == null) {
            throw new IllegalStateException("Dialog activity present, but no dialog creating request has been sent yet!");
        }
    }

    public boolean isClientDialog() {
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new IOException("serialization forbidden");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new IOException("serialization forbidden");
    }
}

