/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.sip.ClientTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.slee.AddressPlan;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.resource.sip11.ClientTransactionActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionAssociation;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.ServerTransactionWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionWrapper;

public class ClientTransactionWrapper
extends TransactionWrapper
implements ClientTransaction {
    private static final long serialVersionUID = 1L;
    private static Tracer tracer;
    private transient ClientTransactionAssociation association;
    private transient javax.slee.Address eventFiringAddress;
    private transient ClientTransaction wrappedTransaction;

    public ClientTransactionWrapper(ClientTransaction wrappedTransaction, SipResourceAdaptor ra) {
        super(new ClientTransactionActivityHandle(wrappedTransaction.getBranchId(), wrappedTransaction.getRequest().getMethod()), ra);
        if (tracer == null) {
            tracer = ra.getTracer(ClientTransactionWrapper.class.getSimpleName());
        }
        this.wrappedTransaction = wrappedTransaction;
        this.wrappedTransaction.setApplicationData((Object)this);
    }

    protected ClientTransactionWrapper(ClientTransactionActivityHandle handle, SipResourceAdaptor ra) {
        super(handle, ra);
        if (tracer == null) {
            tracer = ra.getTracer(ClientTransactionWrapper.class.getSimpleName());
        }
    }

    public Transaction getWrappedTransaction() {
        return this.wrappedTransaction;
    }

    public ClientTransaction getWrappedClientTransaction() {
        return this.wrappedTransaction;
    }

    public void setWrappedClientTransaction(ClientTransaction wrappedTransaction) {
        this.wrappedTransaction = wrappedTransaction;
    }

    public boolean isAckTransaction() {
        return false;
    }

    public boolean isClientTransaction() {
        return true;
    }

    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = ClientTransactionWrapper.getEventFiringAddress(((FromHeader)this.wrappedTransaction.getRequest().getHeader("From")).getAddress());
        }
        return this.eventFiringAddress;
    }

    public static javax.slee.Address getEventFiringAddress(Address fromAddress) {
        return new javax.slee.Address(AddressPlan.SIP, fromAddress.toString());
    }

    private void validateWrappedTransaction() throws IllegalStateException {
        if (this.wrappedTransaction == null) {
            throw new IllegalStateException();
        }
    }

    public Request createAck() throws SipException {
        this.validateWrappedTransaction();
        return this.wrappedTransaction.createAck();
    }

    public Request createCancel() throws SipException {
        this.validateWrappedTransaction();
        return this.wrappedTransaction.createCancel();
    }

    public void sendRequest() throws SipException {
        this.validateWrappedTransaction();
        String method = this.wrappedTransaction.getRequest().getMethod();
        DialogWrapper dw = this.getDialogWrapper();
        if ((method.equals("INVITE") || method.equals("SUBSCRIBE")) && dw != null) {
            dw.lastCancelableTransactionId = this.activityHandle;
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(this.toString() + " sending request:\n" + this.getRequest());
        }
        this.wrappedTransaction.sendRequest();
    }

    public void associateServerTransaction(ServerTransactionWrapper serverTransaction, SipActivityHandle dialogHandle) {
        if (this.association != null) {
            throw new IllegalStateException("Transaction already associated to [" + this.association.getAssociatedServerTransaction() + "] [" + this.association.getDialogActivityHandle() + "]");
        }
        this.association = new ClientTransactionAssociation(dialogHandle, serverTransaction.getActivityHandle());
    }

    public ClientTransactionAssociation getClientTransactionAssociation() {
        return this.association;
    }

    public String toString() {
        String id = this.wrappedTransaction == null ? "null" : this.wrappedTransaction.getBranchId();
        return "ClientTransaction[" + id + ']';
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new IOException("serialization forbidden");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new IOException("serialization forbidden");
    }

    public void terminated() {
        DialogWrapper dw;
        if (this.isActivity() && (dw = this.getDialogWrapper()) != null) {
            dw.removeOngoingTransaction(this);
        }
    }

    public void clear() {
        super.clear();
        if (this.wrappedTransaction != null) {
            this.wrappedTransaction.setApplicationData(null);
            this.wrappedTransaction = null;
        }
        this.eventFiringAddress = null;
        this.association = null;
    }
}

