/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11;

import gov.nist.javax.sip.stack.SIPDialog;
import java.io.Serializable;
import javax.sip.Dialog;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.mobicents.ha.javax.sip.ClusteredSipStack;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.sip11.ClientTransactionActivityHandle;
import org.mobicents.slee.resource.sip11.DialogWithIdActivityHandle;
import org.mobicents.slee.resource.sip11.DialogWithoutIdActivityHandle;
import org.mobicents.slee.resource.sip11.LocalSipActivityManagement;
import org.mobicents.slee.resource.sip11.ServerTransactionActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityHandle;
import org.mobicents.slee.resource.sip11.SipActivityManagement;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredSipActivityManagement
implements SipActivityManagement {
    private final ClusteredSipStack sipStack;
    private final LocalSipActivityManagement nonReplicatedActivityManagement;
    private final ReplicatedData<SipActivityHandle, String> replicatedData;
    private final SleeTransactionManager sleeTransactionManager;
    private final SipResourceAdaptor ra;

    public ClusteredSipActivityManagement(ClusteredSipStack sipStack, ReplicatedData<SipActivityHandle, String> replicatedData, SleeTransactionManager sleeTransactionManager, SipResourceAdaptor ra) {
        this.sipStack = sipStack;
        this.nonReplicatedActivityManagement = new LocalSipActivityManagement();
        this.replicatedData = replicatedData;
        this.sleeTransactionManager = sleeTransactionManager;
        this.ra = ra;
    }

    @Override
    public Wrapper get(SipActivityHandle handle) {
        Class<?> handleType = handle.getClass();
        if (handleType == ServerTransactionActivityHandle.TYPE || handleType == ClientTransactionActivityHandle.TYPE) {
            return this.nonReplicatedActivityManagement.get(handle);
        }
        if (handleType == DialogWithoutIdActivityHandle.TYPE) {
            SIPDialog d;
            DialogWrapper activity = (DialogWrapper)this.nonReplicatedActivityManagement.get(handle);
            String dialogId = null;
            if (activity == null) {
                DialogWithoutIdActivityHandle dialogWithoutIdActivityHandle = (DialogWithoutIdActivityHandle)handle;
                String remoteTag = (String)((Object)this.replicatedData.get((Serializable)handle));
                if (remoteTag != null) {
                    dialogId = (dialogWithoutIdActivityHandle.getCallId() + ':' + dialogWithoutIdActivityHandle.getLocalTag() + ':' + remoteTag).toLowerCase();
                }
            } else {
                dialogId = activity.getDialogId();
            }
            if (dialogId != null && (d = this.sipStack.getDialog(dialogId)) != null) {
                activity = this.ra.getDialogWrapper((Dialog)d);
                this.nonReplicatedActivityManagement.put(handle, activity);
            }
            return activity;
        }
        if (handleType == DialogWithIdActivityHandle.TYPE) {
            SIPDialog d = this.sipStack.getDialog(((DialogWithIdActivityHandle)handle).getDialogId());
            if (d != null) {
                return this.ra.getDialogWrapper((Dialog)d);
            }
            return this.nonReplicatedActivityManagement.get(handle);
        }
        throw new IllegalArgumentException("unknown type of sip activity handle -> " + handle.getClass());
    }

    @Override
    public void put(SipActivityHandle handle, Wrapper activity) {
        this.nonReplicatedActivityManagement.put(handle, activity);
    }

    @Override
    public Wrapper remove(SipActivityHandle handle) {
        Wrapper activity = this.nonReplicatedActivityManagement.remove(handle);
        if (handle.getClass() == DialogWithoutIdActivityHandle.TYPE) {
            Transaction tx = null;
            try {
                tx = this.sleeTransactionManager.getTransaction();
                if (tx != null) {
                    this.sleeTransactionManager.suspend();
                }
            }
            catch (SystemException e) {
                // empty catch block
            }
            this.replicatedData.remove((Serializable)handle);
            if (tx != null) {
                try {
                    this.sleeTransactionManager.resume(tx);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return activity;
    }

    public boolean replicateRemoteTag(SipActivityHandle handle, String tag) {
        if (!this.replicatedData.contains((Serializable)handle)) {
            this.replicatedData.put((Serializable)handle, (Serializable)((Object)tag));
            return true;
        }
        return false;
    }
}

