/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip11.wrappers;

import gov.nist.javax.sip.stack.SIPClientTransaction;
import javax.sip.ClientTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.header.FromHeader;
import javax.sip.message.Request;
import javax.slee.AddressPlan;
import javax.slee.facilities.Tracer;
import org.mobicents.slee.resource.sip11.ClientTransactionActivityHandle;
import org.mobicents.slee.resource.sip11.SipResourceAdaptor;
import org.mobicents.slee.resource.sip11.wrappers.ClientTransactionWrapperAppData;
import org.mobicents.slee.resource.sip11.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip11.wrappers.TransactionWrapper;

public class ClientTransactionWrapper
extends TransactionWrapper
implements ClientTransaction {
    private static final long serialVersionUID = 1L;
    private static Tracer tracer;
    private ClientTransaction wrappedTransaction;
    private transient javax.slee.Address eventFiringAddress;
    private String associatedServerTransactionId;

    public ClientTransactionWrapper(SIPClientTransaction wrappedTransaction, SipResourceAdaptor ra) {
        super(new ClientTransactionActivityHandle(wrappedTransaction.getTransactionId()), ra);
        this.wrappedTransaction = wrappedTransaction;
        this.wrappedTransaction.setApplicationData((Object)new ClientTransactionWrapperAppData(this));
        if (tracer == null) {
            tracer = ra.getTracer(ClientTransactionWrapper.class.getSimpleName());
        }
    }

    protected ClientTransactionWrapper(ClientTransactionActivityHandle handle, SipResourceAdaptor ra) {
        super(handle, ra);
        if (tracer == null) {
            tracer = ra.getTracer(ClientTransactionWrapper.class.getSimpleName());
        }
    }

    public Transaction getWrappedTransaction() {
        return this.wrappedTransaction;
    }

    public ClientTransaction getWrappedClientTransaction() {
        return this.wrappedTransaction;
    }

    public boolean isAckTransaction() {
        return false;
    }

    public javax.slee.Address getEventFiringAddress() {
        if (this.eventFiringAddress == null) {
            this.eventFiringAddress = ClientTransactionWrapper.getEventFiringAddress(((FromHeader)this.wrappedTransaction.getRequest().getHeader("From")).getAddress());
        }
        return this.eventFiringAddress;
    }

    public static javax.slee.Address getEventFiringAddress(Address fromAddress) {
        return new javax.slee.Address(AddressPlan.SIP, fromAddress.toString());
    }

    private void validateWrappedTransaction() throws IllegalStateException {
        if (this.wrappedTransaction == null) {
            throw new IllegalStateException();
        }
    }

    public Request createAck() throws SipException {
        this.validateWrappedTransaction();
        return this.wrappedTransaction.createAck();
    }

    public Request createCancel() throws SipException {
        this.validateWrappedTransaction();
        return this.wrappedTransaction.createCancel();
    }

    public void sendRequest() throws SipException {
        this.validateWrappedTransaction();
        String method = this.wrappedTransaction.getRequest().getMethod();
        DialogWrapper dw = this.getDialogWrapper();
        if ((method.equals("INVITE") || method.equals("SUBSCRIBE")) && dw != null) {
            dw.lastCancelableTransactionId = this.activityHandle;
        }
        if (tracer.isInfoEnabled()) {
            tracer.info(this.toString() + " sending request:\n" + this.getRequest());
        }
        this.wrappedTransaction.sendRequest();
    }

    public String getAssociatedServerTransaction() {
        return this.associatedServerTransactionId;
    }

    public void setAssociatedServerTransaction(String associatedServerTransactionId, boolean failIfAlreadyAssociated) {
        if (failIfAlreadyAssociated && this.associatedServerTransactionId != null) {
            throw new IllegalStateException("Transaction already associated to [" + associatedServerTransactionId + "]");
        }
        this.associatedServerTransactionId = associatedServerTransactionId;
    }

    public String toString() {
        String id = this.wrappedTransaction == null ? "null" : this.wrappedTransaction.getBranchId();
        return "ClientTransaction[" + id + ']';
    }

    public void terminated() {
        DialogWrapper dw = this.getDialogWrapper();
        if (dw != null) {
            dw.removeOngoingTransaction(this);
        }
    }

    public void clear() {
        super.clear();
        if (this.wrappedTransaction != null) {
            this.wrappedTransaction.setApplicationData(null);
        }
        this.wrappedTransaction = null;
    }

    public boolean isClientTransaction() {
        return true;
    }
}

