/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.smpp.ra;

import ie.omk.smpp.Address;
import ie.omk.smpp.BadCommandIDException;
import ie.omk.smpp.Connection;
import ie.omk.smpp.message.DataSM;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.message.tlv.TLVTable;
import ie.omk.smpp.message.tlv.Tag;
import ie.omk.smpp.version.VersionException;
import java.io.IOException;
import java.util.Date;
import net.java.slee.resource.smpp.ClientTransaction;
import net.java.slee.resource.smpp.ShortMessage;
import org.mobicents.slee.resource.smpp.ra.AbstractTransaction;
import org.mobicents.slee.resource.smpp.ra.SmppDialogImpl;

public class ClientDataSmTransactionImpl
extends AbstractTransaction
implements ClientTransaction {
    private Date lastActivity = new Date();

    public ClientDataSmTransactionImpl(int id, SmppDialogImpl dialog) {
        super(id, dialog);
    }

    public void send(ShortMessage message) throws IOException {
        DataSM sm = null;
        Connection connection = this.dialog.resourceAdaptor.smscConnection;
        try {
            sm = (DataSM)connection.newInstance(259);
        }
        catch (VersionException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (BadCommandIDException ex) {
            // empty catch block
        }
        sm.setMessageId(Integer.toString(this.id));
        String destination = message.getRecipient();
        String source = message.getOriginator();
        int encoding = message.getEncoding();
        Address destinationAddress = new Address(1, 1, destination);
        Address sourceAddress = new Address(1, 1, source);
        sm.setDestination(destinationAddress);
        sm.setSource(sourceAddress);
        sm.setDataCoding(encoding);
        TLVTable table = new TLVTable();
        table.set(Tag.MESSAGE_PAYLOAD, (Object)message.getData());
        sm.setTLVTable(table);
        connection.sendRequest((SMPPRequest)sm);
        this.lastActivity = new Date();
    }

    public Date getLastActivity() {
        return this.lastActivity;
    }
}

