/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.smpp.ra;

import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.java.slee.resource.smpp.ClientTransaction;
import net.java.slee.resource.smpp.Dialog;
import net.java.slee.resource.smpp.ServerTransaction;
import net.java.slee.resource.smpp.ShortMessage;
import net.java.slee.resource.smpp.Transaction;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.smpp.ra.AbstractTransaction;
import org.mobicents.slee.resource.smpp.ra.ClientDataSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ClientDeliverSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ClientSubmitSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDataSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDeliverSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerSubmitSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.SmppMessageImpl;
import org.mobicents.slee.resource.smpp.ra.SmppResourceAdaptor;

public class SmppDialogImpl
implements Dialog {
    private static int GENERATOR = 1;
    public static final int TTL = 300;
    private String localAddress;
    private String remoteAddress;
    private Date lastActivity;
    private HashMap transactions = new HashMap();
    protected SmppResourceAdaptor resourceAdaptor;
    private Timer timer;
    private Logger logger = Logger.getLogger(SmppDialogImpl.class);

    public SmppDialogImpl(SmppResourceAdaptor resourceAdaptor, String localAddress, String remoteAddress) {
        this.resourceAdaptor = resourceAdaptor;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.lastActivity = new Date();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                SmppDialogImpl.this.close();
            }
        }, 300000L, 300000L);
    }

    public String getId() {
        this.lastActivity = new Date();
        return this.localAddress + "$" + this.remoteAddress;
    }

    public Date getLastActivity() {
        return this.lastActivity;
    }

    public String getLocalAddress() {
        this.lastActivity = new Date();
        return this.localAddress;
    }

    public String getRemoteAddress() {
        this.lastActivity = new Date();
        return this.remoteAddress;
    }

    public ShortMessage createMessage() {
        this.lastActivity = new Date();
        SmppMessageImpl message = new SmppMessageImpl(this.localAddress, this.remoteAddress);
        return message;
    }

    protected ClientTransaction getTransaction(int id) {
        return (ClientTransaction)this.transactions.get(new Integer(id));
    }

    public ClientTransaction createDataSmTransaction() {
        this.lastActivity = new Date();
        ClientDataSmTransactionImpl tx = new ClientDataSmTransactionImpl(GENERATOR++, this);
        this.transactions.put(new Integer(tx.getId()), tx);
        this.resourceAdaptor.createTransactionHandle(tx);
        return tx;
    }

    protected ServerTransaction createDataSmServerTransaction(int id, ShortMessage msg) {
        ServerDataSmTransactionImpl tx = new ServerDataSmTransactionImpl(id, this, msg);
        this.transactions.put(new Integer(tx.getId()), tx);
        this.resourceAdaptor.createTransactionHandle(tx);
        return tx;
    }

    public ClientTransaction createSubmitSmTransaction() {
        this.lastActivity = new Date();
        ClientSubmitSmTransactionImpl tx = new ClientSubmitSmTransactionImpl(GENERATOR++, this);
        this.transactions.put(new Integer(tx.getId()), tx);
        this.resourceAdaptor.createTransactionHandle(tx);
        return tx;
    }

    protected ServerTransaction createSubmitSmServerTransaction(int id, ShortMessage msg) {
        ServerSubmitSmTransactionImpl tx = new ServerSubmitSmTransactionImpl(id, this, msg);
        this.transactions.put(new Integer(tx.getId()), tx);
        this.resourceAdaptor.createTransactionHandle(tx);
        return tx;
    }

    public ClientTransaction createDeliverSmTransaction() {
        this.lastActivity = new Date();
        ClientDeliverSmTransactionImpl tx = new ClientDeliverSmTransactionImpl(GENERATOR++, this);
        this.transactions.put(new Integer(tx.getId()), tx);
        this.resourceAdaptor.createTransactionHandle(tx);
        return tx;
    }

    protected ServerTransaction createDeliverSmServerTransaction(int id, ShortMessage msg) {
        ServerDeliverSmTransactionImpl tx = new ServerDeliverSmTransactionImpl(id, this, msg);
        this.transactions.put(new Integer(tx.getId()), tx);
        this.resourceAdaptor.createTransactionHandle(tx);
        return tx;
    }

    protected void terminate(Transaction tx) {
        try {
            ((AbstractTransaction)tx).timer.cancel();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Disable timer for tx=" + tx));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transactions.remove(new Integer(tx.getId()));
        this.resourceAdaptor.terminate(tx);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Terminate transaction handle " + tx));
        }
    }

    public void close() {
        try {
            this.timer.cancel();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Transaction tx : this.transactions.values()) {
            this.terminate(tx);
        }
        this.resourceAdaptor.terminate(this);
        this.resourceAdaptor.smppProvider.dialogs.remove(this.localAddress + "#" + this.remoteAddress);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Terminate dialog handler " + this));
        }
    }

    public String toString() {
        return "SmppDialogImpl id = " + this.localAddress + "#" + this.remoteAddress;
    }
}

