/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.smpp.ra;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import ie.omk.smpp.BadCommandIDException;
import ie.omk.smpp.Connection;
import ie.omk.smpp.NotBoundException;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.BindResp;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.message.UnbindResp;
import ie.omk.smpp.version.SMPPVersion;
import ie.omk.smpp.version.VersionException;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.smpp.ActivityContextInterfaceFactory;
import net.java.slee.resource.smpp.ClientTransaction;
import net.java.slee.resource.smpp.Dialog;
import net.java.slee.resource.smpp.ServerTransaction;
import net.java.slee.resource.smpp.SmppEvent;
import net.java.slee.resource.smpp.Transaction;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorActivityContextInterfaceFactory;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.smpp.ra.AbstractTransaction;
import org.mobicents.slee.resource.smpp.ra.DialogHandle;
import org.mobicents.slee.resource.smpp.ra.RequestEventImpl;
import org.mobicents.slee.resource.smpp.ra.ResponseEventImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDataSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDeliverSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerSubmitSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.SmppActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.smpp.ra.SmppDialogImpl;
import org.mobicents.slee.resource.smpp.ra.SmppMessageImpl;
import org.mobicents.slee.resource.smpp.ra.SmppProviderImpl;
import org.mobicents.slee.resource.smpp.ra.TransactionHandle;

public class SmppResourceAdaptor
implements ResourceAdaptor,
Serializable,
ConnectionObserver {
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    protected SmppProviderImpl smppProvider;
    private HashMap activities = new HashMap();
    private HashMap handlers = new HashMap();
    protected Connection smscConnection = null;
    boolean isBound = false;
    private int bindStatus;
    private long enquireLinkInterval = 30000L;
    private long lastActivityTime;
    private long lastEnquireLinkResp;
    private Semaphore semaphore = new Semaphore(0L);
    private String host = "localhost";
    private int port = 2727;
    private String systemID = "1";
    private String systemType = "ESME";
    private String password = "1";
    private int addressTON = 0;
    private int addressNPI = 1;
    private String addressRange = "0020";
    private int enquareLinkTimeout = 300000;
    private transient ActivityContextInterfaceFactory acif = null;
    private Thread linkMonitorThread;
    private Logger logger = Logger.getLogger(SmppResourceAdaptor.class);

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return new Integer(this.port);
    }

    public String getSystemId() {
        return this.systemID;
    }

    public void setSystemId(String systemID) {
        this.systemID = systemID;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getAddressTon() {
        return this.addressTON;
    }

    public void setAddressTon(Integer addressTON) {
        this.addressTON = addressTON;
    }

    public Integer getAddressNpi() {
        return new Integer(this.addressNPI);
    }

    public void setAddressNpi(Integer addressNPI) {
        this.addressNPI = addressNPI;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public Integer getEnquireLinkTimeout() {
        return new Integer(this.enquareLinkTimeout / 1000);
    }

    public void setEnquireLinkTimeout(Integer enquireLinkTimeout) {
        this.enquareLinkTimeout = enquireLinkTimeout * 1000;
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.smppProvider = new SmppProviderImpl(this);
    }

    public void entityRemoved() {
    }

    public void entityActivated() throws ResourceException {
        try {
            this.logger.debug((Object)"Binding to SMSC");
            this.bindSMSC();
            this.logger.debug((Object)"Bound sucssefully");
            this.initializeNamingContext();
            this.linkMonitorThread = new Thread(new LinkMonitor());
            this.linkMonitorThread.start();
        }
        catch (IOException e) {
            this.logger.error((Object)"Could not load ra properties. Caused by", (Throwable)e);
            throw new ResourceException(e.getMessage());
        }
    }

    public void entityDeactivating() {
        this.isBound = false;
        this.linkMonitorThread.interrupt();
    }

    public void entityDeactivated() {
        this.unbindSMSC();
        this.clearNamingContext();
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object object, int i, Address address, int i0) {
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, Object object, int i, Address address, int i0, FailureReason failureReason) {
    }

    public void activityEnded(ActivityHandle activityHandle) {
        Object activity = this.activities.remove(activityHandle);
        this.handlers.remove(activity.toString());
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return (ActivityHandle)this.handlers.get(activity.toString());
    }

    public Object getSBBResourceAdaptorInterface(String string) {
        return this.smppProvider;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceInstalled(String string, int[] i, String[] string0) {
    }

    public void serviceUninstalled(String string) {
    }

    public void serviceActivated(String string) {
    }

    public void serviceDeactivated(String string) {
    }

    protected void fireEvent(String eventName, Object activity, SmppEvent event) {
        ActivityHandle handle = this.getActivityHandle(activity);
        if (handle == null) {
            this.logger.warn((Object)("Unknown activity " + activity));
            return;
        }
        int eventID = -1;
        try {
            eventID = this.eventLookup.getEventID(eventName, "net.java", "3.4");
        }
        catch (FacilityException fe) {
            this.logger.error((Object)"Caught a FacilityException: ");
            fe.printStackTrace();
            throw new RuntimeException("SmppResourceAdaptor.fireEvent(): FacilityException caught. ", fe);
        }
        catch (UnrecognizedEventException ue) {
            this.logger.error((Object)"Caught an UnrecognizedEventException: ");
            ue.printStackTrace();
            throw new RuntimeException("SmppResourceAdaptor.fireEvent(): UnrecognizedEventException caught.", ue);
        }
        if (eventID == -1) {
            this.logger.warn((Object)("Unknown event type: " + eventName));
            return;
        }
        try {
            Address address = new Address(AddressPlan.E164_MOBILE, event.getMessage().getOriginator());
            this.sleeEndpoint.fireEvent(handle, (Object)event, eventID, address);
            this.logger.info((Object)("Fire event: " + eventName));
        }
        catch (IllegalStateException ise) {
            this.logger.error((Object)"Caught an IllegalStateException: ");
            ise.printStackTrace();
        }
        catch (ActivityIsEndingException aiee) {
            this.logger.error((Object)"Caught an ActivityIsEndingException: ");
            aiee.printStackTrace();
        }
        catch (UnrecognizedActivityException uaee) {
            this.logger.error((Object)"Caught an UnrecognizedActivityException: ");
            uaee.printStackTrace();
        }
    }

    private synchronized void bindSMSC() throws UnknownHostException, IOException {
        this.logger.debug((Object)("SMSC HOST    : " + this.host));
        this.logger.debug((Object)("SMSC PORT    : " + this.port));
        this.logger.debug((Object)("SYSTEM-ID    : " + this.systemID));
        this.logger.debug((Object)("SYSTEM-TYPE  : " + this.systemType));
        this.logger.debug((Object)("ADDRESS-TON  : " + this.addressTON));
        this.logger.debug((Object)("ADDRESS-NPI  : " + this.addressNPI));
        this.logger.debug((Object)("ADDRESS-RANGE: " + this.addressRange));
        this.lastActivityTime = System.currentTimeMillis();
        this.smscConnection = new Connection(this.host, this.port, true);
        this.smscConnection.addObserver((ConnectionObserver)this);
        this.smscConnection.setVersion(SMPPVersion.V34);
        this.smscConnection.autoAckLink(true);
        try {
            BindResp resp = this.smscConnection.bind(3, this.systemID, this.password, this.systemType, this.addressTON, this.addressNPI, this.addressRange);
            this.semaphore.attempt(5000L);
        }
        catch (InterruptedException e) {
            this.bindStatus = -1;
        }
        if (this.bindStatus != 0) {
            throw new IOException("Could not bind to SMSC. The reason is " + this.statusMessage(this.bindStatus));
        }
        this.logger.info((Object)"Successfully bound to SMSC. ");
    }

    private void unbindSMSC() {
        try {
            UnbindResp ubr = this.smscConnection.unbind();
            this.logger.info((Object)(this.bootstrapContext.getEntityName() + ": unbinding from SMSC"));
        }
        catch (Exception e) {
            this.logger.error((Object)"There was an error unbinding. ", (Throwable)e);
        }
    }

    public String statusMessage(int status) {
        return "";
    }

    protected void terminate(Transaction tx) {
        ActivityHandle handle = this.getActivityHandle(tx);
        try {
            this.sleeEndpoint.activityEnding(handle);
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Could not end activity: " + handle));
        }
    }

    protected void terminate(Dialog dialog) {
        ActivityHandle handle = this.getActivityHandle(dialog);
        try {
            this.sleeEndpoint.activityEnding(handle);
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Could not end activity: " + handle));
        }
    }

    public void packetReceived(Connection connection, SMPPPacket packet) {
        this.lastActivityTime = System.currentTimeMillis();
        String entityName = this.bootstrapContext.getEntityName();
        switch (packet.getCommandId()) {
            case -2147483639: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(entityName + " receive bind_transaceiver_resp"));
                }
                this.bindStatus = packet.getCommandStatus();
                this.semaphore.release();
                break;
            }
            case -2147483642: {
                this.logger.info((Object)(this.bootstrapContext.getEntityName() + " unbound succsefuly"));
                break;
            }
            case 21: {
                this.lastEnquireLinkResp = System.currentTimeMillis();
                this.logger.debug((Object)"Enquare link packet received");
                break;
            }
            case -2147483627: {
                this.lastEnquireLinkResp = System.currentTimeMillis();
                this.logger.debug((Object)"Enquare link response packet received");
                break;
            }
            case 5: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerTransaction tx = dialog.createDeliverSmServerTransaction(packet.getSequenceNum(), msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DELIVER_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483643: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DELIVER_SM_RESP", tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            case 259: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerDataSmTransactionImpl tx = new ServerDataSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DATA_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483389: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DATA_SM_RESP", tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            case 4: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerSubmitSmTransactionImpl tx = new ServerSubmitSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.SUBMIT_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483644: {
                SmppMessageImpl msg = this.encodeRespMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                msg.setOriginator(((AbstractTransaction)tx).dialog.getRemoteAddress());
                msg.setRecipient(((AbstractTransaction)tx).dialog.getLocalAddress());
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.SUBMIT_SM_RESP", tx, (SmppEvent)responseEvent);
                ((AbstractTransaction)tx).dialog.terminate((Transaction)tx);
                break;
            }
            case 3: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerDeliverSmTransactionImpl tx = new ServerDeliverSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.QUERY_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483645: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.QUERY_SM_RESP", tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            case 7: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerDeliverSmTransactionImpl tx = new ServerDeliverSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.REPLACE_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483641: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.REPLACE_SM_RESP", tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            default: {
                this.logger.warn((Object)("Unexpected packet received! Id = 0x" + Integer.toHexString(packet.getCommandId())));
            }
        }
    }

    private SmppDialogImpl getDialog(SMPPPacket packet) {
        this.logger.info((Object)("Source: " + packet.getSource()));
        this.logger.info((Object)("Destination: " + packet.getDestination()));
        this.logger.info((Object)("ESM class : " + packet.getEsmClass()));
        String remoteAddress = packet.getSource().getAddress();
        String localAddress = packet.getDestination().getAddress();
        SmppDialogImpl dialog = (SmppDialogImpl)this.smppProvider.getDialog(remoteAddress, localAddress);
        return dialog;
    }

    private ClientTransaction getTransaction(SMPPPacket packet) {
        int id = packet.getSequenceNum();
        return this.smppProvider.getClientTransaction(id);
    }

    private SmppMessageImpl encodeMessage(SMPPPacket packet) {
        String remoteAddress = packet.getSource().getAddress();
        String localAddress = packet.getDestination().getAddress();
        SmppMessageImpl msg = new SmppMessageImpl(localAddress, remoteAddress);
        msg.setEncoding(packet.getDataCoding());
        msg.setData(packet.getMessage());
        return msg;
    }

    public SmppMessageImpl encodeRespMessage(SMPPPacket packet) {
        SmppMessageImpl msg = new SmppMessageImpl(packet.getCommandStatus());
        msg.setEncoding(packet.getDataCoding());
        msg.setData(packet.getMessage());
        return msg;
    }

    public void update(Connection connection, SMPPEvent event) {
        this.logger.debug((Object)("Update called " + event));
    }

    private void initializeNamingContext() {
        this.logger.info((Object)"Initialize naming context");
        SleeContainer sleeContainer = SleeContainer.lookupFromJndi();
        this.logger.debug((Object)("SLEE container: " + sleeContainer));
        String entityName = this.bootstrapContext.getEntityName();
        this.logger.debug((Object)("Entity name: " + entityName));
        ResourceAdaptorEntity resourceAdaptorEntity = sleeContainer.getResourceAdaptorEnitity(entityName);
        this.logger.debug((Object)("Resource Adaptor Entity: " + resourceAdaptorEntity));
        ResourceAdaptorTypeIDImpl resourceAdaptorTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.logger.debug((Object)("Resource Adaptor Type ID: " + resourceAdaptorTypeId));
        this.acif = new SmppActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), this, entityName);
        sleeContainer.getActivityContextInterfaceFactories().put(resourceAdaptorTypeId, this.acif);
        String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
        int i = jndiName.indexOf(58);
        int j = jndiName.lastIndexOf(47);
        String prefix = jndiName.substring(i + 1, j);
        String name = jndiName.substring(j + 1);
        SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
    }

    private void clearNamingContext() {
        String jndiName = ((ResourceAdaptorActivityContextInterfaceFactory)this.acif).getJndiName();
        int i = jndiName.indexOf(58);
        String name = jndiName.substring(i + 1);
        SleeContainer.unregisterWithJndi((String)name);
    }

    protected void createDialogHandle(Dialog dialog) {
        DialogHandle handle = new DialogHandle(dialog);
        this.handlers.put(dialog.toString(), handle);
        this.activities.put(handle, dialog);
    }

    protected void createTransactionHandle(Transaction tx) {
        TransactionHandle handle = new TransactionHandle(tx);
        this.handlers.put(tx.toString(), handle);
        this.activities.put(handle, tx);
    }

    private void reconnect() {
        try {
            this.logger.warn((Object)"Lost connection! Reconnect to SMSC");
            this.unbindSMSC();
            this.bindSMSC();
        }
        catch (Exception e) {
            this.logger.error((Object)("Reconnect error: " + e.getMessage()));
        }
    }

    private class LinkMonitor
    implements Runnable {
        private LinkMonitor() {
        }

        public void run() {
            while (SmppResourceAdaptor.this.isBound) {
                long currentTime = System.currentTimeMillis();
                try {
                    EnquireLink sm = (EnquireLink)SmppResourceAdaptor.this.smscConnection.newInstance(21);
                    SmppResourceAdaptor.this.smscConnection.sendRequest((SMPPRequest)sm);
                    if (SmppResourceAdaptor.this.logger.isDebugEnabled()) {
                        SmppResourceAdaptor.this.logger.debug((Object)("Send enquire link for " + SmppResourceAdaptor.this.bootstrapContext.getEntityName()));
                    }
                    Thread.currentThread();
                    Thread.sleep(SmppResourceAdaptor.this.enquireLinkInterval);
                }
                catch (NotBoundException nbe) {
                    SmppResourceAdaptor.this.logger.warn((Object)"Connection lost! Reconnecting...");
                    SmppResourceAdaptor.this.reconnect();
                }
                catch (IOException ie) {
                    SmppResourceAdaptor.this.logger.error((Object)"Connection lost! Communication failed", (Throwable)ie);
                }
                catch (InterruptedException e) {
                    SmppResourceAdaptor.this.logger.info((Object)("Terminate link monitor: " + SmppResourceAdaptor.this.bootstrapContext.getEntityName()));
                }
                catch (BadCommandIDException ex) {
                }
                catch (VersionException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

