/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.smpp.ra;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import net.java.slee.resource.smpp.ClientTransaction;
import net.java.slee.resource.smpp.Dialog;
import net.java.slee.resource.smpp.ServerTransaction;
import net.java.slee.resource.smpp.ShortMessage;
import net.java.slee.resource.smpp.Transaction;
import org.mobicents.slee.resource.smpp.ra.AbstractTransaction;
import org.mobicents.slee.resource.smpp.ra.ClientDataSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ClientDeliverSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ClientSubmitSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDataSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDeliverSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerSubmitSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.SmppActivityImpl;
import org.mobicents.slee.resource.smpp.ra.SmppMessageImpl;
import org.mobicents.slee.resource.smpp.ra.SmppResourceAdaptor;

public class SmppDialogImpl
extends SmppActivityImpl
implements Dialog {
    private static int GENERATOR = 1;
    public static final int TTL = 300;
    private String localAddress;
    private String remoteAddress;
    private Date lastActivity;
    private ConcurrentHashMap<Integer, AbstractTransaction> transactions = new ConcurrentHashMap();
    protected SmppResourceAdaptor resourceAdaptor;
    private Timer timer;

    public SmppDialogImpl(SmppResourceAdaptor resourceAdaptor, String localAddress, String remoteAddress) {
        this.resourceAdaptor = resourceAdaptor;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.lastActivity = new Date();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                SmppDialogImpl.this.close();
            }
        }, 300000L, 300000L);
    }

    public String getId() {
        this.lastActivity = new Date();
        return this.localAddress + "$" + this.remoteAddress;
    }

    public Date getLastActivity() {
        return this.lastActivity;
    }

    public String getLocalAddress() {
        this.lastActivity = new Date();
        return this.localAddress;
    }

    public String getRemoteAddress() {
        this.lastActivity = new Date();
        return this.remoteAddress;
    }

    public ShortMessage createMessage() {
        this.lastActivity = new Date();
        SmppMessageImpl message = new SmppMessageImpl(this.localAddress, this.remoteAddress);
        return message;
    }

    protected ClientTransaction getTransaction(int id) {
        return (ClientTransaction)this.transactions.get(id);
    }

    public ClientTransaction createDataSmTransaction() {
        ClientDataSmTransactionImpl tx;
        AbstractTransaction anotherTx;
        this.lastActivity = new Date();
        return (anotherTx = this.createTransaction(tx = new ClientDataSmTransactionImpl(GENERATOR++, this))) == null ? tx : (ClientTransaction)anotherTx;
    }

    protected ServerTransaction createDataSmServerTransaction(int id, ShortMessage msg) {
        ServerDataSmTransactionImpl tx = new ServerDataSmTransactionImpl(id, this, msg);
        AbstractTransaction anotherTx = this.createTransaction(tx);
        return anotherTx == null ? tx : (ServerTransaction)anotherTx;
    }

    private AbstractTransaction createTransaction(AbstractTransaction newTx) {
        AbstractTransaction tx = this.transactions.putIfAbsent(newTx.getId(), newTx);
        if (tx == null) {
            this.resourceAdaptor.createTransactionHandle(newTx);
        }
        return tx;
    }

    public ClientTransaction createSubmitSmTransaction() {
        this.lastActivity = new Date();
        ClientSubmitSmTransactionImpl tx = new ClientSubmitSmTransactionImpl((int)System.currentTimeMillis(), this);
        AbstractTransaction anotherTx = this.createTransaction(tx);
        return anotherTx == null ? tx : (ClientTransaction)anotherTx;
    }

    protected ServerTransaction createSubmitSmServerTransaction(int id, ShortMessage msg) {
        ServerSubmitSmTransactionImpl tx = new ServerSubmitSmTransactionImpl(id, this, msg);
        AbstractTransaction anotherTx = this.createTransaction(tx);
        return anotherTx == null ? tx : (ServerTransaction)anotherTx;
    }

    public ClientTransaction createDeliverSmTransaction() {
        ClientDeliverSmTransactionImpl tx;
        AbstractTransaction anotherTx;
        this.lastActivity = new Date();
        return (anotherTx = this.createTransaction(tx = new ClientDeliverSmTransactionImpl(GENERATOR++, this))) == null ? tx : (ClientTransaction)anotherTx;
    }

    protected ServerTransaction createDeliverSmServerTransaction(int id, ShortMessage msg) {
        ServerDeliverSmTransactionImpl tx = new ServerDeliverSmTransactionImpl(id, this, msg);
        AbstractTransaction anotherTx = this.createTransaction(tx);
        return anotherTx == null ? tx : (ServerTransaction)anotherTx;
    }

    protected void terminate(Transaction tx) {
        try {
            ((AbstractTransaction)tx).timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transactions.remove(tx.getId());
        this.resourceAdaptor.terminate(tx);
    }

    public void close() {
        try {
            this.timer.cancel();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (Transaction transaction : this.transactions.values()) {
            this.terminate(transaction);
        }
        this.resourceAdaptor.terminate(this);
    }

    public String toString() {
        return "SmppDialogImpl id = " + this.localAddress + "#" + this.remoteAddress;
    }
}

