/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.smpp.ra;

import ie.omk.smpp.BadCommandIDException;
import ie.omk.smpp.Connection;
import ie.omk.smpp.NotBoundException;
import ie.omk.smpp.event.ConnectionObserver;
import ie.omk.smpp.event.SMPPEvent;
import ie.omk.smpp.message.BindResp;
import ie.omk.smpp.message.EnquireLink;
import ie.omk.smpp.message.SMPPPacket;
import ie.omk.smpp.message.SMPPRequest;
import ie.omk.smpp.message.UnbindResp;
import ie.omk.smpp.version.SMPPVersion;
import ie.omk.smpp.version.VersionException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.smpp.ActivityContextInterfaceFactory;
import net.java.slee.resource.smpp.ClientTransaction;
import net.java.slee.resource.smpp.Dialog;
import net.java.slee.resource.smpp.ServerTransaction;
import net.java.slee.resource.smpp.SmppEvent;
import net.java.slee.resource.smpp.Transaction;
import org.mobicents.slee.resource.smpp.ra.AbstractTransaction;
import org.mobicents.slee.resource.smpp.ra.DialogHandle;
import org.mobicents.slee.resource.smpp.ra.FireableEventTypeCache;
import org.mobicents.slee.resource.smpp.ra.FireableEventTypeFilter;
import org.mobicents.slee.resource.smpp.ra.RequestEventImpl;
import org.mobicents.slee.resource.smpp.ra.ResponseEventImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDataSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerDeliverSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.ServerSubmitSmTransactionImpl;
import org.mobicents.slee.resource.smpp.ra.SmppActivityImpl;
import org.mobicents.slee.resource.smpp.ra.SmppDialogImpl;
import org.mobicents.slee.resource.smpp.ra.SmppMessageImpl;
import org.mobicents.slee.resource.smpp.ra.SmppProviderImpl;
import org.mobicents.slee.resource.smpp.ra.TransactionHandle;

public class SmppResourceAdaptor
implements ResourceAdaptor,
ConnectionObserver {
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    protected SmppProviderImpl smppProvider;
    private ConcurrentHashMap activities = new ConcurrentHashMap();
    private ConcurrentHashMap handlers = new ConcurrentHashMap();
    protected Connection smscConnection = null;
    boolean isBound = false;
    private int bindStatus;
    private long enquireLinkInterval = 30000L;
    private long lastActivityTime;
    private long lastEnquireLinkResp;
    private Semaphore semaphore = new Semaphore(0);
    private String host = "localhost";
    private int port = 2727;
    private String systemID = "1";
    private String systemType = "ESME";
    private String password = "1";
    private int addressTON = 0;
    private int addressNPI = 1;
    private String addressRange = "0020";
    private int enquareLinkTimeout = 300000;
    private transient ActivityContextInterfaceFactory acif = null;
    private Thread linkMonitorThread;
    private Tracer tracer;
    private ResourceAdaptorContext raContext;
    private FireableEventTypeCache eventTypeCache;
    private FireableEventTypeFilter eventTypeFilter;
    private static final int EVENT_FLAGS = SmppResourceAdaptor.getEventFlags();

    private static int getEventFlags() {
        int eventFlags = 128;
        EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        return eventFlags;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return new Integer(this.port);
    }

    public String getSystemId() {
        return this.systemID;
    }

    public void setSystemId(String systemID) {
        this.systemID = systemID;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getAddressTon() {
        return this.addressTON;
    }

    public void setAddressTon(Integer addressTON) {
        this.addressTON = addressTON;
    }

    public Integer getAddressNpi() {
        return new Integer(this.addressNPI);
    }

    public void setAddressNpi(Integer addressNPI) {
        this.addressNPI = addressNPI;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    public void setAddressRange(String addressRange) {
        this.addressRange = addressRange;
    }

    public Integer getEnquireLinkTimeout() {
        return new Integer(this.enquareLinkTimeout / 1000);
    }

    public void setEnquireLinkTimeout(Integer enquireLinkTimeout) {
        this.enquareLinkTimeout = enquireLinkTimeout * 1000;
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object object, int i, Address address, int i0) {
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, Object object, int i, Address address, int i0, FailureReason failureReason) {
    }

    public void activityEnded(ActivityHandle activityHandle) {
        Object activity = this.activities.remove(activityHandle);
        if (activity != null) {
            this.handlers.remove(activity.toString());
        }
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return (ActivityHandle)this.handlers.get(activity.toString());
    }

    public Marshaler getMarshaler() {
        return null;
    }

    protected void fireEvent(String eventName, Object activity, SmppEvent event) {
        ActivityHandle handle = this.getActivityHandle(activity);
        FireableEventType eventType = this.eventTypeCache.getEventType(this.eventLookup, eventName);
        if (this.eventTypeFilter.filterEvent(eventType)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("event " + eventName + " filtered");
            }
            return;
        }
        Address address = new Address(AddressPlan.E164_MOBILE, event.getMessage().getOriginator());
        try {
            this.sleeEndpoint.fireEvent(handle, eventType, (Object)event, address, null, EVENT_FLAGS);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Fired event: " + eventName);
            }
        }
        catch (Throwable e) {
            this.tracer.severe("Failed to fire event", e);
        }
    }

    private void bindSMSC() throws UnknownHostException, IOException {
        this.tracer.info("SMSC HOST    : " + this.host);
        this.tracer.info("SMSC PORT    : " + this.port);
        this.tracer.info("SYSTEM-ID    : " + this.systemID);
        this.tracer.info("SYSTEM-TYPE  : " + this.systemType);
        this.tracer.info("ADDRESS-TON  : " + this.addressTON);
        this.tracer.info("ADDRESS-NPI  : " + this.addressNPI);
        this.tracer.info("ADDRESS-RANGE: " + this.addressRange);
        this.lastActivityTime = System.currentTimeMillis();
        this.smscConnection = new Connection(this.host, this.port, true);
        this.smscConnection.addObserver((ConnectionObserver)this);
        this.smscConnection.setVersion(SMPPVersion.V34);
        this.smscConnection.autoAckLink(true);
        try {
            BindResp resp = this.smscConnection.bind(3, this.systemID, this.password, this.systemType, this.addressTON, this.addressNPI, this.addressRange);
            this.semaphore.tryAcquire(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.bindStatus = -1;
        }
        if (this.bindStatus != 0) {
            throw new IOException("Could not bind to SMSC. The reason is " + this.statusMessage(this.bindStatus));
        }
        this.tracer.info("Successfully bound to SMSC. ");
        this.isBound = true;
    }

    private void unbindSMSC() {
        try {
            UnbindResp ubr = this.smscConnection.unbind();
            this.tracer.info(this.raContext.getEntityName() + ": unbinding from SMSC");
            this.isBound = false;
        }
        catch (Exception e) {
            this.tracer.severe("There was an error unbinding. ", (Throwable)e);
        }
    }

    public String statusMessage(int status) {
        return "";
    }

    protected void terminate(Transaction tx) {
        ActivityHandle handle = this.getActivityHandle(tx);
        try {
            this.sleeEndpoint.endActivity(handle);
        }
        catch (Exception ex) {
            this.tracer.warning("Could not end activity: " + handle);
        }
    }

    protected void terminate(Dialog dialog) {
        ActivityHandle handle = this.getActivityHandle(dialog);
        try {
            this.sleeEndpoint.endActivity(handle);
        }
        catch (Exception ex) {
            this.tracer.warning("Could not end activity: " + handle);
        }
    }

    public void packetReceived(Connection connection, SMPPPacket packet) {
        this.lastActivityTime = System.currentTimeMillis();
        String entityName = this.raContext.getEntityName();
        switch (packet.getCommandId()) {
            case -2147483639: {
                this.tracer.info(entityName + " receive bind_transaceiver_resp");
                this.bindStatus = packet.getCommandStatus();
                System.out.println("Bind status=" + this.bindStatus);
                this.semaphore.release();
                break;
            }
            case -2147483642: {
                this.tracer.info(this.raContext.getEntityName() + " unbound successfuly");
                break;
            }
            case 21: {
                this.lastEnquireLinkResp = System.currentTimeMillis();
                this.tracer.info("Enquare link packet received");
                break;
            }
            case -2147483627: {
                this.lastEnquireLinkResp = System.currentTimeMillis();
                if (!this.tracer.isFineEnabled()) break;
                this.tracer.fine("Enquire link response packet received");
                break;
            }
            case 5: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerTransaction tx = dialog.createDeliverSmServerTransaction(packet.getSequenceNum(), msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DELIVER_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483643: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DELIVER_SM_RESP", (SmppActivityImpl)tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            case 259: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerDataSmTransactionImpl tx = new ServerDataSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DATA_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483389: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.DATA_SM_RESP", (SmppActivityImpl)tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            case 4: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerSubmitSmTransactionImpl tx = new ServerSubmitSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.SUBMIT_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483644: {
                SmppMessageImpl msg = this.encodeRespMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                msg.setOriginator(((AbstractTransaction)tx).dialog.getLocalAddress());
                msg.setRecipient(((AbstractTransaction)tx).dialog.getRemoteAddress());
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.SUBMIT_SM_RESP", (SmppActivityImpl)tx, (SmppEvent)responseEvent);
                ((AbstractTransaction)tx).dialog.terminate((Transaction)tx);
                break;
            }
            case 3: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerDeliverSmTransactionImpl tx = new ServerDeliverSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.QUERY_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483645: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.QUERY_SM_RESP", (SmppActivityImpl)tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            case 7: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ServerDeliverSmTransactionImpl tx = new ServerDeliverSmTransactionImpl(packet.getSequenceNum(), dialog, msg);
                RequestEventImpl requestEvent = new RequestEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.REPLACE_SM", tx, (SmppEvent)requestEvent);
                break;
            }
            case -2147483641: {
                SmppDialogImpl dialog = this.getDialog(packet);
                SmppMessageImpl msg = this.encodeMessage(packet);
                ClientTransaction tx = this.getTransaction(packet);
                ResponseEventImpl responseEvent = new ResponseEventImpl(tx, msg);
                this.fireEvent("net.java.slee.resource.smpp.REPLACE_SM_RESP", (SmppActivityImpl)tx, (SmppEvent)responseEvent);
                dialog.terminate((Transaction)tx);
                break;
            }
            default: {
                this.tracer.warning("Unexpected packet received! Id = 0x" + Integer.toHexString(packet.getCommandId()));
            }
        }
    }

    private SmppDialogImpl getDialog(SMPPPacket packet) {
        this.tracer.info("Source: " + packet.getSource());
        this.tracer.info("Destination: " + packet.getDestination());
        this.tracer.info("ESM class : " + packet.getEsmClass());
        String localAddress = packet.getSource().getAddress();
        String remoteAddress = packet.getDestination().getAddress();
        SmppDialogImpl dialog = (SmppDialogImpl)this.smppProvider.getDialog(localAddress, remoteAddress);
        return dialog;
    }

    private ClientTransaction getTransaction(SMPPPacket packet) {
        int id = packet.getSequenceNum();
        return this.smppProvider.getClientTransaction(id);
    }

    private SmppMessageImpl encodeMessage(SMPPPacket packet) {
        String localAddress = packet.getSource().getAddress();
        String remoteAddress = packet.getDestination().getAddress();
        SmppMessageImpl msg = new SmppMessageImpl(localAddress, remoteAddress);
        msg.setEncoding(packet.getDataCoding());
        msg.setData(packet.getMessage());
        return msg;
    }

    public SmppMessageImpl encodeRespMessage(SMPPPacket packet) {
        SmppMessageImpl msg = new SmppMessageImpl(packet.getCommandStatus());
        msg.setEncoding(packet.getDataCoding());
        msg.setData(packet.getMessage());
        return msg;
    }

    public void update(Connection connection, SMPPEvent event) {
        this.tracer.info("Update called " + event);
    }

    protected void createDialogHandle(Dialog dialog) {
        DialogHandle handle = new DialogHandle(dialog);
        if (this.activities.putIfAbsent(handle, dialog) == null) {
            this.handlers.put(dialog.toString(), handle);
            try {
                this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)dialog, 2);
            }
            catch (ActivityAlreadyExistsException e) {
            }
            catch (Throwable e) {
                this.activities.remove(handle);
            }
        }
    }

    protected boolean createTransactionHandle(AbstractTransaction tx) {
        TransactionHandle handle = new TransactionHandle(tx);
        this.handlers.put(tx.toString(), handle);
        this.activities.put(handle, tx);
        try {
            this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)tx);
        }
        catch (ActivityAlreadyExistsException e) {
            this.tracer.warning("Transaction " + tx + " already exists in SLEE, may be acceptable in a cluster env", (Throwable)e);
        }
        catch (Throwable e) {
            this.tracer.severe("Failed to add tx " + tx + " to SLEE activities", e);
            return false;
        }
        return true;
    }

    private void reconnect() {
        try {
            this.tracer.warning("Lost connection! Reconnect to SMSC");
            this.unbindSMSC();
            this.bindSMSC();
        }
        catch (Exception e) {
            this.tracer.severe("Reconnect error: " + e.getMessage());
        }
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public Object getResourceAdaptorInterface(String raTypeSbbInterfaceclassName) {
        return this.smppProvider;
    }

    public void raActive() {
        try {
            this.tracer.info("Binding to SMSC");
            this.bindSMSC();
            this.tracer.info("Bound successfully");
            this.linkMonitorThread = new Thread(new LinkMonitor());
            this.linkMonitorThread.start();
        }
        catch (IOException e) {
            this.tracer.finer("Could not load ra properties. Caused by", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public void raConfigure(ConfigProperties properties) {
        this.setAddressNpi((Integer)properties.getProperty("addressNpi").getValue());
        this.setAddressRange((String)properties.getProperty("addressRange").getValue());
        this.setAddressTon((Integer)properties.getProperty("addressTon").getValue());
        this.setEnquireLinkTimeout((Integer)properties.getProperty("enquireLinkTimeout").getValue());
        this.setHost((String)properties.getProperty("host").getValue());
        this.setPassword((String)properties.getProperty("password").getValue());
        this.setPort((Integer)properties.getProperty("port").getValue());
        this.setSystemId((String)properties.getProperty("systemId").getValue());
        this.setSystemType((String)properties.getProperty("systemType").getValue());
    }

    public void raInactive() {
        this.unbindSMSC();
    }

    public void raStopping() {
        this.isBound = false;
        if (this.linkMonitorThread != null) {
            this.linkMonitorThread.interrupt();
        }
    }

    public void raUnconfigure() {
    }

    public void raVerifyConfiguration(ConfigProperties arg0) throws InvalidConfigurationException {
    }

    public void serviceActive(ReceivableService arg0) {
        this.eventTypeFilter.serviceActive(arg0);
    }

    public void serviceStopping(ReceivableService arg0) {
        this.eventTypeFilter.serviceStopping(arg0);
    }

    public void serviceInactive(ReceivableService arg0) {
        this.eventTypeFilter.serviceInactive(arg0);
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.tracer = raContext.getTracer(this.getClass().getSimpleName());
        this.raContext = raContext;
        this.sleeEndpoint = raContext.getSleeEndpoint();
        this.eventLookup = raContext.getEventLookupFacility();
        this.smppProvider = new SmppProviderImpl(this);
        this.eventTypeCache = new FireableEventTypeCache(this.tracer);
        this.eventTypeFilter = new FireableEventTypeFilter();
    }

    public void unsetResourceAdaptorContext() {
        this.tracer = null;
        this.raContext = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
        this.smppProvider = null;
        this.eventTypeCache = null;
        this.eventTypeFilter = null;
    }

    private class LinkMonitor
    implements Runnable {
        private LinkMonitor() {
        }

        public void run() {
            SmppResourceAdaptor.this.tracer.info("In LinkMonitor, isBound = " + SmppResourceAdaptor.this.isBound);
            while (SmppResourceAdaptor.this.isBound) {
                long currentTime = System.currentTimeMillis();
                try {
                    EnquireLink sm = (EnquireLink)SmppResourceAdaptor.this.smscConnection.newInstance(21);
                    SmppResourceAdaptor.this.smscConnection.sendRequest((SMPPRequest)sm);
                    if (SmppResourceAdaptor.this.tracer.isFineEnabled()) {
                        SmppResourceAdaptor.this.tracer.fine("Send enquire link for " + SmppResourceAdaptor.this.raContext.getEntityName());
                    }
                    Thread.currentThread();
                    Thread.sleep(SmppResourceAdaptor.this.enquireLinkInterval);
                }
                catch (NotBoundException nbe) {
                    SmppResourceAdaptor.this.tracer.warning("Connection lost! Reconnecting...");
                    SmppResourceAdaptor.this.reconnect();
                }
                catch (IOException ie) {
                    SmppResourceAdaptor.this.tracer.severe("Connection lost! Communication failed", (Throwable)ie);
                }
                catch (InterruptedException e) {
                    SmppResourceAdaptor.this.tracer.info("Terminate link monitor: " + SmppResourceAdaptor.this.raContext.getEntityName());
                }
                catch (BadCommandIDException ex) {
                }
                catch (VersionException ex) {
                    SmppResourceAdaptor.this.tracer.severe("Failed to enquire link", (Throwable)ex);
                }
            }
        }
    }
}

