/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.smpp;

import java.io.IOException;
import java.util.TimerTask;
import javax.slee.facilities.Tracer;
import net.java.slee.resources.smpp.SmppSession;
import net.java.slee.resources.smpp.SmppTransaction;
import net.java.slee.resources.smpp.pdu.PDU;
import net.java.slee.resources.smpp.pdu.SmppRequest;
import org.mobicents.slee.resources.smpp.SmppResourceAdaptor;
import org.mobicents.slee.resources.smpp.SmppSessionImpl;
import org.mobicents.slee.resources.smpp.pdu.GenericNackImpl;
import org.mobicents.slee.resources.smpp.pdu.SmppErrorImpl;

public class SmppTransactionImpl
implements SmppTransaction {
    private Tracer tracer;
    private SmppResourceAdaptor smppRA;
    private SmppSessionImpl smppSess;
    private long sequenceNumber;
    private SmppRequest requestPDU;
    private ResponseNotSent responseNotSent;
    private ResponseNotReceived responseNotReceived;

    protected SmppTransactionImpl(SmppRequest requestPDU, SmppResourceAdaptor smppRA, SmppSessionImpl smppSess) {
        this.requestPDU = requestPDU;
        this.smppRA = smppRA;
        this.tracer = this.smppRA.getRAContext().getTracer(SmppTransactionImpl.class.getSimpleName());
        this.smppSess = smppSess;
        this.sequenceNumber = this.requestPDU.getSequenceNum();
    }

    public long getId() {
        return this.sequenceNumber;
    }

    public SmppSession getSmppSession() {
        return this.smppSess;
    }

    protected SmppRequest getSmppRequest() {
        return this.requestPDU;
    }

    protected void setResponseNotSentTimeout() {
        this.responseNotSent = new ResponseNotSent();
        this.smppSess.timer.schedule((TimerTask)this.responseNotSent, this.smppRA.getSmppResponseSentTimeout());
    }

    protected void setResponseNotReceivedTimeout() {
        this.responseNotReceived = new ResponseNotReceived();
        this.smppSess.timer.schedule((TimerTask)this.responseNotReceived, this.smppRA.getSmppResponseReceivedTimeout());
    }

    protected void cancelResponseNotSentTimeout() {
        if (this.responseNotSent != null) {
            this.responseNotSent.cancel();
        }
    }

    protected void cancelResponseNotReceivedTimeout() {
        if (this.responseNotReceived != null) {
            this.responseNotReceived.cancel();
        }
    }

    protected void sendGenericNack() {
        GenericNackImpl genericNak = new GenericNackImpl(255);
        genericNak.setSequenceNum(this.requestPDU.getSequenceNum());
        try {
            this.smppRA.sendResponse(genericNak);
        }
        catch (IOException e) {
            this.tracer.severe("IOException while sending GenericNack SMPP Response", (Throwable)e);
        }
    }

    private void fireSmppTORespNotSent() {
        SmppErrorImpl error = new SmppErrorImpl(2, (PDU)this.requestPDU);
        this.smppRA.fireEvent("net.java.slee.resources.smpp.SMPP_TIMEOUT_RESPONSE_SENT", this, error);
        this.smppRA.endActivity(this);
    }

    private void fireSmppRespNotReceived() {
        SmppErrorImpl error = new SmppErrorImpl(1, (PDU)this.requestPDU);
        this.smppRA.fireEvent("net.java.slee.resources.smpp.SMPP_TIMEOUT_RESPONSE_RECEIVED", this, error);
        this.smppRA.endActivity(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.requestPDU == null ? 0 : this.requestPDU.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmppTransactionImpl other = (SmppTransactionImpl)obj;
        return !(this.requestPDU == null ? other.requestPDU != null : !this.requestPDU.equals(other.requestPDU));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TransactionImpl[SequenceNumber = ").append(this.sequenceNumber).append(", Hash = ").append(this.hashCode()).append("]");
        return sb.toString();
    }

    private class ResponseNotReceived
    extends TimerTask {
        private ResponseNotReceived() {
        }

        public void run() {
            ((SmppTransactionImpl)SmppTransactionImpl.this).smppSess.transactions.remove(this);
            SmppTransactionImpl.this.fireSmppRespNotReceived();
        }
    }

    private class ResponseNotSent
    extends TimerTask {
        private ResponseNotSent() {
        }

        public void run() {
            ((SmppTransactionImpl)SmppTransactionImpl.this).smppSess.transactions.remove(this);
            SmppTransactionImpl.this.sendGenericNack();
            SmppTransactionImpl.this.fireSmppTORespNotSent();
        }
    }
}

