/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.smpp.pdu;

import java.util.HashMap;
import java.util.Map;
import net.java.slee.resources.smpp.pdu.Address;
import net.java.slee.resources.smpp.pdu.PDU;
import net.java.slee.resources.smpp.pdu.TLVNotPermittedException;
import net.java.slee.resources.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.ErrorAddress;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.tlv.Tag;
import org.mobicents.slee.resources.smpp.pdu.AddressImpl;
import org.mobicents.slee.resources.smpp.pdu.ErrorAddressImpl;
import org.mobicents.slee.resources.smpp.util.AbsoluteSMPPDateImpl;
import org.mobicents.slee.resources.smpp.util.RelativeSMPPDateImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDUImpl
implements PDU {
    protected SMPPPacket smppPacket;

    public int getCommandId() {
        return this.smppPacket.getCommandId();
    }

    public int getCommandStatus() {
        return this.smppPacket.getCommandStatus();
    }

    public long getSequenceNum() {
        return this.smppPacket.getSequenceNum();
    }

    public void setSequenceNum(long sequenceNum) {
        this.smppPacket.setSequenceNum(sequenceNum);
    }

    public void addTLV(net.java.slee.resources.smpp.pdu.Tag tag, Object value) throws TLVNotPermittedException {
        if (!this.isTLVPermitted(tag)) {
            throw new TLVNotPermittedException(tag);
        }
        this.smppPacket.getTLVTable().put((Object)Tag.getTag((int)tag.getTag()), value);
    }

    public Map<net.java.slee.resources.smpp.pdu.Tag, Object> getAllTLVs() {
        HashMap<net.java.slee.resources.smpp.pdu.Tag, Object> tlvs = new HashMap<net.java.slee.resources.smpp.pdu.Tag, Object>();
        for (Map.Entry entry : this.smppPacket.getTLVTable().entrySet()) {
            tlvs.put(new net.java.slee.resources.smpp.pdu.Tag(((Tag)entry.getKey()).intValue()), entry.getValue());
        }
        return tlvs;
    }

    public Object getValue(net.java.slee.resources.smpp.pdu.Tag tag) {
        return this.smppPacket.getTLVTable().get(tag.getTag());
    }

    public boolean hasTLV(net.java.slee.resources.smpp.pdu.Tag tag) {
        return this.smppPacket.getTLVTable().containsKey((Object)Tag.getTag((int)tag.getTag()));
    }

    public Object removeTLV(net.java.slee.resources.smpp.pdu.Tag tag) {
        return this.smppPacket.getTLVTable().remove((Object)Tag.getTag((int)tag.getTag()));
    }

    public int hashCode() {
        return this.smppPacket.hashCode();
    }

    public boolean equals(Object obj) {
        return this.smppPacket.equals(obj);
    }

    protected SMPPDate convertProtoDate(org.mobicents.protocols.smpp.util.SMPPDate protoSmppDate) {
        if (protoSmppDate == null) {
            return null;
        }
        if (protoSmppDate.isAbsolute()) {
            return new AbsoluteSMPPDateImpl(protoSmppDate.getCalendar(), protoSmppDate.hasTimezone());
        }
        return new RelativeSMPPDateImpl(protoSmppDate.getYear(), protoSmppDate.getMonth(), protoSmppDate.getDay(), protoSmppDate.getHour(), protoSmppDate.getMinute(), protoSmppDate.getSecond());
    }

    protected Address convertProtoAddress(org.mobicents.protocols.smpp.Address address) {
        if (address == null) {
            return null;
        }
        return new AddressImpl(address);
    }

    protected net.java.slee.resources.smpp.pdu.ErrorAddress convertProtoErrorAddress(ErrorAddress errorAddress) {
        if (errorAddress == null) {
            return null;
        }
        return new ErrorAddressImpl(errorAddress);
    }
}

