/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resources.smpp;

import java.util.concurrent.ConcurrentHashMap;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.FireableEventType;

public class FireableEventTypeCache {
    public static final String VENDOR = "net.java";
    public static final String VERSION = "5.0";
    private ConcurrentHashMap<String, FireableEventType> eventTypes = new ConcurrentHashMap();
    private final Tracer tracer;

    public FireableEventTypeCache(Tracer tracer) {
        this.tracer = tracer;
    }

    public FireableEventType getEventType(EventLookupFacility eventLookupFacility, String eventName) {
        FireableEventType eventType = this.eventTypes.get(eventName);
        if (eventType == null) {
            try {
                eventType = eventLookupFacility.getFireableEventType(new EventTypeID(eventName, VENDOR, VERSION));
            }
            catch (Throwable e) {
                this.tracer.severe("Failed to obtain fireable event type for event with name " + eventName, e);
                return null;
            }
            this.eventTypes.put(eventName, eventType);
        }
        return eventType;
    }
}

