/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.diameter.openims;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.ClientTransaction;
import javax.sip.ResponseEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.java.slee.resource.diameter.base.AuthSessionState;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentityAvp;
import net.java.slee.resource.diameter.base.events.avp.GroupedAvp;
import net.java.slee.resource.diameter.sh.client.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.ShClientProvider;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import net.java.slee.resource.diameter.sh.client.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.client.events.SubscribeNotificationsAnswer;
import net.java.slee.resource.diameter.sh.client.events.avp.UserIdentityAvp;
import net.java.slee.resource.diameter.sh.server.events.SubscribeNotificationsRequest;
import net.java.slee.resource.sip.SleeSipProvider;
import org.apache.log4j.Logger;
import org.mobicents.slee.examples.diameter.openims.MissedCall;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class DiameterOpenIMSExampleSbb
implements Sbb {
    private static Logger logger = Logger.getLogger(DiameterOpenIMSExampleSbb.class);
    private SbbContext sbbContext = null;
    private Context myEnv = null;
    private ShClientProvider provider = null;
    private ShClientMessageFactory shMessageFactory = null;
    private DiameterShAvpFactory avpFactory = null;
    private ShClientActivityContextInterfaceFactory acif = null;
    private TimerFacility timerFacility = null;
    private String originIP = "127.0.0.1";
    private String originPort = "1812";
    private String originRealm = "mobicents.org";
    private String destinationIP = "127.0.0.1";
    private String destinationPort = "3868";
    private String destinationRealm = "mobicents.org";
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private static HashMap<String, Collection<MissedCall>> missedCalls = new HashMap();
    private AddressFactory sipAddressFactory;
    private HeaderFactory sipHeaderFactory;
    private MessageFactory sipMessageFactory;
    private SleeSipProvider sipProvider;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            this.myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.provider = (ShClientProvider)this.myEnv.lookup("slee/resources/diameter-sh-client-ra-interface");
            this.shMessageFactory = this.provider.getClientMessageFactory();
            this.avpFactory = this.provider.getClientAvpFactory();
            this.acif = (ShClientActivityContextInterfaceFactory)this.myEnv.lookup("slee/resources/JDiameterShClientResourceAdaptor/java.net/0.8.1/acif");
            this.sipProvider = (SleeSipProvider)this.myEnv.lookup("slee/resources/jainsip/1.2/provider");
            this.sipAddressFactory = this.sipProvider.getAddressFactory();
            this.sipHeaderFactory = this.sipProvider.getHeaderFactory();
            this.sipMessageFactory = this.sipProvider.getMessageFactory();
            this.timerFacility = (TimerFacility)this.myEnv.lookup("slee/facilities/timer");
            this.nullActivityFactory = (NullActivityFactory)this.myEnv.lookup("slee/nullactivity/factory");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)this.myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
        }
        catch (Exception e) {
            logger.error((Object)"Unable to set sbb context.", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        logger.info((Object)"unsetSbbContext invoked.");
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
        logger.info((Object)"sbbCreate invoked.");
    }

    public void sbbPostCreate() throws CreateException {
        logger.info((Object)"sbbPostCreate invoked.");
    }

    public void sbbActivate() {
        logger.info((Object)"sbbActivate invoked.");
    }

    public void sbbPassivate() {
        logger.info((Object)"sbbPassivate invoked.");
    }

    public void sbbRemove() {
        logger.info((Object)"sbbRemove invoked.");
    }

    public void sbbLoad() {
        logger.info((Object)"sbbLoad invoked.");
    }

    public void sbbStore() {
        logger.info((Object)"sbbStore invoked.");
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
        logger.info((Object)"sbbRolledBack invoked.");
    }

    public void sbbRolledBack(RolledBackContext context) {
        logger.info((Object)"sbbRolledBack invoked.");
    }

    protected SbbContext getSbbContext() {
        logger.info((Object)"getSbbContext invoked.");
        return this.sbbContext;
    }

    public InitialEventSelector myInitialEventSelector(InitialEventSelector ies) {
        Object event = ies.getEvent();
        if (event instanceof ResponseEvent) {
            Response response = ((ResponseEvent)event).getResponse();
            if (response.getStatusCode() == 404) {
                ies.setCustomName("OpenIMS-Example-StaticCustomName");
            } else {
                ies.setInitialEvent(false);
            }
        } else if (event instanceof PushNotificationRequest) {
            ies.setCustomName("OpenIMS-Example-StaticCustomName");
        } else {
            ies.setInitialEvent(false);
        }
        return ies;
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)this.myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                logger.info((Object)"################################################################################");
                logger.info((Object)"### O P E N I M S    E X A M P L E    A P P L I C A T I O N  :: S T A R T E D ##");
                logger.info((Object)"################################################################################");
                this.shMessageFactory = this.provider.getClientMessageFactory();
                this.avpFactory = this.provider.getClientAvpFactory();
                logger.info((Object)"Performing sanity check...");
                logger.info((Object)("Provider [" + this.provider + "]"));
                logger.info((Object)("Message Factory [" + this.shMessageFactory + "]"));
                logger.info((Object)("AVP Factory [" + this.avpFactory + "]"));
                logger.info((Object)("Check completed. Result: " + ((this.provider != null ? 1 : 0) + (this.shMessageFactory != null ? 1 : 0) + (this.avpFactory != null ? 1 : 0)) + "/3"));
                logger.info((Object)("Connected to " + this.provider.getPeerCount() + " peers."));
                for (DiameterIdentityAvp peer : this.provider.getConnectedPeers()) {
                    logger.info((Object)("Connected to Peer[" + peer.stringValue() + "]"));
                }
                NullActivity timerBus = this.nullActivityFactory.createNullActivity();
                ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
                timerBusACI.attach(this.sbbContext.getSbbLocalObject());
                TimerOptions options = new TimerOptions();
                this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + 5000L, options);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to handle service started event...", (Throwable)e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("example.properties"));
            this.originIP = props.getProperty("origin.ip") == null ? this.originIP : props.getProperty("origin.ip");
            this.originPort = props.getProperty("origin.port") == null ? this.originPort : props.getProperty("origin.port");
            this.originRealm = props.getProperty("origin.realm") == null ? this.originRealm : props.getProperty("origin.realm");
            this.destinationIP = props.getProperty("destination.ip") == null ? this.destinationIP : props.getProperty("destination.ip");
            this.destinationPort = props.getProperty("destination.port") == null ? this.destinationPort : props.getProperty("destination.port");
            this.destinationRealm = props.getProperty("destination.realm") == null ? this.destinationRealm : props.getProperty("destination.realm");
            String usersStr = props.getProperty("users");
            if (usersStr != null && usersStr.length() > 0) {
                String[] users = usersStr.split(",");
                logger.info((Object)("Subscribing to Profile Updates from Users " + users.toString()));
                for (String user : users) {
                    this.sendSubscribeNotificationsRequest(user.trim());
                }
            } else {
                logger.warn((Object)"No Users are defined for the example. Nothing will happen...");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failure reading properties file.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPushNotificationRequest(PushNotificationRequest pnr, ActivityContextInterface aci) {
        block8: {
            logger.info((Object)("Push-Notification-Request received.\r\n" + pnr));
            String userData = pnr.getUserData();
            try {
                DocumentBuilderFactory factory;
                DocumentBuilder builder;
                Document doc;
                String userState;
                DiameterAvp[] avps;
                String userId = null;
                for (DiameterAvp avp : avps = pnr.getAvps()) {
                    if (avp.getCode() != 700 || !(avp instanceof GroupedAvp)) continue;
                    GroupedAvp userIdentity = (GroupedAvp)avp;
                    for (DiameterAvp subAvp : userIdentity.getExtensionAvps()) {
                        if (subAvp.getCode() != 601) continue;
                        userId = subAvp.stringValue();
                    }
                }
                Collection<MissedCall> mCs = missedCalls.get(userId);
                if (mCs == null || mCs.size() <= 0 || !(userState = (doc = (builder = (factory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(new InputSource(new StringReader(userData)))).getElementsByTagName("IMSUserState").item(0).getTextContent()).equals("1")) break block8;
                Collection<MissedCall> collection = mCs;
                synchronized (collection) {
                    for (MissedCall missedCall : mCs) {
                        this.sendSIPMessage(userId, missedCall.getNotification());
                    }
                }
                mCs.clear();
            }
            catch (Exception e) {
                logger.error((Object)"Error parsing User-Data AVP.", (Throwable)e);
            }
        }
    }

    public void on4xxResponse(ResponseEvent event, ActivityContextInterface aci) {
        Response response = event.getResponse();
        logger.info((Object)("Received SIP 4xx \u00bb " + response.getStatusCode()));
        if (response.getStatusCode() == 404) {
            String to = ((ToHeader)response.getHeader("To")).getAddress().toString();
            String from = ((FromHeader)response.getHeader("From")).getAddress().toString();
            logger.info((Object)("From[" + from + "], To [" + to + "]"));
            String toAddress = to.substring(to.indexOf("sip:"), to.indexOf(">"));
            MissedCall mC = new MissedCall(from, new Date());
            Collection<MissedCall> mCs = missedCalls.get(toAddress);
            if (mCs == null) {
                mCs = new ArrayList<MissedCall>();
                missedCalls.put(toAddress, mCs);
            }
            if (!mCs.contains(mC)) {
                mCs.add(mC);
            }
        }
    }

    public void onSubscriptionNotificationsAnswer(SubscribeNotificationsAnswer sna, ActivityContextInterface aci) {
        logger.info((Object)("Subscription-Notifications-Answer received with Result-Code[" + sna.getResultCode() + "].."));
        if (sna.getResultCode() != 2001L) {
            logger.warn((Object)"Subscription WAS NOT successful. Please check your permissions and/or users.");
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        logger.info((Object)(" Activity Ended[" + aci.getActivity() + "]"));
    }

    private void sendSubscribeNotificationsRequest(String user) {
        try {
            ShClientSubscriptionActivity shClientSubscriptionActivity = this.provider.createShClientSubscriptionActivity();
            shClientSubscriptionActivity.getDiameterAvpFactory();
            shClientSubscriptionActivity.getDiameterMessageFactory();
            ActivityContextInterface localACI = this.acif.getActivityContextInterface(shClientSubscriptionActivity);
            localACI.attach(this.getSbbContext().getSbbLocalObject());
            ArrayList<Object> avps = new ArrayList<Object>();
            SubscribeNotificationsRequest snr = ((ShClientMessageFactory)shClientSubscriptionActivity.getDiameterMessageFactory()).createSubscribeNotificationsRequest();
            avps.add(this.avpFactory.getBaseFactory().createAvp(263, shClientSubscriptionActivity.getSessionId().getBytes()));
            DiameterAvp avpVendorId = this.avpFactory.getBaseFactory().createAvp(266, 10415);
            DiameterAvp avpAcctApplicationId = this.avpFactory.getBaseFactory().createAvp(258, 0x1000001);
            avps.add(this.avpFactory.getBaseFactory().createAvp(260, new DiameterAvp[]{avpVendorId, avpAcctApplicationId}));
            avps.add(this.avpFactory.getBaseFactory().createAvp(264, ("aaa://" + this.originIP + ":" + this.originPort).getBytes()));
            avps.add(this.avpFactory.getBaseFactory().createAvp(296, this.originRealm.getBytes()));
            avps.add(this.avpFactory.getBaseFactory().createAvp(293, ("aaa://" + this.destinationIP + ":" + this.destinationPort).getBytes()));
            avps.add(this.avpFactory.getBaseFactory().createAvp(283, this.destinationRealm.getBytes()));
            UserIdentityAvp ui = this.avpFactory.createUserIdentity();
            ui.setPublicIdentity("sip:" + user.replaceFirst("sip:", ""));
            avps.add(ui);
            DiameterAvp srt = this.avpFactory.getBaseFactory().createAvp(10415, 705, 0);
            avps.add(srt);
            DiameterAvp avp = this.avpFactory.getBaseFactory().createAvp(10415, 703, 11);
            avps.add(avp);
            avps.add(this.avpFactory.getBaseFactory().createAvp(277, AuthSessionState.Open.ordinal()));
            snr.setExtensionAvps(avps.toArray(avps.toArray(new DiameterAvp[avps.size()])));
            logger.info((Object)("Created Subscribe-Notifications-Request:\r\n" + snr));
            shClientSubscriptionActivity.sendSubscriptionNotificationRequest(snr);
            logger.info((Object)"Subscribe-Notifications-Request sent!");
        }
        catch (Exception e) {
            logger.error((Object)"Failure trying to create/send Subscribe-Notifications-Request.", (Throwable)e);
        }
    }

    private void sendSIPMessage(String toAddressString, String message) {
        try {
            Address toAddress = this.sipAddressFactory.createAddress(toAddressString);
            toAddress.setDisplayName(toAddressString);
            ToHeader toHeader = this.sipHeaderFactory.createToHeader(toAddress, null);
            SipURI fromAddress = this.sipAddressFactory.createSipURI("missed-calls", System.getProperty("bind.address", "127.0.0.1"));
            Address fromNameAddress = this.sipAddressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName("Missed Calls");
            FromHeader fromHeader = this.sipHeaderFactory.createFromHeader(fromNameAddress, "12345SomeTagID6789");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = this.sipHeaderFactory.createViaHeader(this.sipProvider.getListeningPoints()[0].getIPAddress(), this.sipProvider.getListeningPoints()[0].getPort(), this.sipProvider.getListeningPoints()[0].getTransport(), null);
            viaHeaders.add(viaHeader);
            MaxForwardsHeader maxForwards = this.sipHeaderFactory.createMaxForwardsHeader(70);
            URI uri = this.sipProvider.getAddressFactory().createURI(toAddressString);
            Request req = this.sipMessageFactory.createRequest(uri, "MESSAGE", this.sipProvider.getNewCallId(), this.sipHeaderFactory.createCSeqHeader(1L, "MESSAGE"), fromHeader, toHeader, viaHeaders, maxForwards);
            ContentTypeHeader contentType = this.sipHeaderFactory.createContentTypeHeader("text", "plain");
            req.setContent((Object)message, contentType);
            ClientTransaction ct = this.sipProvider.getNewClientTransaction(req);
            ct.sendRequest();
        }
        catch (Exception e) {
            logger.error((Object)"Failure creating SIP Message notification.", (Throwable)e);
        }
    }
}

