/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.diameter.openims;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.ClientTransaction;
import javax.sip.ResponseEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.java.slee.resource.diameter.base.AuthSessionState;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.sh.DiameterShAvpFactory;
import net.java.slee.resource.diameter.sh.client.ShClientActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.sh.client.ShClientMessageFactory;
import net.java.slee.resource.diameter.sh.client.ShClientProvider;
import net.java.slee.resource.diameter.sh.client.ShClientSubscriptionActivity;
import net.java.slee.resource.diameter.sh.events.PushNotificationAnswer;
import net.java.slee.resource.diameter.sh.events.PushNotificationRequest;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsAnswer;
import net.java.slee.resource.diameter.sh.events.SubscribeNotificationsRequest;
import net.java.slee.resource.diameter.sh.events.avp.UserIdentityAvp;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.examples.diameter.openims.MissedCall;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class DiameterOpenIMSExampleSbb
implements Sbb {
    private Tracer tracer;
    private SbbContext sbbContext = null;
    private Context myEnv = null;
    private ShClientProvider provider = null;
    private ShClientMessageFactory shMessageFactory = null;
    private DiameterShAvpFactory shAvpFactory = null;
    private ShClientActivityContextInterfaceFactory acif = null;
    private TimerFacility timerFacility = null;
    private static final int SUCCESS_RESULT_CODE = 2001;
    private String destinationIP = "127.0.0.1";
    private String destinationPort = "3868";
    private String destinationRealm = "mobicents.org";
    private String destinationHost = null;
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private static HashMap<String, Collection<MissedCall>> missedCalls = new HashMap();
    private AddressFactory sipAddressFactory;
    private HeaderFactory sipHeaderFactory;
    private MessageFactory sipMessageFactory;
    private SleeSipProvider sipProvider;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        this.tracer = this.sbbContext.getTracer(DiameterOpenIMSExampleSbb.class.getSimpleName());
        try {
            this.myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.provider = (ShClientProvider)this.myEnv.lookup("slee/resources/diameter-sh-client-ra-interface");
            this.shMessageFactory = this.provider.getClientMessageFactory();
            this.shAvpFactory = this.provider.getClientAvpFactory();
            this.acif = (ShClientActivityContextInterfaceFactory)this.myEnv.lookup("slee/resources/JDiameterShClientResourceAdaptor/java.net/0.8.1/acif");
            this.sipProvider = (SleeSipProvider)this.myEnv.lookup("slee/resources/jainsip/1.2/provider");
            this.sipAddressFactory = this.sipProvider.getAddressFactory();
            this.sipHeaderFactory = this.sipProvider.getHeaderFactory();
            this.sipMessageFactory = this.sipProvider.getMessageFactory();
            this.timerFacility = (TimerFacility)this.myEnv.lookup("slee/facilities/timer");
            this.nullActivityFactory = (NullActivityFactory)this.myEnv.lookup("slee/nullactivity/factory");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)this.myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
        }
        catch (Exception e) {
            this.tracer.severe("Unable to set sbb context.", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("unsetSbbContext invoked.");
        }
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbCreate invoked.");
        }
    }

    public void sbbPostCreate() throws CreateException {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbPostCreate invoked.");
        }
    }

    public void sbbActivate() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbActivate invoked.");
        }
    }

    public void sbbPassivate() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbPassivate invoked.");
        }
    }

    public void sbbRemove() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbRemove invoked.");
        }
    }

    public void sbbLoad() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbLoad invoked.");
        }
    }

    public void sbbStore() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbStore invoked.");
        }
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbRolledBack invoked.");
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("sbbRolledBack invoked.");
        }
    }

    protected SbbContext getSbbContext() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("getSbbContext invoked.");
        }
        return this.sbbContext;
    }

    public InitialEventSelector myInitialEventSelector(InitialEventSelector ies) {
        Object event = ies.getEvent();
        if (event instanceof ResponseEvent) {
            Response response = ((ResponseEvent)event).getResponse();
            if (response.getStatusCode() == 404) {
                ies.setCustomName("OpenIMS-Example-StaticCustomName");
            } else {
                ies.setInitialEvent(false);
            }
        } else if (event instanceof PushNotificationRequest) {
            ies.setCustomName("OpenIMS-Example-StaticCustomName");
        } else {
            ies.setInitialEvent(false);
        }
        return ies;
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)this.myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("################################################################################");
                    this.tracer.info("### O P E N I M S    E X A M P L E    A P P L I C A T I O N  :: S T A R T E D ##");
                    this.tracer.info("################################################################################");
                }
                if (this.tracer.isFineEnabled()) {
                    this.tracer.fine("Performing sanity check...");
                    this.tracer.fine("Provider [" + this.provider + "]");
                    this.tracer.fine("Message Factory [" + this.shMessageFactory + "]");
                    this.tracer.fine("AVP Factory [" + this.shAvpFactory + "]");
                    this.tracer.fine("Check completed. Result: " + ((this.provider != null ? 1 : 0) + (this.shMessageFactory != null ? 1 : 0) + (this.shAvpFactory != null ? 1 : 0)) + "/3");
                }
                this.shMessageFactory = this.provider.getClientMessageFactory();
                this.shAvpFactory = this.provider.getClientAvpFactory();
                NullActivity timerBus = this.nullActivityFactory.createNullActivity();
                ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
                timerBusACI.attach(this.sbbContext.getSbbLocalObject());
                TimerOptions options = new TimerOptions();
                this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + 5000L, options);
            }
        }
        catch (Exception e) {
            this.tracer.severe("Unable to handle service started event...", (Throwable)e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("example.properties"));
            this.destinationIP = props.getProperty("destination.ip") == null ? this.destinationIP : props.getProperty("destination.ip");
            this.destinationPort = props.getProperty("destination.port") == null ? this.destinationPort : props.getProperty("destination.port");
            this.destinationRealm = props.getProperty("destination.realm") == null ? this.destinationRealm : props.getProperty("destination.realm");
            this.destinationHost = props.getProperty("destination.host");
            String usersStr = props.getProperty("users");
            if (usersStr != null && usersStr.length() > 0) {
                Object[] users = usersStr.split(",");
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Subscribing to Profile Updates from Users " + Arrays.deepToString(users));
                }
                for (Object user : users) {
                    this.sendSubscribeNotificationsRequest(((String)user).trim());
                }
            } else {
                this.tracer.warning("No Users are defined for the example. Nothing will happen...");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Failure reading properties file.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPushNotificationRequest(PushNotificationRequest pnr, ActivityContextInterface aci) {
        block12: {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Push-Notification-Request received.\r\n" + pnr);
            }
            String userData = pnr.getUserData();
            try {
                DocumentBuilderFactory factory;
                DocumentBuilder builder;
                Document doc;
                String userState;
                String userId = null;
                UserIdentityAvp userIdentity = pnr.getUserIdentity();
                if (userIdentity == null) {
                    throw new IllegalStateException("No user identity in message: " + pnr);
                }
                userId = userIdentity.getPublicIdentity();
                ShClientSubscriptionActivity activity = (ShClientSubscriptionActivity)aci.getActivity();
                PushNotificationAnswer pna = activity.createPushNotificationAnswer(2001L, false);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("About to send PNA: " + pna);
                }
                activity.sendPushNotificationAnswer(pna);
                Collection<MissedCall> mCs = missedCalls.get(userId);
                if (mCs == null || mCs.size() <= 0 || !(userState = (doc = (builder = (factory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(new InputSource(new StringReader(userData)))).getElementsByTagName("IMSUserState").item(0).getTextContent()).equals("1")) break block12;
                Collection<MissedCall> collection = mCs;
                synchronized (collection) {
                    for (MissedCall missedCall : mCs) {
                        this.sendSIPMessage(userId, missedCall.getNotification());
                    }
                }
                mCs.clear();
            }
            catch (Exception e) {
                this.tracer.severe("Error parsing User-Data AVP.", (Throwable)e);
            }
            finally {
                aci.detach(this.getSbbContext().getSbbLocalObject());
            }
        }
    }

    public void on4xxResponse(ResponseEvent event, ActivityContextInterface aci) {
        Response response = event.getResponse();
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Received SIP 4xx >> " + response.getStatusCode());
        }
        if (response.getStatusCode() == 404) {
            String to = ((ToHeader)response.getHeader("To")).getAddress().toString();
            String from = ((FromHeader)response.getHeader("From")).getAddress().toString();
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("From[" + from + "], To [" + to + "]");
            }
            String toAddress = to.substring(to.indexOf("sip:"), to.indexOf(">"));
            MissedCall mC = new MissedCall(from, new Date());
            Collection<MissedCall> mCs = missedCalls.get(toAddress);
            if (mCs == null) {
                mCs = new ArrayList<MissedCall>();
                missedCalls.put(toAddress, mCs);
            }
            if (!mCs.contains(mC)) {
                mCs.add(mC);
            }
        }
        aci.detach(this.getSbbContext().getSbbLocalObject());
    }

    public void onSubscriptionNotificationsAnswer(SubscribeNotificationsAnswer sna, ActivityContextInterface aci) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Subscription-Notifications-Answer received with Result-Code[" + sna.getResultCode() + "]..");
        }
        if (sna.getResultCode() != 2001L) {
            this.tracer.warning("Subscription WAS NOT successful. Please check your permissions and/or users.");
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info(" Activity Ended[" + aci.getActivity() + "]");
        }
    }

    private void sendSubscribeNotificationsRequest(String user) {
        try {
            ShClientSubscriptionActivity shClientSubscriptionActivity = this.provider.createShClientSubscriptionActivity();
            ActivityContextInterface localACI = this.acif.getActivityContextInterface(shClientSubscriptionActivity);
            localACI.attach(this.getSbbContext().getSbbLocalObject());
            ArrayList<Object> avps = new ArrayList<Object>();
            SubscribeNotificationsRequest snr = shClientSubscriptionActivity.getClientMessageFactory().createSubscribeNotificationsRequest();
            avps.add(this.shAvpFactory.getBaseFactory().createAvp(293, this.destinationHost != null ? this.destinationHost.getBytes() : ("aaa://" + this.destinationIP + ":" + this.destinationPort).getBytes()));
            avps.add(this.shAvpFactory.getBaseFactory().createAvp(283, this.destinationRealm.getBytes()));
            UserIdentityAvp ui = this.shAvpFactory.createUserIdentity();
            ui.setPublicIdentity("sip:" + user.replaceFirst("sip:", ""));
            avps.add(ui);
            DiameterAvp srt = this.shAvpFactory.getBaseFactory().createAvp(10415, 705, 0);
            avps.add(srt);
            DiameterAvp avp = this.shAvpFactory.getBaseFactory().createAvp(10415, 703, 11);
            avps.add(avp);
            avps.add(this.shAvpFactory.getBaseFactory().createAvp(277, AuthSessionState.Open.ordinal()));
            snr.setExtensionAvps(avps.toArray(avps.toArray(new DiameterAvp[avps.size()])));
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Created Subscribe-Notifications-Request:\r\n" + snr);
            }
            shClientSubscriptionActivity.sendSubscribeNotificationsRequest(snr);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Subscribe-Notifications-Request sent!");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Failure trying to create/send Subscribe-Notifications-Request.", (Throwable)e);
        }
    }

    private void sendSIPMessage(String toAddressString, String message) {
        try {
            Address toAddress = this.sipAddressFactory.createAddress(toAddressString);
            toAddress.setDisplayName(toAddressString);
            ToHeader toHeader = this.sipHeaderFactory.createToHeader(toAddress, null);
            SipURI fromAddress = this.sipAddressFactory.createSipURI("missed-calls", System.getProperty("bind.address", "127.0.0.1"));
            Address fromNameAddress = this.sipAddressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName("Missed Calls");
            FromHeader fromHeader = this.sipHeaderFactory.createFromHeader(fromNameAddress, "12345SomeTagID6789");
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = this.sipHeaderFactory.createViaHeader(this.sipProvider.getListeningPoints()[0].getIPAddress(), this.sipProvider.getListeningPoints()[0].getPort(), this.sipProvider.getListeningPoints()[0].getTransport(), null);
            viaHeaders.add(viaHeader);
            MaxForwardsHeader maxForwards = this.sipHeaderFactory.createMaxForwardsHeader(70);
            URI uri = this.sipProvider.getAddressFactory().createURI(toAddressString);
            Request req = this.sipMessageFactory.createRequest(uri, "MESSAGE", this.sipProvider.getNewCallId(), this.sipHeaderFactory.createCSeqHeader(1L, "MESSAGE"), fromHeader, toHeader, viaHeaders, maxForwards);
            ContentTypeHeader contentType = this.sipHeaderFactory.createContentTypeHeader("text", "plain");
            req.setContent((Object)message, contentType);
            ClientTransaction ct = this.sipProvider.getNewClientTransaction(req);
            ct.sendRequest();
        }
        catch (Exception e) {
            this.tracer.severe("Failure creating SIP Message notification.", (Throwable)e);
        }
    }
}

