/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.api;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.UnknownServiceException;

public final class URI
implements Comparable,
Serializable {
    private static final String FIELD_PROTOCOL = "protocol=";
    private static final String FIELD_TRANSPORT = "transport=";
    private static final String SCHEME_SEPARATOR = "://";
    private static final String PARAMS_SEPARATOR = ";";
    private static final int DEFAULT_PORT = 3868;
    private String scheme;
    private String host;
    private int port = -1;
    private String path = "";

    public URI(String uri) throws URISyntaxException, UnknownServiceException {
        this.parse(uri);
        if (this.getFQDN() == null || this.getFQDN().trim().length() == 0) {
            throw new URISyntaxException(uri, "Host not found");
        }
        if (!this.getScheme().equals("aaa") && !this.getScheme().equals("aaas")) {
            throw new UnknownServiceException("Unsupported service: " + this.getScheme());
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getFQDN() {
        return this.host;
    }

    public int getPort() {
        return this.port == -1 ? 3868 : this.port;
    }

    public boolean isSecure() {
        return this.getScheme().endsWith("s");
    }

    public String getPath() {
        return this.path;
    }

    public String getProtocolParam() {
        String[] args;
        for (String arg : args = this.getPath().split(PARAMS_SEPARATOR)) {
            if (!arg.startsWith(FIELD_PROTOCOL)) continue;
            return arg.substring(FIELD_PROTOCOL.length());
        }
        return null;
    }

    public String getTransportParam() {
        String[] args;
        for (String arg : args = this.getPath().split(PARAMS_SEPARATOR)) {
            if (!arg.startsWith(FIELD_TRANSPORT)) continue;
            return arg.substring(FIELD_TRANSPORT.length());
        }
        return null;
    }

    public String toString() {
        StringBuffer rc = new StringBuffer(this.scheme).append(SCHEME_SEPARATOR).append(this.host);
        if (this.port != -1) {
            rc.append(":").append(this.port);
        }
        if (this.path != null && this.path.length() > 0) {
            rc.append(PARAMS_SEPARATOR).append(this.path);
        }
        return rc.toString();
    }

    private void parse(String uri) throws URISyntaxException {
        try {
            int schemeStartIndex = uri.indexOf(SCHEME_SEPARATOR);
            if (schemeStartIndex == -1) {
                throw new URISyntaxException(uri, "Protocol scheme not found");
            }
            this.scheme = uri.substring(0, schemeStartIndex);
            int schemeEndIndex = schemeStartIndex + 3;
            this.host = (schemeStartIndex = uri.indexOf(59, schemeEndIndex)) == -1 ? uri.substring(schemeEndIndex) : uri.substring(schemeEndIndex, schemeStartIndex);
            int sepIndex = this.host.indexOf(58);
            if (sepIndex != -1) {
                this.port = Integer.parseInt(this.host.substring(sepIndex + 1));
                this.host = this.host.substring(0, sepIndex);
            }
            if (schemeStartIndex != -1) {
                this.path = uri.substring(schemeStartIndex + 1);
            }
        }
        catch (Exception e) {
            throw new URISyntaxException(uri, "Uri has incorrect format");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        URI that = (URI)obj;
        return !(this.getPort() != that.getPort() || (this.host == null ? that.host != null : !this.host.equals(that.host)) || (this.path == null ? that.path != null : !this.path.equals(that.path)) || (this.scheme == null ? that.scheme != null : !this.scheme.equals(that.scheme)));
    }

    public int hashCode() {
        int result = this.scheme != null ? this.scheme.hashCode() : 0;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.getPort();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public int compareTo(Object obj) {
        if (obj instanceof URI) {
            return this.toString().compareTo(obj.toString());
        }
        return -1;
    }
}

