/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.transaction.SleeTransactionManager;
import net.java.slee.resource.diameter.base.AccountingClientSessionActivity;
import net.java.slee.resource.diameter.base.AccountingServerSessionActivity;
import net.java.slee.resource.diameter.base.AuthClientSessionActivity;
import net.java.slee.resource.diameter.base.AuthServerSessionActivity;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterException;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.DiameterProvider;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.AvpUtilities;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.RawSession;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.api.acc.ServerAccSession;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.auth.ClientAuthSession;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.acc.ClientAccSessionImpl;
import org.jdiameter.client.impl.app.auth.ClientAuthSessionImpl;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.client.impl.parser.MessageParser;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.impl.validation.JAvpNotAllowedException;
import org.jdiameter.server.impl.app.acc.ServerAccSessionImpl;
import org.jdiameter.server.impl.app.auth.ServerAuthSessionImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.diameter.AbstractClusteredDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.base.AccountingClientSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.AccountingServerSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.AccountingSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.AuthClientSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.AuthServerSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.AuthSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDCache;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.AbortSessionAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AbortSessionRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.CapabilitiesExchangeAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.CapabilitiesExchangeRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DeviceWatchdogAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DeviceWatchdogRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.DisconnectPeerAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.DisconnectPeerRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ReAuthAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ReAuthRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.SessionTerminationAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.SessionTerminationRequestImpl;
import org.mobicents.slee.resource.diameter.base.handlers.AccountingSessionFactory;
import org.mobicents.slee.resource.diameter.base.handlers.AuthorizationSessionFactory;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiameterBaseResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface,
FaultTolerantResourceAdaptor<String, DiameterActivity> {
    private static final long serialVersionUID = 1L;
    private static final String AUTH_APPLICATION_IDS = "authApplicationIds";
    private static final String ACCT_APPLICATION_IDS = "acctApplicationIds";
    private List<ApplicationId> authApplicationIds;
    private List<ApplicationId> acctApplicationIds;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private FaultTolerantResourceAdaptorContext<String, DiameterActivity> ftRAContext;
    private transient SleeEndpoint sleeEndpoint = null;
    private Tracer tracer;
    private DiameterBaseMarshaler marshaler = new DiameterBaseMarshaler();
    private Stack stack;
    private SessionFactory sessionFactory = null;
    private long messageTimeout = 5000L;
    private ObjectName diameterMultiplexerObjectName = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private DiameterAvpFactory avpFactory = null;
    private DiameterMessageFactory messageFactory = null;
    private transient EventLookupFacility eventLookup = null;
    private DiameterActivityManagement activities;
    private transient DiameterProviderImpl raProvider = null;
    protected transient AuthorizationSessionFactory authSessionFactory = null;
    protected transient AccountingSessionFactory accSessionFactory = null;
    protected transient SessionFactory proxySessionFactory = null;
    private static final int EVENT_FLAGS = DiameterBaseResourceAdaptor.getEventFlags();
    private static final int DEFAULT_ACTIVITY_FLAGS = 2;
    private static final int MARSHALABLE_ACTIVITY_FLAGS = ActivityFlags.setSleeMayMarshal((int)2);

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterBaseResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter Base RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.raProvider = new DiameterProviderImpl(this);
            this.initStack();
            this.initActivitiesMgmt();
            this.messageFactory = new DiameterMessageFactoryImpl(this.stack);
            this.avpFactory = new DiameterAvpFactoryImpl();
            this.sessionFactory = this.stack.getSessionFactory();
            this.accSessionFactory = AccountingSessionFactory.INSTANCE;
            this.accSessionFactory.registerListener((DiameterRAInterface)this, this.messageTimeout, this.sessionFactory);
            this.authSessionFactory = new AuthorizationSessionFactory((DiameterRAInterface)this, this.messageTimeout, this.sessionFactory);
            this.proxySessionFactory = new SessionFactory(){

                public <T extends AppSession> T getNewAppSession(ApplicationId applicationId, Class<? extends AppSession> userSession) throws InternalException {
                    return (T)DiameterBaseResourceAdaptor.this.sessionFactory.getNewAppSession(applicationId, userSession);
                }

                public <T extends AppSession> T getNewAppSession(String sessionId, ApplicationId applicationId, Class<? extends AppSession> userSession) throws InternalException {
                    return (T)DiameterBaseResourceAdaptor.this.sessionFactory.getNewAppSession(sessionId, applicationId, userSession);
                }

                public RawSession getNewRawSession() throws InternalException {
                    try {
                        return DiameterBaseResourceAdaptor.this.stack.getSessionFactory().getNewRawSession();
                    }
                    catch (IllegalDiameterStateException e) {
                        DiameterBaseResourceAdaptor.this.tracer.severe("Failure while obtaining Session Factory for new Raw Session.", (Throwable)e);
                        return null;
                    }
                }

                public Session getNewSession() throws InternalException {
                    Session session = DiameterBaseResourceAdaptor.this.sessionFactory.getNewSession();
                    DiameterBaseResourceAdaptor.this.sessionCreated(session);
                    return session;
                }

                public Session getNewSession(String sessionId) throws InternalException {
                    Session session = DiameterBaseResourceAdaptor.this.sessionFactory.getNewSession(sessionId);
                    DiameterBaseResourceAdaptor.this.sessionCreated(session);
                    return session;
                }
            };
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerAccSession.class, (IAppSessionFactory)this.accSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientAccSession.class, (IAppSessionFactory)this.accSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerAuthSession.class, (IAppSessionFactory)this.authSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientAuthSession.class, (IAppSessionFactory)this.authSessionFactory);
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter Base RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister Base RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Base RA :: STOPPING completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: raInactive.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Base RA :: INACTIVE completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: raConfigure");
        }
        this.parseApplicationIds((String)properties.getProperty(AUTH_APPLICATION_IDS).getValue(), true);
        this.parseApplicationIds((String)properties.getProperty(ACCT_APPLICATION_IDS).getValue(), false);
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("RA supporting " + this.authApplicationIds + " " + this.acctApplicationIds);
        }
    }

    private void parseApplicationIds(String appIdsStr, boolean isAuthorization) {
        if (appIdsStr != null) {
            appIdsStr = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = appIdsStr.split(",");
            ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                appIds.add(ApplicationId.createByAccAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
            if (isAuthorization) {
                this.authApplicationIds = appIds;
            } else {
                this.acctApplicationIds = appIds;
            }
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext<String, DiameterActivity> ctx) {
        this.ftRAContext = ctx;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.ftRAContext = null;
    }

    public void dataRemoved(String arg0) {
        this.activities.remove(this.getActivityHandle(arg0));
    }

    public void failOver(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        DiameterActivityImpl activity;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Base RA :: queryLiveness :: handle[" + handle + "].");
        }
        if ((activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle)) != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: getActivity :: handle[" + handle + "].");
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivity inActivity = (DiameterActivity)activity;
        return ((DiameterActivityImpl)inActivity).getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Base RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Base RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: activityEnded :: handle[" + handle + ".");
        }
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (handle instanceof DiameterActivityHandle) {
            this.endActivity((DiameterActivityHandle)handle);
        }
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (message.getCommandCode()) {
            case 274: {
                return isRequest ? new AbortSessionRequestImpl(message) : new AbortSessionAnswerImpl(message);
            }
            case 271: {
                return isRequest ? new AccountingRequestImpl(message) : new AccountingAnswerImpl(message);
            }
            case 257: {
                return isRequest ? new CapabilitiesExchangeRequestImpl(message) : new CapabilitiesExchangeAnswerImpl(message);
            }
            case 280: {
                return isRequest ? new DeviceWatchdogRequestImpl(message) : new DeviceWatchdogAnswerImpl(message);
            }
            case 282: {
                return isRequest ? new DisconnectPeerRequestImpl(message) : new DisconnectPeerAnswerImpl(message);
            }
            case 258: {
                return isRequest ? new ReAuthRequestImpl(message) : new ReAuthAnswerImpl(message);
            }
            case 275: {
                return isRequest ? new SessionTerminationRequestImpl(message) : new SessionTerminationAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    private void addActivity(DiameterActivity ac) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating activity", (Throwable)e);
            throw new RuntimeException("Error creating activity", e);
        }
    }

    public ResourceAdaptorContext getRaContext() {
        return this.raContext;
    }

    private synchronized void initStack() throws Exception {
        ArrayList<ApplicationId> allAppIds = new ArrayList<ApplicationId>();
        allAppIds.addAll(this.authApplicationIds);
        allAppIds.addAll(this.acctApplicationIds);
        this.diameterMux.registerListener((DiameterListener)this, allAppIds.toArray(new ApplicationId[allAppIds.size()]));
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        MessageParser parser = (MessageParser)((IContainer)this.stack).getAssemblerFacility().getComponentInstance(MessageParser.class);
        AvpUtilities.setParser((MessageParser)parser);
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Base RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        final DiameterBaseResourceAdaptor lst = this;
        if (this.ftRAContext.isLocal()) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in LOCAL mode.");
            }
            this.activities = new LocalDiameterActivityManagement();
        } else {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in CLUSTER mode.");
            }
            ReplicatedData clusteredData = this.ftRAContext.getReplicateData(true);
            this.activities = new AbstractClusteredDiameterActivityManagement(this.raContext.getTracer(""), this.stack, this.raContext.getSleeTransactionManager(), clusteredData){

                protected void performBeforeReturn(DiameterActivityImpl activity) {
                    block7: {
                        try {
                            Session session = null;
                            if (activity.getClass().equals(DiameterActivityImpl.class)) {
                                session = this.diameterStack.getSessionFactory().getNewSession(activity.getSessionId());
                                this.performBeforeReturnOnBase(activity, session);
                                return;
                            }
                            if (activity instanceof AccountingClientSessionActivity) {
                                AccountingClientSessionActivityImpl acc = (AccountingClientSessionActivityImpl)activity;
                                ClientAccSession appSession = (ClientAccSession)this.diameterStack.getSession(activity.getSessionId(), ClientAccSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                acc.setSession(appSession);
                                break block7;
                            }
                            if (activity instanceof AccountingServerSessionActivity) {
                                AccountingServerSessionActivityImpl acc = (AccountingServerSessionActivityImpl)activity;
                                ServerAccSession appSession = (ServerAccSession)this.diameterStack.getSession(activity.getSessionId(), ServerAccSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                acc.setSession(appSession);
                                break block7;
                            }
                            if (activity instanceof AuthClientSessionActivity) {
                                AuthClientSessionActivityImpl acc = (AuthClientSessionActivityImpl)activity;
                                ClientAuthSession appSession = (ClientAuthSession)this.diameterStack.getSession(activity.getSessionId(), ClientAuthSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                acc.setSession(appSession);
                                break block7;
                            }
                            if (activity instanceof AuthServerSessionActivity) {
                                AuthServerSessionActivityImpl acc = (AuthServerSessionActivityImpl)activity;
                                ServerAuthSession appSession = (ServerAuthSession)this.diameterStack.getSession(activity.getSessionId(), ServerAuthSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                acc.setSession(appSession);
                                break block7;
                            }
                            throw new IllegalArgumentException("Unknown type of activity: " + activity);
                        }
                        catch (Exception e) {
                            throw new DiameterException((Throwable)e);
                        }
                    }
                }

                private void performBeforeReturnOnBase(DiameterActivityImpl ac, Session session) {
                    DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(session, DiameterBaseResourceAdaptor.this.stack, new DiameterIdentity[0]);
                    ac.setAvpFactory(DiameterBaseResourceAdaptor.this.avpFactory);
                    ac.setMessageFactory((DiameterMessageFactory)msgFactory);
                    ac.setCurrentWorkingSession(session);
                    ac.setSessionListener((Object)lst);
                }
            };
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        block13: {
            SleeTransactionManager txManager = this.raContext.getSleeTransactionManager();
            boolean terminateTx = false;
            try {
                txManager.begin();
                terminateTx = true;
                DiameterActivityImpl activity = (DiameterActivityImpl)this.raProvider.createActivity((Message)request);
                if (activity instanceof AuthServerSessionActivityImpl) {
                    AuthServerSessionActivityImpl assai = (AuthServerSessionActivityImpl)activity;
                    ((ServerAuthSessionImpl)assai.getSession()).processRequest(request);
                } else if (activity instanceof AuthClientSessionActivityImpl) {
                    AuthClientSessionActivityImpl assai = (AuthClientSessionActivityImpl)activity;
                    ((ClientAuthSessionImpl)assai.getSession()).processRequest(request);
                } else if (activity instanceof AccountingServerSessionActivityImpl) {
                    AccountingServerSessionActivityImpl assai = (AccountingServerSessionActivityImpl)activity;
                    ((ServerAccSessionImpl)assai.getSession()).processRequest(request);
                } else if (activity instanceof AccountingClientSessionActivity) {
                    AccountingClientSessionActivityImpl assai = (AccountingClientSessionActivityImpl)activity;
                    ((ClientAccSessionImpl)assai.getSession()).processRequest(request);
                } else if (activity instanceof DiameterActivityImpl) {
                    this.fireEvent(activity.getSessionId(), (Message)request);
                }
                terminateTx = false;
                txManager.commit();
            }
            catch (Throwable e) {
                this.tracer.severe("Failed to process request.", e);
                if (!terminateTx) break block13;
                try {
                    txManager.rollback();
                }
                catch (Throwable t) {
                    this.tracer.severe(t.getMessage(), t);
                }
            }
        }
        return null;
    }

    public void receivedSuccessMessage(Request req, Answer ans) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: receivedSuccessMessage :: Request[" + req + "], Answer[" + ans + "].");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + ans.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request req) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Base RA :: timeoutExpired :: Request[" + req + "].");
        }
        try {
            this.activities.get(this.getActivityHandle(req.getSessionId())).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    public void sessionCreated(ServerAccSession session) {
        DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        AccountingServerSessionActivityImpl activity = new AccountingServerSessionActivityImpl((DiameterMessageFactory)msgFactory, this.avpFactory, session, null, null, this.stack);
        activity.setSessionListener((Object)this);
        this.addActivity((DiameterActivity)activity);
    }

    public void sessionCreated(ServerAuthSession session) {
        DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        AuthServerSessionActivityImpl activity = new AuthServerSessionActivityImpl((DiameterMessageFactory)msgFactory, this.avpFactory, session, null, null);
        activity.setSessionListener((Object)this);
        this.addActivity((DiameterActivity)activity);
    }

    public void sessionCreated(ClientAuthSession session) {
        DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl((Session)session.getSessions().get(0), this.stack, new DiameterIdentity[0]);
        AuthClientSessionActivityImpl activity = new AuthClientSessionActivityImpl((DiameterMessageFactory)msgFactory, this.avpFactory, session, null, null);
        activity.setSessionListener((Object)this);
        this.addActivity((DiameterActivity)activity);
    }

    public void sessionCreated(ClientAccSession session) {
        DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(this.stack);
        AccountingClientSessionActivityImpl activity = new AccountingClientSessionActivityImpl((DiameterMessageFactory)msgFactory, this.avpFactory, session, null, null);
        activity.setSessionListener((Object)this);
        this.addActivity((DiameterActivity)activity);
    }

    public void sessionCreated(Session session) {
        DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(session, this.stack, new DiameterIdentity[]{null, null});
        DiameterActivityImpl activity = new DiameterActivityImpl((DiameterMessageFactory)msgFactory, this.avpFactory, session, (EventListener)this, null, null);
        activity.setSessionListener((Object)this);
        this.addActivity((DiameterActivity)activity);
    }

    public ApplicationId[] getSupportedApplications() {
        ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>();
        appIds.addAll(this.authApplicationIds);
        appIds.addAll(this.acctApplicationIds);
        return appIds.toArray(new ApplicationId[appIds.size()]);
    }

    public void endActivity(DiameterActivityHandle activityHandle) {
        if (this.activities.containsKey(activityHandle)) {
            this.sleeEndpoint.endActivity((ActivityHandle)activityHandle);
        }
    }

    public void update(DiameterActivityHandle activityHandle, DiameterActivity da) {
        this.activities.update(activityHandle, da);
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        if (source instanceof ServerAuthSession || source instanceof ClientAuthSession) {
            AuthSessionActivityImpl activity = (AuthSessionActivityImpl)this.getActivity((ActivityHandle)this.getActivityHandle(source.getSessionId()));
            activity.stateChanged((Object)source, oldState, newState);
        } else if (source instanceof ServerAccSession || source instanceof ClientAccSession) {
            AccountingSessionActivityImpl activity = (AccountingSessionActivityImpl)this.getActivity((ActivityHandle)this.getActivityHandle(source.getSessionId()));
            activity.stateChanged((Object)source, oldState, newState);
        }
    }

    private class DiameterProviderImpl
    implements DiameterProvider {
        protected final Tracer tracer;
        protected DiameterBaseResourceAdaptor ra;

        public DiameterProviderImpl(DiameterBaseResourceAdaptor ra) {
            this.tracer = DiameterBaseResourceAdaptor.this.getRaContext().getTracer("DiameterProvider");
            this.ra = ra;
        }

        public DiameterActivity createActivity() throws CreateActivityException {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Diameter Base RA :: createActivity");
            }
            return this.createActivity(null, null);
        }

        public DiameterActivity createActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Diameter Base RA :: createActivity :: destinationHost[" + destinationHost + "], destinationRealm[" + destinationRealm + "]");
            }
            return this.createActivity(destinationHost, destinationRealm, null);
        }

        public AuthClientSessionActivity createAuthenticationClientSessionActivity() throws CreateActivityException {
            return this.createAuthenticationClientSessionActivity(null, null);
        }

        public AuthClientSessionActivity createAuthenticationClientSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            try {
                ClientAuthSession session = (ClientAuthSession)((ISessionFactory)DiameterBaseResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, (ApplicationId)DiameterBaseResourceAdaptor.this.authApplicationIds.get(0), ClientAuthSession.class);
                DiameterBaseResourceAdaptor.this.sessionCreated(session);
                return (AuthClientSessionActivity)DiameterBaseResourceAdaptor.this.activities.get(DiameterBaseResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating Authentication Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating Authentication Activity", (Throwable)e);
            }
        }

        public AuthServerSessionActivity createAuthenticationServerActivity(Request request) throws CreateActivityException {
            ServerAuthSession session = null;
            try {
                session = (ServerAuthSession)((ISessionFactory)DiameterBaseResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, (ApplicationId)DiameterBaseResourceAdaptor.this.authApplicationIds.get(0), ServerAuthSession.class, new Object[]{request});
                DiameterBaseResourceAdaptor.this.sessionCreated(session);
                return (AuthServerSessionActivity)DiameterBaseResourceAdaptor.this.activities.get(DiameterBaseResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating Server Authentication Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating Server Authentication Activity", (Throwable)e);
            }
        }

        public AccountingClientSessionActivity createAccountingClientSessionActivity() throws CreateActivityException {
            return this.createAccountingClientSessionActivity(null, null);
        }

        public AccountingClientSessionActivity createAccountingClientSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            try {
                ClientAccSession session = (ClientAccSession)((ISessionFactory)DiameterBaseResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, (ApplicationId)DiameterBaseResourceAdaptor.this.acctApplicationIds.get(0), ClientAccSession.class);
                DiameterBaseResourceAdaptor.this.sessionCreated(session);
                return (AccountingClientSessionActivity)DiameterBaseResourceAdaptor.this.activities.get(DiameterBaseResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating Client Accounting Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating Client Accounting Activity", (Throwable)e);
            }
        }

        public AccountingServerSessionActivity createAccountingServerActivity(Request req) throws CreateActivityException {
            ServerAccSession session = null;
            try {
                ApplicationId appId = req.getApplicationIdAvps().isEmpty() ? null : (ApplicationId)req.getApplicationIdAvps().iterator().next();
                session = (ServerAccSession)((ISessionFactory)DiameterBaseResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(req.getSessionId(), appId, ServerAccSession.class, new Object[]{req});
                if (session == null) {
                    throw new CreateActivityException("Got NULL Session while creating Server Accounting Activity");
                }
                DiameterBaseResourceAdaptor.this.sessionCreated(session);
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating Server Accounting Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating Server Accounting Activity", (Throwable)e);
            }
            return (AccountingServerSessionActivity)DiameterBaseResourceAdaptor.this.activities.get(DiameterBaseResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
        }

        public DiameterActivity createActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm, String sessionId) throws CreateActivityException {
            try {
                Session session = sessionId != null ? DiameterBaseResourceAdaptor.this.proxySessionFactory.getNewSession(sessionId) : DiameterBaseResourceAdaptor.this.proxySessionFactory.getNewSession();
                DiameterBaseResourceAdaptor.this.sessionCreated(session);
                return DiameterBaseResourceAdaptor.this.activities.get(DiameterBaseResourceAdaptor.this.getActivityHandle(session.getSessionId()));
            }
            catch (InternalException e) {
                throw new CreateActivityException("Failure obtaining session for creating activity.", (Throwable)e);
            }
        }

        DiameterActivity createActivity(Message message) throws CreateActivityException {
            String sessionId = message.getSessionId();
            DiameterActivityHandle handle = DiameterBaseResourceAdaptor.this.getActivityHandle(sessionId);
            if (DiameterBaseResourceAdaptor.this.activities.containsKey(handle)) {
                return DiameterBaseResourceAdaptor.this.activities.get(handle);
            }
            DiameterIdentity destinationHost = null;
            DiameterIdentity destinationRealm = null;
            AvpSet avps = message.getAvps();
            Avp raw = null;
            raw = avps.getAvp(293);
            if (raw != null) {
                try {
                    destinationHost = new DiameterIdentity(raw.getDiameterIdentity());
                }
                catch (AvpDataException e) {
                    this.tracer.severe("Unable to obtain Destination Host from Diameter Message.", (Throwable)e);
                }
            }
            if ((raw = avps.getAvp(283)) != null) {
                try {
                    destinationRealm = new DiameterIdentity(raw.getDiameterIdentity());
                }
                catch (AvpDataException e) {
                    this.tracer.severe("Unable to obtain Destination Realm from Diameter Message.", (Throwable)e);
                }
            }
            if (this.isMessageOfType(message, 258)) {
                return this.createAuthenticationServerActivity((Request)message);
            }
            if (this.isMessageOfType(message, 259)) {
                return this.createAccountingServerActivity((Request)message);
            }
            return this.createActivity(destinationHost, destinationRealm, message.getSessionId());
        }

        public DiameterMessageFactory getDiameterMessageFactory() {
            if (this.ra.messageFactory == null) {
                this.ra.messageFactory = (DiameterMessageFactory)new DiameterMessageFactoryImpl(this.ra.stack);
            }
            return this.ra.messageFactory;
        }

        public DiameterAvpFactory getDiameterAvpFactory() {
            if (this.ra.avpFactory == null) {
                this.ra.avpFactory = (DiameterAvpFactory)new DiameterAvpFactoryImpl();
            }
            return this.ra.avpFactory;
        }

        public DiameterMessage sendSyncRequest(DiameterMessage message) throws IOException {
            try {
                if (message instanceof DiameterMessageImpl) {
                    DiameterMessageImpl msg = (DiameterMessageImpl)message;
                    String sessionId = message.getSessionId();
                    DiameterActivityHandle handle = DiameterBaseResourceAdaptor.this.getActivityHandle(sessionId);
                    if (!DiameterBaseResourceAdaptor.this.activities.containsKey(handle)) {
                        this.createActivity(msg.getGenericData());
                    }
                    DiameterActivityImpl activity = (DiameterActivityImpl)DiameterBaseResourceAdaptor.this.getActivity((ActivityHandle)handle);
                    return activity.sendSyncMessage(message);
                }
            }
            catch (JAvpNotAllowedException e) {
                throw new AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
            }
            catch (Exception e) {
                throw new IOException("Failed to send message, due to: " + e.getMessage());
            }
            return null;
        }

        public DiameterIdentity[] getConnectedPeers() {
            if (this.ra.stack != null) {
                try {
                    List peers = ((PeerTable)this.ra.stack.unwrap(PeerTable.class)).getPeerTable();
                    DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                    int i = 0;
                    for (Peer peer : peers) {
                        DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                        result[i++] = identity;
                    }
                    return result;
                }
                catch (Exception e) {
                    this.tracer.severe("Failure getting peer list.", (Throwable)e);
                }
            }
            return null;
        }

        public int getPeerCount() {
            return this.getConnectedPeers().length;
        }

        private boolean isMessageOfType(Message message, int type) {
            try {
                Avp vendorSpecificAvp = null;
                if (message.getAvps().getAvp(type) != null) {
                    return true;
                }
                vendorSpecificAvp = message.getAvps().getAvp(260);
                if (vendorSpecificAvp != null) {
                    return vendorSpecificAvp.getGrouped().getAvp(type) != null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

