/*
 * Decompiled with CFR 0.152.
 */
package net.java.slee.resource.diameter.cca.events.avp;

import java.io.StreamCorruptedException;
import net.java.slee.resource.diameter.base.events.avp.Enumerated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RequestedActionType implements Enumerated
{
    DIRECT_DEBITING(0),
    REFUND_ACCOUNT(1),
    CHECK_BALANCE(2),
    PRICE_ENQUIRY(3);

    private int value = -1;

    private RequestedActionType(int value) {
        this.value = value;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return RequestedActionType.fromInt(this.value);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found: " + this.value);
        }
    }

    public static RequestedActionType fromInt(int type) throws IllegalArgumentException {
        switch (type) {
            case 0: {
                return DIRECT_DEBITING;
            }
            case 1: {
                return REFUND_ACCOUNT;
            }
            case 2: {
                return CHECK_BALANCE;
            }
            case 3: {
                return PRICE_ENQUIRY;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getValue() {
        return this.value;
    }
}

