/*
 * Decompiled with CFR 0.152.
 */
package net.java.slee.resource.diameter.cca.events.avp;

import java.io.StreamCorruptedException;
import net.java.slee.resource.diameter.base.events.avp.Enumerated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CcRequestType implements Enumerated
{
    EVENT_REQUEST(4),
    INITIAL_REQUEST(1),
    TERMINATION_REQUEST(3),
    UPDATE_REQUEST(2);

    public static final int _UPDATE_REQUEST;
    public static final int _TERMINATION_REQUEST;
    public static final int _INITIAL_REQUEST;
    public static final int _EVENT_REQUEST;
    private int value = -1;

    private CcRequestType(int value) {
        this.value = value;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return CcRequestType.fromInt(this.value);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found: " + this.value);
        }
    }

    public static CcRequestType fromInt(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return INITIAL_REQUEST;
            }
            case 2: {
                return UPDATE_REQUEST;
            }
            case 3: {
                return TERMINATION_REQUEST;
            }
            case 4: {
                return EVENT_REQUEST;
            }
        }
        throw new IllegalArgumentException();
    }

    public int getValue() {
        return this.value;
    }

    static {
        _UPDATE_REQUEST = UPDATE_REQUEST.getValue();
        _TERMINATION_REQUEST = TERMINATION_REQUEST.getValue();
        _INITIAL_REQUEST = INITIAL_REQUEST.getValue();
        _EVENT_REQUEST = EVENT_REQUEST.getValue();
    }
}

