/*
 * Decompiled with CFR 0.152.
 */
package net.java.slee.resource.diameter.cca.events.avp;

import java.io.StreamCorruptedException;
import net.java.slee.resource.diameter.base.events.avp.Enumerated;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CcUnitType implements Enumerated
{
    TIME(0),
    MONEY(1),
    TOTAL_OCTETS(2),
    INPUT_OCTETS(3),
    OUTPUT_OCTETS(4),
    SERVICE_SPECIFIC_UNITS(5);

    private int value = -1;

    private CcUnitType(int value) {
        this.value = value;
    }

    private Object readResolve() throws StreamCorruptedException {
        try {
            return CcUnitType.fromInt(this.value);
        }
        catch (IllegalArgumentException iae) {
            throw new StreamCorruptedException("Invalid internal state found: " + this.value);
        }
    }

    public static CcUnitType fromInt(int presumableValue) throws IllegalArgumentException {
        switch (presumableValue) {
            case 0: {
                return TIME;
            }
            case 1: {
                return MONEY;
            }
            case 2: {
                return TOTAL_OCTETS;
            }
            case 3: {
                return INPUT_OCTETS;
            }
            case 4: {
                return OUTPUT_OCTETS;
            }
            case 5: {
                return SERVICE_SPECIFIC_UNITS;
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return super.toString().replace("_", "-");
    }

    public int getValue() {
        return this.value;
    }
}

