/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.management.UnrecognizedResourceAdaptorEntityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.AccountingAnswer;
import net.java.slee.resource.diameter.base.events.AccountingRequest;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentityAvp;
import net.java.slee.resource.diameter.rf.RfActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.rf.RfClientSession;
import net.java.slee.resource.diameter.rf.RfMessageFactory;
import net.java.slee.resource.diameter.rf.RfProvider;
import net.java.slee.resource.diameter.ro.RoAvpFactory;
import org.apache.log4j.Logger;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.acc.ClientAccSession;
import org.jdiameter.api.acc.ServerAccSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.ClientAuthSession;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.acc.ClientAccSessionImpl;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.server.impl.app.acc.ServerAccSessionImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.AccountingRequestImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.avp.DiameterIdentityAvpImpl;
import org.mobicents.slee.resource.diameter.base.handlers.AccountingSessionFactory;
import org.mobicents.slee.resource.diameter.base.handlers.BaseSessionCreationListener;
import org.mobicents.slee.resource.diameter.rf.RfActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.diameter.rf.RfClientSessionImpl;
import org.mobicents.slee.resource.diameter.rf.RfMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.rf.RfServerSessionImpl;
import org.mobicents.slee.resource.diameter.ro.RoAvpFactoryImpl;

public class RfResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
BaseSessionCreationListener {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger(RfResourceAdaptor.class);
    private ResourceAdaptorState state;
    private Stack stack;
    private SessionFactory sessionFactory = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient ConcurrentHashMap<ActivityHandle, DiameterActivity> activities = null;
    private DiameterMessageFactoryImpl baseMessageFactory;
    private DiameterAvpFactoryImpl baseAvpFactory;
    private RfMessageFactoryImpl rfMessageFactory;
    private RoAvpFactoryImpl rfAvpFactory;
    protected RfActivityContextInterfaceFactory acif = null;
    private long messageTimeout = 5000L;
    private AccountingSessionFactory accSessionFactory;
    private RfProviderImpl raProvider;

    public RfResourceAdaptor() {
        logger.info((Object)"Diameter Rf RA :: Constructor called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        logger.info((Object)("Diameter Rf RA :: activityEnded :: handle[" + handle + "."));
        if (this.activities != null) {
            ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
            synchronized (concurrentHashMap) {
                this.activities.remove(handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        logger.info((Object)("Diameter Rf RA :: activityUnreferenced :: handle[" + handle + "]."));
        this.activityEnded(handle);
    }

    public void entityActivated() throws ResourceException {
        logger.info((Object)"Diameter Rf RA :: entityActivated.");
        try {
            logger.info((Object)"Activating Diameter Rf RA Entity");
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            String operation = "getMultiplexerMBean";
            ObjectName diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = SleeContainer.lookupFromJndi().getMBeanServer().invoke(diameterMultiplexerObjectName, operation, params, signature);
            if (object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.raProvider = new RfProviderImpl(this);
            this.initializeNamingContext();
            this.activities = new ConcurrentHashMap();
            this.state = ResourceAdaptorState.CONFIGURED;
            this.initStack();
            this.state = ResourceAdaptorState.ACTIVE;
            this.sessionFactory = this.stack.getSessionFactory();
            this.baseMessageFactory = new DiameterMessageFactoryImpl(this.stack);
            this.rfMessageFactory = new RfMessageFactoryImpl(this.baseMessageFactory, this.stack);
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.rfAvpFactory = new RoAvpFactoryImpl((DiameterAvpFactory)this.baseAvpFactory, this.stack);
            this.sessionFactory = this.stack.getSessionFactory();
            this.accSessionFactory = AccountingSessionFactory.INSTANCE;
            this.accSessionFactory.registerListener((BaseSessionCreationListener)this, this.messageTimeout, this.sessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerAccSession.class, (IAppSessionFactory)this.accSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientAccSession.class, (IAppSessionFactory)this.accSessionFactory);
        }
        catch (Exception e) {
            logger.error((Object)"Error Activating Diameter Rf RA Entity", (Throwable)e);
        }
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        logger.info((Object)("Diameter Rf RA :: entityCreated :: bootstrapContext[" + bootstrapContext + "]."));
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityDeactivated() {
        logger.info((Object)"Diameter Rf RA :: entityDeactivated.");
        logger.info((Object)"Diameter Rf RA :: Cleaning RA Activities.");
        ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
        synchronized (concurrentHashMap) {
            this.activities.clear();
        }
        this.activities = null;
        logger.info((Object)"Diameter Rf RA :: Cleaning naming context.");
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            logger.error((Object)"Diameter Rf RA :: Cannot unbind naming context.");
        }
        logger.info((Object)"Diameter Rf RA :: RA Stopped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityDeactivating() {
        logger.info((Object)"Diameter Rf RA :: entityDeactivating.");
        this.state = ResourceAdaptorState.STOPPING;
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            logger.error((Object)"Failure while unregistering Rf Resource Adaptor from Mux.", (Throwable)e);
        }
        ConcurrentHashMap<ActivityHandle, DiameterActivity> concurrentHashMap = this.activities;
        synchronized (concurrentHashMap) {
            for (ActivityHandle activityHandle : this.activities.keySet()) {
                try {
                    logger.info((Object)("Ending activity [" + activityHandle + "]"));
                    this.activities.get(activityHandle).endActivity();
                }
                catch (Exception e) {
                    logger.error((Object)"Error Deactivating Activity", (Throwable)e);
                }
            }
        }
        logger.info((Object)"Diameter Rf RA :: entityDeactivating completed.");
    }

    public void entityRemoved() {
        this.acif = null;
        this.activities = null;
        this.bootstrapContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
        logger.info((Object)"Diameter Rf RA :: entityRemoved.");
    }

    public void eventProcessingFailed(ActivityHandle handle, Object event, int eventID, Address address, int flags, FailureReason reason) {
        logger.info((Object)("Diameter Rf RA :: eventProcessingFailed :: handle[" + handle + "], event[" + event + "], eventID[" + eventID + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "]."));
    }

    public void eventProcessingSuccessful(ActivityHandle handle, Object event, int eventID, Address address, int flags) {
        logger.info((Object)("Diameter Rf RA :: eventProcessingSuccessful :: handle[" + handle + "], event[" + event + "], eventID[" + eventID + "], address[" + address + "], flags[" + flags + "]."));
    }

    public Object getActivity(ActivityHandle handle) {
        logger.info((Object)("Diameter Rf RA :: getActivity :: handle[" + handle + "]."));
        return this.activities.get(handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        logger.info((Object)("Diameter Rf RA :: getActivityHandle :: activity[" + activity + "]."));
        if (!(activity instanceof DiameterActivity)) {
            logger.warn((Object)"Trying to get activity handle for non-Diameter Activity. Returning null.");
            return null;
        }
        DiameterActivity inActivity = (DiameterActivity)activity;
        for (Map.Entry<ActivityHandle, DiameterActivity> activityInfo : this.activities.entrySet()) {
            DiameterActivity curActivity = activityInfo.getValue();
            if (!curActivity.equals(inActivity)) continue;
            return activityInfo.getKey();
        }
        return null;
    }

    public Marshaler getMarshaler() {
        logger.info((Object)"Diameter Rf RA :: getMarshaler");
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String className) {
        logger.info((Object)("Diameter Rf RA :: getSBBResourceAdaptorInterface :: className[" + className + "]."));
        return this.raProvider;
    }

    public void queryLiveness(ActivityHandle handle) {
        logger.info((Object)("Diameter Rf RA :: queryLiveness :: handle[" + handle + "]."));
        DiameterActivityImpl activity = (DiameterActivityImpl)this.activities.get(handle);
        if (activity != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.activityEnding(handle);
            }
            catch (Exception e) {
                logger.error((Object)"Failure while ending non-live activity.", (Throwable)e);
            }
        }
    }

    public void serviceActivated(String serviceKey) {
        logger.info((Object)("Diameter Rf RA :: serviceActivated :: serviceKey[" + serviceKey + "]."));
    }

    public void serviceDeactivated(String serviceKey) {
        logger.info((Object)("Diameter Rf RA :: serviceDeactivated :: serviceKey[" + serviceKey + "]."));
    }

    public void serviceInstalled(String serviceKey, int[] eventIDs, String[] resourceOptions) {
        logger.info((Object)("Diameter Rf RA :: serviceInstalled :: serviceKey[" + serviceKey + "], eventIDs[" + eventIDs + "], resourceOptions[" + resourceOptions + "]."));
    }

    public void serviceUninstalled(String serviceKey) {
        logger.info((Object)("Diameter Rf RA :: serviceUninstalled :: serviceKey[" + serviceKey + "]."));
    }

    private void initializeNamingContext() throws NamingException {
        ResourceAdaptorEntity resourceAdaptorEntity;
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        try {
            resourceAdaptorEntity = container.getResourceAdaptorEntity(entityName);
        }
        catch (UnrecognizedResourceAdaptorEntityException uraee) {
            throw new NamingException("Failure setting up Naming Context. RA Entity not found.");
        }
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new RfActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                int toind = jndiName.lastIndexOf(47);
                String prefix = jndiName.substring(begind + 1, toind);
                String name = jndiName.substring(toind + 1);
                logger.info((Object)("Diameter Rf RA :: Registering in JNDI :: Prefix[" + prefix + "], Name[" + name + "]."));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
                logger.info((Object)"Diameter Rf RA :: Registered in JNDI successfully.");
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            logger.info((Object)"Failure initializing name context.", (Throwable)iobe);
        }
    }

    private void cleanNamingContext() throws NamingException {
        try {
            if (this.acif != null) {
                String jndiName = this.acif.getJndiName();
                int begind = jndiName.indexOf(58);
                String javaJNDIName = jndiName.substring(begind + 1);
                logger.info((Object)("Diameter Rf RA :: Unregistering from JNDI :: Name[" + javaJNDIName + "]."));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.info((Object)"Diameter Rf RA :: Unregistered from JNDI successfully.");
            }
        }
        catch (IndexOutOfBoundsException iobe) {
            logger.error((Object)"Failure cleaning name context.", (Throwable)iobe);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, new ApplicationId[]{ApplicationId.createByAccAppId((long)0L, (long)3L)});
        this.stack = this.diameterMux.getStack();
        this.messageTimeout = this.stack.getMetaData().getConfiguration().getLongValue(Parameters.MessageTimeOut.ordinal(), ((Long)Parameters.MessageTimeOut.defValue()).longValue());
        logger.info((Object)"Diameter Rf RA :: Successfully initialized stack.");
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    private void activityCreated(DiameterActivity ac) {
        logger.info((Object)("Diameter Rf RA :: activityCreated :: activity[" + ac + "]"));
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            this.sleeEndpoint.activityStarted((ActivityHandle)activity.getActivityHandle());
            this.activities.put((ActivityHandle)activity.getActivityHandle(), (DiameterActivity)activity);
            logger.info((Object)("Activity started [" + activity.getActivityHandle() + "]"));
        }
        catch (Exception e) {
            logger.error((Object)"Error creating activity", (Throwable)e);
            throw new RuntimeException("Error creating activity", e);
        }
    }

    private DiameterMessage createEvent(Request request, Answer answer) throws OperationNotSupportedException {
        if (request == null && answer == null) {
            return null;
        }
        int commandCode = request != null ? request.getCommandCode() : answer.getCommandCode();
        switch (commandCode) {
            case 271: {
                return request != null ? new AccountingRequestImpl((Message)request) : new AccountingAnswerImpl((Message)answer);
            }
            case -1: {
                if (answer != null) {
                    return new ErrorAnswerImpl((Message)answer);
                }
                throw new IllegalArgumentException("ErrorAnswer code set on request: " + request);
            }
        }
        throw new OperationNotSupportedException("Not supported message code:" + commandCode + "\n" + (request != null ? request : answer));
    }

    private void fireEvent(ActivityHandle handle, String name, Request request, Answer answer) {
        try {
            int eventID = this.eventLookup.getEventID("net.java.slee.resource.diameter.base.events." + name, "java.net", "0.8");
            DiameterMessage event = this.createEvent(request, answer);
            this.sleeEndpoint.fireEvent(handle, (Object)event, eventID, null);
        }
        catch (Exception e) {
            logger.warn((Object)"Can not send event", (Throwable)e);
        }
    }

    public Answer processRequest(Request request) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)this.raProvider.createActivity((Message)request);
            if (activity instanceof RfServerSessionImpl) {
                RfServerSessionImpl assai = (RfServerSessionImpl)activity;
                ((ServerAccSessionImpl)assai.getSession()).processRequest(request);
            } else if (activity instanceof RfClientSessionImpl) {
                RfClientSessionImpl assai = (RfClientSessionImpl)activity;
                ((ClientAccSessionImpl)assai.getSession()).processRequest(request);
            }
        }
        catch (CreateActivityException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request req, Answer ans) {
        logger.info((Object)("Diameter Rf RA :: receivedSuccessMessage :: Request[" + req + "], Answer[" + ans + "]."));
        try {
            logger.info((Object)("Received Message Result-Code: " + ans.getResultCode().getUnsigned32()));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request req) {
        logger.info((Object)("Diameter Base RA :: timeoutExpired :: Request[" + req + "]."));
        DiameterActivityHandle ah = new DiameterActivityHandle(req.getSessionId());
        try {
            this.activities.get(ah).endActivity();
        }
        catch (Exception e) {
            logger.error((Object)"Failure processing timeout message.", (Throwable)e);
        }
    }

    public void fireEvent(String sessionId, String name, Request request, Answer answer) {
        this.fireEvent((ActivityHandle)this.getActivityHandle(sessionId), name, request, answer);
    }

    public void sessionCreated(ClientAccSession session) {
        DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(this.stack);
        RfClientSessionImpl activity = new RfClientSessionImpl(msgFactory, this.baseAvpFactory, session, this.messageTimeout, null, null, this.sleeEndpoint, this.stack);
        activity.setSessionListener(this);
        session.addStateChangeNotification((StateChangeListener)activity);
        this.activityCreated((DiameterActivity)activity);
    }

    public void sessionCreated(ServerAccSession session) {
        DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(this.stack);
        RfServerSessionImpl activity = new RfServerSessionImpl(msgFactory, this.baseAvpFactory, session, this.messageTimeout, null, null, this.sleeEndpoint, this.stack);
        session.addStateChangeNotification((StateChangeListener)activity);
        activity.setSessionListener(this);
        this.activityCreated((DiameterActivity)activity);
    }

    public void sessionCreated(ServerAuthSession session) {
        logger.error((Object)"Unexpected Auth Session at Rf Resource Adaptor.");
    }

    public void sessionCreated(ClientAuthSession session) {
        logger.error((Object)"Unexpected Auth Session at Rf Resource Adaptor.");
    }

    public void sessionCreated(Session session) {
        if (session instanceof ServerAccSession) {
            this.sessionCreated((ServerAccSession)session);
        } else if (session instanceof ClientAccSession) {
            this.sessionCreated((ClientAccSession)session);
        } else {
            logger.error((Object)("Diameter Rf RA :: Unexpected Session [" + session + "]"));
        }
    }

    public void sessionDestroyed(String sessionId, Object appSession) {
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            logger.error((Object)("Failure Ending Activity with Session-Id[" + sessionId + "]"), (Throwable)e);
        }
    }

    public boolean sessionExists(String sessionId) {
        return this.activities.containsKey(this.getActivityHandle(sessionId));
    }

    public ApplicationId[] getSupportedApplications() {
        return new ApplicationId[]{ApplicationId.createByAccAppId((long)0L, (long)3L)};
    }

    private class RfProviderImpl
    implements RfProvider {
        protected final Logger logger = Logger.getLogger(RfProviderImpl.class);
        protected RfResourceAdaptor ra;
        protected RoAvpFactory avpFactory = null;
        protected DiameterMessageFactory messageFactory = null;

        public RfProviderImpl(RfResourceAdaptor rfResourceAdaptor2) {
            this.ra = rfResourceAdaptor2;
        }

        private DiameterActivity createActivity(Message message) throws CreateActivityException {
            String sessionId = message.getSessionId();
            DiameterActivityHandle handle = new DiameterActivityHandle(sessionId);
            if (RfResourceAdaptor.this.activities.keySet().contains(handle)) {
                return (DiameterActivity)RfResourceAdaptor.this.activities.get(handle);
            }
            if (message.isRequest()) {
                return this.createRfServerSessionActivity((Request)message);
            }
            AvpSet avps = message.getAvps();
            Avp avp = null;
            DiameterIdentityAvpImpl destinationHost = null;
            DiameterIdentityAvpImpl destinationRealm = null;
            avp = avps.getAvp(293);
            if (avp != null) {
                try {
                    destinationHost = new DiameterIdentityAvpImpl(293, avp.getVendorId(), 1, 0, avp.getRaw());
                }
                catch (AvpDataException e) {
                    this.logger.error((Object)"Failed to extract Destination-Host from Message.", (Throwable)e);
                }
            }
            if ((avp = avps.getAvp(283)) != null) {
                try {
                    destinationRealm = new DiameterIdentityAvpImpl(283, 0L, 1, 0, avp.getRaw());
                }
                catch (AvpDataException e) {
                    this.logger.error((Object)"Failed to extract Destination-Realm from Message.", (Throwable)e);
                }
            }
            return this.createRfClientSessionActivity((DiameterIdentityAvp)destinationHost, (DiameterIdentityAvp)destinationRealm);
        }

        private DiameterActivity createRfServerSessionActivity(Request request) throws CreateActivityException {
            ServerAccSession session = null;
            try {
                ApplicationId appId = request.getApplicationIdAvps().isEmpty() ? null : (ApplicationId)request.getApplicationIdAvps().iterator().next();
                session = (ServerAccSession)((ISessionFactory)RfResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(request.getSessionId(), appId, ServerAccSession.class, new Object[]{request});
                if (session == null) {
                    throw new CreateActivityException("Got NULL Session while creating Server Accounting Activity");
                }
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating Server Accounting Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating Server Accounting Activity", (Throwable)e);
            }
            return (RfServerSessionImpl)((Object)RfResourceAdaptor.this.activities.get(RfResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId())));
        }

        public RfClientSession createRfClientSessionActivity() throws CreateActivityException {
            return this.createRfClientSessionActivity(null, null);
        }

        public RfClientSession createRfClientSessionActivity(DiameterIdentityAvp destinationHost, DiameterIdentityAvp destinationRealm) throws CreateActivityException {
            try {
                ClientAccSession session = (ClientAccSession)((ISessionFactory)RfResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, ApplicationId.createByAccAppId((long)0L, (long)3L), ClientAccSession.class);
                return new RfClientSessionImpl(this.ra.rfMessageFactory, (DiameterAvpFactoryImpl)RfResourceAdaptor.this.rfAvpFactory.getBaseFactory(), session, this.ra.messageTimeout, destinationHost, destinationRealm, this.ra.sleeEndpoint, RfResourceAdaptor.this.stack);
            }
            catch (Exception e) {
                throw new CreateActivityException("Internal exception while creating Client Accounting Activity", (Throwable)e);
            }
        }

        public RfMessageFactory getRfMessageFactory() {
            return this.ra.rfMessageFactory;
        }

        public AccountingAnswer sendAccountingRequest(AccountingRequest accountingRequest) {
            try {
                String sessionId = accountingRequest.getSessionId();
                DiameterActivityHandle handle = new DiameterActivityHandle(sessionId);
                if (!RfResourceAdaptor.this.activities.keySet().contains(handle)) {
                    this.createActivity(((DiameterMessageImpl)accountingRequest).getGenericData());
                }
                DiameterActivityImpl activity = (DiameterActivityImpl)RfResourceAdaptor.this.getActivity((ActivityHandle)handle);
                return (AccountingAnswer)activity.sendSyncMessage((DiameterMessage)accountingRequest);
            }
            catch (Exception e) {
                this.logger.error((Object)"Failure sending sync request.", (Throwable)e);
                return null;
            }
        }
    }
}

