/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import java.io.IOException;
import java.util.ArrayList;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.diameter.base.events.AccountingAnswer;
import net.java.slee.resource.diameter.base.events.AccountingRequest;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rf.RfMessageFactory;
import net.java.slee.resource.diameter.rf.RfServerSession;
import org.jdiameter.api.Stack;
import org.jdiameter.api.acc.ServerAccSession;
import org.mobicents.slee.resource.diameter.base.AccountingServerSessionActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.rf.RfMessageFactoryImpl;

public class RfServerSessionImpl
extends AccountingServerSessionActivityImpl
implements RfServerSession {
    protected RfMessageFactory rfMessageFactory = null;
    protected DiameterIdentity remoteRealm;
    protected ArrayList<DiameterMessageImpl> stateMessages = new ArrayList();

    public RfServerSessionImpl(DiameterMessageFactoryImpl messageFactory, DiameterAvpFactoryImpl avpFactory, ServerAccSession serverSession, long timeout, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, SleeEndpoint endpoint, Stack stack) {
        super(messageFactory, avpFactory, serverSession, timeout, destinationHost, destinationRealm, endpoint, stack);
        this.rfMessageFactory = new RfMessageFactoryImpl(messageFactory, stack);
    }

    public AccountingAnswer createRfAccountingAnswer() {
        AccountingAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 271) continue;
            AccountingRequest msg = (AccountingRequest)this.stateMessages.get(index);
            answer = super.createAccountAnswer(msg);
            if (!answer.hasSessionId() && this.session != null) {
                answer.setSessionId(this.session.getSessionId());
            }
            answer.setAcctApplicationId(3L);
            ((DiameterMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public AccountingAnswer createRfAccountingAnswer(AccountingRequest acr) {
        return super.createAccountAnswer(acr);
    }

    public void sendAccountingAnswer(AccountingAnswer accountingAnswer) throws IOException, IllegalArgumentException {
        super.sendAccountAnswer(accountingAnswer);
        this.clean((DiameterMessageImpl)accountingAnswer);
    }

    public RfMessageFactory getRfMessageFactory() {
        return this.rfMessageFactory;
    }

    public void fetchSessionData(DiameterMessage msg, boolean incoming) {
        if (msg.getHeader().isRequest() && incoming) {
            if (this.remoteRealm == null) {
                this.remoteRealm = msg.getOriginRealm();
            }
            this.stateMessages.add((DiameterMessageImpl)msg);
        }
    }

    private void clean(DiameterMessageImpl msg) {
        if (msg.getData() != null) {
            this.stateMessages.remove(msg.removeData());
        }
    }
}

