/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import java.io.IOException;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.avp.AccountingRecordType;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rf.RfClientSessionActivity;
import net.java.slee.resource.diameter.rf.RfMessageFactory;
import net.java.slee.resource.diameter.rf.RfSessionState;
import net.java.slee.resource.diameter.rf.events.RfAccountingRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.rf.ClientRfSession;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.rf.ClientRfSessionState;
import org.jdiameter.common.impl.app.rf.RfAccountingRequestImpl;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.rf.RfMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.rf.RfSessionActivityImpl;

public class RfClientSessionActivityImpl
extends RfSessionActivityImpl
implements RfClientSessionActivity {
    private static final long serialVersionUID = -896041231173969408L;
    protected transient RfMessageFactory rfMessageFactory = null;
    protected transient ClientRfSession clientSession = null;

    public RfClientSessionActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, ClientRfSession clientSession, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(messageFactory, avpFactory, null, (EventListener<Request, Answer>)((EventListener)clientSession), destinationHost, destinationRealm);
        this.setSession(clientSession);
        this.rfMessageFactory = new RfMessageFactoryImpl((DiameterMessageFactory)((DiameterMessageFactoryImpl)messageFactory), clientSession.getSessionId(), stack);
        super.setCurrentWorkingSession((Session)this.clientSession.getSessions().get(0));
    }

    public RfAccountingRequest createRfAccountingRequest(AccountingRecordType accountingRecordType) {
        RfAccountingRequest acr = this.rfMessageFactory.createRfAccountingRequest(accountingRecordType);
        acr.setAcctApplicationId(3L);
        acr.setAccountingRecordType(accountingRecordType);
        return acr;
    }

    public void sendRfAccountingRequest(RfAccountingRequest request) throws IOException {
        DiameterMessageImpl msg = (DiameterMessageImpl)request;
        try {
            this.clientSession.sendAccountRequest((org.jdiameter.api.rf.events.RfAccountingRequest)new RfAccountingRequestImpl((Request)msg.getGenericData()));
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message, due to: ", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e);
        }
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        ClientRfSessionState state = (ClientRfSessionState)newState;
        switch (state) {
            case IDLE: {
                if (oldState == state) break;
                this.endActivity();
                break;
            }
            case OPEN: {
                break;
            }
            case PENDING_EVENT: {
                break;
            }
            case PENDING_START: {
                break;
            }
            case PENDING_INTERIM: {
                break;
            }
            case PENDING_CLOSE: {
                break;
            }
        }
    }

    public ClientRfSession getSession() {
        return this.clientSession;
    }

    public RfSessionState getRfSessionState() {
        ClientRfSessionState state = (ClientRfSessionState)this.clientSession.getState(ClientRfSessionState.class);
        switch (state) {
            case IDLE: {
                return RfSessionState.Idle;
            }
            case OPEN: {
                return RfSessionState.Open;
            }
            case PENDING_EVENT: {
                return RfSessionState.PendingE;
            }
            case PENDING_START: {
                return RfSessionState.PendingS;
            }
            case PENDING_INTERIM: {
                return RfSessionState.PendingI;
            }
            case PENDING_CLOSE: {
                return RfSessionState.PendingC;
            }
            case PENDING_BUFFERED: {
                return RfSessionState.PendingB;
            }
        }
        logger.error((Object)("Unexpected state in Accounting Client FSM: " + state));
        return null;
    }

    public void setSession(ClientRfSession clientSession) {
        this.clientSession = clientSession;
        this.clientSession.addStateChangeNotification((StateChangeListener)this);
        this.eventListener = (EventListener)clientSession;
    }

    public void endActivity() {
        this.clientSession.release();
        this.baseListener.endActivity(this.getActivityHandle());
    }

    public RfMessageFactory getRfMessageFactory() {
        return this.rfMessageFactory;
    }

    public void setRfMessageFactory(RfMessageFactory rfMessageFactory) {
        this.rfMessageFactory = rfMessageFactory;
    }
}

