/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterHeader;
import net.java.slee.resource.diameter.base.events.avp.AccountingRecordType;
import net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.GroupedAvp;
import net.java.slee.resource.diameter.rf.RfMessageFactory;
import net.java.slee.resource.diameter.rf.events.RfAccountingMessage;
import net.java.slee.resource.diameter.rf.events.RfAccountingRequest;
import org.apache.log4j.Logger;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Stack;
import org.mobicents.slee.resource.diameter.rf.events.RfAccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.rf.events.RfAccountingRequestImpl;

public class RfMessageFactoryImpl
implements RfMessageFactory {
    protected DiameterMessageFactory baseFactory = null;
    protected String sessionId;
    protected Stack stack;
    protected Logger logger = Logger.getLogger(this.getClass());

    public RfMessageFactoryImpl(DiameterMessageFactory baseFactory, String sessionId, Stack stack) {
        this.baseFactory = baseFactory;
        this.sessionId = sessionId;
        this.stack = stack;
    }

    public RfAccountingRequest createRfAccountingRequest(AccountingRecordType accountingrecordtype) {
        DiameterAvp[] avps = new DiameterAvp[]{};
        RfAccountingRequest acr = (RfAccountingRequest)this.createRfAccountingRequest(null, avps);
        if (this.sessionId != null) {
            acr.setSessionId(this.sessionId);
        }
        acr.setAccountingRecordType(accountingrecordtype);
        return acr;
    }

    private RfAccountingMessage createRfAccountingRequest(DiameterHeader diameterHeader, DiameterAvp[] avps) throws IllegalArgumentException {
        boolean isRequest = diameterHeader == null;
        RfAccountingAnswerImpl msg = null;
        if (!isRequest) {
            Message raw = this.createMessage(diameterHeader, avps);
            raw.setProxiable(true);
            raw.setRequest(false);
            msg = new RfAccountingAnswerImpl(raw);
        } else {
            Message raw = this.createMessage(null, avps);
            raw.setProxiable(true);
            raw.setRequest(true);
            msg = new RfAccountingRequestImpl(raw);
        }
        return msg;
    }

    public Message createMessage(DiameterHeader header, DiameterAvp[] avps) throws AvpNotAllowedException {
        Message msg = this.createRawMessage(header);
        AvpSet set = msg.getAvps();
        for (DiameterAvp avp : avps) {
            this.addAvp(avp, set);
        }
        return msg;
    }

    protected Message createRawMessage(DiameterHeader header) {
        int commandCode = 0;
        long endToEndId = 0L;
        long hopByHopId = 0L;
        ApplicationId aid = ApplicationId.createByAccAppId((long)0L, (long)3L);
        if (header != null) {
            commandCode = header.getCommandCode();
            endToEndId = header.getEndToEndId();
            hopByHopId = header.getHopByHopId();
        } else {
            commandCode = 271;
        }
        try {
            if (header != null) {
                return this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, aid, hopByHopId, endToEndId, new Avp[0]);
            }
            return this.stack.getSessionFactory().getNewRawSession().createMessage(commandCode, aid, new Avp[0]);
        }
        catch (IllegalDiameterStateException e) {
            this.logger.error((Object)"Failed to get session factory for message creation.", (Throwable)e);
        }
        catch (InternalException e) {
            this.logger.error((Object)"Failed to create new raw session for message creation.", (Throwable)e);
        }
        return null;
    }

    protected void addAvp(DiameterAvp avp, AvpSet set) {
        if (avp instanceof GroupedAvp) {
            DiameterAvp[] groupedAVPs;
            AvpSet avpSet = set.addGroupedAvp(avp.getCode(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
            for (DiameterAvp avpFromGroup : groupedAVPs = ((GroupedAvp)avp).getExtensionAvps()) {
                this.addAvp(avpFromGroup, avpSet);
            }
        } else if (avp != null) {
            set.addAvp(avp.getCode(), avp.byteArrayValue(), avp.getVendorId(), avp.getMandatoryRule() == 1, avp.getProtectedRule() == 1);
        }
    }

    public DiameterMessageFactory getBaseMessageFactory() {
        return this.baseFactory;
    }

    public RfAccountingRequest createRfAccountingRequest(String sessionId, AccountingRecordType accountingRecordType) {
        RfAccountingRequest req = this.createRfAccountingRequest(accountingRecordType);
        if (sessionId != null) {
            req.setSessionId(sessionId);
        }
        return req;
    }
}

