/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import java.io.IOException;
import java.util.ArrayList;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rf.RfMessageFactory;
import net.java.slee.resource.diameter.rf.RfServerSessionActivity;
import net.java.slee.resource.diameter.rf.RfSessionState;
import net.java.slee.resource.diameter.rf.events.RfAccountingAnswer;
import net.java.slee.resource.diameter.rf.events.RfAccountingRequest;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.rf.ServerRfSession;
import org.jdiameter.api.validation.AvpNotAllowedException;
import org.jdiameter.common.api.app.rf.ServerRfSessionState;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.rf.RfMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.rf.RfSessionActivityImpl;
import org.mobicents.slee.resource.diameter.rf.events.RfAccountingAnswerImpl;

public class RfServerSessionActivityImpl
extends RfSessionActivityImpl
implements RfServerSessionActivity {
    private static final long serialVersionUID = -4463687722140594904L;
    protected transient RfMessageFactory rfMessageFactory = null;
    protected transient ArrayList<DiameterMessageImpl> stateMessages = new ArrayList();
    protected transient ServerRfSession serverSession = null;
    protected String originHost = "aaa://127.0.0.1:3868";
    protected String originRealm = "mobicents.org";

    public RfServerSessionActivityImpl(DiameterMessageFactory messageFactory, DiameterAvpFactory avpFactory, ServerRfSession serverSession, DiameterIdentity destinationHost, DiameterIdentity destinationRealm, Stack stack) {
        super(messageFactory, avpFactory, null, (EventListener<Request, Answer>)((EventListener)serverSession), destinationHost, destinationRealm);
        this.originHost = stack.getMetaData().getLocalPeer().getUri().toString();
        this.originRealm = stack.getMetaData().getLocalPeer().getRealmName();
        this.setSession(serverSession);
        super.setCurrentWorkingSession((Session)this.serverSession.getSessions().get(0));
        this.rfMessageFactory = new RfMessageFactoryImpl((DiameterMessageFactory)((DiameterMessageFactoryImpl)messageFactory), serverSession.getSessionId(), stack);
    }

    public RfAccountingAnswer createRfAccountingAnswer(RfAccountingRequest request) {
        try {
            DiameterMessageImpl implRequest = (DiameterMessageImpl)request;
            Message rawMessage = implRequest.getGenericData();
            DiameterAvp accRecordNumber = this.avpFactory.createAvp(485, rawMessage.getAvps().getAvp(485).getRaw());
            DiameterAvp accRecordType = this.avpFactory.createAvp(480, rawMessage.getAvps().getAvp(480).getRaw());
            DiameterAvp originHost = this.avpFactory.createAvp(264, this.originHost.getBytes());
            DiameterAvp originRealm = this.avpFactory.createAvp(296, this.originRealm.getBytes());
            DiameterAvp sessionId = this.avpFactory.createAvp(263, ((Session)this.serverSession.getSessions().get(0)).getSessionId());
            DiameterMessageImpl answer = (DiameterMessageImpl)this.messageFactory.createMessage(implRequest.getHeader(), new DiameterAvp[]{accRecordNumber, accRecordType, originHost, originRealm, sessionId});
            if (request.hasAcctApplicationId()) {
                answer.addAvp(this.avpFactory.createAvp(259, request.getAcctApplicationId()));
            }
            Message rawAnswer = answer.getGenericData();
            rawAnswer.setRequest(false);
            RfAccountingAnswerImpl ans = new RfAccountingAnswerImpl(rawAnswer);
            ans.setData((Object)request);
            return ans;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public RfAccountingAnswer createRfAccountingAnswer(RfAccountingRequest request, int resultCode) {
        RfAccountingAnswer answer = this.createRfAccountingAnswer(request);
        answer.setResultCode((long)resultCode);
        return answer;
    }

    public void sendRfAccountingAnswer(RfAccountingAnswer answer) throws IOException {
        try {
            RfAccountingAnswerImpl aca = (RfAccountingAnswerImpl)answer;
            this.serverSession.sendAccountAnswer((org.jdiameter.api.rf.events.RfAccountingAnswer)new org.jdiameter.common.impl.app.rf.RfAccountingAnswerImpl((Answer)aca.getGenericData()));
            if (this.isTerminateAfterProcessing()) {
                this.endActivity();
            }
            this.clean((DiameterMessageImpl)aca);
        }
        catch (AvpNotAllowedException e) {
            throw new net.java.slee.resource.diameter.base.events.avp.AvpNotAllowedException("Message validation failed.", (Throwable)e, e.getAvpCode(), e.getVendorId());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to send message, due to: ", (Throwable)e);
            }
            throw new IOException("Failed to send message, due to: " + e.getMessage());
        }
    }

    public ServerRfSession getSession() {
        return this.serverSession;
    }

    public void stateChanged(AppSession source, Enum oldState, Enum newState) {
        this.stateChanged(oldState, newState);
    }

    public void stateChanged(Enum oldState, Enum newState) {
        if (newState == ServerRfSessionState.IDLE) {
            this.setTerminateAfterProcessing(true);
        }
    }

    public RfSessionState getRfSessionState() {
        ServerRfSessionState state = (ServerRfSessionState)this.serverSession.getState(ServerRfSessionState.class);
        switch (state) {
            case IDLE: {
                return RfSessionState.Idle;
            }
            case OPEN: {
                return RfSessionState.Open;
            }
        }
        logger.error((Object)("Unexpected state in Accounting Server FSM: " + state));
        return null;
    }

    public RfAccountingAnswer createRfAccountingAnswer() {
        RfAccountingAnswer answer = null;
        for (int index = 0; index < this.stateMessages.size(); ++index) {
            if (this.stateMessages.get(index).getCommand().getCode() != 271) continue;
            RfAccountingRequest msg = (RfAccountingRequest)this.stateMessages.get(index);
            answer = this.createRfAccountingAnswer(msg);
            if (!answer.hasSessionId() && this.session != null) {
                answer.setSessionId(this.session.getSessionId());
            }
            answer.setAcctApplicationId(3L);
            ((DiameterMessageImpl)answer).setData((Object)msg);
            break;
        }
        return answer;
    }

    public void fetchSessionData(DiameterMessage msg, boolean incoming) {
        if (msg.getHeader().isRequest() && incoming) {
            this.stateMessages.add((DiameterMessageImpl)msg);
        }
    }

    private void clean(DiameterMessageImpl msg) {
        if (msg.getData() != null) {
            this.stateMessages.remove(msg.removeData());
        }
    }

    public void setSession(ServerRfSession appSession) {
        this.serverSession = appSession;
        this.serverSession.addStateChangeNotification((StateChangeListener)this);
        this.eventListener = (EventListener)appSession;
    }

    public String toString() {
        return super.toString() + "['" + this.isTerminateAfterProcessing() + "']-" + this.serverSession + "-" + this.eventListener + "-" + this.session + "-" + this.baseListener;
    }

    public void endActivity() {
        this.serverSession.release();
        this.baseListener.endActivity(this.getActivityHandle());
    }

    public RfMessageFactory getRfMessageFactory() {
        return this.rfMessageFactory;
    }

    public void setRfMessageFactory(RfMessageFactory rfMessageFactory) {
        this.rfMessageFactory = rfMessageFactory;
    }
}

