/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.AdditionalContentInformation;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class AdditionalContentInformationImpl
extends GroupedAvpImpl
implements AdditionalContentInformation {
    private static final Logger logger = Logger.getLogger(AdditionalContentInformationImpl.class);

    public AdditionalContentInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getAdditionalTypeInformation() {
        if (this.hasAdditionalTypeInformation()) {
            Avp rawAvp = this.avpSet.getAvp(1205, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1205L);
                logger.error((Object)"Failure while trying to obtain Additional-Type-Information AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public long getContentSize() {
        if (this.hasContentSize()) {
            Avp rawAvp = this.avpSet.getAvp(1206, 10415L);
            try {
                return rawAvp.getUnsigned32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1206L);
                logger.error((Object)"Failure while trying to obtain Content-Size AVP.", (Throwable)e);
            }
        }
        return -1L;
    }

    public int getTypeNumber() {
        if (this.hasTypeNumber()) {
            Avp rawAvp = this.avpSet.getAvp(1204, 10415L);
            try {
                return rawAvp.getInteger32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1204L);
                logger.error((Object)"Failure while trying to obtain Type-Number AVP.", (Throwable)e);
            }
        }
        return -1;
    }

    public boolean hasAdditionalTypeInformation() {
        return this.hasAvp(1205, 10415L);
    }

    public boolean hasContentSize() {
        return this.hasAvp(1206, 10415L);
    }

    public boolean hasTypeNumber() {
        return this.hasAvp(1204, 10415L);
    }

    public void setAdditionalTypeInformation(String additionalTypeInformation) {
        if (this.hasAdditionalTypeInformation()) {
            throw new IllegalStateException("AVP Additional-Type-Information is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1205, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1205, additionalTypeInformation, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setContentSize(long contentSize) {
        if (this.hasContentSize()) {
            throw new IllegalStateException("AVP Content-Size is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1206, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1206, contentSize, 10415L, mandatoryAvp, protectedAvp, true);
    }

    public void setTypeNumber(int typeNumber) {
        if (this.hasTypeNumber()) {
            throw new IllegalStateException("AVP Type-Number is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1204, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1204, (long)typeNumber, 10415L, mandatoryAvp, protectedAvp, true);
    }
}

