/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.AddressDomain;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class AddressDomainImpl
extends GroupedAvpImpl
implements AddressDomain {
    private static final Logger logger = Logger.getLogger(AddressDomainImpl.class);

    public AddressDomainImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getDomainName() {
        if (this.hasDomainName()) {
            Avp rawAvp = this.avpSet.getAvp(1200, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 1200L);
                logger.error((Object)"Failure while trying to obtain Domain-Name AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getTgppImsiMccMnc() {
        if (this.hasDomainName()) {
            Avp rawAvp = this.avpSet.getAvp(8, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 8L);
                logger.error((Object)"Failure while trying to obtain 3GPP-IMSI-MCC-MNC AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasDomainName() {
        return this.hasAvp(1200, 10415L);
    }

    public boolean hasTgppImsiMccMnc() {
        return this.hasAvp(8, 10415L);
    }

    public void setDomainName(String domainName) {
        if (this.hasDomainName()) {
            throw new IllegalStateException("AVP Domain-Name is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1200, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1200, domainName, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setTgppImsiMccMnc(byte[] tgppImsiMccMnc) {
        if (this.hasTgppImsiMccMnc()) {
            throw new IllegalStateException("AVP 3GPP-IMSI-MCC-MNC is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(8, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(8, tgppImsiMccMnc, 10415L, mandatoryAvp, protectedAvp);
    }
}

