/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.ApplicationServerInformation;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class ApplicationServerInformationImpl
extends GroupedAvpImpl
implements ApplicationServerInformation {
    private static final Logger logger = Logger.getLogger(ApplicationServerInformationImpl.class);

    public ApplicationServerInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String[] getApplicationProvidedCalledPartyAddresses() {
        String[] applicationProvidedCalledPartyAddresses = null;
        AvpSet rawAvps = this.avpSet.getAvps(837, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            applicationProvidedCalledPartyAddresses = new String[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    applicationProvidedCalledPartyAddresses[i] = rawAvps.getAvpByIndex(i).getUTF8String();
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 837L);
                    logger.error((Object)("Failure while trying to obtain Application-Provided-Called-Party-Address AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return applicationProvidedCalledPartyAddresses;
    }

    public String getApplicationServer() {
        if (this.hasApplicationServer()) {
            Avp rawAvp = this.avpSet.getAvp(836, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 836L);
                logger.error((Object)"Failure while trying to obtain Application-Server AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasApplicationServer() {
        return this.hasAvp(836, 10415L);
    }

    public void setApplicationProvidedCalledPartyAddress(String applicationProvidedCalledPartyAddress) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1205, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(1205, applicationProvidedCalledPartyAddress, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setApplicationProvidedCalledPartyAddresses(String[] applicationProvidedCalledPartyAddresses) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(1205, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (String applicationProvidedCalledPartyAddress : applicationProvidedCalledPartyAddresses) {
            this.avpSet.addAvp(1205, applicationProvidedCalledPartyAddress, 10415L, mandatoryAvp, protectedAvp, false);
        }
    }

    public void setApplicationServer(String applicationServer) {
        if (this.hasApplicationServer()) {
            throw new IllegalStateException("AVP Application-Server is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(836, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(836, applicationServer, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

