/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.EventType;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class EventTypeImpl
extends GroupedAvpImpl
implements EventType {
    private static final Logger logger = Logger.getLogger(EventTypeImpl.class);

    public EventTypeImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getEvent() {
        if (this.hasEvent()) {
            Avp rawAvp = this.avpSet.getAvp(825, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 825L);
                logger.error((Object)"Failure while trying to obtain Event AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public long getExpires() {
        if (this.hasExpires()) {
            Avp rawAvp = this.avpSet.getAvp(888, 10415L);
            try {
                return rawAvp.getUnsigned32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 888L);
                logger.error((Object)"Failure while trying to obtain Expires AVP.", (Throwable)e);
            }
        }
        return -1L;
    }

    public String getSipMethod() {
        if (this.hasSipMethod()) {
            Avp rawAvp = this.avpSet.getAvp(824, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 824L);
                logger.error((Object)"Failure while trying to obtain SIP-Method AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasEvent() {
        return this.hasAvp(825, 10415L);
    }

    public boolean hasExpires() {
        return this.hasAvp(888, 10415L);
    }

    public boolean hasSipMethod() {
        return this.hasAvp(824, 10415L);
    }

    public void setEvent(String event) {
        if (this.hasEvent()) {
            throw new IllegalStateException("AVP Event is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(825, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(825, event, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setExpires(long expires) {
        if (this.hasExpires()) {
            throw new IllegalStateException("AVP Expires is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(888, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(888, expires, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setSipMethod(String sipMethod) {
        if (this.hasSipMethod()) {
            throw new IllegalStateException("AVP SIP-Method is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(824, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(824, sipMethod, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

