/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.base.events.avp.AddressAvp;
import net.java.slee.resource.diameter.ro.events.avp.ApplicationServerInformation;
import net.java.slee.resource.diameter.ro.events.avp.EventType;
import net.java.slee.resource.diameter.ro.events.avp.ImsInformation;
import net.java.slee.resource.diameter.ro.events.avp.InterOperatorIdentifier;
import net.java.slee.resource.diameter.ro.events.avp.MessageBody;
import net.java.slee.resource.diameter.ro.events.avp.NodeFunctionality;
import net.java.slee.resource.diameter.ro.events.avp.RoleOfNode;
import net.java.slee.resource.diameter.ro.events.avp.SdpMediaComponent;
import net.java.slee.resource.diameter.ro.events.avp.TimeStamps;
import net.java.slee.resource.diameter.ro.events.avp.TrunkGroupId;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.AddressAvpImpl;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.ApplicationServerInformationImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.EventTypeImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.InterOperatorIdentifierImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.MessageBodyImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.SdpMediaComponentImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.TimeStampsImpl;
import org.mobicents.slee.resource.diameter.ro.events.avp.TrunkGroupIdImpl;

public class ImsInformationImpl
extends GroupedAvpImpl
implements ImsInformation {
    private static final Logger logger = Logger.getLogger(ImsInformationImpl.class);

    public ImsInformationImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public ApplicationServerInformation[] getApplicationServerInformations() {
        ApplicationServerInformation[] applicationServerInformations = null;
        AvpSet rawAvps = this.avpSet.getAvps(850, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            applicationServerInformations = new ApplicationServerInformation[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    Avp rawAvp = rawAvps.getAvpByIndex(i);
                    applicationServerInformations[i] = new ApplicationServerInformationImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 850L);
                    logger.error((Object)("Failure while trying to obtain Application-Server-Information AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return applicationServerInformations;
    }

    public byte[] getBearerService() {
        if (this.hasBearerService()) {
            Avp rawAvp = this.avpSet.getAvp(854, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 854L);
                logger.error((Object)"Failure while trying to obtain Bearer-Service AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getCalledPartyAddress() {
        if (this.hasCalledPartyAddress()) {
            Avp rawAvp = this.avpSet.getAvp(832, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 832L);
                logger.error((Object)"Failure while trying to obtain Called-Party-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getCallingPartyAddress() {
        if (this.hasCallingPartyAddress()) {
            Avp rawAvp = this.avpSet.getAvp(831, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 831L);
                logger.error((Object)"Failure while trying to obtain Calling-Party-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public int getCauseCode() {
        if (this.hasCauseCode()) {
            Avp rawAvp = this.avpSet.getAvp(861, 10415L);
            try {
                return rawAvp.getInteger32();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 861L);
                logger.error((Object)"Failure while trying to obtain Cause-Code AVP.", (Throwable)e);
            }
        }
        return -1;
    }

    public EventType getEventType() {
        if (this.hasEventType()) {
            Avp rawAvp = this.avpSet.getAvp(823, 10415L);
            try {
                return new EventTypeImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 823L);
                logger.error((Object)"Failure while trying to obtain Event-Type AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getImsChargingIdentifier() {
        if (this.hasImsChargingIdentifier()) {
            Avp rawAvp = this.avpSet.getAvp(841, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 841L);
                logger.error((Object)"Failure while trying to obtain IMS-Charging-Identifier AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public InterOperatorIdentifier[] getInterOperatorIdentifiers() {
        InterOperatorIdentifier[] interOperatorIdentifiers = null;
        AvpSet rawAvps = this.avpSet.getAvps(838, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            interOperatorIdentifiers = new InterOperatorIdentifier[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    Avp rawAvp = rawAvps.getAvpByIndex(i);
                    interOperatorIdentifiers[i] = new InterOperatorIdentifierImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 838L);
                    logger.error((Object)("Failure while trying to obtain Inter-Operator-Identifier AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return interOperatorIdentifiers;
    }

    public MessageBody[] getMessageBodys() {
        MessageBody[] messageBodies = null;
        AvpSet rawAvps = this.avpSet.getAvps(889, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            messageBodies = new MessageBody[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    Avp rawAvp = rawAvps.getAvpByIndex(i);
                    messageBodies[i] = new MessageBodyImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 889L);
                    logger.error((Object)("Failure while trying to obtain Message-Body AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return messageBodies;
    }

    public NodeFunctionality getNodeFunctionality() {
        if (this.hasNodeFunctionality()) {
            Avp rawAvp = this.avpSet.getAvp(862, 10415L);
            try {
                return NodeFunctionality.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 862L);
                logger.error((Object)"Failure while trying to obtain Node-Functionality AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public RoleOfNode getRoleOfNode() {
        if (this.hasNodeFunctionality()) {
            Avp rawAvp = this.avpSet.getAvp(829, 10415L);
            try {
                return RoleOfNode.fromInt(rawAvp.getInteger32());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 829L);
                logger.error((Object)"Failure while trying to obtain Role-of-Node AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public SdpMediaComponent[] getSdpMediaComponents() {
        SdpMediaComponent[] sdpMediaComponents = null;
        AvpSet rawAvps = this.avpSet.getAvps(843, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            sdpMediaComponents = new SdpMediaComponent[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    Avp rawAvp = rawAvps.getAvpByIndex(i);
                    sdpMediaComponents[i] = new SdpMediaComponentImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 843L);
                    logger.error((Object)("Failure while trying to obtain SDP-Media-Component AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return sdpMediaComponents;
    }

    public String[] getSdpSessionDescriptions() {
        String[] sdpSessionDescriptions = null;
        AvpSet rawAvps = this.avpSet.getAvps(842, 10415L);
        if (rawAvps != null && rawAvps.size() > 0) {
            sdpSessionDescriptions = new String[rawAvps.size()];
            for (int i = 0; i < rawAvps.size(); ++i) {
                try {
                    sdpSessionDescriptions[i] = rawAvps.getAvp(i).getUTF8String();
                    continue;
                }
                catch (AvpDataException e) {
                    this.reportAvpFetchError(e.getMessage(), 842L);
                    logger.error((Object)("Failure while trying to obtain SDP-Session-Description AVP (index:" + i + ")."), (Throwable)e);
                }
            }
        }
        return sdpSessionDescriptions;
    }

    public AddressAvp getServedPartyIpAddress() {
        if (this.hasServedPartyIpAddress()) {
            Avp rawAvp = this.avpSet.getAvp(848, 10415L);
            try {
                return AddressAvpImpl.decode((byte[])rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 848L);
                logger.error((Object)"Failure while trying to obtain Served-Party-IP-Address AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public byte[] getServerCapabilities() {
        if (this.hasServerCapabilities()) {
            Avp rawAvp = this.avpSet.getAvp(603, 10415L);
            try {
                return rawAvp.getRaw();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 603L);
                logger.error((Object)"Failure while trying to obtain Server-Capabilities AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getServiceId() {
        if (this.hasServiceId()) {
            Avp rawAvp = this.avpSet.getAvp(855, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 855L);
                logger.error((Object)"Failure while trying to obtain Service-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getServiceSpecificData() {
        if (this.hasServiceSpecificData()) {
            Avp rawAvp = this.avpSet.getAvp(863, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 863L);
                logger.error((Object)"Failure while trying to obtain Service-Specific-Data AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public TimeStamps getTimeStamps() {
        if (this.hasTimeStamps()) {
            Avp rawAvp = this.avpSet.getAvp(833, 10415L);
            try {
                return new TimeStampsImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 833L);
                logger.error((Object)"Failure while trying to obtain Time-Stamps AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public TrunkGroupId getTrunkGroupId() {
        if (this.hasTrunkGroupId()) {
            Avp rawAvp = this.avpSet.getAvp(851, 10415L);
            try {
                return new TrunkGroupIdImpl(rawAvp.getCode(), rawAvp.getVendorId(), rawAvp.isMandatory() ? 1 : 0, rawAvp.isEncrypted() ? 1 : 0, rawAvp.getRaw());
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 851L);
                logger.error((Object)"Failure while trying to obtain Trunk-Group-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getUserSessionId() {
        if (this.hasUserSessionId()) {
            Avp rawAvp = this.avpSet.getAvp(830, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 830L);
                logger.error((Object)"Failure while trying to obtain User-Session-Id AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasBearerService() {
        return this.hasAvp(854, 10415L);
    }

    public boolean hasCalledPartyAddress() {
        return this.hasAvp(832, 10415L);
    }

    public boolean hasCallingPartyAddress() {
        return this.hasAvp(831, 10415L);
    }

    public boolean hasCauseCode() {
        return this.hasAvp(861, 10415L);
    }

    public boolean hasEventType() {
        return this.hasAvp(823, 10415L);
    }

    public boolean hasImsChargingIdentifier() {
        return this.hasAvp(841, 10415L);
    }

    public boolean hasNodeFunctionality() {
        return this.hasAvp(862, 10415L);
    }

    public boolean hasRoleOfNode() {
        return this.hasAvp(829, 10415L);
    }

    public boolean hasServedPartyIpAddress() {
        return this.hasAvp(848, 10415L);
    }

    public boolean hasServerCapabilities() {
        return this.hasAvp(603, 10415L);
    }

    public boolean hasServiceId() {
        return this.hasAvp(855, 10415L);
    }

    public boolean hasServiceSpecificData() {
        return this.hasAvp(863, 10415L);
    }

    public boolean hasTimeStamps() {
        return this.hasAvp(833, 10415L);
    }

    public boolean hasTrunkGroupId() {
        return this.hasAvp(851, 10415L);
    }

    public boolean hasUserSessionId() {
        return this.hasAvp(830, 10415L);
    }

    public void setApplicationServerInformation(ApplicationServerInformation applicationServerInformation) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(850, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(850, applicationServerInformation.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setApplicationServerInformations(ApplicationServerInformation[] applicationServerInformations) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(850, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (ApplicationServerInformation applicationServerInformation : applicationServerInformations) {
            this.avpSet.addAvp(850, applicationServerInformation.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
        }
    }

    public void setBearerService(byte[] bearerService) {
        if (this.hasBearerService()) {
            throw new IllegalStateException("AVP Bearer-Service is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(854, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(854, bearerService, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setCalledPartyAddress(String calledPartyAddress) {
        if (this.hasCalledPartyAddress()) {
            throw new IllegalStateException("AVP Called-Party-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(832, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(832, calledPartyAddress, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setCallingPartyAddress(String callingPartyAddress) {
        if (this.hasCallingPartyAddress()) {
            throw new IllegalStateException("AVP Calling-Party-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(831, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(831, callingPartyAddress, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setCauseCode(int causeCode) {
        if (this.hasCauseCode()) {
            throw new IllegalStateException("AVP Cause-Code is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(861, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(861, causeCode, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setEventType(EventType eventType) {
        if (this.hasEventType()) {
            throw new IllegalStateException("AVP Event-Type is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(823, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(823, eventType.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setImsChargingIdentifier(String imsChargingIdentifier) {
        if (this.hasImsChargingIdentifier()) {
            throw new IllegalStateException("AVP IMS-Charging-Identifier is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(841, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(841, imsChargingIdentifier, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setInterOperatorIdentifier(InterOperatorIdentifier interOperatorIdentifier) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(841, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(841, interOperatorIdentifier.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setInterOperatorIdentifiers(InterOperatorIdentifier[] interOperatorIdentifiers) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(841, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (InterOperatorIdentifier interOperatorIdentifier : interOperatorIdentifiers) {
            this.avpSet.addAvp(841, interOperatorIdentifier.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
        }
    }

    public void setMessageBody(MessageBody messageBody) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(889, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(889, messageBody.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setMessageBodys(MessageBody[] messageBodys) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(889, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (MessageBody messageBody : messageBodys) {
            this.avpSet.addAvp(889, messageBody.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
        }
    }

    public void setNodeFunctionality(NodeFunctionality nodeFunctionality) {
        if (this.hasNodeFunctionality()) {
            throw new IllegalStateException("AVP Node-Functionality is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(862, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(862, nodeFunctionality.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setRoleOfNode(RoleOfNode roleOfNode) {
        if (this.hasRoleOfNode()) {
            throw new IllegalStateException("AVP Role-of-Node is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(829, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(829, roleOfNode.getValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setSdpMediaComponent(SdpMediaComponent sdpMediaComponent) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(843, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(843, sdpMediaComponent.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setSdpMediaComponents(SdpMediaComponent[] sdpMediaComponents) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(843, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (SdpMediaComponent sdpMediaComponent : sdpMediaComponents) {
            this.avpSet.addAvp(843, sdpMediaComponent.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
        }
    }

    public void setSdpSessionDescription(String sdpSessionDescription) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(842, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(842, sdpSessionDescription, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setSdpSessionDescriptions(String[] sdpSessionDescriptions) {
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(842, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        for (String sdpSessionDescription : sdpSessionDescriptions) {
            this.avpSet.addAvp(842, sdpSessionDescription, 10415L, mandatoryAvp, protectedAvp, false);
        }
    }

    public void setServedPartyIpAddress(AddressAvp servedPartyIpAddress) {
        if (this.hasServedPartyIpAddress()) {
            throw new IllegalStateException("AVP Served-Party-IP-Address is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(848, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(848, servedPartyIpAddress.encode(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setServerCapabilities(byte[] serverCapabilities) {
        if (this.hasServerCapabilities()) {
            throw new IllegalStateException("AVP Server-Capabilities is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(603, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(603, serverCapabilities, 10415L, mandatoryAvp, protectedAvp);
    }

    public void setServiceId(String serviceId) {
        if (this.hasServiceId()) {
            throw new IllegalStateException("AVP Service-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(855, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(855, serviceId, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setServiceSpecificData(String serviceSpecificData) {
        if (this.hasServiceSpecificData()) {
            throw new IllegalStateException("AVP Service-Specific-Data is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(863, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(863, serviceSpecificData, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setTimeStamps(TimeStamps timeStamps) {
        if (this.hasTimeStamps()) {
            throw new IllegalStateException("AVP Time-Stamps is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(833, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(833, timeStamps.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setTrunkGroupId(TrunkGroupId trunkGroupId) {
        if (this.hasTrunkGroupId()) {
            throw new IllegalStateException("AVP Trunk-Group-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(851, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(851, trunkGroupId.byteArrayValue(), 10415L, mandatoryAvp, protectedAvp);
    }

    public void setUserSessionId(String userSessionId) {
        if (this.hasUserSessionId()) {
            throw new IllegalStateException("AVP User-Session-Id is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(830, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(830, userSessionId, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

