/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.ro.events.avp;

import net.java.slee.resource.diameter.ro.events.avp.InterOperatorIdentifier;
import org.apache.log4j.Logger;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.mobicents.diameter.dictionary.AvpDictionary;
import org.mobicents.diameter.dictionary.AvpRepresentation;
import org.mobicents.slee.resource.diameter.base.events.avp.GroupedAvpImpl;

public class InterOperatorIdentifierImpl
extends GroupedAvpImpl
implements InterOperatorIdentifier {
    private static final Logger logger = Logger.getLogger(InterOperatorIdentifierImpl.class);

    public InterOperatorIdentifierImpl(int code, long vendorId, int mnd, int prt, byte[] value) {
        super(code, vendorId, mnd, prt, value);
    }

    public String getOriginatingIoi() {
        if (this.hasOriginatingIoi()) {
            Avp rawAvp = this.avpSet.getAvp(839, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 839L);
                logger.error((Object)"Failure while trying to obtain Originating-IOI AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public String getTerminatingIoi() {
        if (this.hasTerminatingIoi()) {
            Avp rawAvp = this.avpSet.getAvp(840, 10415L);
            try {
                return rawAvp.getUTF8String();
            }
            catch (AvpDataException e) {
                this.reportAvpFetchError(e.getMessage(), 840L);
                logger.error((Object)"Failure while trying to obtain Terminating-IOI AVP.", (Throwable)e);
            }
        }
        return null;
    }

    public boolean hasOriginatingIoi() {
        return this.hasAvp(839, 10415L);
    }

    public boolean hasTerminatingIoi() {
        return this.hasAvp(840, 10415L);
    }

    public void setOriginatingIoi(String originatingIoi) {
        if (this.hasOriginatingIoi()) {
            throw new IllegalStateException("AVP Originating-IOI is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(839, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(839, originatingIoi, 10415L, mandatoryAvp, protectedAvp, false);
    }

    public void setTerminatingIoi(String terminatingIoi) {
        if (this.hasTerminatingIoi()) {
            throw new IllegalStateException("AVP Terminating-IOI is already present in message and cannot be overwritten.");
        }
        AvpRepresentation avpRep = AvpDictionary.INSTANCE.getAvp(840, 10415L);
        boolean mandatoryAvp = !avpRep.getRuleMandatory().equals("mustnot") && !avpRep.getRuleMandatory().equals("shouldnot");
        boolean protectedAvp = avpRep.getRuleProtected().equals("must");
        this.avpSet.addAvp(840, terminatingIoi, 10415L, mandatoryAvp, protectedAvp, false);
    }
}

